/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.item.custom;

import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import net.dawson.adorablehamsterpets.block.client.HamsterBedItemRenderer;
import net.dawson.adorablehamsterpets.block.custom.HamsterBedBlock;
import net.dawson.adorablehamsterpets.block.custom.WoodVariant;
import net.dawson.adorablehamsterpets.block.entity.HamsterBedBlockEntity;
import net.dawson.adorablehamsterpets.component.ModDataComponentTypes;
import net.dawson.adorablehamsterpets.config.Configs;
import net.dawson.adorablehamsterpets.config.WanderDistance;
import net.dawson.adorablehamsterpets.entity.custom.HamsterEntity;
import net.dawson.adorablehamsterpets.particles.ModParticles;
import net.dawson.adorablehamsterpets.sound.ModSounds;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_437;
import net.minecraft.class_756;
import net.minecraft.class_9331;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.client.GeoRenderProvider;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class HamsterBedItem
extends class_1747
implements GeoItem {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final WoodVariant variant;

    public HamsterBedItem(class_2248 block, WoodVariant variant, class_1792.class_1793 settings) {
        super(block, settings);
        this.variant = variant;
        GeoItem.registerSyncedAnimatable((GeoAnimatable)this);
    }

    protected boolean method_7710(class_2338 pos, class_1937 world, @Nullable class_1657 player, class_1799 stack, class_2680 state) {
        if (!world.field_9236) {
            class_2586 be;
            class_3414 rustleSound = ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_BED_LEAVES_RUSTLE_SOUNDS, world.method_8409());
            if (rustleSound != null) {
                world.method_8396(null, pos, rustleSound, class_3419.field_15245, 0.5f, 1.5f);
            }
            if ((be = world.method_8321(pos)) instanceof HamsterBedBlockEntity) {
                HamsterBedBlockEntity bedEntity = (HamsterBedBlockEntity)be;
                bedEntity.triggerAnim("hamster_bed_controller", "anim_bed_being_placed");
                WoodVariant variant = (WoodVariant)((Object)stack.method_57825((class_9331)ModDataComponentTypes.WOOD_VARIANT.get(), (Object)this.variant));
                ((class_3218)world).method_14199((class_2394)ModParticles.getForVariant(variant), (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.3, (double)pos.method_10260() + 0.5, 30, 0.1, 0.2, 0.1, 0.0);
            }
        }
        return world.method_8652(pos, (class_2680)state.method_11657(HamsterBedBlock.WOOD_VARIANT, (Comparable)((Object)this.variant)), 11);
    }

    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 type) {
        WoodVariant stackVariant = (WoodVariant)((Object)stack.method_57825((class_9331)ModDataComponentTypes.WOOD_VARIANT.get(), (Object)this.variant));
        if (Configs.AHP.enableItemTooltips) {
            if (class_437.method_25442()) {
                tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.adorablehamsterpets.hamster_bed.description1").method_27692(class_124.field_1065));
                tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.adorablehamsterpets.hamster_bed.description2").method_27692(class_124.field_1080));
                tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.adorablehamsterpets.jade.wander_controls").method_27692(class_124.field_1080));
                tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.adorablehamsterpets.jade.lure_hint").method_27692(class_124.field_1080));
                tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.adorablehamsterpets.jade.repellent_hint").method_27692(class_124.field_1080));
                tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.adorablehamsterpets.jade.unlink_hint").method_27692(class_124.field_1080));
                UUID hamsterUuid = (UUID)stack.method_57824((class_9331)ModDataComponentTypes.LINKED_HAMSTER_UUID.get());
                class_2561 hamsterName = (class_2561)stack.method_57824((class_9331)ModDataComponentTypes.LINKED_HAMSTER_NAME.get());
                WanderDistance wanderDistance = (WanderDistance)((Object)stack.method_57824((class_9331)ModDataComponentTypes.WANDER_DISTANCE.get()));
                if (hamsterUuid != null && hamsterName != null) {
                    tooltip.add((class_2561)class_2561.method_43470((String)""));
                    tooltip.add((class_2561)class_2561.method_43469((String)"tooltip.adorablehamsterpets.hamster_bed.linked_to", (Object[])new Object[]{hamsterName}).method_27692(class_124.field_1060));
                    if (wanderDistance != null) {
                        int radius = switch (wanderDistance) {
                            case WanderDistance.NEAR -> (Integer)Configs.AHP.wanderDistanceNear.get();
                            case WanderDistance.FAR -> (Integer)Configs.AHP.wanderDistanceFar.get();
                            default -> (Integer)Configs.AHP.wanderDistanceMedium.get();
                        };
                        tooltip.add((class_2561)class_2561.method_43469((String)"tooltip.adorablehamsterpets.hamster_bed.wander_distance", (Object[])new Object[]{wanderDistance.method_15434(), radius}).method_27692(class_124.field_1075));
                    }
                }
            } else {
                tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.adorablehamsterpets.hamster_bed.description1").method_27692(class_124.field_1065));
                tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.adorablehamsterpets.shift_for_info").method_27692(class_124.field_1063));
            }
        } else {
            tooltip.add((class_2561)class_2561.method_43470((String)"Adorable Hamster Pets").method_27695(new class_124[]{class_124.field_1078, class_124.field_1056}));
        }
        super.method_7851(stack, context, tooltip, type);
    }

    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        if (!world.field_9236) {
            return;
        }
        UUID linkedUuid = (UUID)stack.method_57824((class_9331)ModDataComponentTypes.LINKED_HAMSTER_UUID.get());
        if (linkedUuid != null && entity instanceof class_1657) {
            world.method_8390(HamsterEntity.class, entity.method_5829().method_1014(16.0), e -> e.method_5667().equals(linkedUuid)).stream().findFirst().ifPresent(hamster -> {
                Object newName = hamster.method_16914() ? hamster.method_5477() : hamster.method_5476().method_27661().method_27693(" " + hamster.method_5628());
                class_2561 currentNameOnStack = (class_2561)stack.method_57824((class_9331)ModDataComponentTypes.LINKED_HAMSTER_NAME.get());
                if (currentNameOnStack == null || !currentNameOnStack.equals(newName)) {
                    stack.method_57379((class_9331)ModDataComponentTypes.LINKED_HAMSTER_NAME.get(), newName);
                }
            });
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public WoodVariant getVariant() {
        return this.variant;
    }

    public String method_7876() {
        return this.method_7869();
    }

    public void createGeoRenderer(Consumer<GeoRenderProvider> consumer) {
        consumer.accept(new GeoRenderProvider(this){
            private HamsterBedItemRenderer renderer;

            public class_756 getGeoItemRenderer() {
                if (this.renderer == null) {
                    this.renderer = new HamsterBedItemRenderer();
                }
                return this.renderer;
            }
        });
    }
}

