/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.networking;

import dev.architectury.networking.NetworkManager;
import net.dawson.adorablehamsterpets.AdorableHamsterPetsClient;
import net.dawson.adorablehamsterpets.accessor.PlayerEntityAccessor;
import net.dawson.adorablehamsterpets.entity.custom.HamsterEntity;
import net.dawson.adorablehamsterpets.item.ModItems;
import net.dawson.adorablehamsterpets.networking.payload.DismountHamsterPayload;
import net.dawson.adorablehamsterpets.networking.payload.PlayGuidebookEffectsPayload;
import net.dawson.adorablehamsterpets.networking.payload.RequestGuidebookPayload;
import net.dawson.adorablehamsterpets.networking.payload.RequestHamsterMountPayload;
import net.dawson.adorablehamsterpets.networking.payload.SpawnBeddingParticlesPayload;
import net.dawson.adorablehamsterpets.networking.payload.ThrowHamsterPayload;
import net.dawson.adorablehamsterpets.networking.payload.UpdateHamsterRenderStatePayload;
import net.dawson.adorablehamsterpets.util.HamsterRenderTracker;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_7923;
import net.minecraft.class_8710;
import net.minecraft.class_9331;

public class ModPackets {
    public static void registerPayloads() {
        NetworkManager.registerS2CPayloadType(SpawnBeddingParticlesPayload.ID, SpawnBeddingParticlesPayload.CODEC);
        NetworkManager.registerS2CPayloadType(PlayGuidebookEffectsPayload.ID, PlayGuidebookEffectsPayload.CODEC);
    }

    public static void registerC2SPackets() {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, ThrowHamsterPayload.ID, ThrowHamsterPayload.CODEC, (payload, context) -> context.queue(() -> HamsterEntity.tryThrowFromShoulder((class_3222)context.getPlayer())));
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, UpdateHamsterRenderStatePayload.ID, UpdateHamsterRenderStatePayload.CODEC, (payload, context) -> context.queue(() -> ModPackets.handleUpdateRenderState(payload, context)));
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, DismountHamsterPayload.ID, DismountHamsterPayload.CODEC, (payload, context) -> context.queue(() -> {
            class_1657 patt0$temp = context.getPlayer();
            if (patt0$temp instanceof class_3222) {
                class_3222 player = (class_3222)patt0$temp;
                ((PlayerEntityAccessor)player).adorablehamsterpets$dismountShoulderHamster(false);
            }
        }));
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, RequestGuidebookPayload.ID, RequestGuidebookPayload.CODEC, (payload, context) -> context.queue(() -> {
            class_3222 player = (class_3222)context.getPlayer();
            class_1799 bookStack = new class_1799((class_1935)ModItems.HAMSTER_GUIDE_BOOK.get());
            class_9331 bookComponent = (class_9331)class_7923.field_49658.method_10223(class_2960.method_60655((String)"patchouli", (String)"book"));
            if (bookComponent != null) {
                bookStack.method_57379(bookComponent, (Object)class_2960.method_60655((String)"adorablehamsterpets", (String)"hamster_tips_guide_book"));
                player.method_31548().method_7398(bookStack);
                NetworkManager.sendToPlayer((class_3222)player, (class_8710)new PlayGuidebookEffectsPayload());
            }
        }));
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, RequestHamsterMountPayload.ID, RequestHamsterMountPayload.CODEC, (payload, context) -> context.queue(() -> {
            HamsterEntity hamster;
            class_1657 player = context.getPlayer();
            class_1297 entity = player.method_37908().method_8469(payload.entityId());
            if (entity instanceof HamsterEntity && (hamster = (HamsterEntity)entity).method_6171((class_1309)player) && hamster.method_5858((class_1297)player) < 64.0) {
                hamster.tryShoulderMount(player, class_1799.field_8037);
            }
        }));
    }

    public static void registerS2CPackets() {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, SpawnBeddingParticlesPayload.ID, SpawnBeddingParticlesPayload.CODEC, (payload, context) -> context.queue(() -> AdorableHamsterPetsClient.handleSpawnBeddingParticles(payload)));
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, PlayGuidebookEffectsPayload.ID, PlayGuidebookEffectsPayload.CODEC, (payload, context) -> context.queue(AdorableHamsterPetsClient::handlePlayGuidebookEffects));
    }

    private static void handleUpdateRenderState(UpdateHamsterRenderStatePayload payload, NetworkManager.PacketContext context) {
        if (payload.isRendering()) {
            HamsterRenderTracker.addPlayer(payload.hamsterEntityId(), context.getPlayer().method_5667());
        } else {
            HamsterRenderTracker.removePlayer(payload.hamsterEntityId(), context.getPlayer().method_5667());
        }
    }
}

