/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets;

import dev.architectury.event.events.common.CommandRegistrationEvent;
import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.event.events.common.PlayerEvent;
import dev.architectury.platform.Platform;
import dev.architectury.registry.level.entity.EntityAttributeRegistry;
import dev.architectury.utils.Env;
import net.dawson.adorablehamsterpets.ModRegistries;
import net.dawson.adorablehamsterpets.accessor.PlayerEntityAccessor;
import net.dawson.adorablehamsterpets.advancement.criterion.FirstJoinCriterion;
import net.dawson.adorablehamsterpets.advancement.criterion.ModCriteria;
import net.dawson.adorablehamsterpets.block.ModBlocks;
import net.dawson.adorablehamsterpets.command.ModCommands;
import net.dawson.adorablehamsterpets.component.ModDataComponentTypes;
import net.dawson.adorablehamsterpets.config.AhpConfig;
import net.dawson.adorablehamsterpets.config.Configs;
import net.dawson.adorablehamsterpets.entity.ModEntities;
import net.dawson.adorablehamsterpets.entity.ShoulderLocation;
import net.dawson.adorablehamsterpets.entity.custom.HamsterEntity;
import net.dawson.adorablehamsterpets.event.AHPCommonEvents;
import net.dawson.adorablehamsterpets.item.ModItemGroups;
import net.dawson.adorablehamsterpets.item.ModItems;
import net.dawson.adorablehamsterpets.networking.ModPackets;
import net.dawson.adorablehamsterpets.screen.ModScreenHandlers;
import net.dawson.adorablehamsterpets.sound.ModSounds;
import net.dawson.adorablehamsterpets.tag.ModItemTags;
import net.dawson.adorablehamsterpets.world.ModSpawnPlacements;
import net.dawson.adorablehamsterpets.world.ModWorldGeneration;
import net.dawson.adorablehamsterpets.world.gen.ModEntitySpawns;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.PlayerAdvancements;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdorableHamsterPets {
    public static final String MOD_ID = "adorablehamsterpets";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"adorablehamsterpets");
    public static AhpConfig CONFIG;

    public static void initRegistries() {
        CONFIG = Configs.AHP;
        ModEntities.register();
        ModDataComponentTypes.registerDataComponentTypes();
        ModSounds.register();
        ModBlocks.register();
        ModItems.register();
        ModItemGroups.register();
        ModScreenHandlers.register();
        ModCriteria.register();
    }

    public static void initCommonSetup() {
        if (System.getProperty("fabric-api.datagen") == null) {
            ModRegistries.registerCompostables();
            ModEntitySpawns.parseConfig();
            ModWorldGeneration.parseConfig();
            ModItemTags.parseConfig();
            if (Platform.getEnvironment() == Env.SERVER) {
                ModPackets.registerPayloads();
            }
            ModPackets.registerC2SPackets();
            ModWorldGeneration.registerBiomeModifications();
            AHPCommonEvents.init();
            PlayerEvent.PLAYER_JOIN.register(AdorableHamsterPets::onPlayerJoin);
            PlayerEvent.PLAYER_CLONE.register(AdorableHamsterPets::onPlayerClone);
            CommandRegistrationEvent.EVENT.register(ModCommands::register);
            LifecycleEvent.SETUP.register(AdorableHamsterPets::onSetup);
        }
    }

    public static void initAttributes() {
        EntityAttributeRegistry.register(ModEntities.HAMSTER, HamsterEntity::createHamsterAttributes);
    }

    private static void onSetup() {
        ModSpawnPlacements.register((EntityType)ModEntities.HAMSTER.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (type, world, reason, pos, random) -> Animal.checkAnimalSpawnRules((EntityType)type, (LevelAccessor)world, (MobSpawnType)reason, (BlockPos)pos, (RandomSource)random) || ModEntitySpawns.VALID_SPAWN_BLOCKS.contains(world.getBlockState(pos.below()).getBlock()));
    }

    private static void onPlayerJoin(ServerPlayer player) {
        if (Configs.AHP.enableAutoGuidebookDelivery) {
            PlayerAdvancements advancementTracker = player.getAdvancements();
            ResourceLocation flagAdvId = ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)"technical/has_received_initial_guidebook");
            AdvancementHolder flagAdvancementEntry = player.server.getAdvancements().get(flagAdvId);
            if (flagAdvancementEntry != null) {
                AdvancementProgress flagProgress = advancementTracker.getOrStartProgress(flagAdvancementEntry);
                if (!flagProgress.isDone()) {
                    ((FirstJoinCriterion)((Object)ModCriteria.FIRST_JOIN_GUIDEBOOK_CHECK.get())).trigger(player);
                    for (String criterion : flagAdvancementEntry.value().criteria().keySet()) {
                        advancementTracker.award(flagAdvancementEntry, criterion);
                    }
                }
            } else {
                LOGGER.warn("Could not find flag advancement: {}", (Object)flagAdvId);
            }
        }
        AdorableHamsterPets.replaceOldBooksInInventory((Container)player.getInventory());
    }

    private static void onPlayerClone(ServerPlayer oldPlayer, ServerPlayer newPlayer, boolean wasDeath) {
        PlayerEntityAccessor oldPlayerAccessor = (PlayerEntityAccessor)oldPlayer;
        PlayerEntityAccessor newPlayerAccessor = (PlayerEntityAccessor)newPlayer;
        for (ShoulderLocation location : ShoulderLocation.values()) {
            CompoundTag shoulderNbt = oldPlayerAccessor.getShoulderHamster(location);
            if (shoulderNbt.isEmpty()) continue;
            if (wasDeath) {
                ServerLevel world = oldPlayer.serverLevel();
                HamsterEntity.spawnFromNbt(world, (Player)oldPlayer, shoulderNbt, false, null);
                LOGGER.debug("Player {} died. Spawning {} hamster at death location.", (Object)oldPlayer.getName().getString(), (Object)location);
                continue;
            }
            newPlayerAccessor.setShoulderHamster(location, shoulderNbt);
            LOGGER.debug("Player {} was cloned. Transferring {} hamster to new entity.", (Object)newPlayer.getName().getString(), (Object)location);
        }
    }

    public static void replaceOldBooksInInventory(Container inventory) {
        DataComponentType bookComponent = (DataComponentType)BuiltInRegistries.DATA_COMPONENT_TYPE.get(ResourceLocation.fromNamespaceAndPath((String)"patchouli", (String)"book"));
        if (bookComponent == null) {
            return;
        }
        for (int i = 0; i < inventory.getContainerSize(); ++i) {
            ItemStack stack = inventory.getItem(i);
            if (!stack.is((Item)ModItems.HAMSTER_GUIDE_BOOK.get()) || stack.has(bookComponent)) continue;
            ItemStack newBookStack = new ItemStack((ItemLike)ModItems.HAMSTER_GUIDE_BOOK.get(), stack.getCount());
            newBookStack.set(bookComponent, (Object)ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)"hamster_tips_guide_book"));
            inventory.setItem(i, newBookStack);
            LOGGER.info("Upgraded an old Hamster Tips Guide Book to the new Patchouli version.");
        }
    }
}

