/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets;

import dev.architectury.event.events.client.ClientGuiEvent;
import dev.architectury.event.events.client.ClientPlayerEvent;
import dev.architectury.event.events.client.ClientTickEvent;
import dev.architectury.networking.NetworkManager;
import dev.architectury.registry.client.level.entity.EntityRendererRegistry;
import dev.architectury.registry.client.rendering.ColorHandlerRegistry;
import dev.architectury.registry.client.rendering.RenderTypeRegistry;
import dev.architectury.registry.menu.MenuRegistry;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import me.fzzyhmstrs.fzzy_config.api.ConfigApiJava;
import net.dawson.adorablehamsterpets.AdorableHamsterPets;
import net.dawson.adorablehamsterpets.accessor.PlayerEntityAccessor;
import net.dawson.adorablehamsterpets.block.ModBlocks;
import net.dawson.adorablehamsterpets.client.announcements.AnnouncementHudRenderer;
import net.dawson.adorablehamsterpets.client.announcements.AnnouncementManager;
import net.dawson.adorablehamsterpets.client.event.AHPClientScreenEvents;
import net.dawson.adorablehamsterpets.client.gui.widgets.AnnouncementIconAnimator;
import net.dawson.adorablehamsterpets.client.option.ModKeyBindings;
import net.dawson.adorablehamsterpets.client.sound.HamsterFlightSoundInstance;
import net.dawson.adorablehamsterpets.client.sound.HamsterThrowSoundInstance;
import net.dawson.adorablehamsterpets.command.ModClientCommands;
import net.dawson.adorablehamsterpets.config.AhpConfig;
import net.dawson.adorablehamsterpets.config.Configs;
import net.dawson.adorablehamsterpets.config.DismountPressType;
import net.dawson.adorablehamsterpets.config.DismountTriggerType;
import net.dawson.adorablehamsterpets.entity.ModEntities;
import net.dawson.adorablehamsterpets.entity.client.HamsterRenderer;
import net.dawson.adorablehamsterpets.entity.custom.HamsterEntity;
import net.dawson.adorablehamsterpets.item.ModItems;
import net.dawson.adorablehamsterpets.networking.ModPackets;
import net.dawson.adorablehamsterpets.networking.payload.DismountHamsterPayload;
import net.dawson.adorablehamsterpets.networking.payload.StartHamsterFlightSoundPayload;
import net.dawson.adorablehamsterpets.networking.payload.StartHamsterThrowSoundPayload;
import net.dawson.adorablehamsterpets.networking.payload.ThrowHamsterPayload;
import net.dawson.adorablehamsterpets.networking.payload.UpdateHamsterRenderStatePayload;
import net.dawson.adorablehamsterpets.screen.HamsterInventoryScreen;
import net.dawson.adorablehamsterpets.screen.ModScreenHandlers;
import net.dawson.adorablehamsterpets.sound.ModSounds;
import net.dawson.adorablehamsterpets.tag.ModItemTags;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.HitResult;

public class AdorableHamsterPetsClient {
    private static final Set<Integer> renderedHamsterIdsThisTick = new HashSet<Integer>();
    private static final Set<Integer> renderedHamsterIdsLastTick = new HashSet<Integer>();
    private static long lastSneakPressTime = 0L;
    private static boolean isWaitingForSecondSneakPress = false;
    private static boolean hadShoulderHamsterLastTick = false;
    private static int dismountDebounceTicks = 0;
    private static final int DISMOUNT_DEBOUNCE_DEFAULT = 5;
    private static final AnnouncementHudRenderer announcementHudRenderer = new AnnouncementHudRenderer();
    private static List<AnnouncementManager.PendingNotification> pendingNotifications = Collections.emptyList();
    private static int nextRefreshTicks = 6000;

    public static List<AnnouncementManager.PendingNotification> getPendingNotifications() {
        return pendingNotifications;
    }

    public static void init() {
        RenderTypeRegistry.register((RenderType)RenderType.cutout(), (Block[])new Block[]{(Block)ModBlocks.GREEN_BEANS_CROP.get(), (Block)ModBlocks.CUCUMBER_CROP.get(), (Block)ModBlocks.SUNFLOWER_BLOCK.get(), (Block)ModBlocks.WILD_CUCUMBER_BUSH.get(), (Block)ModBlocks.WILD_GREEN_BEAN_BUSH.get()});
        ConfigApiJava.event().onUpdateClient((id, config) -> {
            if (id.equals((Object)ResourceLocation.fromNamespaceAndPath((String)"adorablehamsterpets", (String)"main"))) {
                ModItemTags.parseConfig();
                AdorableHamsterPets.LOGGER.info("Reloaded Adorable Hamster Pets item tag config on client following GUI update. *wink wink*");
            }
        });
        ColorHandlerRegistry.registerItemColors((stack, tintIndex) -> -1, (ItemLike[])new ItemLike[]{(ItemLike)ModItems.HAMSTER_SPAWN_EGG.get()});
        ModPackets.registerS2CPackets();
        AHPClientScreenEvents.register();
        ModClientCommands.register();
        ClientTickEvent.CLIENT_POST.register(AdorableHamsterPetsClient::onEndClientTick);
        ClientPlayerEvent.CLIENT_PLAYER_JOIN.register(player -> AnnouncementManager.INSTANCE.processDeferredReadMarks());
        ClientGuiEvent.RENDER_HUD.register((context, tickCounter) -> announcementHudRenderer.render(context, tickCounter.getGameTimeDeltaPartialTick(true)));
    }

    public static void initScreenHandlers() {
        MenuRegistry.registerScreenFactory((MenuType)((MenuType)ModScreenHandlers.HAMSTER_INVENTORY_SCREEN_HANDLER.get()), HamsterInventoryScreen::new);
    }

    public static void initEntityRenderers() {
        EntityRendererRegistry.register(ModEntities.HAMSTER, HamsterRenderer::new);
    }

    public static void onHamsterRendered(int entityId) {
        renderedHamsterIdsThisTick.add(entityId);
    }

    private static void onEndClientTick(Minecraft client) {
        boolean isGuiOpen = client.screen != null;
        AnnouncementIconAnimator.INSTANCE.tick(isGuiOpen);
        if (client.level != null) {
            pendingNotifications = AnnouncementManager.INSTANCE.getPendingNotifications();
        }
        if (--nextRefreshTicks <= 0) {
            nextRefreshTicks = 6000;
            AnnouncementManager.INSTANCE.refreshManifest();
            AdorableHamsterPets.LOGGER.debug("[AHP Client Tick] Triggered periodic manifest refresh.");
        }
        if (client.player == null || client.level == null) {
            renderedHamsterIdsThisTick.clear();
            renderedHamsterIdsLastTick.clear();
            return;
        }
        if (ModKeyBindings.THROW_HAMSTER_KEY.consumeClick()) {
            AhpConfig currentConfig = AdorableHamsterPets.CONFIG;
            if (!currentConfig.enableHamsterThrowing) {
                client.player.displayClientMessage((Component)Component.translatable((String)"message.adorablehamsterpets.throwing_disabled"), true);
            } else {
                boolean lookingAtReachableBlock = client.hitResult != null && client.hitResult.getType() == HitResult.Type.BLOCK;
                boolean hasShoulderHamsterClient = ((PlayerEntityAccessor)client.player).hasAnyShoulderHamster();
                if (!lookingAtReachableBlock && hasShoulderHamsterClient) {
                    NetworkManager.sendToServer((CustomPacketPayload)new ThrowHamsterPayload());
                }
            }
        }
        HashSet<Integer> stoppedRendering = new HashSet<Integer>(renderedHamsterIdsLastTick);
        stoppedRendering.removeAll(renderedHamsterIdsThisTick);
        for (Integer entityId : stoppedRendering) {
            NetworkManager.sendToServer((CustomPacketPayload)new UpdateHamsterRenderStatePayload(entityId, false));
        }
        renderedHamsterIdsLastTick.clear();
        renderedHamsterIdsLastTick.addAll(renderedHamsterIdsThisTick);
        renderedHamsterIdsThisTick.clear();
        AdorableHamsterPetsClient.handleDismountKeyPress(client);
    }

    public static void handleStartFlightSound(StartHamsterFlightSoundPayload payload) {
        HamsterEntity hamster;
        SoundEvent flightSound;
        Minecraft client = Minecraft.getInstance();
        if (client.level == null) {
            return;
        }
        Entity entity = client.level.getEntity(payload.hamsterEntityId());
        if (entity instanceof HamsterEntity && (flightSound = ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_FLYING_SOUNDS, (hamster = (HamsterEntity)entity).getRandom())) != null) {
            client.getSoundManager().play((SoundInstance)new HamsterFlightSoundInstance(flightSound, SoundSource.NEUTRAL, hamster));
        }
    }

    public static void handleStartThrowSound(StartHamsterThrowSoundPayload payload) {
        Minecraft client = Minecraft.getInstance();
        if (client.level == null) {
            return;
        }
        Entity entity = client.level.getEntity(payload.hamsterEntityId());
        if (entity instanceof HamsterEntity) {
            HamsterEntity hamster = (HamsterEntity)entity;
            client.getSoundManager().play((SoundInstance)new HamsterThrowSoundInstance((SoundEvent)ModSounds.HAMSTER_THROW.get(), SoundSource.PLAYERS, hamster));
        }
    }

    private static void handleDismountKeyPress(Minecraft client) {
        long delayMillis;
        long currentTime;
        if (client.player == null || client.level == null) {
            return;
        }
        boolean hasShoulderHamster = ((PlayerEntityAccessor)client.player).hasAnyShoulderHamster();
        if (hasShoulderHamster && !hadShoulderHamsterLastTick) {
            KeyMapping vanillaSneak = client.options.keyShift;
            KeyMapping customDismount = ModKeyBindings.DISMOUNT_HAMSTER_KEY;
            if (vanillaSneak != null) {
                vanillaSneak.setDown(false);
                while (vanillaSneak.consumeClick()) {
                }
            }
            if (customDismount != null) {
                customDismount.setDown(false);
                while (customDismount.consumeClick()) {
                }
            }
            dismountDebounceTicks = 5;
            isWaitingForSecondSneakPress = false;
            AdorableHamsterPets.LOGGER.trace("[AHP DEBUG CLIENT] Mount transition detected -> draining input queues and starting debounce ({} ticks).", (Object)5);
        }
        hadShoulderHamsterLastTick = hasShoulderHamster;
        if (!hasShoulderHamster) {
            if (isWaitingForSecondSneakPress) {
                isWaitingForSecondSneakPress = false;
            }
            return;
        }
        if (dismountDebounceTicks > 0) {
            --dismountDebounceTicks;
            return;
        }
        AhpConfig config = AdorableHamsterPets.CONFIG;
        KeyMapping keyToListenFor = Configs.AHP.dismountTriggerType == DismountTriggerType.CUSTOM_KEYBIND ? ModKeyBindings.DISMOUNT_HAMSTER_KEY : client.options.keyShift;
        boolean wasKeyPressed = keyToListenFor != null && keyToListenFor.consumeClick();
        AdorableHamsterPets.LOGGER.trace("[AHP DEBUG CLIENT] Tick Handler: Listening for '{}'. wasPressed() = {}", (Object)(keyToListenFor != null ? keyToListenFor.getName() : "null-binding"), (Object)wasKeyPressed);
        if (wasKeyPressed) {
            AdorableHamsterPets.LOGGER.debug("[AHP DEBUG CLIENT] Tick Handler: SINGLE_PRESS detected. Press type config: {}", config.dismountPressType.get());
            if (config.dismountPressType.get() == DismountPressType.SINGLE_PRESS) {
                NetworkManager.sendToServer((CustomPacketPayload)new DismountHamsterPayload());
            } else {
                currentTime = System.currentTimeMillis();
                delayMillis = (long)((Integer)config.doubleTapDelayTicks.get()).intValue() * 50L;
                if (isWaitingForSecondSneakPress && currentTime - lastSneakPressTime <= delayMillis) {
                    AdorableHamsterPets.LOGGER.trace("[AHP DEBUG CLIENT] Tick Handler: DOUBLE_TAP second press detected. Sending dismount payload.");
                    NetworkManager.sendToServer((CustomPacketPayload)new DismountHamsterPayload());
                    isWaitingForSecondSneakPress = false;
                } else {
                    AdorableHamsterPets.LOGGER.trace("[AHP DEBUG CLIENT] Tick Handler: DOUBLE_TAP first press detected. Starting timer.");
                    isWaitingForSecondSneakPress = true;
                    lastSneakPressTime = currentTime;
                }
            }
        }
        if (isWaitingForSecondSneakPress && (currentTime = System.currentTimeMillis()) - lastSneakPressTime > (delayMillis = (long)((Integer)config.doubleTapDelayTicks.get()).intValue() * 50L)) {
            AdorableHamsterPets.LOGGER.trace("[AHP DEBUG CLIENT] Tick Handler: DOUBLE_TAP timed out.");
            isWaitingForSecondSneakPress = false;
        }
    }
}

