/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.advancement.criterion;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.dawson.adorablehamsterpets.entity.custom.HamsterEntity;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.storage.loot.LootContext;

public class HamsterLedToDiamondCriterion
extends SimpleCriterionTrigger<Conditions> {
    public static final Codec<Conditions> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(Conditions::player), (App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("hamster").forGetter(Conditions::hamster), (App)BlockPredicate.CODEC.optionalFieldOf("ore_block").forGetter(Conditions::oreBlock)).apply((Applicative)instance, Conditions::new));

    public void trigger(ServerPlayer player, HamsterEntity hamster, BlockPos orePos) {
        LootContext hamsterContext = EntityPredicate.createContext((ServerPlayer)player, (Entity)hamster);
        this.trigger(player, conditions -> conditions.matches(player, hamsterContext, orePos));
    }

    public Codec<Conditions> codec() {
        return CODEC;
    }

    public record Conditions(Optional<ContextAwarePredicate> player, Optional<ContextAwarePredicate> hamster, Optional<BlockPredicate> oreBlock) implements SimpleCriterionTrigger.SimpleInstance
    {
        public boolean matches(ServerPlayer playerEntity, LootContext hamsterContext, BlockPos orePos) {
            if (this.player.isPresent() && !this.player.get().matches(EntityPredicate.createContext((ServerPlayer)playerEntity, (Entity)playerEntity))) {
                return false;
            }
            return !this.hamster.isPresent() || this.hamster.get().matches(hamsterContext);
        }
    }
}

