/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.advancement.criterion;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.dawson.adorablehamsterpets.entity.custom.HamsterEntity;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.storage.loot.LootContext;

public class HamsterPouchFilledCriterion
extends SimpleCriterionTrigger<Conditions> {
    public static final Codec<Conditions> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(Conditions::player), (App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("hamster").forGetter(Conditions::hamster)).apply((Applicative)instance, Conditions::new));

    public void trigger(ServerPlayer player, HamsterEntity hamster) {
        LootContext hamsterContext = EntityPredicate.createContext((ServerPlayer)player, (Entity)hamster);
        this.trigger(player, conditions -> conditions.matches(player, hamsterContext));
    }

    public Codec<Conditions> codec() {
        return CODEC;
    }

    public record Conditions(Optional<ContextAwarePredicate> player, Optional<ContextAwarePredicate> hamster) implements SimpleCriterionTrigger.SimpleInstance
    {
        public boolean matches(ServerPlayer playerEntity, LootContext hamsterContext) {
            if (this.player.isPresent() && !this.player.get().matches(EntityPredicate.createContext((ServerPlayer)playerEntity, (Entity)playerEntity))) {
                return false;
            }
            return this.hamster.isEmpty() || this.hamster.get().matches(hamsterContext);
        }
    }
}

