/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.block.custom;

import com.mojang.serialization.MapCodec;
import net.dawson.adorablehamsterpets.AdorableHamsterPets;
import net.dawson.adorablehamsterpets.config.AhpConfig;
import net.dawson.adorablehamsterpets.item.ModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.TallFlowerBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class SunflowerBlock
extends TallFlowerBlock
implements BonemealableBlock {
    public static final BooleanProperty HAS_SEEDS = BooleanProperty.create((String)"has_seeds");
    public static final MapCodec<TallFlowerBlock> CODEC = TallFlowerBlock.simpleCodec(SunflowerBlock::new);

    public SunflowerBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)HALF, (Comparable)DoubleBlockHalf.LOWER)).setValue((Property)HAS_SEEDS, (Comparable)Boolean.valueOf(true)));
    }

    public MapCodec<TallFlowerBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{HAS_SEEDS});
    }

    public boolean isRandomlyTicking(BlockState state) {
        return state.getValue((Property)HALF) == DoubleBlockHalf.UPPER && (Boolean)state.getValue((Property)HAS_SEEDS) == false;
    }

    public void randomTick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (state.getValue((Property)HALF) == DoubleBlockHalf.UPPER && !((Boolean)state.getValue((Property)HAS_SEEDS)).booleanValue()) {
            AhpConfig config = AdorableHamsterPets.CONFIG;
            double modifier = (Double)config.sunflowerRegrowthModifier.get();
            modifier = Math.max(0.1, modifier);
            int baseRegrowthChanceDenominator = 150;
            int effectiveDenominator = (int)Math.round((double)baseRegrowthChanceDenominator * modifier);
            if (random.nextInt(effectiveDenominator = Math.max(1, effectiveDenominator)) == 0) {
                world.setBlock(pos, (BlockState)state.setValue((Property)HAS_SEEDS, (Comparable)Boolean.valueOf(true)), 2);
            }
        }
    }

    public InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        if (state.getValue((Property)HALF) == DoubleBlockHalf.LOWER) {
            BlockPos topPos = pos.above();
            BlockState topState = world.getBlockState(topPos);
            if (topState.is((Block)this) && topState.getValue((Property)HALF) == DoubleBlockHalf.UPPER) {
                return this.useWithoutItem(topState, world, topPos, player, hit);
            }
            return InteractionResult.PASS;
        }
        if (((Boolean)state.getValue((Property)HAS_SEEDS)).booleanValue()) {
            if (!world.isClientSide) {
                int seedAmount = world.random.nextInt(3) + 1;
                ItemStack seedStack = new ItemStack((ItemLike)ModItems.SUNFLOWER_SEEDS.get(), seedAmount);
                Containers.dropItemStack((Level)world, (double)((double)pos.getX() + 0.5), (double)((double)pos.getY() + 0.5), (double)((double)pos.getZ() + 0.5), (ItemStack)seedStack);
                world.setBlock(pos, (BlockState)state.setValue((Property)HAS_SEEDS, (Comparable)Boolean.valueOf(false)), 2);
                world.playSound(null, pos, SoundEvents.SWEET_BERRY_BUSH_PICK_BERRIES, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            return InteractionResult.sidedSuccess((boolean)world.isClientSide);
        }
        return InteractionResult.PASS;
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack itemStack) {
        BlockPos topPos;
        BlockState topState;
        super.setPlacedBy(world, pos, state, placer, itemStack);
        if (!world.isClientSide && (topState = world.getBlockState(topPos = pos.above())).is((Block)this) && topState.getValue((Property)HALF) == DoubleBlockHalf.UPPER) {
            world.setBlock(topPos, (BlockState)topState.setValue((Property)HAS_SEEDS, (Comparable)Boolean.valueOf(false)), 2);
        }
    }

    public ItemStack getCloneItemStack(LevelReader world, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)Items.SUNFLOWER);
    }

    public boolean isValidBonemealTarget(LevelReader world, BlockPos pos, BlockState state) {
        return state.getValue((Property)HALF) == DoubleBlockHalf.LOWER && world.getBlockState(pos.above()).isAir();
    }

    public boolean isBonemealSuccess(Level world, RandomSource random, BlockPos pos, BlockState state) {
        return state.getValue((Property)HALF) == DoubleBlockHalf.LOWER && world.isEmptyBlock(pos.above());
    }

    public void performBonemeal(ServerLevel world, RandomSource random, BlockPos pos, BlockState state) {
        DoublePlantBlock.placeAt((LevelAccessor)world, (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)HALF, (Comparable)DoubleBlockHalf.UPPER)).setValue((Property)HAS_SEEDS, (Comparable)Boolean.valueOf(false))), (BlockPos)pos.above(), (int)2);
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        return super.updateShape(state, direction, neighborState, world, pos, neighborPos);
    }
}

