/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.client.announcements;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.List;
import net.dawson.adorablehamsterpets.AdorableHamsterPetsClient;
import net.dawson.adorablehamsterpets.client.announcements.AnnouncementManager;
import net.dawson.adorablehamsterpets.client.gui.widgets.AnnouncementIconAnimator;
import net.dawson.adorablehamsterpets.config.AhpConfig;
import net.dawson.adorablehamsterpets.config.Configs;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class AnnouncementHudRenderer {
    private static final ResourceLocation ICON_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"adorablehamsterpets", (String)"textures/item/announcement_bell_icon.png");
    private static final int ICON_WIDTH = 16;
    private static final int ICON_HEIGHT = 16;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(GuiGraphics context, float tickDelta) {
        Minecraft client = Minecraft.getInstance();
        AhpConfig config = Configs.AHP;
        if (!((Boolean)config.enableHudIcon.get()).booleanValue() || client.screen != null) {
            return;
        }
        List<AnnouncementManager.PendingNotification> notifications = AdorableHamsterPetsClient.getPendingNotifications();
        if (notifications.isEmpty()) {
            return;
        }
        AnnouncementIconAnimator animator = AnnouncementIconAnimator.INSTANCE;
        animator.setHovered(false);
        int screenWidth = context.guiWidth();
        int screenHeight = context.guiHeight();
        animator.updateTargetPosition(screenWidth, screenHeight);
        animator.updateHudPosition(animator.getTargetX(), animator.getTargetY());
        float animScale = animator.getRenderScale(tickDelta);
        float configScale = ((Float)Configs.AHP.hudIconScale.get()).floatValue();
        float finalScale = animScale * configScale;
        float angle = animator.getRenderAngle(tickDelta);
        double renderX = animator.getRenderX(tickDelta);
        double renderY = animator.getRenderY(tickDelta);
        context.pose().pushPose();
        try {
            context.pose().translate(renderX + 8.0, renderY + 8.0, 0.0);
            context.pose().scale(finalScale, finalScale, 1.0f);
            context.pose().mulPose(Axis.ZP.rotationDegrees(angle));
            context.pose().translate(-8.0, -8.0, 0.0);
            RenderSystem.enableBlend();
            context.blit(ICON_TEXTURE, 0, 0, 0.0f, 0.0f, 16, 16, 16, 16);
        }
        finally {
            context.pose().popPose();
        }
        double mouseX = client.mouseHandler.xpos();
        double mouseY = client.mouseHandler.ypos();
        if (mouseX >= renderX && mouseX <= renderX + (double)(16.0f * finalScale) && mouseY >= renderY && mouseY <= renderY + (double)(16.0f * finalScale)) {
            ArrayList<Object> tooltipLines = new ArrayList<Object>();
            MutableComponent modNameText = Component.translatable((String)"key.categories.adorablehamsterpets.main").withStyle(new ChatFormatting[]{ChatFormatting.BLUE, ChatFormatting.ITALIC});
            AnnouncementManager.PendingNotification primary = notifications.get(0);
            Component mainTooltipLine = AnnouncementManager.getTooltipTextForNotification(primary);
            tooltipLines.add(mainTooltipLine);
            tooltipLines.add(modNameText);
            context.renderComponentTooltip(client.font, tooltipLines, (int)mouseX, (int)mouseY);
        }
    }
}

