/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.client.announcements;

import java.util.List;
import net.dawson.adorablehamsterpets.AdorableHamsterPets;
import net.minecraft.resources.ResourceLocation;
import vazkii.patchouli.client.base.PersistentData;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.common.book.Book;
import vazkii.patchouli.common.book.BookRegistry;

public class PatchouliIntegration {
    public static void setEntryAsRead(BookEntry entry) {
        if (entry == null) {
            return;
        }
        PersistentData.BookData data = PersistentData.data.getBookData(entry.getBook());
        ResourceLocation entryId = entry.getId();
        if (!data.viewedEntries.contains(entryId)) {
            data.viewedEntries.add(entryId);
            entry.markReadStateDirty();
            PersistentData.save();
            AdorableHamsterPets.LOGGER.debug("[Announcements] Marked Patchouli entry '{}' as read.", (Object)entryId);
        }
    }

    public static void setEntryAsUnread(ResourceLocation entryId) {
        ResourceLocation bookId = ResourceLocation.fromNamespaceAndPath((String)"adorablehamsterpets", (String)"hamster_tips_guide_book");
        Book book = (Book)BookRegistry.INSTANCE.books.get(bookId);
        if (book == null) {
            return;
        }
        PersistentData.BookData data = PersistentData.data.getBookData(book);
        if (data.viewedEntries.remove(entryId.toString())) {
            BookEntry entry = (BookEntry)book.getContents().entries.get(entryId);
            if (entry != null) {
                entry.markReadStateDirty();
            }
            PersistentData.save();
            AdorableHamsterPets.LOGGER.debug("[Announcements] Marked Patchouli entry '{}' as unread.", (Object)entryId);
        }
    }

    public static void clearAllVirtualEntriesFromHistory() {
        ResourceLocation bookId = ResourceLocation.fromNamespaceAndPath((String)"adorablehamsterpets", (String)"hamster_tips_guide_book");
        Book book = (Book)BookRegistry.INSTANCE.books.get(bookId);
        if (book == null) {
            return;
        }
        PersistentData.BookData data = PersistentData.data.getBookData(book);
        List viewed = data.viewedEntries;
        boolean removed = viewed.removeIf(id -> id.getNamespace().equals("adorablehamsterpets") && id.getPath().startsWith("announcement_"));
        if (removed) {
            if (book.getContents() != null) {
                book.getContents().entries.values().forEach(BookEntry::markReadStateDirty);
            }
            PersistentData.save();
            AdorableHamsterPets.LOGGER.debug("[Announcements] Cleared all virtual announcement entries from Patchouli history.");
        }
    }
}

