/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.client.sound;

import net.dawson.adorablehamsterpets.entity.custom.HamsterEntity;
import net.dawson.adorablehamsterpets.sound.ModSounds;
import net.minecraft.client.resources.sounds.AbstractSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.resources.sounds.TickableSoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;

public class HamsterCleaningSoundInstance
extends AbstractSoundInstance
implements TickableSoundInstance {
    private final HamsterEntity hamster;
    private boolean done = false;

    public HamsterCleaningSoundInstance(HamsterEntity hamster) {
        super((SoundEvent)ModSounds.HAMSTER_SCRATCH.get(), SoundSource.NEUTRAL, hamster.getRandom());
        this.hamster = hamster;
        this.x = hamster.getX();
        this.y = hamster.getY();
        this.z = hamster.getZ();
        this.looping = true;
        this.delay = 0;
        this.volume = 2.0f;
        this.pitch = 1.0f;
        this.relative = false;
        this.attenuation = SoundInstance.Attenuation.LINEAR;
    }

    public void stop() {
        this.done = true;
    }

    public boolean isStopped() {
        return this.done;
    }

    public void tick() {
        if (!this.hamster.isCleaning() || !this.hamster.isAlive()) {
            this.done = true;
            return;
        }
        this.x = this.hamster.getX();
        this.y = this.hamster.getY();
        this.z = this.hamster.getZ();
    }
}

