/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.client.sound;

import java.util.Objects;
import net.dawson.adorablehamsterpets.AdorableHamsterPets;
import net.dawson.adorablehamsterpets.entity.custom.HamsterEntity;
import net.minecraft.client.resources.sounds.AbstractSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.resources.sounds.TickableSoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;

public class HamsterFlightSoundInstance
extends AbstractSoundInstance
implements TickableSoundInstance {
    private final HamsterEntity hamster;
    private boolean done = false;
    private int ticksElapsed = 0;
    private final int effectDuration = 30;
    private final float initialPitch = 1.0f;
    private final float basePitch = 0.5f;
    private final float initialVolume = 1.0f;
    private final float endVolume = 0.2f;

    public HamsterFlightSoundInstance(SoundEvent sound, SoundSource category, HamsterEntity hamster) {
        super(sound, category, hamster.getRandom());
        this.hamster = hamster;
        this.x = hamster.getX();
        this.y = hamster.getY();
        this.z = hamster.getZ();
        this.looping = false;
        this.delay = 0;
        this.volume = 1.0f;
        this.pitch = 1.0f;
        this.relative = false;
        this.attenuation = SoundInstance.Attenuation.LINEAR;
    }

    public boolean isStopped() {
        AdorableHamsterPets.LOGGER.debug("HamsterFlightSoundInstance isDone() checked, returning: {}", (Object)this.done);
        return this.done;
    }

    public void tick() {
        if (!this.hamster.isAlive() || this.hamster.isRemoved()) {
            if (!this.done) {
                AdorableHamsterPets.LOGGER.debug("HamsterFlightSoundInstance: Hamster invalid, setting done=true.");
            }
            this.done = true;
            return;
        }
        if (this.ticksElapsed > this.effectDuration) {
            if (!this.done) {
                AdorableHamsterPets.LOGGER.debug("HamsterFlightSoundInstance: Duration exceeded ({}), setting done=true.", (Object)this.effectDuration);
            }
            this.done = true;
            return;
        }
        ++this.ticksElapsed;
        this.x = this.hamster.getX();
        this.y = this.hamster.getY();
        this.z = this.hamster.getZ();
        float f = this.ticksElapsed;
        Objects.requireNonNull(this);
        float progress = Mth.clamp((float)(f / 30.0f), (float)0.0f, (float)1.0f);
        float curveFactor = Mth.cos((float)(progress * 1.5707964f));
        Objects.requireNonNull(this);
        this.pitch = this.basePitch + (1.0f - this.basePitch) * curveFactor;
        Objects.requireNonNull(this);
        this.volume = this.endVolume + (1.0f - this.endVolume) * curveFactor;
        this.pitch = Mth.clamp((float)this.pitch, (float)0.5f, (float)2.0f);
        this.volume = Mth.clamp((float)this.volume, (float)0.0f, (float)1.0f);
    }
}

