/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.client.sound;

import net.dawson.adorablehamsterpets.entity.custom.HamsterEntity;
import net.minecraft.client.resources.sounds.AbstractSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.resources.sounds.TickableSoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;

public class HamsterThrowSoundInstance
extends AbstractSoundInstance
implements TickableSoundInstance {
    private final HamsterEntity hamster;
    private boolean done = false;
    private boolean fadingOut = false;
    private int fadeOutTicksRemaining = 0;
    private static final int FADE_OUT_DURATION = 10;
    private static final float FIXED_VOLUME = 1.0f;
    private static final float FIXED_PITCH = 1.0f;

    public HamsterThrowSoundInstance(SoundEvent sound, SoundSource category, HamsterEntity hamster) {
        super(sound, category, hamster.getRandom());
        this.hamster = hamster;
        this.x = hamster.getX();
        this.y = hamster.getY();
        this.z = hamster.getZ();
        this.looping = false;
        this.delay = 0;
        this.volume = 1.0f;
        this.pitch = 1.0f;
        this.relative = false;
        this.attenuation = SoundInstance.Attenuation.LINEAR;
    }

    public boolean isStopped() {
        return this.done;
    }

    public void tick() {
        if (!this.hamster.isAlive() || this.hamster.isRemoved()) {
            this.done = true;
            return;
        }
        this.x = this.hamster.getX();
        this.y = this.hamster.getY();
        this.z = this.hamster.getZ();
        if (!this.fadingOut && !this.hamster.isThrown()) {
            this.fadingOut = true;
            this.fadeOutTicksRemaining = 10;
        }
        if (this.fadingOut) {
            if (this.fadeOutTicksRemaining > 0) {
                this.volume = 1.0f * ((float)this.fadeOutTicksRemaining / 10.0f);
                this.volume = Mth.clamp((float)this.volume, (float)0.0f, (float)1.0f);
                --this.fadeOutTicksRemaining;
            } else {
                this.volume = 0.0f;
                this.done = true;
            }
        }
    }
}

