/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.PlayerAdvancements;
import net.minecraft.server.level.ServerPlayer;

public class ModCommands {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext registryAccess, Commands.CommandSelection environment) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"ahamsterpets_unlock_advancements").requires(source -> source.hasPermission(2))).executes(context -> ModCommands.executeUnlockAllModAdvancements((CommandSourceStack)context.getSource())));
    }

    private static int executeUnlockAllModAdvancements(CommandSourceStack source) throws CommandSyntaxException {
        ServerPlayer player = source.getPlayerOrException();
        PlayerAdvancements tracker = player.getAdvancements();
        Collection allAdvancements = source.getServer().getAdvancements().getAllAdvancements();
        int count = 0;
        for (AdvancementHolder advancementEntry : allAdvancements) {
            AdvancementProgress progress;
            ResourceLocation id = advancementEntry.id();
            if (!id.getNamespace().equals("adorablehamsterpets") || !id.getPath().startsWith("husbandry/") || (progress = tracker.getOrStartProgress(advancementEntry)).isDone()) continue;
            for (String criterion : advancementEntry.value().criteria().keySet()) {
                tracker.award(advancementEntry, criterion);
            }
            ++count;
        }
        int finalCount = count;
        if (finalCount > 0) {
            source.sendSuccess(() -> Component.literal((String)("Unlocked " + finalCount + " Adorable Hamster Pets advancements.")), true);
        } else {
            source.sendSuccess(() -> Component.literal((String)"No new Adorable Hamster Pets advancements to unlock or all already unlocked."), true);
        }
        return finalCount;
    }
}

