/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.entity.AI;

import net.dawson.adorablehamsterpets.AdorableHamsterPets;
import net.dawson.adorablehamsterpets.entity.AI.HamsterWanderAroundFarGoal;
import net.dawson.adorablehamsterpets.entity.custom.HamsterEntity;
import net.dawson.adorablehamsterpets.mixin.accessor.LookAroundGoalAccessor;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;

public class HamsterLookAroundGoal
extends RandomLookAroundGoal {
    private final Mob hamsterMob;

    public HamsterLookAroundGoal(Mob mob) {
        super(mob);
        this.hamsterMob = mob;
    }

    public boolean canUse() {
        LookAroundGoalAccessor accessor = (LookAroundGoalAccessor)((Object)this);
        Mob mob = accessor.getMob();
        if (mob.getRandom().nextFloat() >= 0.02f) {
            return false;
        }
        Mob mob2 = this.hamsterMob;
        if (mob2 instanceof HamsterEntity) {
            HamsterEntity hamster = (HamsterEntity)mob2;
            return !hamster.isOrderedToSit() && !hamster.isSleeping() && !hamster.isKnockedOut() && !hamster.isSulking() && !hamster.isStealingDiamond() && !hamster.isCelebratingChase() && !hamster.getActiveCustomGoalDebugName().equals(HamsterWanderAroundFarGoal.class.getSimpleName());
        }
        return true;
    }

    public void start() {
        super.start();
        Mob mob = this.hamsterMob;
        if (mob instanceof HamsterEntity) {
            HamsterEntity he = (HamsterEntity)mob;
            he.setActiveCustomGoalDebugName(((Object)((Object)this)).getClass().getSimpleName());
            AdorableHamsterPets.LOGGER.trace("[AI Goal Start] Hamster {} started LookAroundGoal.", (Object)he.getId());
        }
    }

    public boolean canContinueToUse() {
        HamsterEntity hamster;
        Mob mob = this.hamsterMob;
        if (mob instanceof HamsterEntity && ((hamster = (HamsterEntity)mob).isOrderedToSit() || hamster.isSleeping() || hamster.isKnockedOut() || hamster.isSulking() || hamster.isStealingDiamond() || hamster.isCelebratingChase())) {
            return false;
        }
        return super.canContinueToUse();
    }

    public void stop() {
        HamsterEntity he;
        super.stop();
        Mob mob = this.hamsterMob;
        if (mob instanceof HamsterEntity && (he = (HamsterEntity)mob).getActiveCustomGoalDebugName().equals(((Object)((Object)this)).getClass().getSimpleName())) {
            he.setActiveCustomGoalDebugName("None");
        }
    }

    public void tick() {
        LookAroundGoalAccessor accessor = (LookAroundGoalAccessor)((Object)this);
        Mob mob = accessor.getMob();
        accessor.setLookTime(accessor.getLookTime() - 1);
        mob.getLookControl().setLookAt(mob.getX() + accessor.getDeltaX(), mob.getEyeY(), mob.getZ() + accessor.getDeltaZ(), 25.0f, 25.0f);
    }
}

