/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.entity.AI;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.dawson.adorablehamsterpets.AdorableHamsterPets;
import net.dawson.adorablehamsterpets.accessor.PlayerEntityAccessor;
import net.dawson.adorablehamsterpets.advancement.criterion.HamsterFoundGoldCriterion;
import net.dawson.adorablehamsterpets.advancement.criterion.HamsterLedToDiamondCriterion;
import net.dawson.adorablehamsterpets.advancement.criterion.ModCriteria;
import net.dawson.adorablehamsterpets.config.Configs;
import net.dawson.adorablehamsterpets.entity.custom.HamsterEntity;
import net.dawson.adorablehamsterpets.sound.ModSounds;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.PlayerAdvancements;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import org.jetbrains.annotations.Nullable;

public class HamsterSeekDiamondGoal
extends Goal {
    private final HamsterEntity hamster;
    private final Level world;
    private BlockPos targetOrePos;
    private boolean isSeekingGold;
    private SeekingState currentState = SeekingState.IDLE;
    private int pathingTickTimer;
    private int soundTimer;
    @Nullable
    private Path path;
    private static final int PATHING_RECHECK_INTERVAL = 20;
    private static final int SNIFF_SOUND_INTERVAL_MOVING = 30;
    private static final int SNIFF_SOUND_INTERVAL_WAITING = 160;

    public HamsterSeekDiamondGoal(HamsterEntity hamster) {
        this.hamster = hamster;
        this.world = hamster.level();
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        if (this.world.isClientSide || !Configs.AHP.enableIndependentDiamondSeeking) {
            return false;
        }
        if (!this.hamster.isPrimedToSeekDiamonds) {
            return false;
        }
        if (this.hamster.isOrderedToSit() || this.hamster.isSleeping() || this.hamster.isKnockedOut() || this.hamster.isCelebratingChase() || this.hamster.isSulking()) {
            return false;
        }
        if (this.hamster.getTarget() != null) {
            return false;
        }
        if (Configs.AHP.enableIndependentDiamondSeekCooldown && this.hamster.foundOreCooldownEndTick > this.world.getGameTime()) {
            return false;
        }
        return this.findNewTargetOreAndSetState();
    }

    private boolean findNewTargetOreAndSetState() {
        boolean targetIsGold;
        this.targetOrePos = null;
        this.isSeekingGold = false;
        this.hamster.currentOreTarget = null;
        ArrayList<BlockPos> exposedDiamondOres = new ArrayList<BlockPos>();
        ArrayList<BlockPos> buriedDiamondOres = new ArrayList<BlockPos>();
        ArrayList<BlockPos> buriedGoldOres = new ArrayList<BlockPos>();
        int radius = (Integer)Configs.AHP.diamondSeekRadius.get();
        for (BlockPos pos2 : BlockPos.withinManhattan((BlockPos)this.hamster.blockPosition(), (int)radius, (int)radius, (int)radius)) {
            BlockState state = this.world.getBlockState(pos2);
            Block block = state.getBlock();
            if (block == Blocks.DIAMOND_ORE || block == Blocks.DEEPSLATE_DIAMOND_ORE) {
                if (HamsterSeekDiamondGoal.isOreExposed(pos2, this.world)) {
                    exposedDiamondOres.add(pos2.immutable());
                    continue;
                }
                buriedDiamondOres.add(pos2.immutable());
                continue;
            }
            if (block != Blocks.GOLD_ORE && block != Blocks.DEEPSLATE_GOLD_ORE || !HamsterSeekDiamondGoal.isOreExposed(pos2, this.world)) continue;
            buriedGoldOres.add(pos2.immutable());
        }
        boolean bl = targetIsGold = !buriedGoldOres.isEmpty() && this.world.random.nextFloat() < ((Float)Configs.AHP.goldMistakeChance.get()).floatValue();
        if (targetIsGold) {
            buriedGoldOres.sort(Comparator.comparingDouble(pos -> pos.distToCenterSqr((Position)this.hamster.position())));
            this.targetOrePos = (BlockPos)buriedGoldOres.get(0);
            this.isSeekingGold = true;
        } else if (!exposedDiamondOres.isEmpty()) {
            exposedDiamondOres.sort(Comparator.comparingDouble(pos -> pos.distToCenterSqr((Position)this.hamster.position())));
            this.targetOrePos = (BlockPos)exposedDiamondOres.get(0);
        } else if (!buriedDiamondOres.isEmpty()) {
            buriedDiamondOres.sort(Comparator.comparingDouble(pos -> pos.distToCenterSqr((Position)this.hamster.position())));
            this.targetOrePos = (BlockPos)buriedDiamondOres.get(0);
        }
        if (this.targetOrePos != null) {
            this.hamster.currentOreTarget = this.targetOrePos;
            this.currentState = SeekingState.SCANNING;
            return true;
        }
        return false;
    }

    public void start() {
        this.hamster.setActiveCustomGoalDebugName(((Object)((Object)this)).getClass().getSimpleName() + (this.isSeekingGold ? "_Gold" : "_Diamond"));
        this.pathingTickTimer = 0;
        this.soundTimer = 0;
        this.attemptPathToTarget();
    }

    private void attemptPathToTarget() {
        if (this.targetOrePos == null) {
            this.currentState = SeekingState.IDLE;
            return;
        }
        this.path = this.hamster.getNavigation().createPath((double)this.targetOrePos.getX() + 0.5, (double)this.targetOrePos.getY(), (double)this.targetOrePos.getZ() + 0.5, 0);
        if (this.path != null) {
            this.hamster.getNavigation().moveTo(this.path, 0.5);
            this.currentState = SeekingState.MOVING_TO_ORE;
            this.soundTimer = 15;
        } else {
            this.currentState = SeekingState.WAITING_FOR_PATH;
            this.pathingTickTimer = 20;
            this.soundTimer = 80;
        }
    }

    public boolean canContinueToUse() {
        boolean isTargetGold;
        if (this.currentState == SeekingState.IDLE || this.currentState == SeekingState.CELEBRATING_DIAMOND || this.currentState == SeekingState.SULKING_AT_GOLD) {
            return false;
        }
        if (this.hamster.isOrderedToSit() || this.hamster.isSleeping() || this.hamster.isKnockedOut() || this.hamster.isSulking()) {
            return false;
        }
        if (this.hamster.getTarget() != null) {
            return false;
        }
        if (this.targetOrePos == null) {
            return false;
        }
        Block targetBlock = this.world.getBlockState(this.targetOrePos).getBlock();
        boolean isTargetDiamond = targetBlock == Blocks.DIAMOND_ORE || targetBlock == Blocks.DEEPSLATE_DIAMOND_ORE;
        boolean bl = isTargetGold = targetBlock == Blocks.GOLD_ORE || targetBlock == Blocks.DEEPSLATE_GOLD_ORE;
        if (this.isSeekingGold) {
            return isTargetGold;
        }
        return isTargetDiamond;
    }

    public void tick() {
        if (this.targetOrePos == null) {
            this.stop();
            return;
        }
        this.hamster.getLookControl().setLookAt((double)this.targetOrePos.getX() + 0.5, (double)this.targetOrePos.getY() + 0.5, (double)this.targetOrePos.getZ() + 0.5, 25.0f, 25.0f);
        if (this.soundTimer > 0) {
            --this.soundTimer;
        }
        switch (this.currentState.ordinal()) {
            case 2: {
                if (this.path != null && !this.world.isClientSide()) {
                    int currentNodeIndex = this.path.getNextNodeIndex();
                    int pathLength = this.path.getNodeCount();
                    for (int i = currentNodeIndex; i < pathLength; ++i) {
                        Node node = this.path.getNode(i);
                        Vec3 directionVector = Vec3.ZERO;
                        if (i + 1 < pathLength) {
                            Node nextNode = this.path.getNode(i + 1);
                            directionVector = new Vec3((double)(nextNode.x - node.x), 0.0, (double)(nextNode.z - node.z)).normalize();
                        }
                        for (int p = 0; p < 3; ++p) {
                            double distanceAlongPath = this.world.random.nextDouble();
                            Vec3 pathOffset = directionVector.scale(distanceAlongPath);
                            double offsetY = (this.world.random.nextDouble() - 0.5) * 0.1;
                            ((ServerLevel)this.world).sendParticles((ParticleOptions)ParticleTypes.MYCELIUM, (double)node.x + 0.5 + pathOffset.x, (double)node.y + 0.5 - 0.38 + offsetY, (double)node.z + 0.5 + pathOffset.z, 1, 0.2, 0.0, 0.2, 3.0);
                        }
                    }
                }
                if (this.hamster.getNavigation().isDone() || this.hamster.blockPosition().closerThan((Vec3i)this.targetOrePos, 1.5)) {
                    if (this.hamster.blockPosition().closerThan((Vec3i)this.targetOrePos, 1.5)) {
                        this.onOreReached();
                        break;
                    }
                    this.path = null;
                    this.currentState = SeekingState.WAITING_FOR_PATH;
                    this.pathingTickTimer = 20;
                    this.soundTimer = 80;
                    break;
                }
                if (this.soundTimer > 0) break;
                this.playSniffSound();
                this.soundTimer = 30;
                break;
            }
            case 3: {
                if (this.pathingTickTimer > 0) {
                    --this.pathingTickTimer;
                } else {
                    this.attemptPathToTarget();
                }
                if (this.soundTimer > 0) break;
                this.playSniffSound();
                this.soundTimer = 160;
            }
        }
    }

    private void onOreReached() {
        this.hamster.getNavigation().stop();
        this.hamster.isPrimedToSeekDiamonds = false;
        if (Configs.AHP.enableIndependentDiamondSeekCooldown) {
            this.hamster.foundOreCooldownEndTick = this.world.getGameTime() + (long)((Integer)Configs.AHP.independentOreSeekCooldownTicks.get()).intValue();
        }
        if (this.isSeekingGold) {
            this.currentState = SeekingState.SULKING_AT_GOLD;
            LivingEntity livingEntity = this.hamster.getOwner();
            if (livingEntity instanceof ServerPlayer) {
                ServerPlayer owner = (ServerPlayer)livingEntity;
                if (this.hamster.distanceToSqr((Entity)owner) < 36.0) {
                    this.hamster.getLookControl().setLookAt((Entity)owner, 25.0f, 25.0f);
                }
                this.sendMessageToOwner(owner);
            }
            Vec3 awayFromOre = this.hamster.position().subtract(Vec3.atCenterOf((Vec3i)this.targetOrePos)).normalize();
            this.hamster.setDeltaMovement(awayFromOre.x * 0.1, 0.5, awayFromOre.z * 0.1);
            this.hamster.hasImpulse = true;
            SoundEvent bounceSound = ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_BOUNCE_SOUNDS, this.hamster.getRandom());
            if (bounceSound != null) {
                this.world.playSound(null, this.hamster.blockPosition(), bounceSound, SoundSource.NEUTRAL, 0.6f, this.hamster.getVoicePitch());
            }
            this.hamster.setSulking(true);
            this.hamster.triggerAnimOnServer("mainController", "anim_hamster_sulk");
        } else {
            this.currentState = SeekingState.CELEBRATING_DIAMOND;
            this.hamster.setCelebratingDiamond(true);
            AdorableHamsterPets.LOGGER.trace("Hamster {} reached CELEBRATING_DIAMOND state for ore at {}", (Object)this.hamster.getId(), (Object)this.targetOrePos);
            LivingEntity livingEntity = this.hamster.getOwner();
            if (livingEntity instanceof ServerPlayer) {
                ServerPlayer serverPlayerOwner = (ServerPlayer)livingEntity;
                ((HamsterLedToDiamondCriterion)((Object)ModCriteria.HAMSTER_LED_TO_DIAMOND.get())).trigger(serverPlayerOwner, this.hamster, this.targetOrePos);
            }
        }
    }

    private void playSniffSound() {
        SoundEvent sniffSound = ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_DIAMOND_SNIFF_SOUNDS, this.hamster.getRandom());
        if (sniffSound != null) {
            this.world.playSound(null, this.hamster.blockPosition(), sniffSound, SoundSource.NEUTRAL, 3.0f, this.hamster.getVoicePitch());
        }
    }

    public void stop() {
        this.path = null;
        this.hamster.getNavigation().stop();
        boolean targetOreStillExists = false;
        if (this.targetOrePos != null) {
            boolean isTargetGold;
            Block targetBlock = this.world.getBlockState(this.targetOrePos).getBlock();
            boolean isTargetDiamond = targetBlock == Blocks.DIAMOND_ORE || targetBlock == Blocks.DEEPSLATE_DIAMOND_ORE;
            boolean bl = isTargetGold = targetBlock == Blocks.GOLD_ORE || targetBlock == Blocks.DEEPSLATE_GOLD_ORE;
            if (this.isSeekingGold && isTargetGold) {
                targetOreStillExists = true;
            }
            if (!this.isSeekingGold && isTargetDiamond) {
                targetOreStillExists = true;
            }
        }
        if (this.currentState != SeekingState.CELEBRATING_DIAMOND && this.currentState != SeekingState.SULKING_AT_GOLD && !targetOreStillExists) {
            this.hamster.isPrimedToSeekDiamonds = false;
        }
        if (this.hamster.isCelebratingDiamond() && (this.currentState != SeekingState.CELEBRATING_DIAMOND || !targetOreStillExists)) {
            this.hamster.setCelebratingDiamond(false);
        }
        if (this.hamster.getActiveCustomGoalDebugName().startsWith(((Object)((Object)this)).getClass().getSimpleName())) {
            this.hamster.setActiveCustomGoalDebugName("None");
        }
        this.currentState = SeekingState.IDLE;
        this.targetOrePos = null;
    }

    private void sendMessageToOwner(ServerPlayer owner) {
        int messageIndex;
        PlayerAdvancements tracker = owner.getAdvancements();
        ResourceLocation advId = ResourceLocation.fromNamespaceAndPath((String)"adorablehamsterpets", (String)"technical/hamster_found_gold_first_time");
        AdvancementHolder advancement = owner.server.getAdvancements().get(advId);
        if (advancement == null) {
            AdorableHamsterPets.LOGGER.error("[GoldMessage] CRITICAL: Could not find advancement '{}'. Message will not be sent. Check file path and JSON validity.", (Object)advId);
            return;
        }
        AdvancementProgress progress = tracker.getOrStartProgress(advancement);
        if (!progress.isDone()) {
            messageIndex = 0;
            for (String criterion : advancement.value().criteria().keySet()) {
                tracker.award(advancement, criterion);
            }
        } else {
            PlayerEntityAccessor accessor = (PlayerEntityAccessor)owner;
            int lastIndex = accessor.ahp_getLastGoldMessageIndex();
            List possibleIndices = IntStream.range(0, 7).boxed().collect(Collectors.toList());
            if (lastIndex >= 0 && lastIndex < 7) {
                possibleIndices.remove((Object)lastIndex);
            }
            messageIndex = (Integer)possibleIndices.get(this.world.random.nextInt(possibleIndices.size()));
        }
        ((PlayerEntityAccessor)owner).ahp_setLastGoldMessageIndex(messageIndex);
        String messageKey = "message.adorablehamsterpets.found_gold_mistake." + (messageIndex + 1);
        owner.displayClientMessage((Component)Component.translatable((String)messageKey).withStyle(ChatFormatting.GOLD), true);
        ((HamsterFoundGoldCriterion)((Object)ModCriteria.HAMSTER_FOUND_GOLD.get())).trigger(owner);
    }

    public static boolean isOreExposed(BlockPos orePos, Level world) {
        for (Direction direction : Direction.values()) {
            BlockPos adjacentPos = orePos.relative(direction);
            if (!world.getBlockState(adjacentPos).getCollisionShape((BlockGetter)world, adjacentPos, CollisionContext.empty()).isEmpty()) continue;
            return true;
        }
        return false;
    }

    private static enum SeekingState {
        IDLE,
        SCANNING,
        MOVING_TO_ORE,
        WAITING_FOR_PATH,
        CELEBRATING_DIAMOND,
        SULKING_AT_GOLD;

    }
}

