/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.entity.AI;

import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.dawson.adorablehamsterpets.AdorableHamsterPets;
import net.dawson.adorablehamsterpets.config.Configs;
import net.dawson.adorablehamsterpets.entity.custom.HamsterEntity;
import net.dawson.adorablehamsterpets.sound.ModSounds;
import net.dawson.adorablehamsterpets.tag.ModItemTags;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class HamsterStealDiamondGoal
extends Goal {
    private final HamsterEntity hamster;
    private final Level world;
    @Nullable
    private ItemEntity targetItem;
    @Nullable
    private Player owner;
    @Nullable
    private Vec3 pounceStartPos;
    private int bounceSoundDelayTicks;
    private int tauntSettleTicks;
    @Nullable
    private Vec3 repositionTarget;
    private int repositionAttempts;
    private static final int LUNGE_DURATION_TICKS = 5;
    private int lungeTicks;
    private State currentState = State.SCANNING;
    private int stealDurationTimer;

    public HamsterStealDiamondGoal(HamsterEntity hamster) {
        this.hamster = hamster;
        this.world = hamster.level();
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
    }

    public boolean canUse() {
        float chance;
        AdorableHamsterPets.LOGGER.trace("[StealGoal-{}] Evaluating canStart...", (Object)this.hamster.getId());
        if (this.hamster.isStealingDiamond()) {
            if (this.hamster.isOrderedToSit()) {
                return false;
            }
            if (!(this.hamster.getOwner() instanceof Player)) {
                return false;
            }
            this.owner = (Player)this.hamster.getOwner();
            AdorableHamsterPets.LOGGER.trace("[StealGoal-{}] canStart SUCCEEDED: Resuming existing steal.", (Object)this.hamster.getId());
            return true;
        }
        if (!Configs.AHP.enableDiamondStealing) {
            return false;
        }
        if (this.hamster.isStealingDiamond()) {
            AdorableHamsterPets.LOGGER.trace("[StealGoal-{}] canStart FAILED: Hamster is already in a stealing state.", (Object)this.hamster.getId());
            return false;
        }
        if (this.hamster.isOrderedToSit()) {
            AdorableHamsterPets.LOGGER.trace("[StealGoal-{}] canStart FAILED: Hamster is sitting.", (Object)this.hamster.getId());
            return false;
        }
        long currentTime = this.world.getGameTime();
        if (this.hamster.stealCooldownEndTick > currentTime) {
            AdorableHamsterPets.LOGGER.trace("[StealGoal-{}] canStart FAILED: Steal cooldown is active for another {} ticks.", (Object)this.hamster.getId(), (Object)(this.hamster.stealCooldownEndTick - currentTime));
            return false;
        }
        float randomVal = this.hamster.getRandom().nextFloat();
        if (randomVal > (chance = ((Float)Configs.AHP.diamondPounceChance.get()).floatValue())) {
            AdorableHamsterPets.LOGGER.trace("[StealGoal-{}] canStart FAILED: Pounce chance check failed (Rolled {} > Chance {})", new Object[]{this.hamster.getId(), String.format("%.2f", Float.valueOf(randomVal)), String.format("%.2f", Float.valueOf(chance))});
            return false;
        }
        LivingEntity livingEntity = this.hamster.getOwner();
        if (!(livingEntity instanceof Player)) {
            AdorableHamsterPets.LOGGER.trace("[StealGoal-{}] canStart FAILED: Hamster has no valid owner.", (Object)this.hamster.getId());
            return false;
        }
        Player playerOwner = (Player)livingEntity;
        this.owner = playerOwner;
        List<Item> stealableItems = Configs.AHP.stealableItems.stream().map(ResourceLocation::tryParse).filter(Objects::nonNull).map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.ITEM).get(arg_0)).filter(item -> item != Items.AIR).toList();
        if (stealableItems.isEmpty()) {
            AdorableHamsterPets.LOGGER.trace("[StealGoal-{}] canStart FAILED: No valid stealable items configured or parsed.", (Object)this.hamster.getId());
            return false;
        }
        List nearbyItems = this.world.getEntitiesOfClass(ItemEntity.class, this.hamster.getBoundingBox().inflate(10.0), itemEntity -> ModItemTags.isStealableItem(itemEntity.getItem()) && itemEntity.onGround());
        Optional<ItemEntity> closestItem = nearbyItems.stream().filter(item -> this.hamster.getNavigation().createPath((Entity)item, 0) != null).min((item1, item2) -> Float.compare(item1.distanceTo((Entity)this.hamster), item2.distanceTo((Entity)this.hamster)));
        if (closestItem.isPresent()) {
            this.targetItem = closestItem.get();
            AdorableHamsterPets.LOGGER.trace("[StealGoal-{}] canStart SUCCEEDED. Target item: {} at {}. Owner: {}", new Object[]{this.hamster.getId(), this.targetItem.getItem().getItem(), this.targetItem.blockPosition(), this.owner.getName().getString()});
            return true;
        }
        return false;
    }

    public boolean canContinueToUse() {
        if (this.hamster.isOrderedToSit()) {
            AdorableHamsterPets.LOGGER.trace("[StealGoal-{}] shouldContinue check failed: Hamster is sitting.", (Object)this.hamster.getId());
            return false;
        }
        if (this.owner == null || !this.owner.isAlive()) {
            AdorableHamsterPets.LOGGER.trace("[StealGoal-{}] shouldContinue check failed: Owner is null or not alive.", (Object)this.hamster.getId());
            return false;
        }
        if (this.stealDurationTimer <= 0) {
            AdorableHamsterPets.LOGGER.trace("[StealGoal-{}] shouldContinue check failed: Steal duration timer expired.", (Object)this.hamster.getId());
            return false;
        }
        if (this.currentState == State.FLEEING || this.currentState == State.TAUNTING) {
            if (!this.hamster.isStealingDiamond()) {
                AdorableHamsterPets.LOGGER.trace("[StealGoal-{}] shouldContinue check failed: Player retrieved diamond (isStealingDiamond is false).", (Object)this.hamster.getId());
                return false;
            }
        } else if (!(this.currentState != State.MOVING_TO_DIAMOND && this.currentState != State.POUNCING || this.targetItem != null && this.targetItem.isAlive())) {
            AdorableHamsterPets.LOGGER.trace("[StealGoal-{}] shouldContinue check failed: Target item disappeared before pounce.", (Object)this.hamster.getId());
            return false;
        }
        return true;
    }

    public void start() {
        this.hamster.setActiveCustomGoalDebugName(((Object)((Object)this)).getClass().getSimpleName());
        if (this.hamster.isStealingDiamond()) {
            this.stealDurationTimer = this.hamster.getStealDurationTimer();
            this.targetItem = null;
            AdorableHamsterPets.LOGGER.trace("[StealGoal-{}] Resuming steal. Duration left: {} ticks.", (Object)this.hamster.getId(), (Object)this.stealDurationTimer);
            this.currentState = this.hamster.distanceTo((Entity)this.owner) < (float)((Integer)Configs.AHP.minFleeDistance.get()).intValue() ? State.FLEEING : State.TAUNTING;
        } else {
            this.currentState = State.MOVING_TO_DIAMOND;
            this.hamster.getNavigation().moveTo((Entity)this.targetItem, 0.75);
            this.stealDurationTimer = this.hamster.getRandom().nextIntBetweenInclusive((Integer)Configs.AHP.minStealDurationSeconds.get() * 20, (Integer)Configs.AHP.maxStealDurationSeconds.get() * 20);
            this.hamster.setStealDurationTimer(this.stealDurationTimer);
            this.repositionTarget = null;
            this.repositionAttempts = 0;
            AdorableHamsterPets.LOGGER.trace("[StealGoal-{}] Goal started fresh. State: MOVING_TO_DIAMOND. Duration: {} ticks.", (Object)this.hamster.getId(), (Object)this.stealDurationTimer);
        }
    }

    public void stop() {
        ItemStack stolenStack;
        AdorableHamsterPets.LOGGER.trace("[StealGoal-{}] Goal stopped. Final state was: {}.", (Object)this.hamster.getId(), (Object)this.currentState);
        this.hamster.stealCooldownEndTick = this.world.getGameTime() + (long)((Integer)Configs.AHP.stealCooldownTicks.get()).intValue();
        if (this.hamster.isStealingDiamond() && this.stealDurationTimer <= 0 && !(stolenStack = this.hamster.getStolenItemStack()).isEmpty()) {
            this.world.addFreshEntity((Entity)new ItemEntity(this.world, this.hamster.getX(), this.hamster.getY(), this.hamster.getZ(), stolenStack.copy()));
            this.hamster.playSound(ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_HURT_SOUNDS, this.hamster.getRandom()), 1.0f, 1.0f);
            SoundEvent pounceSound = ModSounds.getDynamicItemSound(stolenStack);
            float volume = pounceSound == SoundEvents.GENERIC_EAT ? 0.35f : 1.0f;
            this.world.playSound(null, this.hamster.blockPosition(), pounceSound, SoundSource.NEUTRAL, volume, 1.7f);
            AdorableHamsterPets.LOGGER.trace("[StealGoal-{}] Dropped stolen item {} because timer expired.", (Object)this.hamster.getId(), (Object)stolenStack.getItem());
        }
        this.hamster.setStolenItemStack(ItemStack.EMPTY);
        this.hamster.setStealDurationTimer(0);
        this.hamster.setTaunting(false);
        this.hamster.setStealingDiamond(false);
        this.hamster.getNavigation().stop();
        this.targetItem = null;
        this.owner = null;
        this.currentState = State.SCANNING;
        if (this.hamster.getActiveCustomGoalDebugName().equals(((Object)((Object)this)).getClass().getSimpleName())) {
            this.hamster.setActiveCustomGoalDebugName("None");
        }
    }

    public void tick() {
        if (this.stealDurationTimer > 0) {
            --this.stealDurationTimer;
            this.hamster.setStealDurationTimer(this.stealDurationTimer);
        }
        if (this.owner == null) {
            return;
        }
        if (this.bounceSoundDelayTicks > 0) {
            --this.bounceSoundDelayTicks;
            if (this.bounceSoundDelayTicks == 0) {
                this.hamster.playSound((SoundEvent)ModSounds.HAMSTER_BOUNCE.get(), 0.6f, this.hamster.getVoicePitch() * 1.2f);
            }
        }
        --this.stealDurationTimer;
        this.hamster.setStealDurationTimer(this.stealDurationTimer);
        switch (this.currentState.ordinal()) {
            case 1: {
                if (this.targetItem == null) {
                    return;
                }
                this.hamster.getLookControl().setLookAt((Entity)this.targetItem, 25.0f, 25.0f);
                if (this.hamster.getNavigation().isDone()) {
                    this.currentState = State.REPOSITIONING;
                    AdorableHamsterPets.LOGGER.trace("[StealGoal-{}] Navigator is idle, transitioning to REPOSITIONING.", (Object)this.hamster.getId());
                    return;
                }
                if (!((double)this.hamster.distanceTo((Entity)this.targetItem) < 1.5)) break;
                this.currentState = State.POUNCING;
                this.lungeTicks = 5;
                this.pounceStartPos = this.hamster.position();
                this.hamster.getNavigation().stop();
                this.hamster.triggerAnimOnServer("mainController", "anim_hamster_diamond_pounce");
                this.bounceSoundDelayTicks = 5;
                SoundEvent celebrationSound = ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_CELEBRATE_SOUNDS, this.hamster.getRandom());
                if (celebrationSound != null) {
                    this.hamster.playSound(celebrationSound, 0.7f, this.hamster.getVoicePitch());
                }
                AdorableHamsterPets.LOGGER.trace("[StealGoal-{}] State changed to POUNCING.", (Object)this.hamster.getId());
                break;
            }
            case 2: {
                if (this.targetItem == null) {
                    return;
                }
                if (this.repositionAttempts >= 3) {
                    AdorableHamsterPets.LOGGER.trace("[StealGoal-{}] Exceeded max reposition attempts. Stopping goal.", (Object)this.hamster.getId());
                    this.stealDurationTimer = 0;
                    return;
                }
                if (this.repositionTarget == null) {
                    ++this.repositionAttempts;
                    this.repositionTarget = LandRandomPos.getPosTowards((PathfinderMob)this.hamster, (int)2, (int)3, (Vec3)Vec3.atCenterOf((Vec3i)this.targetItem.blockPosition()));
                    if (this.repositionTarget != null) {
                        this.hamster.getNavigation().moveTo(this.repositionTarget.x, this.repositionTarget.y, this.repositionTarget.z, 0.75);
                        AdorableHamsterPets.LOGGER.trace("[StealGoal-{}] Attempt #{}: Found repositioning target at {}. Moving now.", new Object[]{this.hamster.getId(), this.repositionAttempts, this.repositionTarget});
                    } else {
                        AdorableHamsterPets.LOGGER.trace("[StealGoal-{}] Could not find a repositioning target. Stopping goal.", (Object)this.hamster.getId());
                        this.stealDurationTimer = 0;
                        return;
                    }
                }
                if (!this.hamster.getNavigation().isDone()) break;
                this.repositionTarget = null;
                this.currentState = State.MOVING_TO_DIAMOND;
                AdorableHamsterPets.LOGGER.trace("[StealGoal-{}] Repositioning move complete. Transitioning back to MOVING_TO_DIAMOND.", (Object)this.hamster.getId());
                break;
            }
            case 3: {
                if (this.targetItem == null) {
                    return;
                }
                --this.lungeTicks;
                if (this.pounceStartPos != null && this.lungeTicks >= 0) {
                    double progress = (double)(5 - this.lungeTicks) / 5.0;
                    double easedProgress = progress * progress;
                    double newX = this.pounceStartPos.x + easedProgress * (this.targetItem.getX() - this.pounceStartPos.x);
                    double newZ = this.pounceStartPos.z + easedProgress * (this.targetItem.getZ() - this.pounceStartPos.z);
                    this.hamster.setPos(newX, this.hamster.getY(), newZ);
                }
                if (this.lungeTicks >= 0) break;
                ItemStack stackToSteal = this.targetItem.getItem().copy();
                if (stackToSteal.isEmpty()) {
                    this.stealDurationTimer = 0;
                    return;
                }
                this.hamster.setStolenItemStack(stackToSteal);
                this.targetItem.discard();
                this.hamster.setStealingDiamond(true);
                SoundEvent pounceSound = ModSounds.getDynamicItemSound(stackToSteal);
                float volume = pounceSound == SoundEvents.GENERIC_EAT ? 0.35f : 1.0f;
                this.world.playSound(null, this.hamster.blockPosition(), pounceSound, SoundSource.NEUTRAL, volume, 1.7f);
                if (!this.world.isClientSide) {
                    ((ServerLevel)this.world).sendParticles((ParticleOptions)ParticleTypes.END_ROD, this.hamster.getX(), this.hamster.getY() + 0.5, this.hamster.getZ(), 5, 0.1, 0.1, 0.1, 0.05);
                    ((ServerLevel)this.world).sendParticles((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, stackToSteal), this.hamster.getX(), this.hamster.getY() + 0.5, this.hamster.getZ(), 18, 0.2, 0.2, 0.2, 0.1);
                }
                this.currentState = State.FLEEING;
                AdorableHamsterPets.LOGGER.trace("[StealGoal-{}] Pounce finished. Item stolen. State changed to FLEEING.", (Object)this.hamster.getId());
                break;
            }
            case 4: {
                this.hamster.setTaunting(false);
                if (this.hamster.distanceTo((Entity)this.owner) < (float)((Integer)Configs.AHP.minFleeDistance.get()).intValue()) {
                    Vec3 fleePos = LandRandomPos.getPosAway((PathfinderMob)this.hamster, (int)((Integer)Configs.AHP.maxFleeDistance.get()), (int)7, (Vec3)this.owner.position());
                    if (fleePos == null) break;
                    this.hamster.getNavigation().moveTo(fleePos.x, fleePos.y, fleePos.z, 1.5);
                    AdorableHamsterPets.LOGGER.trace("[StealGoal-{}] Fleeing: Owner too close, found new flee point at {}.", (Object)this.hamster.getId(), (Object)fleePos);
                    break;
                }
                this.currentState = State.TAUNTING;
                this.hamster.getNavigation().stop();
                AdorableHamsterPets.LOGGER.trace("[StealGoal-{}] State changed to TAUNTING.", (Object)this.hamster.getId());
                break;
            }
            case 5: {
                this.hamster.getLookControl().setLookAt((Entity)this.owner, 25.0f, 25.0f);
                if (!this.hamster.isTaunting() && this.tauntSettleTicks == 0) {
                    this.tauntSettleTicks = 5;
                }
                if (this.tauntSettleTicks > 0) {
                    --this.tauntSettleTicks;
                }
                if (this.hamster.getNavigation().isDone() && this.tauntSettleTicks == 0) {
                    this.hamster.setTaunting(true);
                }
                if (!(this.hamster.distanceTo((Entity)this.owner) < (float)((Integer)Configs.AHP.minFleeDistance.get()).intValue())) break;
                this.currentState = State.FLEEING;
                this.hamster.setTaunting(false);
                this.tauntSettleTicks = 0;
                AdorableHamsterPets.LOGGER.trace("[StealGoal-{}] State changed back to FLEEING.", (Object)this.hamster.getId());
            }
        }
    }

    private static enum State {
        SCANNING,
        MOVING_TO_DIAMOND,
        REPOSITIONING,
        POUNCING,
        FLEEING,
        TAUNTING;

    }
}

