/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.entity.AI;

import java.util.Optional;
import net.dawson.adorablehamsterpets.AdorableHamsterPets;
import net.dawson.adorablehamsterpets.entity.custom.HamsterEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class HamsterWanderAroundFarGoal
extends WaterAvoidingRandomStrollGoal {
    private final HamsterEntity hamster;
    private static final double BUFFED_WANDER_SPEED = 0.9;

    public HamsterWanderAroundFarGoal(HamsterEntity hamster, double speed) {
        super((PathfinderMob)hamster, speed);
        this.hamster = hamster;
        this.setInterval(110);
    }

    public HamsterWanderAroundFarGoal(HamsterEntity hamster, double speed, float probability) {
        super((PathfinderMob)hamster, speed, probability);
        this.hamster = hamster;
        this.setInterval(110);
    }

    public boolean canUse() {
        if (this.hamster.isOrderedToSit() || this.hamster.isSleeping() || this.hamster.isKnockedOut() || this.hamster.isSulking() || this.hamster.isCelebratingDiamond() || this.hamster.isCelebratingChase()) {
            return false;
        }
        if (this.hamster.hasGreenBeanBuff()) {
            if (this.mob.getRandom().nextInt(3) != 0) {
                AdorableHamsterPets.LOGGER.trace("[WanderGoal-{}] canStart (Zoomies): FAILED - On cooldown.", (Object)this.hamster.getId());
                return false;
            }
            Vec3 target = this.getPosition();
            if (target == null) {
                AdorableHamsterPets.LOGGER.trace("[WanderGoal-{}] canStart (Zoomies): FAILED - No valid target found.", (Object)this.hamster.getId());
                return false;
            }
            this.wantedX = target.x;
            this.wantedY = target.y;
            this.wantedZ = target.z;
            AdorableHamsterPets.LOGGER.trace("[WanderGoal-{}] canStart (Zoomies): SUCCEEDED. Target: ({}, {}, {})", new Object[]{this.hamster.getId(), String.format("%.2f", target.x), String.format("%.2f", target.y), String.format("%.2f", target.z)});
            return true;
        }
        boolean canStartNormal = super.canUse();
        AdorableHamsterPets.LOGGER.trace("[WanderGoal-{}] canStart (Normal): Result: {}", (Object)this.hamster.getId(), (Object)canStartNormal);
        return canStartNormal;
    }

    public boolean canContinueToUse() {
        if (this.hamster.hasGreenBeanBuff()) {
            return !this.hamster.isOrderedToSit() && !this.hamster.isSleeping() && !this.hamster.isKnockedOut() && !this.mob.getNavigation().isDone();
        }
        return super.canContinueToUse();
    }

    public void tick() {
        if (this.hamster.hasGreenBeanBuff() && this.mob.getNavigation().isDone()) {
            AdorableHamsterPets.LOGGER.trace("[WanderGoal-{}] tick (Zoomies): Navigation is idle. Finding new target.", (Object)this.hamster.getId());
            Vec3 newTarget = this.getPosition();
            if (newTarget != null) {
                this.mob.getNavigation().moveTo(newTarget.x, newTarget.y, newTarget.z, 0.9);
            }
        }
    }

    public void start() {
        double currentSpeed = this.hamster.hasGreenBeanBuff() ? 0.9 : this.speedModifier;
        this.mob.getNavigation().moveTo(this.wantedX, this.wantedY, this.wantedZ, currentSpeed);
        this.hamster.setActiveCustomGoalDebugName(((Object)((Object)this)).getClass().getSimpleName() + (this.hamster.hasGreenBeanBuff() ? " (Zoomies)" : ""));
        AdorableHamsterPets.LOGGER.trace("[WanderGoal-{}] start: Goal has started. IsBuffed: {}", (Object)this.hamster.getId(), (Object)this.hamster.hasGreenBeanBuff());
    }

    @Nullable
    protected Vec3 getPosition() {
        if (this.hamster.hasGreenBeanBuff()) {
            return this.getPreciseZoomiesTarget().map(Vec3::atCenterOf).orElse(null);
        }
        return super.getPosition();
    }

    private Optional<BlockPos> getPreciseZoomiesTarget() {
        LivingEntity livingEntity = this.hamster.getOwner();
        if (!(livingEntity instanceof Player)) {
            return Optional.empty();
        }
        Player owner = (Player)livingEntity;
        double lastAngle = this.hamster.getLastZoomiesAngle();
        boolean isClockwise = this.hamster.getZoomiesIsClockwise();
        double angleStep = Math.toRadians(this.hamster.getRandom().nextIntBetweenInclusive(40, 70));
        double newAngle = isClockwise ? lastAngle + angleStep : lastAngle - angleStep;
        this.hamster.setLastZoomiesAngle(newAngle);
        int radiusModifier = this.hamster.getZoomiesRadiusModifier();
        double radius = this.hamster.getRandom().nextIntBetweenInclusive(3 + radiusModifier, 5 + radiusModifier);
        double targetX = owner.getX() + radius * Math.cos(newAngle);
        double targetZ = owner.getZ() + radius * Math.sin(newAngle);
        BlockPos idealPos = new BlockPos((int)targetX, (int)this.hamster.getY(), (int)targetZ);
        Optional<BlockPos> finalTargetPos = this.hamster.findSafeSpawnPosition(idealPos, this.hamster.level(), 2);
        AdorableHamsterPets.LOGGER.trace("[WanderGoal-{}] getPreciseZoomiesTarget:\n  - IsClockwise: {}\n  - LastAngle(rad): {}\n  - AngleStep(rad): {}\n  - NewAngle(rad): {}\n  - Radius: {}\n  - IdealPos: {}\n  - FinalTarget: {}", new Object[]{this.hamster.getId(), isClockwise, String.format("%.2f", lastAngle), String.format("%.2f", angleStep), String.format("%.2f", newAngle), String.format("%.2f", radius), idealPos, finalTargetPos.map(Vec3i::toString).orElse("null")});
        return this.hamster.findSafeSpawnPosition(idealPos, this.hamster.level(), 2);
    }

    public void stop() {
        super.stop();
        if (this.hamster.getActiveCustomGoalDebugName().startsWith(((Object)((Object)this)).getClass().getSimpleName())) {
            this.hamster.setActiveCustomGoalDebugName("None");
        }
        AdorableHamsterPets.LOGGER.trace("[WanderGoal-{}] stop: Goal has stopped.", (Object)this.hamster.getId());
    }
}

