/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.entity;

import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.item.ItemStack;

public interface ImplementedInventory
extends Container {
    public NonNullList<ItemStack> getItems();

    public static NonNullList<ItemStack> create(int size) {
        return NonNullList.withSize((int)size, (Object)ItemStack.EMPTY);
    }

    default public int getContainerSize() {
        return this.getItems().size();
    }

    default public boolean isEmpty() {
        for (int i = 0; i < this.getContainerSize(); ++i) {
            ItemStack stack = this.getItem(i);
            if (stack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    default public ItemStack getItem(int slot) {
        return (ItemStack)this.getItems().get(slot);
    }

    default public ItemStack removeItem(int slot, int amount) {
        ItemStack result = ContainerHelper.removeItem(this.getItems(), (int)slot, (int)amount);
        if (!result.isEmpty()) {
            this.setChanged();
        }
        return result;
    }

    default public ItemStack removeItemNoUpdate(int slot) {
        this.setChanged();
        return ContainerHelper.takeItem(this.getItems(), (int)slot);
    }

    default public void setItem(int slot, ItemStack stack) {
        this.getItems().set(slot, (Object)stack);
        this.setChanged();
    }

    default public void clearContent() {
        this.getItems().clear();
        this.setChanged();
    }

    default public void setChanged() {
    }

    default public int getMaxStackSize() {
        return 64;
    }

    default public void startOpen(Player player) {
    }

    default public void stopOpen(Player player) {
    }

    default public boolean stillValid(Player player) {
        return true;
    }

    default public boolean canPlaceItem(int slot, ItemStack stack) {
        return true;
    }

    default public ContainerData getPropertyDelegate() {
        return new SimpleContainerData(0);
    }
}

