/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.entity.client;

import net.dawson.adorablehamsterpets.entity.custom.HamsterEntity;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoRenderer;

public class HamsterModel
extends GeoModel<HamsterEntity> {
    private static final float ADULT_SCALE = 0.8f;
    private static final float ADULT_HEAD_SCALE = 1.0f;
    private static final float BABY_SCALE = 0.5f;
    private static final float BABY_HEAD_SCALE = 1.2f;

    public ResourceLocation getModelResource(HamsterEntity animatable, @Nullable GeoRenderer<HamsterEntity> renderer) {
        return ResourceLocation.fromNamespaceAndPath((String)"adorablehamsterpets", (String)"geo/hamster.geo.json");
    }

    public ResourceLocation getTextureResource(HamsterEntity animatable, @Nullable GeoRenderer<HamsterEntity> renderer) {
        return ResourceLocation.fromNamespaceAndPath((String)"adorablehamsterpets", (String)"textures/entity/hamster/orange.png");
    }

    @Deprecated(forRemoval=true)
    public ResourceLocation getModelResource(HamsterEntity animatable) {
        return this.getModelResource(animatable, null);
    }

    @Deprecated(forRemoval=true)
    public ResourceLocation getTextureResource(HamsterEntity animatable) {
        return this.getTextureResource(animatable, null);
    }

    public ResourceLocation getAnimationResource(HamsterEntity animatable) {
        return ResourceLocation.fromNamespaceAndPath((String)"adorablehamsterpets", (String)"animations/anim_hamster.animation.json");
    }

    public void setCustomAnimations(HamsterEntity entity, long instanceId, AnimationState<HamsterEntity> animationState) {
        super.setCustomAnimations((GeoAnimatable)entity, instanceId, animationState);
        GeoBone rootBone = this.getAnimationProcessor().getBone("root");
        GeoBone headParentBone = this.getAnimationProcessor().getBone("head_parent");
        GeoBone leftCheekDefBone = this.getAnimationProcessor().getBone("left_cheek_deflated");
        GeoBone rightCheekDefBone = this.getAnimationProcessor().getBone("right_cheek_deflated");
        GeoBone leftCheekInfBone = this.getAnimationProcessor().getBone("left_cheek_inflated");
        GeoBone rightCheekInfBone = this.getAnimationProcessor().getBone("right_cheek_inflated");
        if (leftCheekDefBone != null && leftCheekInfBone != null) {
            boolean leftFull = entity.isLeftCheekFull();
            leftCheekDefBone.setHidden(leftFull);
            leftCheekInfBone.setHidden(!leftFull);
        }
        if (rightCheekDefBone != null && rightCheekInfBone != null) {
            boolean rightFull = entity.isRightCheekFull();
            rightCheekDefBone.setHidden(rightFull);
            rightCheekInfBone.setHidden(!rightFull);
        }
        if (rootBone != null && headParentBone != null) {
            float baseScale = entity.isBaby() ? 0.5f : 0.8f;
            float headScale = entity.isBaby() ? 1.2f : 1.0f;
            rootBone.setScaleX(baseScale);
            rootBone.setScaleY(baseScale);
            rootBone.setScaleZ(baseScale);
            if (entity.isShoulderPet()) {
                rootBone.setScaleY(baseScale * entity.dynamicScaleY);
            }
            headParentBone.setScaleX(headScale);
            headParentBone.setScaleY(headScale);
            headParentBone.setScaleZ(headScale);
        }
    }
}

