/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.entity.client.feature;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.EnumMap;
import java.util.Map;
import net.dawson.adorablehamsterpets.accessor.PlayerEntityAccessor;
import net.dawson.adorablehamsterpets.client.state.ClientShoulderHamsterData;
import net.dawson.adorablehamsterpets.component.HamsterShoulderData;
import net.dawson.adorablehamsterpets.entity.ModEntities;
import net.dawson.adorablehamsterpets.entity.ShoulderLocation;
import net.dawson.adorablehamsterpets.entity.client.feature.ShoulderAnimationState;
import net.dawson.adorablehamsterpets.entity.client.feature.ShoulderHamsterState;
import net.dawson.adorablehamsterpets.entity.client.renderer.ShoulderHamsterRenderer;
import net.dawson.adorablehamsterpets.entity.custom.HamsterEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import org.joml.Matrix4f;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;

public class HamsterShoulderFeatureRenderer
extends RenderLayer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> {
    private static final float HAMSTER_SHOULDER_SCALE = 0.8f;
    private final Map<ShoulderLocation, HamsterEntity> dummyHamsters = new EnumMap<ShoulderLocation, HamsterEntity>(ShoulderLocation.class);
    private final Map<ShoulderLocation, ShoulderHamsterRenderer> hamsterRenderers = new EnumMap<ShoulderLocation, ShoulderHamsterRenderer>(ShoulderLocation.class);

    public HamsterShoulderFeatureRenderer(RenderLayerParent<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> context) {
        super(context);
    }

    public void render(PoseStack matrices, MultiBufferSource vertexConsumers, int light, AbstractClientPlayer player, float limbAngle, float limbDistance, float tickDelta, float animationProgress, float headYaw, float headPitch) {
        ClientShoulderHamsterData clientData;
        PlayerEntityAccessor playerAccessor = (PlayerEntityAccessor)player;
        if (!playerAccessor.hasAnyShoulderHamster()) {
            return;
        }
        if (this.dummyHamsters.isEmpty()) {
            this.initializeDummies(player.level());
        }
        if ((clientData = playerAccessor.adorablehamsterpets$getClientShoulderData()) == null) {
            return;
        }
        for (ShoulderLocation location : ShoulderLocation.values()) {
            CompoundTag shoulderNbt = playerAccessor.getShoulderHamster(location);
            if (shoulderNbt.isEmpty()) continue;
            HamsterShoulderData.fromNbt(shoulderNbt).ifPresent(shoulderData -> this.renderShoulderHamster(matrices, vertexConsumers, light, player, (HamsterShoulderData)shoulderData, tickDelta, clientData, location));
        }
    }

    private void applyShoulderData(HamsterEntity dummyHamster, HamsterShoulderData data, Player owner) {
        dummyHamster.setShoulderPet(true);
        dummyHamster.setVariant(data.variantId());
        dummyHamster.setLeftCheekFull((data.hamsterFlags() & 0x40) != 0);
        dummyHamster.setRightCheekFull((data.hamsterFlags() & 0x80) != 0);
        dummyHamster.getEntityData().set(HamsterEntity.PINK_PETAL_TYPE, (Object)data.pinkPetalType());
        dummyHamster.getEntityData().set(HamsterEntity.ANIMATION_PERSONALITY_ID, (Object)data.animationPersonalityId());
        dummyHamster.setAge(data.breedingAge());
        dummyHamster.setOwnerUUID(owner.getUUID());
        dummyHamster.setTame(true, false);
    }

    private void renderShoulderHamster(PoseStack matrices, MultiBufferSource vertexConsumers, int light, AbstractClientPlayer player, HamsterShoulderData shoulderData, float tickDelta, ClientShoulderHamsterData clientData, ShoulderLocation location) {
        float renderScaleY;
        AnimatableManager manager;
        HamsterEntity dummyHamster = this.dummyHamsters.get((Object)location);
        ShoulderHamsterRenderer hamsterRenderer = this.hamsterRenderers.get((Object)location);
        if (dummyHamster == null || hamsterRenderer == null) {
            return;
        }
        this.updateDummyState(dummyHamster, shoulderData, clientData, location, (Player)player);
        AnimatableInstanceCache cache = dummyHamster.getAnimatableInstanceCache();
        if (cache != null && (manager = cache.getManagerForId((long)dummyHamster.getId())) != null) {
            manager.updatedAt(0.0);
        }
        float renderOffsetY = clientData.getRenderOffsetY(location, tickDelta);
        dummyHamster.dynamicScaleY = renderScaleY = clientData.getRenderScaleY(location, tickDelta);
        matrices.pushPose();
        ItemStack chestStack = player.getInventory().getArmor(2);
        boolean isWearingChestplate = !chestStack.isEmpty() && !chestStack.is(Items.ELYTRA);
        boolean isSlim = player.getSkin().model() == PlayerSkin.Model.SLIM;
        switch (location) {
            case RIGHT_SHOULDER: {
                float yOffset;
                float xOffset;
                ((PlayerModel)this.getParentModel()).rightArm.translateAndRotate(matrices);
                if (isWearingChestplate) {
                    xOffset = -0.18f;
                    yOffset = -0.18f;
                } else {
                    xOffset = isSlim ? -0.08f : -0.12f;
                    yOffset = -0.12f;
                }
                matrices.translate(xOffset, yOffset, -0.016f);
                matrices.mulPose(Axis.YP.rotationDegrees(15.0f));
                break;
            }
            case LEFT_SHOULDER: {
                float yOffset;
                float xOffset;
                ((PlayerModel)this.getParentModel()).leftArm.translateAndRotate(matrices);
                if (isWearingChestplate) {
                    xOffset = 0.18f;
                    yOffset = -0.18f;
                } else {
                    xOffset = isSlim ? 0.08f : 0.12f;
                    yOffset = -0.12f;
                }
                matrices.translate(xOffset, yOffset, -0.016f);
                matrices.mulPose(Axis.YP.rotationDegrees(-15.0f));
                break;
            }
            case HEAD: {
                ((PlayerModel)this.getParentModel()).head.translateAndRotate(matrices);
                matrices.translate(0.0f, -0.5f, -0.05f);
            }
        }
        matrices.translate(0.0f, -renderOffsetY, 0.0f);
        matrices.mulPose(Axis.XP.rotationDegrees(180.0f));
        matrices.scale(0.8f, 0.8f, 0.8f);
        float renderYaw = 180.0f - player.getVisualRotationYInDegrees();
        hamsterRenderer.render(dummyHamster, renderYaw, tickDelta, matrices, vertexConsumers, light);
        matrices.popPose();
    }

    private double getAnchorBoneWorldY(PoseStack matrices, ModelPart anchorBone) {
        PoseStack tempMatrices = new PoseStack();
        tempMatrices.mulPose(matrices.last().pose());
        anchorBone.translateAndRotate(tempMatrices);
        Matrix4f finalMatrix = tempMatrices.last().pose();
        return finalMatrix.m31();
    }

    private void updateDummyState(HamsterEntity dummyHamster, HamsterShoulderData nbtData, ClientShoulderHamsterData clientData, ShoulderLocation location, Player owner) {
        this.applyShoulderData(dummyHamster, nbtData, owner);
        dummyHamster.tickCount = clientData.getAnimationAge(location);
        ShoulderHamsterState state = clientData.getHamsterState(location);
        if (state != null) {
            ShoulderAnimationState currentState = state.getCurrentState();
            dummyHamster.getEntityData().set(HamsterEntity.SHOULDER_ANIMATION_STATE, (Object)currentState.ordinal());
            dummyHamster.setSitting(currentState == ShoulderAnimationState.SITTING, true);
        }
        dummyHamster.shoulderLocation = location;
    }

    private void initializeDummies(Level world) {
        if (world == null) {
            return;
        }
        Minecraft client = Minecraft.getInstance();
        EntityRendererProvider.Context context = new EntityRendererProvider.Context(client.getEntityRenderDispatcher(), client.getItemRenderer(), client.getBlockRenderer(), client.getEntityRenderDispatcher().getItemInHandRenderer(), client.getResourceManager(), client.getEntityModels(), client.font);
        for (ShoulderLocation location : ShoulderLocation.values()) {
            HamsterEntity dummy = new HamsterEntity((EntityType<? extends TamableAnimal>)((EntityType)ModEntities.HAMSTER.get()), world);
            dummy.setNoGravity(true);
            dummy.setSilent(true);
            this.dummyHamsters.put(location, dummy);
            this.hamsterRenderers.put(location, new ShoulderHamsterRenderer(context));
        }
    }
}

