/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.entity.client.feature;

import net.dawson.adorablehamsterpets.config.Configs;
import net.dawson.adorablehamsterpets.config.ForcedShoulderState;
import net.dawson.adorablehamsterpets.entity.client.feature.ShoulderAnimationState;
import net.dawson.adorablehamsterpets.entity.custom.HamsterEntity;
import net.dawson.adorablehamsterpets.sound.ModSounds;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;

public class ShoulderHamsterState {
    private ShoulderAnimationState currentState;
    private int timer;
    private final RandomSource random = RandomSource.create();
    private int sprintTransitionDelay = 0;
    private int idleSoundCooldown = 0;

    public ShoulderHamsterState() {
        this.currentState = ShoulderAnimationState.values()[this.random.nextInt(ShoulderAnimationState.values().length)];
        this.timer = this.getNewRandomDuration();
    }

    public void tick(boolean isPlayerSprinting, boolean isPlayerWalking) {
        boolean shouldForceLayDown;
        boolean bl = shouldForceLayDown = Configs.AHP.forceLayDownOnSprint && isPlayerSprinting || Configs.AHP.forceLayDownOnWalk && isPlayerWalking;
        if (shouldForceLayDown) {
            if (this.currentState != ShoulderAnimationState.LAYING_DOWN && this.sprintTransitionDelay == 0) {
                this.sprintTransitionDelay = this.random.nextIntBetweenInclusive(1, 7);
            }
            if (this.sprintTransitionDelay > 0) {
                --this.sprintTransitionDelay;
                if (this.sprintTransitionDelay == 0) {
                    this.currentState = ShoulderAnimationState.LAYING_DOWN;
                    this.timer = this.random.nextIntBetweenInclusive(5, 40);
                }
            }
        } else {
            this.sprintTransitionDelay = 0;
            if (this.timer > 0) {
                --this.timer;
            }
            if (this.timer <= 0) {
                if (((Boolean)Configs.AHP.enableDynamicShoulderAnimations.get()).booleanValue()) {
                    ShoulderAnimationState nextState;
                    while ((nextState = ShoulderAnimationState.values()[this.random.nextInt(ShoulderAnimationState.values().length)]) == this.currentState) {
                    }
                    this.currentState = nextState;
                    this.timer = this.getNewRandomDuration();
                } else {
                    switch ((ForcedShoulderState)((Object)Configs.AHP.forcedShoulderState.get())) {
                        case ALWAYS_SIT: {
                            ShoulderAnimationState shoulderAnimationState = ShoulderAnimationState.SITTING;
                            break;
                        }
                        case ALWAYS_LAY_DOWN: {
                            ShoulderAnimationState shoulderAnimationState = ShoulderAnimationState.LAYING_DOWN;
                            break;
                        }
                        default: {
                            ShoulderAnimationState shoulderAnimationState = this.currentState = ShoulderAnimationState.STANDING;
                        }
                    }
                }
            }
        }
        if (!Configs.AHP.silenceShoulderIdleSounds) {
            if (this.idleSoundCooldown > 0) {
                --this.idleSoundCooldown;
            } else if (this.random.nextInt(250) == 0) {
                SoundEvent idleSound;
                Minecraft client = Minecraft.getInstance();
                if (client.player != null && (idleSound = ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_IDLE_SOUNDS, this.random)) != null) {
                    client.getSoundManager().play((SoundInstance)new SimpleSoundInstance(idleSound, SoundSource.PLAYERS, 0.25f, 1.2f + (this.random.nextFloat() - 0.5f) * 0.4f, this.random, client.player.getX(), client.player.getY(), client.player.getZ()));
                    this.idleSoundCooldown = 100;
                }
            }
        }
    }

    public ShoulderAnimationState getCurrentState() {
        return this.currentState;
    }

    private void updateHamsterEntityState(HamsterEntity hamster, ShoulderAnimationState stateToApply) {
        hamster.getEntityData().set(HamsterEntity.SHOULDER_ANIMATION_STATE, (Object)stateToApply.ordinal());
        hamster.setSitting(stateToApply == ShoulderAnimationState.SITTING, true);
    }

    private int getNewRandomDuration() {
        int max;
        int min = (Integer)Configs.AHP.shoulderMinStateSeconds.get() * 20;
        if (min >= (max = (Integer)Configs.AHP.shoulderMaxStateSeconds.get() * 20)) {
            return min;
        }
        return this.random.nextIntBetweenInclusive(min, max);
    }
}

