/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.entity.custom;

import dev.architectury.registry.menu.ExtendedMenuProvider;
import dev.architectury.registry.menu.MenuRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.dawson.adorablehamsterpets.AdorableHamsterPets;
import net.dawson.adorablehamsterpets.accessor.PlayerEntityAccessor;
import net.dawson.adorablehamsterpets.advancement.criterion.AppliedPinkPetalCriterion;
import net.dawson.adorablehamsterpets.advancement.criterion.CheekPouchUnlockedCriterion;
import net.dawson.adorablehamsterpets.advancement.criterion.FedHamsterSteamedBeansCriterion;
import net.dawson.adorablehamsterpets.advancement.criterion.HamsterAutoFedCriterion;
import net.dawson.adorablehamsterpets.advancement.criterion.HamsterOnShoulderCriterion;
import net.dawson.adorablehamsterpets.advancement.criterion.HamsterPouchFilledCriterion;
import net.dawson.adorablehamsterpets.advancement.criterion.ModCriteria;
import net.dawson.adorablehamsterpets.client.option.ModKeyBindings;
import net.dawson.adorablehamsterpets.component.HamsterShoulderData;
import net.dawson.adorablehamsterpets.config.AhpConfig;
import net.dawson.adorablehamsterpets.config.Configs;
import net.dawson.adorablehamsterpets.entity.AI.HamsterFleeGoal;
import net.dawson.adorablehamsterpets.entity.AI.HamsterFollowOwnerGoal;
import net.dawson.adorablehamsterpets.entity.AI.HamsterLookAroundGoal;
import net.dawson.adorablehamsterpets.entity.AI.HamsterLookAtEntityGoal;
import net.dawson.adorablehamsterpets.entity.AI.HamsterMateGoal;
import net.dawson.adorablehamsterpets.entity.AI.HamsterMeleeAttackGoal;
import net.dawson.adorablehamsterpets.entity.AI.HamsterSeekDiamondGoal;
import net.dawson.adorablehamsterpets.entity.AI.HamsterSitGoal;
import net.dawson.adorablehamsterpets.entity.AI.HamsterSleepGoal;
import net.dawson.adorablehamsterpets.entity.AI.HamsterStealDiamondGoal;
import net.dawson.adorablehamsterpets.entity.AI.HamsterTemptGoal;
import net.dawson.adorablehamsterpets.entity.AI.HamsterWanderAroundFarGoal;
import net.dawson.adorablehamsterpets.entity.ImplementedInventory;
import net.dawson.adorablehamsterpets.entity.ModEntities;
import net.dawson.adorablehamsterpets.entity.ShoulderLocation;
import net.dawson.adorablehamsterpets.entity.client.feature.ShoulderAnimationState;
import net.dawson.adorablehamsterpets.entity.control.HamsterBodyControl;
import net.dawson.adorablehamsterpets.entity.custom.HamsterVariant;
import net.dawson.adorablehamsterpets.item.ModItems;
import net.dawson.adorablehamsterpets.mixin.accessor.LandPathNodeMakerInvoker;
import net.dawson.adorablehamsterpets.screen.HamsterScreenHandlerFactory;
import net.dawson.adorablehamsterpets.sound.ModSounds;
import net.dawson.adorablehamsterpets.tag.ModBiomeTags;
import net.dawson.adorablehamsterpets.tag.ModItemTags;
import net.dawson.adorablehamsterpets.util.HamsterRenderTracker;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Unique;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class HamsterEntity
extends TamableAnimal
implements GeoEntity,
ImplementedInventory {
    private static final double WALK_TO_RUN_THRESHOLD_SQUARED = 0.002;
    private static final double RUN_TO_SPRINT_THRESHOLD_SQUARED = 0.008;
    public static final float FAST_YAW_CHANGE = 25.0f;
    public static final float FAST_PITCH_CHANGE = 25.0f;
    private static final int INVENTORY_SIZE = 6;
    private static final int REFUSE_FOOD_TIMER_TICKS = 40;
    private static final int CUSTOM_LOVE_TICKS = 600;
    private static final float THROW_DAMAGE = 20.0f;
    private static final double THROWN_GRAVITY = -0.05;
    private static final double HAMSTER_ATTACK_BOX_EXPANSION = 0.7;
    public static final int CELEBRATION_PARTICLE_DURATION_TICKS = 600;
    private static final float DEFAULT_FOOTSTEP_VOLUME = 0.1f;
    private static final float GRAVEL_VOLUME_MODIFIER = 0.6f;
    private static final Set<PathType> HAZARDOUS_FLOOR_TYPES = EnumSet.of(PathType.LAVA, new PathType[]{PathType.DAMAGE_FIRE, PathType.DANGER_FIRE, PathType.POWDER_SNOW, PathType.DAMAGE_OTHER, PathType.DANGER_OTHER, PathType.DAMAGE_CAUTIOUS, PathType.WATER});
    private static final List<HamsterVariant> ORANGE_VARIANTS = List.of(HamsterVariant.ORANGE, HamsterVariant.ORANGE_OVERLAY1, HamsterVariant.ORANGE_OVERLAY2, HamsterVariant.ORANGE_OVERLAY3, HamsterVariant.ORANGE_OVERLAY4, HamsterVariant.ORANGE_OVERLAY5, HamsterVariant.ORANGE_OVERLAY6, HamsterVariant.ORANGE_OVERLAY7, HamsterVariant.ORANGE_OVERLAY8);
    private static final List<HamsterVariant> BLACK_VARIANTS = List.of(HamsterVariant.BLACK, HamsterVariant.BLACK_OVERLAY1, HamsterVariant.BLACK_OVERLAY2, HamsterVariant.BLACK_OVERLAY3, HamsterVariant.BLACK_OVERLAY4, HamsterVariant.BLACK_OVERLAY5, HamsterVariant.BLACK_OVERLAY6, HamsterVariant.BLACK_OVERLAY7, HamsterVariant.BLACK_OVERLAY8);
    private static final List<HamsterVariant> BLUE_VARIANTS = List.of(HamsterVariant.BLUE, HamsterVariant.BLUE_OVERLAY1, HamsterVariant.BLUE_OVERLAY2, HamsterVariant.BLUE_OVERLAY3, HamsterVariant.BLUE_OVERLAY4, HamsterVariant.BLUE_OVERLAY5, HamsterVariant.BLUE_OVERLAY6, HamsterVariant.BLUE_OVERLAY7, HamsterVariant.BLUE_OVERLAY8);
    private static final List<HamsterVariant> CHOCOLATE_VARIANTS = List.of(HamsterVariant.CHOCOLATE, HamsterVariant.CHOCOLATE_OVERLAY1, HamsterVariant.CHOCOLATE_OVERLAY2, HamsterVariant.CHOCOLATE_OVERLAY3, HamsterVariant.CHOCOLATE_OVERLAY4, HamsterVariant.CHOCOLATE_OVERLAY5, HamsterVariant.CHOCOLATE_OVERLAY6, HamsterVariant.CHOCOLATE_OVERLAY7, HamsterVariant.CHOCOLATE_OVERLAY8);
    private static final List<HamsterVariant> CREAM_VARIANTS = List.of(HamsterVariant.CREAM, HamsterVariant.CREAM_OVERLAY1, HamsterVariant.CREAM_OVERLAY2, HamsterVariant.CREAM_OVERLAY3, HamsterVariant.CREAM_OVERLAY4, HamsterVariant.CREAM_OVERLAY5, HamsterVariant.CREAM_OVERLAY6, HamsterVariant.CREAM_OVERLAY7, HamsterVariant.CREAM_OVERLAY8);
    private static final List<HamsterVariant> DARK_GRAY_VARIANTS = List.of(HamsterVariant.DARK_GRAY, HamsterVariant.DARK_GRAY_OVERLAY1, HamsterVariant.DARK_GRAY_OVERLAY2, HamsterVariant.DARK_GRAY_OVERLAY3, HamsterVariant.DARK_GRAY_OVERLAY4, HamsterVariant.DARK_GRAY_OVERLAY5, HamsterVariant.DARK_GRAY_OVERLAY6, HamsterVariant.DARK_GRAY_OVERLAY7, HamsterVariant.DARK_GRAY_OVERLAY8);
    private static final List<HamsterVariant> LAVENDER_VARIANTS = List.of(HamsterVariant.LAVENDER, HamsterVariant.LAVENDER_OVERLAY1, HamsterVariant.LAVENDER_OVERLAY2, HamsterVariant.LAVENDER_OVERLAY3, HamsterVariant.LAVENDER_OVERLAY4, HamsterVariant.LAVENDER_OVERLAY5, HamsterVariant.LAVENDER_OVERLAY6, HamsterVariant.LAVENDER_OVERLAY7, HamsterVariant.LAVENDER_OVERLAY8);
    private static final List<HamsterVariant> LIGHT_GRAY_VARIANTS = List.of(HamsterVariant.LIGHT_GRAY, HamsterVariant.LIGHT_GRAY_OVERLAY1, HamsterVariant.LIGHT_GRAY_OVERLAY2, HamsterVariant.LIGHT_GRAY_OVERLAY3, HamsterVariant.LIGHT_GRAY_OVERLAY4, HamsterVariant.LIGHT_GRAY_OVERLAY5, HamsterVariant.LIGHT_GRAY_OVERLAY6, HamsterVariant.LIGHT_GRAY_OVERLAY7, HamsterVariant.LIGHT_GRAY_OVERLAY8);
    private static final List<HamsterVariant> WHITE_VARIANTS = List.of(HamsterVariant.WHITE);
    public static final int SLEEPING_FLAG = 1;
    public static final int SITTING_FLAG = 2;
    public static final int BEGGING_FLAG = 4;
    public static final int IN_LOVE_FLAG = 8;
    public static final int REFUSING_FOOD_FLAG = 16;
    public static final int THROWN_FLAG = 32;
    public static final int LEFT_CHEEK_FULL_FLAG = 64;
    public static final int RIGHT_CHEEK_FULL_FLAG = 128;
    public static final int KNOCKED_OUT_FLAG = 256;
    public static final int CHEEK_POUCH_UNLOCKED_FLAG = 512;
    public static final int CONSIDERING_AUTO_EAT_FLAG = 1024;
    public static final int SULKING_FLAG = 2048;
    public static final int CELEBRATING_DIAMOND_FLAG = 4096;
    public static final int CLEANING_FLAG = 8192;
    public static final int STEALING_DIAMOND_FLAG = 16384;
    public static final int TAUNTING_FLAG = 32768;
    public static final int CELEBRATING_CHASE_FLAG = 65536;
    public static final int IS_SHOULDER_PET_FLAG = 131072;
    private static final EntityDataAccessor<Integer> HAMSTER_FLAGS = SynchedEntityData.defineId(HamsterEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.defineId(HamsterEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> ANIMATION_PERSONALITY_ID = SynchedEntityData.defineId(HamsterEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> PINK_PETAL_TYPE = SynchedEntityData.defineId(HamsterEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DOZING_PHASE = SynchedEntityData.defineId(HamsterEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<String> CURRENT_DEEP_SLEEP_ANIM_ID = SynchedEntityData.defineId(HamsterEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private static final EntityDataAccessor<String> ACTIVE_CUSTOM_GOAL_NAME_DEBUG = SynchedEntityData.defineId(HamsterEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final EntityDataAccessor<Integer> STEAL_DURATION_TIMER = SynchedEntityData.defineId(HamsterEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<ItemStack> STOLEN_ITEM_STACK = SynchedEntityData.defineId(HamsterEntity.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);
    public static final EntityDataAccessor<Long> GREEN_BEAN_BUFF_DURATION = SynchedEntityData.defineId(HamsterEntity.class, (EntityDataSerializer)EntityDataSerializers.LONG);
    public static final EntityDataAccessor<Integer> CURRENT_LOOK_UP_ANIM_ID = SynchedEntityData.defineId(HamsterEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> SHOULDER_ANIMATION_STATE = SynchedEntityData.defineId(HamsterEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final RawAnimation CRASH_ANIM = RawAnimation.begin().thenPlay("anim_hamster_crash");
    private static final RawAnimation KNOCKED_OUT_ANIM = RawAnimation.begin().thenPlay("anim_hamster_ko");
    private static final RawAnimation WAKE_UP_ANIM = RawAnimation.begin().thenPlay("anim_hamster_wakeup");
    private static final RawAnimation FLYING_ANIM = RawAnimation.begin().thenPlay("anim_hamster_flying");
    private static final RawAnimation STATIONARY_HEADSHAKE_ANIM = RawAnimation.begin().thenPlay("anim_hamster_stationary_headshake");
    private static final RawAnimation MOVING_HEADSHAKE_ANIM = RawAnimation.begin().thenPlay("anim_hamster_moving_headshake");
    private static final RawAnimation SLEEP_POSE1_ANIM = RawAnimation.begin().thenPlay("anim_hamster_sleep_pose1");
    private static final RawAnimation SLEEP_POSE2_ANIM = RawAnimation.begin().thenPlay("anim_hamster_sleep_pose2");
    private static final RawAnimation SLEEP_POSE3_ANIM = RawAnimation.begin().thenPlay("anim_hamster_sleep_pose3");
    private static final RawAnimation SIT_SETTLE_SLEEP1_ANIM = RawAnimation.begin().thenPlay("anim_hamster_sit_settle_sleep1");
    private static final RawAnimation SIT_SETTLE_SLEEP2_ANIM = RawAnimation.begin().thenPlay("anim_hamster_sit_settle_sleep2");
    private static final RawAnimation SIT_SETTLE_SLEEP3_ANIM = RawAnimation.begin().thenPlay("anim_hamster_sit_settle_sleep3");
    private static final RawAnimation STAND_SETTLE_SLEEP1_ANIM = RawAnimation.begin().thenPlay("anim_hamster_stand_settle_sleep1");
    private static final RawAnimation STAND_SETTLE_SLEEP2_ANIM = RawAnimation.begin().thenPlay("anim_hamster_stand_settle_sleep2");
    private static final RawAnimation STAND_SETTLE_SLEEP3_ANIM = RawAnimation.begin().thenPlay("anim_hamster_stand_settle_sleep3");
    private static final RawAnimation SITTING_POSE1_ANIM = RawAnimation.begin().thenPlay("anim_hamster_sitting_pose1");
    private static final RawAnimation SITTING_POSE2_ANIM = RawAnimation.begin().thenPlay("anim_hamster_sitting_pose2");
    private static final RawAnimation SITTING_POSE3_ANIM = RawAnimation.begin().thenPlay("anim_hamster_sitting_pose3");
    private static final RawAnimation DRIFTING_OFF_POSE1_ANIM = RawAnimation.begin().thenPlay("anim_hamster_drifting_off_pose1");
    private static final RawAnimation DRIFTING_OFF_POSE2_ANIM = RawAnimation.begin().thenPlay("anim_hamster_drifting_off_pose2");
    private static final RawAnimation DRIFTING_OFF_POSE3_ANIM = RawAnimation.begin().thenPlay("anim_hamster_drifting_off_pose3");
    private static final RawAnimation CLEANING_ANIM = RawAnimation.begin().thenPlay("anim_hamster_cleaning");
    private static final RawAnimation RUNNING_ANIM = RawAnimation.begin().thenPlay("anim_hamster_running");
    private static final RawAnimation WALKING_ANIM = RawAnimation.begin().thenPlay("anim_hamster_walking");
    private static final RawAnimation SPRINTING_ANIM = RawAnimation.begin().thenPlay("anim_hamster_sprinting");
    private static final RawAnimation BEGGING_ANIM = RawAnimation.begin().thenPlay("anim_hamster_begging");
    private static final RawAnimation IDLE1_ANIM = RawAnimation.begin().thenPlay("anim_hamster_idle1");
    private static final RawAnimation IDLE2_ANIM = RawAnimation.begin().thenPlay("anim_hamster_idle2");
    private static final RawAnimation IDLE_LOOKING_UP1_ANIM = RawAnimation.begin().thenPlay("anim_hamster_idle_looking_up1");
    private static final RawAnimation IDLE_LOOKING_UP2_ANIM = RawAnimation.begin().thenPlay("anim_hamster_idle_looking_up2");
    private static final RawAnimation IDLE_LOOKING_UP3_ANIM = RawAnimation.begin().thenPlay("anim_hamster_idle_looking_up3");
    private static final RawAnimation ATTACK_ANIM = RawAnimation.begin().thenPlay("anim_hamster_attack");
    private static final RawAnimation SULK_ANIM = RawAnimation.begin().thenPlay("anim_hamster_sulk");
    private static final RawAnimation SULKING_ANIM = RawAnimation.begin().thenPlay("anim_hamster_sulking");
    private static final RawAnimation SEEKING_DIAMOND_ANIM = RawAnimation.begin().thenPlay("anim_hamster_seeking_diamond");
    private static final RawAnimation WANTS_TO_SEEK_DIAMOND_ANIM = RawAnimation.begin().thenPlay("anim_hamster_wants_to_seek_diamond");
    private static final RawAnimation DIAMOND_POUNCE_ANIM = RawAnimation.begin().thenPlay("anim_hamster_diamond_pounce");
    private static final RawAnimation DIAMOND_TAUNT_ANIM = RawAnimation.begin().thenPlay("anim_hamster_diamond_taunt");
    private static final RawAnimation CELEBRATE_CHASE_ANIM = RawAnimation.begin().thenPlay("anim_hamster_celebrate_chase");
    private static final RawAnimation LAYING_DOWN_HEAD_ANIM = RawAnimation.begin().thenPlay("anim_hamster_shoulder_laying_down_head");
    private static final RawAnimation LAYING_DOWN_RIGHT_SHOULDER_ANIM = RawAnimation.begin().thenPlay("anim_hamster_shoulder_laying_down_right_shoulder");
    private static final RawAnimation LAYING_DOWN_LEFT_SHOULDER_ANIM = RawAnimation.begin().thenPlay("anim_hamster_shoulder_laying_down_left_shoulder");
    @Unique
    public int interactionCooldown = 0;
    @Unique
    public int throwTicks = 0;
    @Unique
    public int wakingUpTicks = 0;
    @Unique
    private int ejectionCheckCooldown = 20;
    @Unique
    private int preAutoEatDelayTicks = 0;
    @Unique
    private int quiescentSitDurationTimer = 0;
    @Unique
    private int driftingOffTimer = 0;
    @Unique
    private int settleSleepAnimationCooldown = 0;
    @Unique
    private String activeCustomGoalDebugName = "None";
    @Unique
    public boolean isPrimedToSeekDiamonds = false;
    @Unique
    public long foundOreCooldownEndTick = 0L;
    @Unique
    public BlockPos currentOreTarget = null;
    @Unique
    private int celebrationParticleTicks = 0;
    @Unique
    private int diamondCelebrationSoundTicks = 0;
    @Unique
    private int sulkOrchestraHitDelayTicks = 0;
    @Unique
    private int sulkFailParticleTicks = 0;
    @Unique
    private int sulkEntityEffectTicks = 0;
    @Unique
    private int sulkShockedSoundDelayTicks = 0;
    @Unique
    private int diamondSparkleSoundDelayTicks = 0;
    @Unique
    public transient String particleEffectId = null;
    @Unique
    public transient String soundEffectId = null;
    @Unique
    public long stealCooldownEndTick = 0L;
    @Unique
    private int celebrationChaseTicks = 0;
    @Unique
    private boolean zoomiesIsClockwise = false;
    @Unique
    private double lastZoomiesAngle = 0.0;
    @Unique
    private int zoomiesRadiusModifier = 0;
    @Unique
    public transient float renderedSnowYOffset = 0.0f;
    @Unique
    public transient ShoulderLocation shoulderLocation = ShoulderLocation.RIGHT_SHOULDER;
    @Unique
    public int suffocationGracePeriod = 0;
    @Unique
    public transient float dynamicScaleY = 1.0f;
    private final NonNullList<ItemStack> items = ImplementedInventory.create(6);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private int refuseTimer = 0;
    private ItemStack lastFoodItem = ItemStack.EMPTY;
    public int customLoveTimer;
    private int tamingCooldown = 0;
    public long throwCooldownEndTick = 0L;
    private long greenBeanBuffEndTick = 0L;
    private boolean isAutoEating = false;
    private int autoEatProgressTicks = 0;
    private int autoEatCooldownTicks = 0;
    public int cleaningTimer = 0;
    private int cleaningCooldownTimer = 0;

    private static HamsterVariant determineVariantForBiome(Holder<Biome> biomeEntry, RandomSource random) {
        String biomeName = biomeEntry.unwrapKey().map(k -> k.location().toString()).orElse("unknown");
        AdorableHamsterPets.LOGGER.debug("[AHP Spawn Debug] determineVariantForBiome called for biome: {}", (Object)biomeName);
        HamsterVariant result = HamsterEntity.canSpawnBlue(biomeEntry) ? (random.nextInt(10) < 7 ? HamsterEntity.getRandomVariant(BLUE_VARIANTS, random) : HamsterVariant.WHITE) : (HamsterEntity.canSpawnLavender(biomeEntry) ? HamsterEntity.getRandomVariant(LAVENDER_VARIANTS, random) : (HamsterEntity.canSpawnWhite(biomeEntry) ? HamsterVariant.WHITE : (HamsterEntity.canSpawnGray(biomeEntry) ? (random.nextBoolean() ? HamsterEntity.getRandomVariant(LIGHT_GRAY_VARIANTS, random) : HamsterEntity.getRandomVariant(DARK_GRAY_VARIANTS, random)) : (HamsterEntity.canSpawnBlack(biomeEntry) ? HamsterVariant.BLACK : (HamsterEntity.canSpawnCream(biomeEntry) ? HamsterEntity.getRandomVariant(CREAM_VARIANTS, random) : (HamsterEntity.canSpawnChocolate(biomeEntry) ? HamsterEntity.getRandomVariant(CHOCOLATE_VARIANTS, random) : HamsterEntity.getRandomVariant(ORANGE_VARIANTS, random)))))));
        AdorableHamsterPets.LOGGER.debug("[AHP Spawn Debug] Determined variant for {} is {}", (Object)biomeName, (Object)result.name());
        return result;
    }

    private static boolean canSpawnBlue(Holder<Biome> biomeEntry) {
        return biomeEntry.is(ModBiomeTags.IS_ICY) || biomeEntry.is(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"terralith", (String)"glacial_chasm"))) || biomeEntry.is(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"terralith", (String)"mirage_isles"))) || biomeEntry.is(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"terralith", (String)"moonlight_valley"))) || biomeEntry.is(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"biomesoplenty", (String)"enchanted_garden")));
    }

    private static boolean canSpawnLavender(Holder<Biome> biomeEntry) {
        boolean isLavenderTheme = biomeEntry.is(ModBiomeTags.IS_MUSHROOM) || biomeEntry.is(ModBiomeTags.IS_MAGICAL) || biomeEntry.is(TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"terralith", (String)"mystical"))) || biomeEntry.is(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"biomesoplenty", (String)"fungi_forest"))) || biomeEntry.is(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"biomesoplenty", (String)"mystic_grove"))) || biomeEntry.is(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"terralith", (String)"sakura_valley"))) || biomeEntry.is(Biomes.CHERRY_GROVE);
        return isLavenderTheme && !HamsterEntity.canSpawnBlue(biomeEntry);
    }

    private static boolean canSpawnWhite(Holder<Biome> biomeEntry) {
        boolean isWhiteTheme;
        boolean bl = isWhiteTheme = biomeEntry.is(ModBiomeTags.IS_COLD) || biomeEntry.is(ModBiomeTags.IS_SNOWY) || biomeEntry.is(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"terralith", (String)"snowy_maple_forest"))) || biomeEntry.is(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"terralith", (String)"wintry_forest"))) || biomeEntry.is(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"terralith", (String)"alpine_grove"))) || biomeEntry.is(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"terralith", (String)"siberian_grove")));
        if (!isWhiteTheme) {
            return false;
        }
        return !HamsterEntity.canSpawnBlue(biomeEntry) && !HamsterEntity.canSpawnLavender(biomeEntry) && !biomeEntry.is(Biomes.DEEP_FROZEN_OCEAN) && !biomeEntry.is(Biomes.FROZEN_OCEAN) && !biomeEntry.is(Biomes.STONY_SHORE) && !biomeEntry.is(Biomes.WINDSWEPT_FOREST) && !biomeEntry.is(Biomes.WINDSWEPT_GRAVELLY_HILLS) && !biomeEntry.is(Biomes.WINDSWEPT_HILLS) && !biomeEntry.is(Biomes.TAIGA) && !biomeEntry.is(Biomes.OLD_GROWTH_PINE_TAIGA) && !biomeEntry.is(Biomes.OLD_GROWTH_SPRUCE_TAIGA);
    }

    private static boolean canSpawnGray(Holder<Biome> biomeEntry) {
        boolean isGrayTheme;
        boolean bl = isGrayTheme = biomeEntry.is(ModBiomeTags.IS_MOUNTAIN) || biomeEntry.is(ModBiomeTags.IS_SPARSE_VEGETATION) || biomeEntry.is(TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"terralith", (String)"cliffs"))) || biomeEntry.is(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"terralith", (String)"stony_spires")));
        if (!isGrayTheme) {
            return false;
        }
        return !HamsterEntity.canSpawnBlue(biomeEntry) && !HamsterEntity.canSpawnLavender(biomeEntry) && !HamsterEntity.canSpawnWhite(biomeEntry) && !biomeEntry.is(BiomeTags.IS_BADLANDS) && !biomeEntry.is(BiomeTags.IS_JUNGLE) && !biomeEntry.is(BiomeTags.IS_SAVANNA);
    }

    private static boolean canSpawnBlack(Holder<Biome> biomeEntry) {
        boolean isBlackTheme;
        boolean bl = isBlackTheme = biomeEntry.is(ModBiomeTags.IS_WET) || biomeEntry.is(ModBiomeTags.IS_CAVE) || biomeEntry.is(Biomes.DEEP_DARK);
        if (!isBlackTheme) {
            return false;
        }
        return !HamsterEntity.canSpawnBlue(biomeEntry) && !HamsterEntity.canSpawnLavender(biomeEntry) && !HamsterEntity.canSpawnWhite(biomeEntry) && !HamsterEntity.canSpawnGray(biomeEntry) && !biomeEntry.is(BiomeTags.IS_JUNGLE) && !biomeEntry.is(BiomeTags.IS_BEACH) && !biomeEntry.is(Biomes.DRIPSTONE_CAVES) && !biomeEntry.is(Biomes.LUSH_CAVES);
    }

    private static boolean canSpawnCream(Holder<Biome> biomeEntry) {
        boolean isCreamTheme;
        boolean bl = isCreamTheme = biomeEntry.is(ModBiomeTags.IS_SANDY) || biomeEntry.is(Biomes.OLD_GROWTH_BIRCH_FOREST) || biomeEntry.is(Biomes.BIRCH_FOREST) || biomeEntry.is(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"terralith", (String)"ancient_sands"))) || biomeEntry.is(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"terralith", (String)"sandstone_valley"))) || biomeEntry.is(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"biomesoplenty", (String)"wasteland")));
        if (!isCreamTheme) {
            return false;
        }
        return !HamsterEntity.canSpawnBlue(biomeEntry) && !HamsterEntity.canSpawnLavender(biomeEntry) && !HamsterEntity.canSpawnWhite(biomeEntry) && !HamsterEntity.canSpawnGray(biomeEntry) && !HamsterEntity.canSpawnBlack(biomeEntry) && !biomeEntry.is(BiomeTags.IS_BADLANDS) && !biomeEntry.is(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"terralith", (String)"gravel_beach")));
    }

    private static boolean canSpawnChocolate(Holder<Biome> biomeEntry) {
        boolean isChocolateTheme;
        boolean bl = isChocolateTheme = biomeEntry.is(ModBiomeTags.IS_FOREST) || biomeEntry.is(ModBiomeTags.IS_DENSE_VEGETATION) || biomeEntry.is(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"terralith", (String)"cloud_forest"))) || biomeEntry.is(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"biomesoplenty", (String)"redwood_forest")));
        if (!isChocolateTheme) {
            return false;
        }
        return !HamsterEntity.canSpawnBlue(biomeEntry) && !HamsterEntity.canSpawnLavender(biomeEntry) && !HamsterEntity.canSpawnWhite(biomeEntry) && !HamsterEntity.canSpawnGray(biomeEntry) && !HamsterEntity.canSpawnBlack(biomeEntry) && !HamsterEntity.canSpawnCream(biomeEntry);
    }

    private static HamsterVariant getRandomVariant(List<HamsterVariant> variantPool, RandomSource random) {
        if (variantPool == null || variantPool.isEmpty()) {
            return HamsterVariant.ORANGE;
        }
        return variantPool.get(random.nextInt(variantPool.size()));
    }

    public static AttributeSupplier.Builder createHamsterAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, ((Double)Configs.AHP.wildMaxHealth.get()).doubleValue()).add(Attributes.MOVEMENT_SPEED, 0.25).add(Attributes.ATTACK_DAMAGE, 20.0).add(Attributes.ATTACK_DAMAGE, ((Double)Configs.AHP.meleeDamage.get()).doubleValue()).add(Attributes.FOLLOW_RANGE, 40.0);
    }

    @Nullable
    public static HamsterEntity createFromNbt(ServerLevel world, Player player, CompoundTag nbt) {
        Optional<HamsterShoulderData> dataOpt = HamsterShoulderData.fromNbt(nbt);
        if (dataOpt.isEmpty()) {
            AdorableHamsterPets.LOGGER.error("Failed to deserialize HamsterShoulderData from NBT: {}", (Object)nbt);
            return null;
        }
        HamsterShoulderData data = dataOpt.get();
        AdorableHamsterPets.LOGGER.debug("[HamsterEntity] createFromNbt called for player {} with data: {}", (Object)player.getName().getString(), (Object)data);
        HamsterEntity hamster = (HamsterEntity)((EntityType)ModEntities.HAMSTER.get()).create((Level)world);
        if (hamster != null) {
            CompoundTag effectsNbt;
            hamster.setVariant(data.variantId());
            hamster.setHealth(data.health());
            hamster.setOwnerUUID(player.getUUID());
            hamster.setTame(true, true);
            hamster.setAge(data.breedingAge());
            hamster.throwCooldownEndTick = data.throwCooldownEndTick();
            hamster.greenBeanBuffEndTick = data.greenBeanBuffEndTick();
            hamster.getEntityData().set(GREEN_BEAN_BUFF_DURATION, (Object)data.greenBeanBuffDuration());
            hamster.autoEatCooldownTicks = data.autoEatCooldownTicks();
            hamster.getEntityData().set(PINK_PETAL_TYPE, (Object)data.pinkPetalType());
            hamster.getEntityData().set(ANIMATION_PERSONALITY_ID, (Object)data.animationPersonalityId());
            hamster.getEntityData().set(HAMSTER_FLAGS, (Object)data.hamsterFlags());
            hamster.setHamsterFlag(2, false);
            data.customName().ifPresent(name -> {
                if (!name.isEmpty()) {
                    hamster.setCustomName((Component)Component.literal((String)name));
                }
            });
            RegistryAccess registries = world.registryAccess();
            if (!data.inventoryNbt().isEmpty()) {
                ContainerHelper.loadAllItems((CompoundTag)data.inventoryNbt(), hamster.items, (HolderLookup.Provider)registries);
                hamster.updateCheekTrackers();
            }
            if ((effectsNbt = data.activeEffectsNbt()).contains("active_effects", 9)) {
                ListTag effectsList = effectsNbt.getList("active_effects", 10);
                for (Tag effectElement : effectsList) {
                    CompoundTag effectInstanceNbt;
                    MobEffectInstance effectInstance;
                    if (!(effectElement instanceof CompoundTag) || (effectInstance = MobEffectInstance.load((CompoundTag)(effectInstanceNbt = (CompoundTag)effectElement))) == null) continue;
                    hamster.addEffect(effectInstance);
                }
            }
            HamsterShoulderData.SeekingBehaviorData seekingData = data.seekingBehaviorData();
            hamster.isPrimedToSeekDiamonds = seekingData.isPrimedToSeekDiamonds();
            hamster.foundOreCooldownEndTick = seekingData.foundOreCooldownEndTick();
            hamster.currentOreTarget = seekingData.currentOreTarget().orElse(null);
            hamster.isAutoEating = false;
            hamster.autoEatProgressTicks = 0;
            hamster.setHamsterFlag(8192, false);
            hamster.setDozingPhase(DozingPhase.NONE);
        }
        return hamster;
    }

    public static void spawnFromNbt(ServerLevel world, Player player, CompoundTag nbt, boolean wasDiamondAlertActive, @Nullable HamsterEntity preconfiguredHamster) {
        HamsterEntity hamster;
        HamsterEntity hamsterEntity = hamster = preconfiguredHamster != null ? preconfiguredHamster : HamsterEntity.createFromNbt(world, player, nbt);
        if (hamster == null) {
            return;
        }
        hamster.suffocationGracePeriod = 200;
        if (wasDiamondAlertActive && Configs.AHP.enableIndependentDiamondSeeking) {
            hamster.isPrimedToSeekDiamonds = true;
            AdorableHamsterPets.LOGGER.debug("[HamsterEntity {}] Primed for diamond seeking upon dismount.", (Object)hamster.getId());
        }
        if (hamster.isThrown()) {
            world.addFreshEntity((Entity)hamster);
            AdorableHamsterPets.LOGGER.debug("[HamsterEntity] Spawned THROWN Hamster ID {} from NBT data near Player {}.", (Object)hamster.getId(), (Object)player.getName().getString());
        } else {
            BlockPos ultimateFallbackPos = player.blockPosition();
            HitResult hitResult = player.pick(4.5, 0.0f, false);
            BlockPos initialSearchPos = hitResult.getType() == HitResult.Type.BLOCK ? ((BlockHitResult)hitResult).getBlockPos() : ultimateFallbackPos;
            Optional<BlockPos> safePosOpt = hamster.findSafeSpawnPosition(initialSearchPos, (Level)world, 5);
            safePosOpt.ifPresentOrElse(safePos -> {
                hamster.moveTo((double)safePos.getX() + 0.5, safePos.getY(), (double)safePos.getZ() + 0.5, player.getYRot(), player.getXRot());
                AdorableHamsterPets.LOGGER.debug("[HamsterDismount] Found safe spawn at {} for player {}.", safePos, (Object)player.getName().getString());
            }, () -> {
                AdorableHamsterPets.LOGGER.warn("[HamsterDismount] Could not find a safe spawn position for player {}. Spawning at player's feet as a fallback.", (Object)player.getName().getString());
                hamster.moveTo((double)ultimateFallbackPos.getX() + 0.5, ultimateFallbackPos.getY(), (double)ultimateFallbackPos.getZ() + 0.5, player.getYRot(), player.getXRot());
            });
            world.addFreshEntityWithPassengers((Entity)hamster);
            AdorableHamsterPets.LOGGER.debug("[HamsterEntity] Spawned Hamster ID {} from NBT data near Player {}.", (Object)hamster.getId(), (Object)player.getName().getString());
        }
    }

    public static void tryThrowFromShoulder(ServerPlayer player) {
        PlayerEntityAccessor playerAccessor = (PlayerEntityAccessor)player;
        AhpConfig config = AdorableHamsterPets.CONFIG;
        if (!config.enableHamsterThrowing) {
            player.displayClientMessage((Component)Component.translatable((String)"message.adorablehamsterpets.throwing_disabled"), true);
            return;
        }
        if (!playerAccessor.hasAnyShoulderHamster()) {
            AdorableHamsterPets.LOGGER.warn("[HamsterThrow] Player {} tried to throw, but has no shoulder hamster.", (Object)player.getName().getString());
            return;
        }
        playerAccessor.adorablehamsterpets$dismountShoulderHamster(true);
    }

    public HamsterEntity(EntityType<? extends TamableAnimal> entityType, Level world) {
        super(entityType, world);
        this.xpReward = 3;
        this.setPathfindingMalus(PathType.WATER, 16.0f);
        this.setPathfindingMalus(PathType.LAVA, 16.0f);
        this.setPathfindingMalus(PathType.DAMAGE_FIRE, 16.0f);
        this.setPathfindingMalus(PathType.DANGER_FIRE, 16.0f);
    }

    public int getVariant() {
        return (Integer)this.entityData.get(VARIANT);
    }

    public void setVariant(int variantId) {
        this.entityData.set(VARIANT, (Object)variantId);
    }

    public boolean isSleeping() {
        return this.getHamsterFlag(1);
    }

    public void setSleeping(boolean sleeping) {
        this.setHamsterFlag(1, sleeping);
    }

    public boolean isOrderedToSit() {
        return this.getHamsterFlag(2) || this.getHamsterFlag(1) || this.getHamsterFlag(256) || this.getHamsterFlag(2048);
    }

    public boolean isCleaning() {
        return this.getHamsterFlag(8192);
    }

    public boolean isBegging() {
        return this.getHamsterFlag(4);
    }

    public void setBegging(boolean value) {
        this.setHamsterFlag(4, value);
    }

    public boolean isInLove() {
        return this.getHamsterFlag(8);
    }

    public void setInLove(boolean value) {
        this.setHamsterFlag(8, value);
    }

    public boolean isRefusingFood() {
        return this.getHamsterFlag(16);
    }

    public void setRefusingFood(boolean value) {
        this.setHamsterFlag(16, value);
    }

    public boolean isThrown() {
        return this.getHamsterFlag(32);
    }

    public void setThrown(boolean thrown) {
        this.setHamsterFlag(32, thrown);
    }

    public boolean isLeftCheekFull() {
        return this.getHamsterFlag(64);
    }

    public void setLeftCheekFull(boolean full) {
        this.setHamsterFlag(64, full);
    }

    public boolean isRightCheekFull() {
        return this.getHamsterFlag(128);
    }

    public void setRightCheekFull(boolean full) {
        this.setHamsterFlag(128, full);
    }

    public boolean isKnockedOut() {
        return this.getHamsterFlag(256);
    }

    public void setKnockedOut(boolean knocked_out) {
        this.setHamsterFlag(256, knocked_out);
    }

    public String getCurrentDeepSleepAnimationIdFromTracker() {
        return (String)this.entityData.get(CURRENT_DEEP_SLEEP_ANIM_ID);
    }

    public boolean isAutoEating() {
        return this.isAutoEating;
    }

    public boolean isConsideringAutoEat() {
        return this.getHamsterFlag(1024);
    }

    public DozingPhase getDozingPhase() {
        return DozingPhase.values()[(Integer)this.entityData.get(DOZING_PHASE)];
    }

    public void setDozingPhase(DozingPhase phase) {
        this.entityData.set(DOZING_PHASE, (Object)phase.ordinal());
    }

    public void setActiveCustomGoalDebugName(String name) {
        this.entityData.set(ACTIVE_CUSTOM_GOAL_NAME_DEBUG, (Object)name);
    }

    public String getActiveCustomGoalDebugName() {
        String goalName = (String)this.entityData.get(ACTIVE_CUSTOM_GOAL_NAME_DEBUG);
        return goalName;
    }

    public boolean isSulking() {
        return this.getHamsterFlag(2048);
    }

    public boolean isCelebratingDiamond() {
        return this.getHamsterFlag(4096);
    }

    public void setCelebratingDiamond(boolean celebrating) {
        this.setHamsterFlag(4096, celebrating);
        if (celebrating) {
            this.setBegging(false);
            if (!this.level().isClientSide()) {
                this.celebrationParticleTicks = 600;
                this.diamondSparkleSoundDelayTicks = 10;
            }
        } else {
            this.celebrationParticleTicks = 0;
            this.diamondSparkleSoundDelayTicks = 0;
            this.diamondCelebrationSoundTicks = 0;
        }
    }

    public void setSulking(boolean sulking) {
        this.setHamsterFlag(2048, sulking);
        if (sulking) {
            if (!this.level().isClientSide()) {
                this.sulkOrchestraHitDelayTicks = 10;
                this.sulkShockedSoundDelayTicks = 44;
                this.sulkFailParticleTicks = 600;
                this.sulkEntityEffectTicks = 600;
            }
        } else {
            this.sulkOrchestraHitDelayTicks = 0;
            this.sulkFailParticleTicks = 0;
            this.sulkEntityEffectTicks = 0;
        }
    }

    public boolean isStealingDiamond() {
        return this.getHamsterFlag(16384);
    }

    public void setStealingDiamond(boolean stealing) {
        this.setHamsterFlag(16384, stealing);
    }

    public int getStealDurationTimer() {
        return (Integer)this.entityData.get(STEAL_DURATION_TIMER);
    }

    public void setStealDurationTimer(int ticks) {
        this.entityData.set(STEAL_DURATION_TIMER, (Object)ticks);
    }

    public boolean isTaunting() {
        return this.getHamsterFlag(32768);
    }

    public void setTaunting(boolean taunting) {
        this.setHamsterFlag(32768, taunting);
    }

    public ItemStack getStolenItemStack() {
        return (ItemStack)this.entityData.get(STOLEN_ITEM_STACK);
    }

    public void setStolenItemStack(ItemStack stack) {
        this.entityData.set(STOLEN_ITEM_STACK, (Object)stack);
    }

    public boolean isCelebratingChase() {
        return this.getHamsterFlag(65536);
    }

    public void setCelebratingChase(boolean celebrating) {
        this.setHamsterFlag(65536, celebrating);
    }

    public boolean hasGreenBeanBuff() {
        return (Long)this.getEntityData().get(GREEN_BEAN_BUFF_DURATION) > this.level().getGameTime();
    }

    public boolean getZoomiesIsClockwise() {
        return this.zoomiesIsClockwise;
    }

    public double getLastZoomiesAngle() {
        return this.lastZoomiesAngle;
    }

    public void setLastZoomiesAngle(double angle) {
        this.lastZoomiesAngle = angle;
    }

    public int getZoomiesRadiusModifier() {
        return this.zoomiesRadiusModifier;
    }

    public boolean isShoulderPet() {
        return this.getHamsterFlag(131072);
    }

    public void setShoulderPet(boolean isShoulderPet) {
        this.setHamsterFlag(131072, isShoulderPet);
    }

    @Override
    public NonNullList<ItemStack> getItems() {
        return this.items;
    }

    @Override
    public void setChanged() {
        if (!this.level().isClientSide()) {
            this.updateCheekTrackers();
        }
    }

    public Component getDisplayName() {
        if (this.hasCustomName()) {
            return super.getDisplayName();
        }
        if (Configs.AHP.useHampterName) {
            return Component.translatable((String)"entity.adorablehamsterpets.hampter");
        }
        return super.getDisplayName();
    }

    @Override
    public boolean canPlaceItem(int slot, ItemStack stack) {
        if (slot < 0 || slot >= 6) {
            return false;
        }
        return !this.isItemDisallowed(stack);
    }

    public void updateCheekTrackers() {
        LivingEntity livingEntity;
        boolean leftFull = false;
        for (int i = 0; i < 3; ++i) {
            if (((ItemStack)this.items.get(i)).isEmpty()) continue;
            leftFull = true;
            break;
        }
        boolean rightFull = false;
        for (int i = 3; i < 6; ++i) {
            if (((ItemStack)this.items.get(i)).isEmpty()) continue;
            rightFull = true;
            break;
        }
        if (this.isLeftCheekFull() != leftFull) {
            this.setLeftCheekFull(leftFull);
        }
        if (this.isRightCheekFull() != rightFull) {
            this.setRightCheekFull(rightFull);
        }
        if (!this.level().isClientSide() && (livingEntity = this.getOwner()) instanceof ServerPlayer) {
            ServerPlayer serverPlayerOwner = (ServerPlayer)livingEntity;
            boolean allSlotsFilled = true;
            for (int i = 0; i < 6; ++i) {
                if (!((ItemStack)this.items.get(i)).isEmpty()) continue;
                allSlotsFilled = false;
                break;
            }
            if (allSlotsFilled) {
                ((HamsterPouchFilledCriterion)((Object)ModCriteria.HAMSTER_POUCH_FILLED.get())).trigger(serverPlayerOwner, this);
            }
        }
    }

    public void addAdditionalSaveData(CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        nbt.putInt("HamsterVariant", this.getVariant());
        if (this.isTame()) {
            nbt.putBoolean("Sitting", this.getHamsterFlag(2));
        }
        nbt.putBoolean("KnockedOut", this.getHamsterFlag(256));
        nbt.putBoolean("CheekPouchUnlocked", this.getHamsterFlag(512));
        nbt.putLong("ThrowCooldownEnd", this.throwCooldownEndTick);
        nbt.putLong("GreenBeanBuffDuration", ((Long)this.getEntityData().get(GREEN_BEAN_BUFF_DURATION)).longValue());
        nbt.putInt("AutoEatCooldown", this.autoEatCooldownTicks);
        nbt.putInt("EjectionCheckCooldown", this.ejectionCheckCooldown);
        nbt.putInt("PinkPetalType", ((Integer)this.entityData.get(PINK_PETAL_TYPE)).intValue());
        nbt.putInt("AnimationPersonalityId", ((Integer)this.entityData.get(ANIMATION_PERSONALITY_ID)).intValue());
        nbt.putInt("DozingPhase", this.getDozingPhase().ordinal());
        nbt.putString("CurrentDeepSleepAnimId", (String)this.entityData.get(CURRENT_DEEP_SLEEP_ANIM_ID));
        nbt.putInt("QuiescentSitTimer", this.quiescentSitDurationTimer);
        nbt.putInt("DriftingOffTimer", this.driftingOffTimer);
        nbt.putInt("SettleSleepCooldown", this.settleSleepAnimationCooldown);
        HolderLookup.Provider registries = this.getRegistryLookup();
        CompoundTag inventoryWrapperNbt = new CompoundTag();
        ContainerHelper.saveAllItems((CompoundTag)inventoryWrapperNbt, this.items, (HolderLookup.Provider)registries);
        nbt.put("Inventory", (Tag)inventoryWrapperNbt);
        nbt.putBoolean("IsPrimedToSeekDiamonds", this.isPrimedToSeekDiamonds);
        nbt.putLong("FoundOreCooldownEndTick", this.foundOreCooldownEndTick);
        if (this.currentOreTarget != null) {
            nbt.putInt("OreTargetX", this.currentOreTarget.getX());
            nbt.putInt("OreTargetY", this.currentOreTarget.getY());
            nbt.putInt("OreTargetZ", this.currentOreTarget.getZ());
        }
        nbt.putBoolean("IsSulking", this.getHamsterFlag(2048));
        nbt.putBoolean("IsCelebratingDiamond", this.getHamsterFlag(4096));
        if (this.isStealingDiamond()) {
            nbt.putBoolean("IsStealingDiamond", true);
            nbt.putInt("StealDurationTimer", this.getStealDurationTimer());
            if (!this.getStolenItemStack().isEmpty()) {
                nbt.put("StolenItemStack", this.getStolenItemStack().save(registries));
            }
        }
    }

    public void readAdditionalSaveData(CompoundTag nbt) {
        super.readAdditionalSaveData(nbt);
        this.setVariant(nbt.getInt("HamsterVariant"));
        boolean wasSittingNbt = this.isTame() && nbt.getBoolean("Sitting");
        this.setSitting(wasSittingNbt, true);
        this.setHamsterFlag(256, nbt.getBoolean("KnockedOut"));
        this.setHamsterFlag(512, nbt.getBoolean("CheekPouchUnlocked"));
        this.setHamsterFlag(2048, nbt.getBoolean("IsSulking"));
        this.setHamsterFlag(4096, nbt.getBoolean("IsCelebratingDiamond"));
        this.throwCooldownEndTick = nbt.getLong("ThrowCooldownEnd");
        this.getEntityData().set(GREEN_BEAN_BUFF_DURATION, (Object)nbt.getLong("GreenBeanBuffDuration"));
        this.autoEatCooldownTicks = nbt.getInt("AutoEatCooldown");
        this.ejectionCheckCooldown = nbt.contains("EjectionCheckCooldown", 3) ? nbt.getInt("EjectionCheckCooldown") : 20;
        this.entityData.set(PINK_PETAL_TYPE, (Object)nbt.getInt("PinkPetalType"));
        this.entityData.set(ANIMATION_PERSONALITY_ID, (Object)nbt.getInt("AnimationPersonalityId"));
        if (nbt.contains("DozingPhase", 3)) {
            int phaseOrdinal = nbt.getInt("DozingPhase");
            if (phaseOrdinal >= 0 && phaseOrdinal < DozingPhase.values().length) {
                this.setDozingPhase(DozingPhase.values()[phaseOrdinal]);
            } else {
                this.setDozingPhase(DozingPhase.NONE);
            }
        } else {
            this.setDozingPhase(DozingPhase.NONE);
        }
        this.entityData.set(CURRENT_DEEP_SLEEP_ANIM_ID, (Object)nbt.getString("CurrentDeepSleepAnimId"));
        this.quiescentSitDurationTimer = nbt.getInt("QuiescentSitTimer");
        this.driftingOffTimer = nbt.getInt("DriftingOffTimer");
        this.settleSleepAnimationCooldown = nbt.getInt("SettleSleepCooldown");
        this.items.clear();
        HolderLookup.Provider registries = this.getRegistryLookup();
        if (nbt.contains("Inventory", 10)) {
            ContainerHelper.loadAllItems((CompoundTag)nbt.getCompound("Inventory"), this.items, (HolderLookup.Provider)registries);
        }
        this.updateCheekTrackers();
        this.isPrimedToSeekDiamonds = nbt.getBoolean("IsPrimedToSeekDiamonds");
        this.foundOreCooldownEndTick = nbt.getLong("FoundOreCooldownEndTick");
        this.currentOreTarget = nbt.contains("OreTargetX") && nbt.contains("OreTargetY") && nbt.contains("OreTargetZ") ? new BlockPos(nbt.getInt("OreTargetX"), nbt.getInt("OreTargetY"), nbt.getInt("OreTargetZ")) : null;
        this.setStealingDiamond(nbt.getBoolean("IsStealingDiamond"));
        if (this.isStealingDiamond()) {
            this.setStealDurationTimer(nbt.getInt("StealDurationTimer"));
            if (nbt.contains("StolenItemStack", 10)) {
                ItemStack.parse((HolderLookup.Provider)registries, (Tag)nbt.get("StolenItemStack")).ifPresent(this::setStolenItemStack);
            }
        } else {
            this.setStealDurationTimer(0);
            this.setStolenItemStack(ItemStack.EMPTY);
        }
    }

    public HamsterShoulderData saveToShoulderData() {
        this.updateCheekTrackers();
        CompoundTag inventoryNbt = new CompoundTag();
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)level;
            ContainerHelper.saveAllItems((CompoundTag)inventoryNbt, this.items, (HolderLookup.Provider)serverWorld.registryAccess());
        }
        CompoundTag effectsNbt = new CompoundTag();
        if (!this.getActiveEffects().isEmpty()) {
            ListTag effectsList = new ListTag();
            for (MobEffectInstance effectInstance : this.getActiveEffects()) {
                effectsList.add((Object)effectInstance.save());
            }
            effectsNbt.put("active_effects", (Tag)effectsList);
        }
        Optional<String> nameOptional = Optional.ofNullable(this.getCustomName()).map(Component::getString);
        HamsterShoulderData.SeekingBehaviorData seekingData = new HamsterShoulderData.SeekingBehaviorData(this.isPrimedToSeekDiamonds, this.foundOreCooldownEndTick, Optional.ofNullable(this.currentOreTarget));
        return new HamsterShoulderData(this.getVariant(), this.getHealth(), inventoryNbt, this.getAge(), this.throwCooldownEndTick, this.greenBeanBuffEndTick, (Long)this.getEntityData().get(GREEN_BEAN_BUFF_DURATION), effectsNbt, this.autoEatCooldownTicks, nameOptional, (Integer)this.entityData.get(PINK_PETAL_TYPE), (Integer)this.entityData.get(ANIMATION_PERSONALITY_ID), seekingData, (Integer)this.entityData.get(HAMSTER_FLAGS));
    }

    public boolean causeFallDamage(float fallDistance, float damageMultiplier, DamageSource damageSource) {
        return false;
    }

    public void turn(double cursorX, double cursorY) {
        if (this.isSleeping()) {
            return;
        }
        super.turn(cursorX, cursorY);
    }

    public Optional<BlockPos> findSafeSpawnPosition(BlockPos initialTarget, Level world, int searchRadius) {
        if (this.isSafeSpawnLocation(initialTarget, world)) {
            return Optional.of(initialTarget);
        }
        for (int i = 1; i <= 3; ++i) {
            BlockPos abovePos = initialTarget.above(i);
            if (!this.isSafeSpawnLocation(abovePos, world)) continue;
            return Optional.of(abovePos);
        }
        for (int r = 1; r <= searchRadius; ++r) {
            for (int i = -r; i <= r; ++i) {
                for (int j = -r; j <= r; ++j) {
                    BlockPos checkPos;
                    if (Math.abs(i) != r && Math.abs(j) != r || !this.isSafeSpawnLocation(checkPos = initialTarget.offset(i, 0, j), world)) continue;
                    return Optional.of(checkPos);
                }
            }
        }
        return Optional.empty();
    }

    public void setOrderedToSit(boolean sitting) {
        this.setSitting(sitting, true);
    }

    public void setSitting(boolean sitting, boolean suppressSound) {
        if (!sitting && this.isTame() && this.getDozingPhase() != DozingPhase.NONE) {
            this.resetSleepSequence("Player commanded hamster to stand up.");
        }
        this.setHamsterFlag(2, sitting);
        this.setInSittingPose(sitting);
        if (sitting) {
            this.cleaningTimer = 0;
        } else {
            this.quiescentSitDurationTimer = 0;
            this.cleaningTimer = 0;
            if (this.getHamsterFlag(8192)) {
                this.setHamsterFlag(8192, false);
            }
        }
    }

    public boolean isWithinMeleeAttackRange(LivingEntity entity) {
        AABB hamsterBox = this.getBoundingBox();
        AABB attackBox = hamsterBox.inflate(0.7, 0.0, 0.7);
        boolean intersects = attackBox.intersects(entity.getBoundingBox());
        return intersects;
    }

    public boolean wantsToAttack(LivingEntity target, LivingEntity owner) {
        TraceableEntity ownableFallback;
        Entity fallbackOwnerEntity;
        UUID ownerUuid = owner.getUUID();
        AdorableHamsterPets.LOGGER.trace("[canAttackWithOwner] Hamster: {}, Target: {}, Owner: {}", new Object[]{this.getName().getString(), target.getName().getString(), owner.getName().getString()});
        if (target == this || target == owner) {
            return false;
        }
        if (target instanceof Player && target.getUUID().equals(ownerUuid)) {
            return false;
        }
        if (target instanceof Creeper || target instanceof ArmorStand) {
            return false;
        }
        if (target instanceof TamableAnimal) {
            TamableAnimal tameablePet = (TamableAnimal)target;
            UUID petOwnerUuid = tameablePet.getOwnerUUID();
            if (petOwnerUuid != null && petOwnerUuid.equals(ownerUuid)) {
                AdorableHamsterPets.LOGGER.trace("[canAttackWithOwner] Target is a TameableEntity owned by the same player. Preventing attack.");
                return false;
            }
        } else if (target instanceof AbstractHorse) {
            AbstractHorse horsePet = (AbstractHorse)target;
            LivingEntity horseOwnerEntity = horsePet.getOwner();
            if (horseOwnerEntity != null && horseOwnerEntity.getUUID().equals(ownerUuid)) {
                AdorableHamsterPets.LOGGER.trace("[canAttackWithOwner] Target is an AbstractHorseEntity owned by the same player. Preventing attack.");
                return false;
            }
        } else if (target instanceof TraceableEntity && (fallbackOwnerEntity = (ownableFallback = (TraceableEntity)target).getOwner()) != null && fallbackOwnerEntity.getUUID().equals(ownerUuid)) {
            AdorableHamsterPets.LOGGER.trace("[canAttackWithOwner] Target is an Ownable (fallback) owned by the same player. Preventing attack.");
            return false;
        }
        return true;
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        Level world = this.level();
        AdorableHamsterPets.LOGGER.trace("[InteractMob {} Tick {}] Interaction start. Player: {}, Hand: {}, Item: {}", new Object[]{this.getId(), world.getGameTime(), player.getName().getString(), hand, stack.getItem()});
        if (this.interactionCooldown > 0) {
            AdorableHamsterPets.LOGGER.trace("[InteractMob {} Tick {}] Interaction cooldown active ({} ticks left). Passing.", new Object[]{this.getId(), world.getGameTime(), this.interactionCooldown});
            return InteractionResult.PASS;
        }
        if (player.isShiftKeyDown() && stack.is((Item)ModItems.HAMSTER_GUIDE_BOOK.get())) {
            if (!world.isClientSide) {
                boolean newSetting;
                AhpConfig currentConfig = AdorableHamsterPets.CONFIG;
                boolean currentSetting = currentConfig.enableJadeHamsterDebugInfo;
                currentConfig.enableJadeHamsterDebugInfo = newSetting = !currentSetting;
                currentConfig.save();
                MutableComponent message = Component.translatable((String)(newSetting ? "message.adorablehamsterpets.debug_overlay_enabled" : "message.adorablehamsterpets.debug_overlay_disabled")).withStyle(newSetting ? ChatFormatting.GREEN : ChatFormatting.RED);
                player.displayClientMessage((Component)message, true);
                AdorableHamsterPets.LOGGER.info("Player {} toggled Jade Hamster Debug Info via Guide Book to: {} for hamster {}", new Object[]{player.getName().getString(), newSetting, this.getId()});
            }
            return InteractionResult.sidedSuccess((boolean)world.isClientSide());
        }
        if (!this.isTame()) {
            AdorableHamsterPets.LOGGER.trace("[InteractMob {} Tick {}] Hamster not tamed. Checking for taming attempt.", (Object)this.getId(), (Object)world.getGameTime());
            if (player.isShiftKeyDown() && ModItemTags.isTamingFood(stack)) {
                AdorableHamsterPets.LOGGER.trace("[InteractMob {} Tick {}] Taming attempt detected.", (Object)this.getId(), (Object)world.getGameTime());
                if (!world.isClientSide) {
                    this.tryTame(player, stack);
                }
                return InteractionResult.sidedSuccess((boolean)world.isClientSide());
            }
            AdorableHamsterPets.LOGGER.trace("[InteractMob {} Tick {}] Not a taming attempt. Calling super.interactMob for untamed.", (Object)this.getId(), (Object)world.getGameTime());
            return super.mobInteract(player, hand);
        }
        if (this.isOwnedBy((LivingEntity)player)) {
            boolean isPotentialFood;
            boolean isUsingKeybind;
            AdorableHamsterPets.LOGGER.trace("[InteractMob {} Tick {}] Player is owner. Processing owner interactions.", (Object)this.getId(), (Object)world.getGameTime());
            boolean isSneaking = player.isShiftKeyDown();
            PlayerEntityAccessor playerAccessor = (PlayerEntityAccessor)player;
            if (this.getDozingPhase() != DozingPhase.NONE) {
                this.resetSleepSequence("Player attempted to feed hamster.");
            }
            if (this.isStealingDiamond() && this.isOwnedBy((LivingEntity)player)) {
                AdorableHamsterPets.LOGGER.trace("[InteractMob-{}] Passed 'isStealingDiamond' check.", (Object)this.getId());
                if (!world.isClientSide) {
                    ItemStack retrievedStack = this.getStolenItemStack().copy();
                    player.getInventory().placeItemBackInInventory(this.getStolenItemStack().copy());
                    this.setStolenItemStack(ItemStack.EMPTY);
                    this.setStealDurationTimer(0);
                    this.setStealingDiamond(false);
                    this.setCelebratingChase(true);
                    this.celebrationChaseTicks = 30;
                    this.triggerAnimOnServer("mainController", "anim_hamster_celebrate_chase");
                    world.playSound(null, this.blockPosition(), ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_AFFECTION_SOUNDS, this.random), SoundSource.NEUTRAL, 1.0f, this.getVoicePitch());
                    if (!retrievedStack.isEmpty()) {
                        SoundEvent pounceSound = ModSounds.getDynamicItemSound(retrievedStack);
                        float volume = pounceSound == SoundEvents.GENERIC_EAT ? 0.35f : 1.0f;
                        world.playSound(null, this.blockPosition(), pounceSound, SoundSource.NEUTRAL, volume, 1.7f);
                    }
                    AdorableHamsterPets.LOGGER.trace("[InteractMob-{}] Diamond returned to player and goal stopped.", (Object)this.getId());
                }
                return InteractionResult.sidedSuccess((boolean)world.isClientSide());
            }
            if (this.isKnockedOut()) {
                AdorableHamsterPets.LOGGER.trace("[InteractMob {} Tick {}] Hamster is knocked out. Waking up.", (Object)this.getId(), (Object)world.getGameTime());
                if (!world.isClientSide()) {
                    SoundEvent wakeUpSound = ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_WAKE_UP_SOUNDS, this.random);
                    if (wakeUpSound != null) {
                        world.playSound(null, this.blockPosition(), wakeUpSound, SoundSource.NEUTRAL, 1.0f, 1.0f);
                    }
                    this.setKnockedOut(false);
                    this.setSitting(false, true);
                    this.triggerAnimOnServer("mainController", "wakeup");
                }
                return InteractionResult.sidedSuccess((boolean)world.isClientSide());
            }
            if (this.isCelebratingDiamond()) {
                if (!world.isClientSide()) {
                    this.setCelebratingDiamond(false);
                    this.setSitting(false, true);
                    SoundEvent affectionSound = ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_AFFECTION_SOUNDS, this.random);
                    if (affectionSound != null) {
                        world.playSound(null, this.blockPosition(), affectionSound, SoundSource.NEUTRAL, 1.0f, this.getVoicePitch());
                    } else {
                        world.playSound(null, this.blockPosition(), SoundEvents.ITEM_PICKUP, SoundSource.NEUTRAL, 0.5f, 1.5f);
                    }
                }
                return InteractionResult.sidedSuccess((boolean)world.isClientSide());
            }
            if (this.isSulking()) {
                if (!world.isClientSide()) {
                    this.setSulking(false);
                    this.setSitting(false, true);
                    SoundEvent affectionSound = ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_AFFECTION_SOUNDS, this.random);
                    if (affectionSound != null) {
                        world.playSound(null, this.blockPosition(), affectionSound, SoundSource.NEUTRAL, 1.0f, this.getVoicePitch());
                    } else {
                        world.playSound(null, this.blockPosition(), SoundEvents.CHICKEN_STEP, SoundSource.NEUTRAL, 0.5f, 1.5f);
                    }
                }
                return InteractionResult.sidedSuccess((boolean)world.isClientSide());
            }
            if (stack.is(Items.PINK_PETALS) && !player.isShiftKeyDown()) {
                if (!world.isClientSide) {
                    int currentPetalType = (Integer)this.entityData.get(PINK_PETAL_TYPE);
                    int nextPetalType = currentPetalType % 3 + 1;
                    this.entityData.set(PINK_PETAL_TYPE, (Object)nextPetalType);
                    world.playSound(null, this.blockPosition(), SoundEvents.PINK_PETALS_PLACE, SoundSource.PLAYERS, 0.7f, 1.0f + this.random.nextFloat() * 0.2f);
                    if (world instanceof ServerLevel) {
                        ServerLevel serverWorld = (ServerLevel)world;
                        serverWorld.sendParticles((ParticleOptions)ParticleTypes.FALLING_SPORE_BLOSSOM, this.getX(), this.getY() + (double)this.getBbHeight() * 0.75, this.getZ(), 7, (double)(this.getBbWidth() / 2.0f), (double)(this.getBbHeight() / 2.0f), (double)(this.getBbWidth() / 2.0f), 0.0);
                    }
                    if (!player.getAbilities().instabuild) {
                        stack.shrink(1);
                    }
                    AdorableHamsterPets.LOGGER.trace("[InteractMob {}] Cycled/Applied pink petal to type {}.", (Object)this.getId(), (Object)nextPetalType);
                    if (player instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)player;
                        ((AppliedPinkPetalCriterion)((Object)ModCriteria.APPLIED_PINK_PETAL.get())).trigger(serverPlayer, this);
                    }
                }
                return InteractionResult.sidedSuccess((boolean)world.isClientSide());
            }
            if (stack.is(Items.SHEARS) && !player.isShiftKeyDown() && (Integer)this.entityData.get(PINK_PETAL_TYPE) > 0) {
                if (!world.isClientSide) {
                    this.entityData.set(PINK_PETAL_TYPE, (Object)0);
                    world.playSound(null, this.blockPosition(), SoundEvents.SHEEP_SHEAR, SoundSource.PLAYERS, 0.9f, 1.0f + this.random.nextFloat() * 0.1f);
                    if (world instanceof ServerLevel) {
                        ServerLevel serverWorld = (ServerLevel)world;
                        serverWorld.sendParticles((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, new ItemStack((ItemLike)Items.PINK_PETALS)), this.getX(), this.getY() + (double)this.getBbHeight() * 0.5, this.getZ(), 5, (double)(this.getBbWidth() / 2.0f), (double)(this.getBbHeight() / 2.0f), (double)(this.getBbWidth() / 2.0f), 0.05);
                    }
                    Containers.dropItemStack((Level)world, (double)this.getX(), (double)(this.getY() + 0.5), (double)this.getZ(), (ItemStack)new ItemStack((ItemLike)Items.PINK_PETALS, 1));
                    if (!player.getAbilities().instabuild) {
                        stack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
                    }
                    AdorableHamsterPets.LOGGER.trace("[InteractMob {}] Removed pink petals with shears.", (Object)this.getId());
                }
                return InteractionResult.sidedSuccess((boolean)world.isClientSide());
            }
            boolean isUsingItem = ModItemTags.isShoulderMountFood(stack);
            boolean bl = isUsingKeybind = !world.isClientSide() && Configs.AHP.enableShoulderMountKeybind && ModKeyBindings.FORCE_MOUNT_HAMSTER_KEY.isDown();
            if (isUsingItem || isUsingKeybind) {
                if (!world.isClientSide) {
                    ShoulderLocation availableSlot = null;
                    if (playerAccessor.getShoulderHamster(ShoulderLocation.RIGHT_SHOULDER).isEmpty()) {
                        availableSlot = ShoulderLocation.RIGHT_SHOULDER;
                    } else if (playerAccessor.getShoulderHamster(ShoulderLocation.LEFT_SHOULDER).isEmpty()) {
                        availableSlot = ShoulderLocation.LEFT_SHOULDER;
                    } else if (playerAccessor.getShoulderHamster(ShoulderLocation.HEAD).isEmpty()) {
                        availableSlot = ShoulderLocation.HEAD;
                    }
                    if (availableSlot != null) {
                        AdorableHamsterPets.LOGGER.debug("[AHP DEBUG] MOUNTING: Found available slot '{}' for Hamster ID {}.", (Object)availableSlot, (Object)this.getId());
                        HamsterShoulderData data = this.saveToShoulderData();
                        playerAccessor.setShoulderHamster(availableSlot, data.toNbt());
                        playerAccessor.adorablehamsterpets$getMountOrderQueue().addLast(availableSlot);
                        BlockPos hamsterPosForMountSound = this.blockPosition();
                        this.discard();
                        if (player instanceof ServerPlayer) {
                            ServerPlayer serverPlayer = (ServerPlayer)player;
                            ((HamsterOnShoulderCriterion)((Object)ModCriteria.HAMSTER_ON_SHOULDER.get())).trigger(serverPlayer);
                        }
                        player.displayClientMessage((Component)Component.translatable((String)"message.adorablehamsterpets.shoulder_mount_success"), true);
                        SoundEvent mountSound = ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_SHOULDER_MOUNT_SOUNDS, this.random);
                        if (mountSound != null) {
                            world.playSound(null, player.blockPosition(), mountSound, SoundSource.PLAYERS, 1.0f, this.getVoicePitch());
                        }
                        if (isUsingItem) {
                            SoundEvent mountLureSound = ModSounds.getDynamicItemSound(stack);
                            world.playSound(null, hamsterPosForMountSound, mountLureSound, SoundSource.PLAYERS, 1.0f, 1.0f);
                            ((ServerLevel)world).sendParticles((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, stack), (double)hamsterPosForMountSound.getX() + 0.5, (double)hamsterPosForMountSound.getY() + 0.5, (double)hamsterPosForMountSound.getZ() + 0.5, 8, 0.25, 0.25, 0.25, 0.05);
                            if (!player.getAbilities().instabuild && Configs.AHP.consumeShoulderMountItem) {
                                stack.shrink(1);
                            }
                        }
                    } else {
                        player.displayClientMessage((Component)Component.translatable((String)"message.adorablehamsterpets.shoulder_occupied"), true);
                    }
                } else {
                    player.swing(hand);
                }
                return InteractionResult.CONSUME;
            }
            if (!world.isClientSide() && isSneaking) {
                if (this.getHamsterFlag(512) || !AdorableHamsterPets.CONFIG.requireFoodMixToUnlockCheeks) {
                    MenuRegistry.openExtendedMenu((ServerPlayer)((ServerPlayer)player), (ExtendedMenuProvider)new HamsterScreenHandlerFactory(this));
                } else {
                    player.displayClientMessage((Component)Component.translatable((String)"message.adorablehamsterpets.cheek_pouch_locked").withStyle(ChatFormatting.WHITE), true);
                }
                return InteractionResult.CONSUME;
            }
            boolean bl2 = isPotentialFood = ModItemTags.isStandardFood(stack) || ModItemTags.isBuffFood(stack) || ModItemTags.isPouchUnlockFood(stack);
            if (!world.isClientSide() && !isSneaking && isPotentialFood) {
                AdorableHamsterPets.LOGGER.trace("[InteractMob {} Tick {}] Owner not sneaking, holding potential food. Checking refusal.", (Object)this.getId(), (Object)world.getGameTime());
                if (this.checkRepeatFoodRefusal(stack, player)) {
                    AdorableHamsterPets.LOGGER.trace("[InteractMob {} Tick {}] Food refused. Consuming interaction.", (Object)this.getId(), (Object)world.getGameTime());
                    return InteractionResult.CONSUME;
                }
                AdorableHamsterPets.LOGGER.trace("[InteractMob {} Tick {}] Attempting feeding via tryFeedingAsTamed.", (Object)this.getId(), (Object)world.getGameTime());
                boolean feedingOccurred = this.tryFeedingAsTamed(player, stack);
                if (feedingOccurred) {
                    AdorableHamsterPets.LOGGER.trace("[InteractMob {} Tick {}] tryFeedingAsTamed returned true. Setting last food, decrementing stack.", (Object)this.getId(), (Object)world.getGameTime());
                    this.lastFoodItem = stack.copy();
                    if (!player.getAbilities().instabuild) {
                        stack.shrink(1);
                    }
                    return InteractionResult.CONSUME;
                }
                AdorableHamsterPets.LOGGER.trace("[InteractMob {} Tick {}] tryFeedingAsTamed returned false. Passing to vanilla/sitting.", (Object)this.getId(), (Object)world.getGameTime());
            }
            if (!(isSneaking || isPotentialFood || ModItemTags.isShoulderMountFood(stack) || stack.is(Items.PINK_PETALS))) {
                AdorableHamsterPets.LOGGER.trace("[InteractMob {} Tick {}] Not sneaking or holding handled food/petals. Calling super.interactMob.", (Object)this.getId(), (Object)world.getGameTime());
                InteractionResult vanillaResult = super.mobInteract(player, hand);
                AdorableHamsterPets.LOGGER.trace("[InteractMob {} Tick {}] super.interactMob returned: {}", new Object[]{this.getId(), world.getGameTime(), vanillaResult});
                if (vanillaResult.consumesAction()) {
                    return vanillaResult;
                }
            }
            if (!world.isClientSide() && !isSneaking) {
                AdorableHamsterPets.LOGGER.trace("[InteractMob {} Tick {}] Fallback: Toggling sitting state.", (Object)this.getId(), (Object)world.getGameTime());
                this.setOrderedToSit(!this.isOrderedToSit());
                this.jumping = false;
                this.navigation.stop();
                this.setTarget(null);
                return InteractionResult.CONSUME_PARTIAL;
            }
            AdorableHamsterPets.LOGGER.debug("[InteractMob {} Tick {}] Reached end of owner logic. Returning client-side success/pass.", (Object)this.getId(), (Object)world.getGameTime());
            return InteractionResult.sidedSuccess((boolean)world.isClientSide());
        }
        AdorableHamsterPets.LOGGER.debug("[InteractMob {} Tick {}] Player is not owner. Calling super.interactMob.", (Object)this.getId(), (Object)world.getGameTime());
        return super.mobInteract(player, hand);
    }

    public void setTame(boolean tamed, boolean updateAttributes) {
        super.setTame(tamed, updateAttributes);
        if (tamed) {
            this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(((Double)Configs.AHP.tamedMaxHealth.get()).doubleValue());
            this.setHealth(this.getMaxHealth());
            this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(((Double)Configs.AHP.meleeDamage.get()).doubleValue());
        } else {
            this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(((Double)Configs.AHP.wildMaxHealth.get()).doubleValue());
            this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(((Double)Configs.AHP.meleeDamage.get()).doubleValue());
        }
    }

    public boolean isInCustomLove() {
        return this.customLoveTimer > 0;
    }

    public void setCustomInLove(Player player) {
        this.customLoveTimer = 600;
        if (!this.level().isClientSide) {
            this.level().broadcastEntityEvent((Entity)this, (byte)18);
        }
    }

    public void setBaby(boolean baby) {
        this.setAge(baby ? -24000 : 0);
    }

    public void setInSittingPose(boolean inSittingPose) {
        super.setInSittingPose(inSittingPose);
        if (this.getHamsterFlag(2) != inSittingPose) {
            this.setHamsterFlag(2, inSittingPose);
        }
        if (!inSittingPose) {
            if (this.isSleeping()) {
                this.setSleeping(false);
            }
            if (this.isKnockedOut()) {
                this.setKnockedOut(false);
            }
        }
    }

    public HamsterVariant getVariantEnum() {
        return HamsterVariant.byId(this.getVariant());
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel world, AgeableMob mate) {
        HamsterVariant babyFinalVariant;
        boolean motherHasOverlay;
        HamsterEntity baby = (HamsterEntity)((EntityType)ModEntities.HAMSTER.get()).create((Level)world);
        if (baby == null) {
            return null;
        }
        if (!(mate instanceof HamsterEntity)) {
            int randomVariantId = this.random.nextInt(HamsterVariant.values().length);
            baby.setVariant(randomVariantId);
            baby.setBaby(true);
            AdorableHamsterPets.LOGGER.warn("Hamster breeding attempted with non-hamster mate. Assigning random variant to baby.");
            return baby;
        }
        HamsterEntity mother = (HamsterEntity)mate;
        HamsterEntity father = this;
        HamsterVariant parentProvidingBaseColor = this.random.nextBoolean() ? father.getVariantEnum() : mother.getVariantEnum();
        HamsterVariant babyBaseColorEnum = parentProvidingBaseColor.getBaseVariant();
        @Nullable String fatherOverlayName = father.getVariantEnum().getOverlayTextureName();
        @Nullable String motherOverlayName = mother.getVariantEnum().getOverlayTextureName();
        List<HamsterVariant> allVariantsForBabyBase = HamsterVariant.getVariantsForBase(babyBaseColorEnum);
        ArrayList<@Nullable String> eligibleOverlayNames = new ArrayList<String>();
        for (HamsterVariant variant : allVariantsForBabyBase) {
            boolean matchesMother;
            @Nullable String candidateOverlay = variant.getOverlayTextureName();
            boolean matchesFather = fatherOverlayName != null && fatherOverlayName.equals(candidateOverlay);
            boolean bl = matchesMother = motherOverlayName != null && motherOverlayName.equals(candidateOverlay);
            if (matchesFather || matchesMother) continue;
            eligibleOverlayNames.add(candidateOverlay);
        }
        ArrayList<@Nullable String> finalSelectableOverlayNames = new ArrayList<String>();
        boolean fatherHasOverlay = fatherOverlayName != null;
        boolean bl = motherHasOverlay = motherOverlayName != null;
        if (fatherHasOverlay && motherHasOverlay) {
            for (String overlayName : eligibleOverlayNames) {
                if (overlayName == null) continue;
                finalSelectableOverlayNames.add(overlayName);
            }
            if (finalSelectableOverlayNames.isEmpty() && babyBaseColorEnum != HamsterVariant.WHITE) {
                for (HamsterVariant variant : allVariantsForBabyBase) {
                    if (variant.getOverlayTextureName() == null) continue;
                    finalSelectableOverlayNames.add(variant.getOverlayTextureName());
                }
            }
        } else {
            finalSelectableOverlayNames.addAll(eligibleOverlayNames);
        }
        if (!finalSelectableOverlayNames.isEmpty()) {
            @Nullable String chosenOverlayName = (String)finalSelectableOverlayNames.get(this.random.nextInt(finalSelectableOverlayNames.size()));
            babyFinalVariant = HamsterVariant.getVariantByBaseAndOverlay(babyBaseColorEnum, chosenOverlayName);
        } else {
            babyFinalVariant = babyBaseColorEnum;
        }
        baby.setVariant(babyFinalVariant.getId());
        UUID ownerUUID = father.getOwnerUUID();
        if (ownerUUID != null) {
            baby.setOwnerUUID(ownerUUID);
            baby.setTame(true, true);
        }
        baby.setBaby(true);
        return baby;
    }

    public boolean isFood(ItemStack stack) {
        return ModItemTags.isStandardFood(stack);
    }

    public void tick() {
        Level world;
        int chanceDenominator;
        if (this.interactionCooldown > 0) {
            --this.interactionCooldown;
        }
        if (this.suffocationGracePeriod > 0) {
            --this.suffocationGracePeriod;
        }
        if (this.cleaningCooldownTimer > 0) {
            --this.cleaningCooldownTimer;
        }
        if (this.cleaningTimer > 0) {
            --this.cleaningTimer;
            if (this.cleaningTimer == 0) {
                if (!this.level().isClientSide) {
                    this.setHamsterFlag(8192, false);
                }
                this.cleaningCooldownTimer = 200;
            }
        }
        if (this.wakingUpTicks > 0) {
            --this.wakingUpTicks;
        }
        if (this.autoEatCooldownTicks > 0) {
            --this.autoEatCooldownTicks;
        }
        if (this.autoEatProgressTicks > 0) {
            --this.autoEatProgressTicks;
        }
        if (this.ejectionCheckCooldown > 0) {
            --this.ejectionCheckCooldown;
        }
        if (this.preAutoEatDelayTicks > 0) {
            --this.preAutoEatDelayTicks;
        }
        if (this.celebrationParticleTicks > 0) {
            --this.celebrationParticleTicks;
        }
        if (this.celebrationParticleTicks > 0) {
            --this.celebrationParticleTicks;
        }
        if (this.diamondCelebrationSoundTicks > 0) {
            --this.diamondCelebrationSoundTicks;
        }
        if (this.sulkOrchestraHitDelayTicks > 0) {
            --this.sulkOrchestraHitDelayTicks;
        }
        if (this.sulkFailParticleTicks > 0) {
            --this.sulkFailParticleTicks;
        }
        if (this.sulkEntityEffectTicks > 0) {
            --this.sulkEntityEffectTicks;
        }
        if (this.sulkShockedSoundDelayTicks > 0) {
            --this.sulkShockedSoundDelayTicks;
        }
        if (this.diamondSparkleSoundDelayTicks > 0) {
            --this.diamondSparkleSoundDelayTicks;
        }
        if (this.isKnockedOut() && this.getHamsterFlag(8192)) {
            this.setHamsterFlag(8192, false);
            this.cleaningTimer = 0;
        }
        DozingPhase currentPhase = this.getDozingPhase();
        if (!this.level().isClientSide() && this.isTame() && this.isOrderedToSit() && !this.getHamsterFlag(8192) && this.cleaningCooldownTimer <= 0 && (currentPhase == DozingPhase.NONE || currentPhase == DozingPhase.QUIESCENT_SITTING) && (chanceDenominator = ((Integer)Configs.AHP.cleaningChanceDenominator.get()).intValue()) > 0 && this.random.nextInt(chanceDenominator) == 0) {
            this.cleaningTimer = this.random.nextIntBetweenInclusive(30, 60);
            this.setHamsterFlag(8192, true);
        }
        if (this.isCelebratingChase()) {
            if (this.celebrationChaseTicks > 0) {
                if (this.getOwner() != null) {
                    this.getLookControl().setLookAt((Entity)this.getOwner(), 25.0f, 25.0f);
                }
                --this.celebrationChaseTicks;
            } else {
                this.setCelebratingChase(false);
            }
        }
        if (this.isThrown()) {
            ++this.throwTicks;
            Vec3 currentPos = this.position();
            Vec3 currentVel = this.getDeltaMovement();
            Vec3 nextPos = currentPos.add(currentVel);
            Level world2 = this.level();
            BlockHitResult blockHit = world2.clip(new ClipContext(currentPos, nextPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
            boolean stopped = false;
            if (blockHit.getType() == HitResult.Type.BLOCK) {
                BlockHitResult blockHitResult = blockHit;
                BlockPos adjacentPos = blockHitResult.getBlockPos().relative(blockHitResult.getDirection());
                this.setPos((double)adjacentPos.getX() + 0.5, adjacentPos.getY(), (double)adjacentPos.getZ() + 0.5);
                this.setDeltaMovement(currentVel.multiply(0.6, 0.0, 0.6));
                this.setThrown(false);
                this.playSound(SoundEvents.GENERIC_SMALL_FALL, 1.0f, 1.2f);
                this.setKnockedOut(true);
                this.setInSittingPose(true);
                if (!world2.isClientSide()) {
                    this.triggerAnimOnServer("mainController", "crash");
                }
                stopped = true;
            } else {
                EntityHitResult entityHit = ProjectileUtil.getEntityHitResult((Level)world2, (Entity)this, (Vec3)currentPos, (Vec3)nextPos, (AABB)this.getBoundingBox().expandTowards(currentVel).inflate(1.0), this::canHitEntity);
                if (entityHit != null && entityHit.getEntity() != null) {
                    Entity hitEntity = entityHit.getEntity();
                    BlockPos impactPos = hitEntity.blockPosition();
                    boolean playEffects = false;
                    if (hitEntity instanceof ArmorStand) {
                        playEffects = true;
                    } else if (hitEntity instanceof LivingEntity) {
                        float damageAmount;
                        LivingEntity livingHit = (LivingEntity)hitEntity;
                        DamageSource damageSource = this.damageSources().mobAttack((LivingEntity)this);
                        boolean damaged = livingHit.hurt(damageSource, damageAmount = ((Double)Configs.AHP.hamsterThrowDamage.get()).floatValue());
                        if (damaged) {
                            livingHit.addEffect(new MobEffectInstance(MobEffects.CONFUSION, 20, 0, false, false, false));
                            playEffects = true;
                        }
                    } else {
                        playEffects = true;
                    }
                    if (playEffects) {
                        world2.playSound(null, this.getX(), this.getY(), this.getZ(), ModSounds.HAMSTER_IMPACT, SoundSource.NEUTRAL, 1.0f, 1.0f);
                        if (!world2.isClientSide()) {
                            ((ServerLevel)world2).sendParticles((ParticleOptions)ParticleTypes.POOF, this.getX(), this.getY() + (double)this.getBbHeight() / 2.0, this.getZ(), 50, 0.4, 0.4, 0.4, 0.1);
                        }
                    }
                    Optional<BlockPos> safePosOpt = this.findSafeSpawnPosition(impactPos, world2, 2);
                    safePosOpt.ifPresentOrElse(safePos -> this.setPos((double)safePos.getX() + 0.5, safePos.getY(), (double)safePos.getZ() + 0.5), () -> {
                        AdorableHamsterPets.LOGGER.warn("[HamsterThrow] Could not find safe landing spot after hitting entity. Using entity's position {} as fallback.", (Object)impactPos);
                        this.setPos((double)impactPos.getX() + 0.5, impactPos.getY(), (double)impactPos.getZ() + 0.5);
                    });
                    this.setDeltaMovement(currentVel.multiply(0.1, 0.1, 0.1));
                    this.setThrown(false);
                    this.setKnockedOut(true);
                    this.setInSittingPose(true);
                    if (!world2.isClientSide()) {
                        this.triggerAnimOnServer("mainController", "crash");
                    }
                    stopped = true;
                }
            }
            if (this.isThrown() && !stopped) {
                if (!this.isNoGravity()) {
                    this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.05, 0.0));
                }
                Vec3 currentVelocity = this.getDeltaMovement();
                if (Double.isNaN(currentVelocity.x) || Double.isNaN(currentVelocity.y) || Double.isNaN(currentVelocity.z)) {
                    this.setDeltaMovement(Vec3.ZERO);
                    this.setThrown(false);
                    AdorableHamsterPets.LOGGER.warn("Hamster velocity became NaN, resetting and stopping throw.");
                } else {
                    int particleDelay;
                    this.setPos(this.getX() + currentVelocity.x, this.getY() + currentVelocity.y, this.getZ() + currentVelocity.z);
                    this.hasImpulse = true;
                    int n = particleDelay = this.hasGreenBeanBuff() ? 3 : 5;
                    if (!world2.isClientSide() && this.throwTicks > particleDelay) {
                        double offsetMultiplier = 1.5;
                        double spawnX = this.xo - currentVelocity.x * offsetMultiplier;
                        double spawnY = this.yo + (double)this.getBbHeight() / 2.0 - currentVelocity.y * offsetMultiplier;
                        double spawnZ = this.zo - currentVelocity.z * offsetMultiplier;
                        ((ServerLevel)world2).sendParticles((ParticleOptions)ParticleTypes.GUST, spawnX, spawnY, spawnZ, 1, 0.1, 0.1, 0.1, 0.0);
                    }
                }
            } else if (this.throwTicks != 0) {
                this.throwTicks = 0;
            }
        }
        if (!this.level().isClientSide() && this.isTame() && !this.isKnockedOut()) {
            boolean canInitiateDrowsiness = this.checkConditionsForInitiatingDrowsiness();
            boolean canSustainSlumber = this.checkConditionsForSustainingSlumber();
            switch (currentPhase.ordinal()) {
                case 0: {
                    int durationTicks;
                    if (!this.isOrderedToSit() || !canInitiateDrowsiness || this.quiescentSitDurationTimer != 0) break;
                    this.setDozingPhase(DozingPhase.QUIESCENT_SITTING);
                    int minSeconds = (Integer)Configs.AHP.tamedQuiescentSitMinSeconds.get();
                    int maxSeconds = (Integer)Configs.AHP.tamedQuiescentSitMaxSeconds.get();
                    if (minSeconds > maxSeconds) {
                        AdorableHamsterPets.LOGGER.info("Config issue: tamedQuiescentSitMinSeconds ({}) > tamedQuiescentSitMaxSeconds ({}). Swapping.", (Object)minSeconds, (Object)maxSeconds);
                        int temp = minSeconds;
                        minSeconds = maxSeconds;
                        maxSeconds = temp;
                    }
                    if (maxSeconds < minSeconds) {
                        maxSeconds = minSeconds;
                    }
                    this.quiescentSitDurationTimer = durationTicks = this.random.nextIntBetweenInclusive(minSeconds * 20, maxSeconds * 20 + 1);
                    AdorableHamsterPets.LOGGER.debug("Hamster {} entering QUIESCENT_SITTING for {} ticks.", (Object)this.getId(), (Object)durationTicks);
                    break;
                }
                case 1: {
                    if (!this.isOrderedToSit() || !canInitiateDrowsiness) {
                        this.resetSleepSequence("Quiescent sitting interrupted: no longer sitting or conditions unfavorable.");
                        break;
                    }
                    if (this.quiescentSitDurationTimer > 0) {
                        --this.quiescentSitDurationTimer;
                        break;
                    }
                    this.setDozingPhase(DozingPhase.DRIFTING_OFF);
                    this.driftingOffTimer = 1800;
                    AdorableHamsterPets.LOGGER.debug("Hamster {} entering DRIFTING_OFF for {} ticks.", (Object)this.getId(), (Object)this.driftingOffTimer);
                    break;
                }
                case 2: {
                    String settleAnimId;
                    if (!canSustainSlumber) {
                        this.resetSleepSequence("Drifting off interrupted: conditions for slumber no longer met.");
                        break;
                    }
                    if (this.driftingOffTimer > 0) {
                        --this.driftingOffTimer;
                        break;
                    }
                    this.setDozingPhase(DozingPhase.SETTLING_INTO_SLUMBER);
                    int choice = this.random.nextInt(3);
                    String deepSleepAnimIdForTracker = switch (choice) {
                        case 0 -> {
                            settleAnimId = "anim_hamster_sit_settle_sleep1";
                            yield "anim_hamster_sleep_pose1";
                        }
                        case 1 -> {
                            settleAnimId = "anim_hamster_sit_settle_sleep2";
                            yield "anim_hamster_sleep_pose2";
                        }
                        default -> {
                            settleAnimId = "anim_hamster_sit_settle_sleep3";
                            yield "anim_hamster_sleep_pose3";
                        }
                    };
                    this.entityData.set(CURRENT_DEEP_SLEEP_ANIM_ID, (Object)deepSleepAnimIdForTracker);
                    this.triggerAnimOnServer("mainController", settleAnimId);
                    this.settleSleepAnimationCooldown = 20;
                    AdorableHamsterPets.LOGGER.debug("Hamster {} entering SETTLING_INTO_SLUMBER, triggering {}, target deep sleep anim ID: {}.", new Object[]{this.getId(), settleAnimId, deepSleepAnimIdForTracker});
                    break;
                }
                case 3: {
                    if (!canSustainSlumber) {
                        this.resetSleepSequence("Settling into slumber interrupted: conditions for slumber no longer met.");
                        break;
                    }
                    if (this.settleSleepAnimationCooldown > 0) {
                        --this.settleSleepAnimationCooldown;
                        break;
                    }
                    this.setDozingPhase(DozingPhase.DEEP_SLEEP);
                    AdorableHamsterPets.LOGGER.debug("Hamster {} entering DEEP_SLEEP, playing {}.", (Object)this.getId(), this.entityData.get(CURRENT_DEEP_SLEEP_ANIM_ID));
                    break;
                }
                case 4: {
                    if (canSustainSlumber) break;
                    this.resetSleepSequence("Deep sleep interrupted: conditions for slumber no longer met.");
                }
            }
        }
        super.tick();
        if (!this.level().isClientSide() && this.isSulking() && !this.onGround() && this.getDeltaMovement().y < 0.0) {
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, -1.0, 0.0));
            this.hasImpulse = true;
        }
        if (!(world = this.level()).isClientSide()) {
            BlockPos particlePos;
            if (this.suffocationGracePeriod > 0 && this.isInWall()) {
                for (int i = 1; i <= 5; ++i) {
                    BlockPos checkPos = this.blockPosition().above(i);
                    if (!this.isSafeSpawnLocation(checkPos, world)) continue;
                    this.randomTeleport((double)checkPos.getX() + 0.5, checkPos.getY(), (double)checkPos.getZ() + 0.5, false);
                    AdorableHamsterPets.LOGGER.debug("[HamsterSelfRescue] Hamster {} teleported from {} to safe location {}.", new Object[]{this.getId(), this.blockPosition().below(i), checkPos});
                    this.suffocationGracePeriod = 0;
                    break;
                }
            }
            if (this.ejectionCheckCooldown <= 0) {
                this.ejectionCheckCooldown = 100;
                boolean ejectedItem = false;
                for (int i = 0; i < this.items.size(); ++i) {
                    ItemStack stack = (ItemStack)this.items.get(i);
                    if (stack.isEmpty() || !this.isItemDisallowed(stack)) continue;
                    AdorableHamsterPets.LOGGER.warn("[HamsterTick {}] Ejecting disallowed item {} from slot {}.", new Object[]{this.getId(), stack.getItem(), i});
                    Containers.dropItemStack((Level)world, (double)this.getX(), (double)this.getY(), (double)this.getZ(), (ItemStack)stack.copy());
                    this.items.set(i, (Object)ItemStack.EMPTY);
                    this.setChanged();
                    ejectedItem = true;
                    break;
                }
            }
            if (this.isTame() && this.getHealth() < this.getMaxHealth() && !this.isAutoEating() && !this.isConsideringAutoEat() && this.autoEatCooldownTicks == 0 && !this.isThrown() && !this.isKnockedOut()) {
                for (int i = 0; i < this.items.size(); ++i) {
                    ItemStack stack = (ItemStack)this.items.get(i);
                    if (stack.isEmpty() || !ModItemTags.isAutoHealFood(stack)) continue;
                    this.setHamsterFlag(1024, true);
                    this.preAutoEatDelayTicks = 40;
                    AdorableHamsterPets.LOGGER.trace("[HamsterTick {}] Eligible to auto-eat. Starting 2s pre-eat delay.", (Object)this.getId());
                    break;
                }
            }
            if (this.isConsideringAutoEat() && this.preAutoEatDelayTicks == 0) {
                this.setHamsterFlag(1024, false);
                boolean foodStillAvailable = false;
                ItemStack foodToEat = ItemStack.EMPTY;
                int foodSlot = -1;
                for (int i = 0; i < this.items.size(); ++i) {
                    ItemStack stack = (ItemStack)this.items.get(i);
                    if (stack.isEmpty() || !ModItemTags.isAutoHealFood(stack)) continue;
                    foodStillAvailable = true;
                    foodToEat = stack;
                    foodSlot = i;
                    break;
                }
                if (foodStillAvailable) {
                    AdorableHamsterPets.LOGGER.trace("[HamsterTick {}] Pre-eat delay finished. Starting auto-eat on {} from slot {}", new Object[]{this.getId(), foodToEat.getItem(), foodSlot});
                    this.isAutoEating = true;
                    this.autoEatProgressTicks = 60;
                    this.playSound(SoundEvents.GENERIC_EAT, 0.7f, 1.3f);
                    if (world instanceof ServerLevel) {
                        ServerLevel serverWorld = (ServerLevel)world;
                        serverWorld.sendParticles((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, foodToEat.split(1)), this.getX() + this.random.nextGaussian() * 0.1, this.getY() + (double)this.getBbHeight() / 2.0 + this.random.nextGaussian() * 0.1, this.getZ() + this.random.nextGaussian() * 0.1, 5, 0.1, 0.1, 0.1, 0.02);
                    }
                    if (foodToEat.isEmpty()) {
                        this.items.set(foodSlot, (Object)ItemStack.EMPTY);
                    }
                    this.updateCheekTrackers();
                } else {
                    AdorableHamsterPets.LOGGER.trace("[HamsterTick {}] Pre-eat delay finished, but food no longer available.", (Object)this.getId());
                }
            }
            if (this.isAutoEating() && this.autoEatProgressTicks == 0) {
                this.heal(((Float)Configs.AHP.hamsterFoodMixHealing.get()).floatValue());
                this.autoEatCooldownTicks = 60;
                this.isAutoEating = false;
                AdorableHamsterPets.LOGGER.trace("[HamsterTick {}] Auto-eat finished. Healed. Cooldown set to 60.", (Object)this.getId());
                LivingEntity livingEntity = this.getOwner();
                if (livingEntity instanceof ServerPlayer) {
                    ServerPlayer serverPlayerOwner = (ServerPlayer)livingEntity;
                    ((HamsterAutoFedCriterion)((Object)ModCriteria.HAMSTER_AUTO_FED.get())).trigger(serverPlayerOwner, this);
                }
            }
            if (!this.level().isClientSide() && this.isCelebratingDiamond()) {
                SoundEvent sparkleSound;
                if (this.diamondSparkleSoundDelayTicks == 1 && (sparkleSound = ModSounds.getRandomSoundFrom(ModSounds.DIAMOND_SPARKLE_SOUNDS, this.random)) != null) {
                    if (this.currentOreTarget != null) {
                        this.level().playSound(null, this.currentOreTarget, sparkleSound, SoundSource.NEUTRAL, 1.0f, 1.0f);
                    } else {
                        this.level().playSound(null, this.blockPosition(), sparkleSound, SoundSource.NEUTRAL, 1.0f, 1.0f);
                    }
                }
                if (this.celebrationParticleTicks > 0) {
                    ((ServerLevel)this.level()).sendParticles((ParticleOptions)ParticleTypes.TRIAL_SPAWNER_DETECTED_PLAYER_OMINOUS, this.getX(), this.getY() + 1.5, this.getZ(), 4, 0.08, 0.15, 0.08, 0.01);
                    if (this.currentOreTarget != null && this.random.nextInt(4) == 0) {
                        particlePos = this.currentOreTarget.above();
                        ((ServerLevel)this.level()).sendParticles((ParticleOptions)ParticleTypes.FIREWORK, (double)particlePos.getX() + 0.5, (double)particlePos.getY() + 0.5, (double)particlePos.getZ() + 0.5, 1, 0.2, 0.35, 0.2, 0.003);
                    }
                }
                if (this.diamondCelebrationSoundTicks <= 0) {
                    SoundEvent celebrationSound = ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_BEG_SOUNDS, this.random);
                    if (celebrationSound != null) {
                        this.level().playSound(null, this.blockPosition(), celebrationSound, SoundSource.NEUTRAL, 0.8f, this.getVoicePitch());
                    }
                    this.diamondCelebrationSoundTicks = 30;
                }
            }
            if (this.isSulking()) {
                if (this.sulkOrchestraHitDelayTicks == 1) {
                    this.level().playSound(null, this.blockPosition(), (SoundEvent)ModSounds.ALARM_ORCHESTRA_HIT.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
                }
                if (this.sulkShockedSoundDelayTicks == 1) {
                    this.level().playSound(null, this.blockPosition(), (SoundEvent)ModSounds.HAMSTER_SHOCKED.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
                }
                if (this.sulkFailParticleTicks > 0 && this.currentOreTarget != null && this.random.nextInt(3) == 0) {
                    particlePos = this.currentOreTarget.above();
                    ((ServerLevel)this.level()).sendParticles((ParticleOptions)ParticleTypes.SMOKE, (double)particlePos.getX() + 0.5, (double)particlePos.getY() + 0.5, (double)particlePos.getZ() + 0.5, 2, 0.3, 0.3, 0.3, 0.005);
                }
                if (this.sulkEntityEffectTicks > 0 && this.random.nextInt(5) == 0) {
                    ColorParticleOption darkGrayEffect = ColorParticleOption.create((ParticleType)ParticleTypes.ENTITY_EFFECT, (float)0.3f, (float)0.3f, (float)0.3f);
                    ((ServerLevel)this.level()).sendParticles((ParticleOptions)darkGrayEffect, this.getRandomX(0.3), this.getRandomY(), this.getRandomZ(0.3), 1, 0.01, 0.05, 0.01, 0.005);
                }
            }
        }
        if (world.isClientSide && this.hasGreenBeanBuff() && this.getDeltaMovement().horizontalDistanceSqr() > 1.0E-6) {
            double backwardsSpeed = 1.7;
            double scatterStrength = 0.025;
            double downwardVelocity = 0.17;
            double positionOffsetMultiplier = 1.4;
            if (this.random.nextInt(2) == 0) {
                for (int i = 0; i < 3; ++i) {
                    Vec3 currentVelocity = this.getDeltaMovement();
                    double baseX = this.xo - currentVelocity.x * 1.4;
                    double baseY = this.yo + (double)this.getBbHeight() / 2.0 - currentVelocity.y * 1.4;
                    double baseZ = this.zo - currentVelocity.z * 1.4;
                    double spawnX = baseX + (this.random.nextDouble() - 0.5) * ((double)this.getBbWidth() * 0.8);
                    double spawnY = baseY + (this.random.nextDouble() - 0.5) * ((double)this.getBbHeight() * 0.05);
                    double spawnZ = baseZ + (this.random.nextDouble() - 0.5) * ((double)this.getBbWidth() * 0.8);
                    Vec3 hamsterMovementVec = this.getDeltaMovement();
                    Vec3 backwardsBaseVel = hamsterMovementVec.scale(-1.7);
                    double finalVelX = backwardsBaseVel.x + this.random.nextGaussian() * 0.025;
                    double finalVelY = backwardsBaseVel.y + this.random.nextGaussian() * 0.025 - 0.17;
                    double finalVelZ = backwardsBaseVel.z + this.random.nextGaussian() * 0.025;
                    world.addParticle((ParticleOptions)ParticleTypes.WHITE_SMOKE, spawnX, spawnY, spawnZ, finalVelX, finalVelY, finalVelZ);
                }
            }
        }
        if (this.isTaunting() && this.random.nextInt(7) == 0) {
            for (int i = 0; i < 2; ++i) {
                world.addParticle((ParticleOptions)ParticleTypes.INSTANT_EFFECT, this.getRandomX(0.6), this.getRandomY(), this.getRandomZ(0.6), (this.random.nextDouble() - 0.5) * 0.5, (this.random.nextDouble() - 0.5) * 0.5, (this.random.nextDouble() - 0.5) * 0.5);
            }
        }
        if (this.isRefusingFood() && this.refuseTimer > 0 && --this.refuseTimer <= 0) {
            this.setRefusingFood(false);
        }
        if (this.tamingCooldown > 0) {
            --this.tamingCooldown;
        }
        if (this.customLoveTimer > 0) {
            --this.customLoveTimer;
        }
        if (this.customLoveTimer <= 0 && this.isInLove()) {
            this.setInLove(false);
        }
    }

    public boolean isEffectiveAi() {
        return super.isEffectiveAi() && !this.isThrown();
    }

    public boolean isPushable() {
        return super.isPushable() && !this.isThrown();
    }

    public void die(DamageSource source) {
        Level world = this.level();
        if (!world.isClientSide()) {
            for (ItemStack stack : this.items) {
                if (stack.isEmpty()) continue;
                Containers.dropItemStack((Level)world, (double)this.getX(), (double)this.getY(), (double)this.getZ(), (ItemStack)stack);
            }
            this.items.clear();
            this.updateCheekTrackers();
        }
        super.die(source);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "mainController", 2, event -> {
            DozingPhase currentDozingPhase = this.getDozingPhase();
            int personality = (Integer)this.entityData.get(ANIMATION_PERSONALITY_ID);
            if (this.isShoulderPet()) {
                ShoulderAnimationState shoulderState = ShoulderAnimationState.values()[(Integer)this.entityData.get(SHOULDER_ANIMATION_STATE)];
                return switch (shoulderState) {
                    case ShoulderAnimationState.SITTING -> {
                        if (this.getHamsterFlag(8192)) {
                            yield event.setAndContinue(CLEANING_ANIM);
                        }
                        RawAnimation v1 = switch (personality) {
                            case 2 -> SITTING_POSE2_ANIM;
                            case 3 -> SITTING_POSE3_ANIM;
                            default -> SITTING_POSE1_ANIM;
                        };
                        yield event.setAndContinue(v1);
                    }
                    case ShoulderAnimationState.LAYING_DOWN -> {
                        switch (this.shoulderLocation) {
                            case LEFT_SHOULDER: {
                                yield event.setAndContinue(LAYING_DOWN_LEFT_SHOULDER_ANIM);
                            }
                            case HEAD: {
                                yield event.setAndContinue(LAYING_DOWN_HEAD_ANIM);
                            }
                        }
                        yield event.setAndContinue(LAYING_DOWN_RIGHT_SHOULDER_ANIM);
                    }
                    default -> {
                        RawAnimation current = event.getController().getCurrentRawAnimation();
                        if (current != null && (current.equals((Object)IDLE1_ANIM) || current.equals((Object)IDLE2_ANIM))) {
                            yield event.setAndContinue(current);
                        }
                        yield event.setAndContinue(this.random.nextBoolean() ? IDLE1_ANIM : IDLE2_ANIM);
                    }
                };
            }
            if (this.isKnockedOut()) {
                return event.setAndContinue(KNOCKED_OUT_ANIM);
            }
            if (this.isSulking()) {
                return event.setAndContinue(SULKING_ANIM);
            }
            if (this.isThrown()) {
                return event.setAndContinue(FLYING_ANIM);
            }
            if (this.isTaunting()) {
                return event.setAndContinue(DIAMOND_TAUNT_ANIM);
            }
            boolean isSeekingGoalActive = false;
            String activeGoalName = this.getActiveCustomGoalDebugName();
            if (activeGoalName.startsWith(HamsterSeekDiamondGoal.class.getSimpleName())) {
                isSeekingGoalActive = true;
            }
            if (isSeekingGoalActive) {
                double horizontalSpeedSquared = this.getDeltaMovement().horizontalDistanceSqr();
                if (horizontalSpeedSquared > 1.0E-6) {
                    return event.setAndContinue(SEEKING_DIAMOND_ANIM);
                }
                return event.setAndContinue(WANTS_TO_SEEK_DIAMOND_ANIM);
            }
            if (this.isCelebratingDiamond()) {
                return event.setAndContinue(BEGGING_ANIM);
            }
            if (this.isTame()) {
                switch (currentDozingPhase.ordinal()) {
                    case 2: {
                        return event.setAndContinue(switch (personality) {
                            case 2 -> DRIFTING_OFF_POSE2_ANIM;
                            case 3 -> DRIFTING_OFF_POSE3_ANIM;
                            default -> DRIFTING_OFF_POSE1_ANIM;
                        });
                    }
                    case 3: {
                        String targetDeepSleepId = (String)this.entityData.get(CURRENT_DEEP_SLEEP_ANIM_ID);
                        if (!targetDeepSleepId.isEmpty()) {
                            RawAnimation targetDeepSleepAnim = switch (targetDeepSleepId) {
                                case "anim_hamster_sleep_pose1" -> SLEEP_POSE1_ANIM;
                                case "anim_hamster_sleep_pose2" -> SLEEP_POSE2_ANIM;
                                case "anim_hamster_sleep_pose3" -> SLEEP_POSE3_ANIM;
                                default -> SITTING_POSE1_ANIM;
                            };
                            return event.setAndContinue(targetDeepSleepAnim);
                        }
                        if (!this.isOrderedToSit()) break;
                        return event.setAndContinue(switch (personality) {
                            case 2 -> SITTING_POSE2_ANIM;
                            case 3 -> SITTING_POSE3_ANIM;
                            default -> SITTING_POSE1_ANIM;
                        });
                    }
                    case 4: {
                        String deepSleepId;
                        RawAnimation deepSleepAnimToPlay = switch (deepSleepId = (String)this.entityData.get(CURRENT_DEEP_SLEEP_ANIM_ID)) {
                            case "anim_hamster_sleep_pose1" -> SLEEP_POSE1_ANIM;
                            case "anim_hamster_sleep_pose2" -> SLEEP_POSE2_ANIM;
                            case "anim_hamster_sleep_pose3" -> SLEEP_POSE3_ANIM;
                            default -> {
                                switch (personality) {
                                    case 2: {
                                        yield SITTING_POSE2_ANIM;
                                    }
                                    case 3: {
                                        yield SITTING_POSE3_ANIM;
                                    }
                                }
                                yield SITTING_POSE1_ANIM;
                            }
                        };
                        return event.setAndContinue(deepSleepAnimToPlay);
                    }
                }
            }
            if (!this.isTame() && this.isSleeping()) {
                String deepSleepId;
                RawAnimation deepSleepAnimToPlay = switch (deepSleepId = (String)this.entityData.get(CURRENT_DEEP_SLEEP_ANIM_ID)) {
                    case "anim_hamster_sleep_pose2" -> SLEEP_POSE2_ANIM;
                    case "anim_hamster_sleep_pose3" -> SLEEP_POSE3_ANIM;
                    default -> SLEEP_POSE1_ANIM;
                };
                return event.setAndContinue(deepSleepAnimToPlay);
            }
            if (this.isOrderedToSit() && !this.isKnockedOut()) {
                if (this.getHamsterFlag(8192)) {
                    return event.setAndContinue(CLEANING_ANIM);
                }
                return event.setAndContinue(switch (personality) {
                    case 2 -> SITTING_POSE2_ANIM;
                    case 3 -> SITTING_POSE3_ANIM;
                    default -> SITTING_POSE1_ANIM;
                });
            }
            double horizontalSpeedSquared = this.getDeltaMovement().horizontalDistanceSqr();
            if (horizontalSpeedSquared > 1.0E-6) {
                if (horizontalSpeedSquared > 0.008) {
                    return event.setAndContinue(SPRINTING_ANIM);
                }
                if (horizontalSpeedSquared > 0.002) {
                    return event.setAndContinue(RUNNING_ANIM);
                }
                return event.setAndContinue(WALKING_ANIM);
            }
            if (this.isBegging()) {
                return event.setAndContinue(BEGGING_ANIM);
            }
            if (activeGoalName.equals(HamsterLookAtEntityGoal.class.getSimpleName())) {
                return switch ((Integer)this.entityData.get(CURRENT_LOOK_UP_ANIM_ID)) {
                    case 2 -> event.setAndContinue(IDLE_LOOKING_UP2_ANIM);
                    case 3 -> event.setAndContinue(IDLE_LOOKING_UP3_ANIM);
                    default -> event.setAndContinue(IDLE_LOOKING_UP1_ANIM);
                };
            }
            RawAnimation current = event.getController().getCurrentRawAnimation();
            if (current != null && (current.equals((Object)IDLE1_ANIM) || current.equals((Object)IDLE2_ANIM))) {
                return event.setAndContinue(current);
            }
            return event.setAndContinue(this.random.nextBoolean() ? IDLE1_ANIM : IDLE2_ANIM);
        }).triggerableAnim("crash", CRASH_ANIM).triggerableAnim("wakeup", WAKE_UP_ANIM).triggerableAnim("stationary_headshake", STATIONARY_HEADSHAKE_ANIM).triggerableAnim("moving_headshake", MOVING_HEADSHAKE_ANIM).triggerableAnim("attack", ATTACK_ANIM).triggerableAnim("anim_hamster_sit_settle_sleep1", SIT_SETTLE_SLEEP1_ANIM).triggerableAnim("anim_hamster_sit_settle_sleep2", SIT_SETTLE_SLEEP2_ANIM).triggerableAnim("anim_hamster_sit_settle_sleep3", SIT_SETTLE_SLEEP3_ANIM).triggerableAnim("anim_hamster_stand_settle_sleep1", STAND_SETTLE_SLEEP1_ANIM).triggerableAnim("anim_hamster_stand_settle_sleep2", STAND_SETTLE_SLEEP2_ANIM).triggerableAnim("anim_hamster_stand_settle_sleep3", STAND_SETTLE_SLEEP3_ANIM).triggerableAnim("anim_hamster_sulk", SULK_ANIM).triggerableAnim("anim_hamster_diamond_pounce", DIAMOND_POUNCE_ANIM).triggerableAnim("anim_hamster_celebrate_chase", CELEBRATE_CHASE_ANIM).setParticleKeyframeHandler(event -> {
            this.particleEffectId = event.getKeyframeData().getEffect();
        }).setSoundKeyframeHandler(event -> {
            this.soundEffectId = event.getKeyframeData().getSound();
        }));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void triggerAnimOnServer(String controllerName, String animName) {
        if (!this.level().isClientSide()) {
            ServerLevel serverWorld = (ServerLevel)this.level();
            this.triggerAnim(controllerName, animName);
            AdorableHamsterPets.LOGGER.trace("[HamsterEntity {}] Triggered server-side animation: Controller='{}', Anim='{}'", new Object[]{this.getId(), controllerName, animName});
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(HAMSTER_FLAGS, (Object)0);
        builder.define(VARIANT, (Object)0);
        builder.define(PINK_PETAL_TYPE, (Object)0);
        builder.define(DOZING_PHASE, (Object)DozingPhase.NONE.ordinal());
        builder.define(CURRENT_DEEP_SLEEP_ANIM_ID, (Object)"");
        builder.define(ACTIVE_CUSTOM_GOAL_NAME_DEBUG, (Object)"None");
        builder.define(ANIMATION_PERSONALITY_ID, (Object)1);
        builder.define(STEAL_DURATION_TIMER, (Object)0);
        builder.define(STOLEN_ITEM_STACK, (Object)ItemStack.EMPTY);
        builder.define(GREEN_BEAN_BUFF_DURATION, (Object)0L);
        builder.define(CURRENT_LOOK_UP_ANIM_ID, (Object)1);
        builder.define(SHOULDER_ANIMATION_STATE, (Object)ShoulderAnimationState.STANDING.ordinal());
    }

    protected void registerGoals() {
        AdorableHamsterPets.LOGGER.debug("[AI Init {} Tick {}] Initializing goals. Current State: isSleeping={}, isSittingPose={}", new Object[]{this.getId(), this.level().isClientSide ? "ClientTick?" : Long.valueOf(this.level().getGameTime()), this.isSleeping(), this.isInSittingPose()});
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new HamsterSeekDiamondGoal(this));
        this.goalSelector.addGoal(1, (Goal)new HamsterStealDiamondGoal(this));
        this.goalSelector.addGoal(2, (Goal)new HamsterMeleeAttackGoal(this, 1.5, true));
        this.goalSelector.addGoal(3, (Goal)new HamsterMateGoal(this, 0.75));
        this.goalSelector.addGoal(4, (Goal)new HamsterFollowOwnerGoal(this, 1.0, 4.0f, 16.0f));
        this.goalSelector.addGoal(5, new HamsterFleeGoal<LivingEntity>(this, LivingEntity.class, 8.0f, 0.75, 1.5));
        this.goalSelector.addGoal(6, (Goal)new HamsterTemptGoal(this, 1.0, false));
        this.goalSelector.addGoal(7, (Goal)new HamsterSitGoal(this));
        this.goalSelector.addGoal(8, (Goal)new HamsterSleepGoal(this));
        this.goalSelector.addGoal(9, (Goal)new HamsterWanderAroundFarGoal(this, 0.75));
        this.goalSelector.addGoal(10, (Goal)new HamsterLookAtEntityGoal((Mob)this, Player.class, 2.0f, 0.15f));
        this.goalSelector.addGoal(11, (Goal)new HamsterLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(2, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[0]));
        AdorableHamsterPets.LOGGER.debug("[AI Init {} Tick {}] Finished initializing goals.", (Object)this.getId(), this.level().isClientSide ? "ClientTick?" : Long.valueOf(this.level().getGameTime()));
    }

    public void setTarget(@Nullable LivingEntity target) {
        if (target == null) {
            super.setTarget(null);
            return;
        }
        if (this.isTame() && this.getOwner() != null) {
            TraceableEntity ownableFallback;
            Entity fallbackOwnerEntity;
            LivingEntity owner = this.getOwner();
            UUID ownerUuid = owner.getUUID();
            boolean preventTargeting = false;
            if (target instanceof TamableAnimal) {
                TamableAnimal tameablePet = (TamableAnimal)target;
                UUID petOwnerUuid = tameablePet.getOwnerUUID();
                if (petOwnerUuid != null && petOwnerUuid.equals(ownerUuid) && tameablePet != this) {
                    preventTargeting = true;
                }
            } else if (target instanceof AbstractHorse) {
                AbstractHorse horsePet = (AbstractHorse)target;
                LivingEntity horseOwnerEntity = horsePet.getOwner();
                if (horseOwnerEntity != null && horseOwnerEntity.getUUID().equals(ownerUuid)) {
                    preventTargeting = true;
                }
            } else if (target instanceof TraceableEntity && (fallbackOwnerEntity = (ownableFallback = (TraceableEntity)target).getOwner()) != null && fallbackOwnerEntity.getUUID().equals(ownerUuid) && ownableFallback != this) {
                preventTargeting = true;
            }
            if (preventTargeting) {
                super.setTarget(null);
                return;
            }
        }
        super.setTarget(target);
    }

    protected SoundEvent getAmbientSound() {
        if (this.isKnockedOut()) {
            return null;
        }
        if (this.isBegging() || this.isTaunting()) {
            return ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_BEG_SOUNDS, this.random);
        }
        boolean playSleepSounds = false;
        if (this.isTame()) {
            DozingPhase phase = this.getDozingPhase();
            if (phase == DozingPhase.DRIFTING_OFF || phase == DozingPhase.SETTLING_INTO_SLUMBER || phase == DozingPhase.DEEP_SLEEP) {
                playSleepSounds = true;
            }
        } else if (this.isSleeping()) {
            playSleepSounds = true;
        }
        if (playSleepSounds) {
            return ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_SLEEP_SOUNDS, this.random);
        }
        return ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_IDLE_SOUNDS, this.random);
    }

    public void playAmbientSound() {
        SoundEvent soundEvent = this.getAmbientSound();
        if (soundEvent != null && Arrays.asList(ModSounds.HAMSTER_BEG_SOUNDS).contains(soundEvent)) {
            this.playSound(soundEvent, 0.8f, this.getVoicePitch());
        } else {
            super.playAmbientSound();
        }
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_HURT_SOUNDS, this.random);
    }

    protected SoundEvent getDeathSound() {
        return ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_DEATH_SOUNDS, this.random);
    }

    protected void playStepSound(BlockPos pos, BlockState state) {
        if (this.level().isClientSide()) {
            return;
        }
        if (!HamsterRenderTracker.isBeingRendered(this.getId())) {
            try {
                SoundType group = state.getSoundType();
                float volume = state.is(Blocks.GRAVEL) ? 0.060000002f : 0.1f;
                this.playSound(group.getStepSound(), volume, group.getPitch() * 1.5f);
            }
            catch (Exception ex) {
                AdorableHamsterPets.LOGGER.warn("Error playing fallback step sound", (Throwable)ex);
            }
        }
    }

    protected boolean canHitEntity(Entity entity) {
        if (entity instanceof ArmorStand) {
            return !entity.isSpectator();
        }
        if (!entity.isSpectator() && entity.isAlive() && entity.isPickable()) {
            LivingEntity owner = this.getOwner();
            return entity != this && (owner == null || !owner.isPassengerOfSameVehicle(entity));
        }
        return false;
    }

    protected void applyGravity() {
        if (this.isThrown() && this.isNoGravity()) {
            return;
        }
        super.applyGravity();
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType spawnReason, @Nullable SpawnGroupData entityData) {
        AdorableHamsterPets.LOGGER.debug("[AHP Spawn Debug] HamsterEntity.initialize called. SpawnReason: {}", (Object)spawnReason);
        this.entityData.set(ANIMATION_PERSONALITY_ID, (Object)this.random.nextIntBetweenInclusive(1, 3));
        if (spawnReason == MobSpawnType.NATURAL || spawnReason == MobSpawnType.SPAWN_EGG || spawnReason == MobSpawnType.CHUNK_GENERATION) {
            Holder biomeEntry = world.getBiome(this.blockPosition());
            String biomeKeyStr = biomeEntry.unwrapKey().map(key -> key.location().toString()).orElse("UNKNOWN");
            AdorableHamsterPets.LOGGER.debug("[HamsterInit] SpawnReason: {}, BiomeKey: {}", (Object)spawnReason, (Object)biomeKeyStr);
            HamsterVariant chosenVariant = HamsterEntity.determineVariantForBiome((Holder<Biome>)biomeEntry, this.random);
            this.setVariant(chosenVariant.getId());
            AdorableHamsterPets.LOGGER.debug("[HamsterInit] Assigned variant: {}", (Object)chosenVariant.name());
        } else {
            int randomVariantId = this.random.nextInt(HamsterVariant.values().length);
            this.setVariant(randomVariantId);
            AdorableHamsterPets.LOGGER.debug("[HamsterInit] SpawnReason: {}, Assigned random variant: {}", (Object)spawnReason, (Object)HamsterVariant.byId(randomVariantId).name());
        }
        if (!this.isTame()) {
            this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(((Double)Configs.AHP.wildMaxHealth.get()).doubleValue());
            this.setHealth(this.getMaxHealth());
        }
        this.updateCheekTrackers();
        return super.finalizeSpawn(world, difficulty, spawnReason, entityData);
    }

    protected BodyRotationControl createBodyControl() {
        return new HamsterBodyControl((Mob)this);
    }

    private boolean getHamsterFlag(int flag) {
        return ((Integer)this.entityData.get(HAMSTER_FLAGS) & flag) != 0;
    }

    private void setHamsterFlag(int flag, boolean value) {
        int currentFlags = (Integer)this.entityData.get(HAMSTER_FLAGS);
        if (value) {
            this.entityData.set(HAMSTER_FLAGS, (Object)(currentFlags | flag));
        } else {
            this.entityData.set(HAMSTER_FLAGS, (Object)(currentFlags & ~flag));
        }
    }

    private boolean isSafeSpawnLocation(BlockPos pos, Level world) {
        BlockPos floorPos = pos.below();
        BlockState floorState = world.getBlockState(floorPos);
        PathType floorType = LandPathNodeMakerInvoker.callGetCommonNodeType((BlockGetter)world, floorPos);
        if (HAZARDOUS_FLOOR_TYPES.contains(floorType)) {
            return false;
        }
        if (floorState.getCollisionShape((BlockGetter)world, floorPos).isEmpty()) {
            return false;
        }
        CollisionContext entityContext = CollisionContext.of((Entity)this);
        return world.getBlockState(pos).getCollisionShape((BlockGetter)world, pos, entityContext).isEmpty() && world.getBlockState(pos.above()).getCollisionShape((BlockGetter)world, pos.above(), entityContext).isEmpty();
    }

    public boolean isItemDisallowed(ItemStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        if (ModItemTags.isPouchAllowed(stack)) {
            return false;
        }
        if (ModItemTags.isPouchDisallowed(stack)) {
            return true;
        }
        if (stack.get(DataComponents.FOOD) != null) {
            return false;
        }
        Item item = stack.getItem();
        if (item instanceof BlockItem) {
            return true;
        }
        return item instanceof SpawnEggItem;
    }

    private HolderLookup.Provider getRegistryLookup() {
        return this.level().registryAccess();
    }

    private boolean tryTame(Player player, ItemStack itemStack) {
        if (!player.getAbilities().instabuild) {
            itemStack.shrink(1);
        }
        AhpConfig config = AdorableHamsterPets.CONFIG;
        int denominator = Math.max(1, (Integer)config.tamingChanceDenominator.get());
        if (this.random.nextInt(denominator) == 0) {
            this.setOwnerUUID(player.getUUID());
            this.setTame(true, true);
            this.navigation.stop();
            this.setOrderedToSit(false);
            this.setSleeping(false);
            this.setTarget(null);
            this.level().broadcastEntityEvent((Entity)this, (byte)7);
            SoundEvent celebrateSound = ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_CELEBRATE_SOUNDS, this.random);
            this.level().playSound(null, this.blockPosition(), celebrateSound, SoundSource.NEUTRAL, 0.7f, 1.0f);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                CriteriaTriggers.TAME_ANIMAL.trigger(serverPlayer, (Animal)this);
            }
            return true;
        }
        this.level().broadcastEntityEvent((Entity)this, (byte)6);
        return false;
    }

    private boolean checkRepeatFoodRefusal(ItemStack currentStack, Player player) {
        if (ModItemTags.isRepeatableFood(currentStack)) {
            return false;
        }
        if (!this.lastFoodItem.isEmpty() && ItemStack.isSameItem((ItemStack)this.lastFoodItem, (ItemStack)currentStack)) {
            this.setRefusingFood(true);
            this.refuseTimer = 40;
            player.displayClientMessage((Component)Component.translatable((String)"message.adorablehamsterpets.food_refusal"), true);
            if (!this.level().isClientSide()) {
                boolean isMoving;
                boolean bl = isMoving = this.getDeltaMovement().horizontalDistanceSqr() > 1.0E-6;
                if (isMoving) {
                    this.triggerAnimOnServer("mainController", "moving_headshake");
                } else {
                    this.triggerAnimOnServer("mainController", "stationary_headshake");
                }
            }
            return true;
        }
        return false;
    }

    private boolean tryFeedingAsTamed(Player player, ItemStack stack) {
        boolean isFood = ModItemTags.isStandardFood(stack);
        boolean isBuffItem = ModItemTags.isBuffFood(stack);
        boolean isPouchUnlockFood = ModItemTags.isPouchUnlockFood(stack);
        boolean canHeal = this.getHealth() < this.getMaxHealth();
        boolean readyToBreed = this.getAge() == 0 && !this.isInCustomLove();
        Level world = this.level();
        AhpConfig config = AdorableHamsterPets.CONFIG;
        boolean actionTaken = false;
        AdorableHamsterPets.LOGGER.debug("[FeedAttempt {} Tick {}] Entering tryFeedingAsTamed. Item: {}, isFood={}, isBuff={}, canHeal={}, breedingAge={}, isInCustomLove={}, readyToBreed={}", new Object[]{this.getId(), world.getGameTime(), stack.getItem(), isFood, isBuffItem, canHeal, this.getAge(), this.isInCustomLove(), readyToBreed});
        if (isPouchUnlockFood && !this.getHamsterFlag(512)) {
            this.setHamsterFlag(512, true);
            AdorableHamsterPets.LOGGER.debug("Hamster {} cheek pouch unlocked by {}.", (Object)this.getId(), (Object)stack.getItem());
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                ((CheekPouchUnlockedCriterion)((Object)ModCriteria.CHEEK_POUCH_UNLOCKED.get())).trigger(serverPlayer, this);
            }
            world.playSound(null, this.blockPosition(), SoundEvents.PLAYER_LEVELUP, SoundSource.NEUTRAL, 0.5f, 1.5f);
            if (!world.isClientSide) {
                ((ServerLevel)world).sendParticles((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, stack.copy()), this.getX(), this.getY(0.2), this.getZ(), 25, 0.25, 0.15, 0.25, 0.0);
            }
            return true;
        }
        if (isBuffItem) {
            long currentTime = world.getGameTime();
            if (this.greenBeanBuffEndTick > currentTime) {
                long remainingTicks = this.greenBeanBuffEndTick - currentTime;
                long totalSecondsRemaining = remainingTicks / 20L;
                long minutes = totalSecondsRemaining / 60L;
                long seconds = totalSecondsRemaining % 60L;
                player.displayClientMessage((Component)Component.translatable((String)"message.adorablehamsterpets.beans_cooldown", (Object[])new Object[]{minutes, seconds}).withStyle(ChatFormatting.RED), true);
                AdorableHamsterPets.LOGGER.debug("[FeedAttempt {} Tick {}] Buff item used, but on cooldown ({} ticks remaining). Returning false.", new Object[]{this.getId(), world.getGameTime(), remainingTicks});
                return false;
            }
            int duration = (Integer)config.greenBeanBuffDuration.get();
            int speedAmplifier = (Integer)config.greenBeanBuffAmplifierSpeed.get();
            int strengthAmplifier = (Integer)config.greenBeanBuffAmplifierStrength.get();
            int absorptionAmplifier = (Integer)config.greenBeanBuffAmplifierAbsorption.get();
            int regenAmplifier = (Integer)config.greenBeanBuffAmplifierRegen.get();
            this.zoomiesIsClockwise = this.random.nextBoolean();
            this.lastZoomiesAngle = 0.0;
            this.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, duration, speedAmplifier));
            this.addEffect(new MobEffectInstance(MobEffects.DAMAGE_BOOST, duration, strengthAmplifier));
            this.addEffect(new MobEffectInstance(MobEffects.ABSORPTION, duration, absorptionAmplifier));
            this.addEffect(new MobEffectInstance(MobEffects.REGENERATION, duration, regenAmplifier));
            this.zoomiesIsClockwise = this.random.nextBoolean();
            this.zoomiesRadiusModifier = this.random.nextIntBetweenInclusive(-2, 4);
            double dx = this.getX() - player.getX();
            double dz = this.getZ() - player.getZ();
            this.lastZoomiesAngle = Math.atan2(dz, dx);
            SoundEvent buffSound = ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_CELEBRATE_SOUNDS, this.random);
            world.playSound(null, this.blockPosition(), buffSound, SoundSource.NEUTRAL, 1.0f, 1.0f);
            long buffDurationEnd = currentTime + (long)((Integer)config.greenBeanBuffDuration.get()).intValue();
            this.getEntityData().set(GREEN_BEAN_BUFF_DURATION, (Object)buffDurationEnd);
            this.greenBeanBuffEndTick = currentTime + (long)((Integer)config.steamedGreenBeansBuffCooldown.get()).intValue();
            actionTaken = true;
            AdorableHamsterPets.LOGGER.trace("[FeedAttempt {} Tick {}] Applied buffs. Duration ends at tick {}. Cooldown ends at tick {}.", new Object[]{this.getId(), world.getGameTime(), buffDurationEnd, this.greenBeanBuffEndTick});
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                ((FedHamsterSteamedBeansCriterion)((Object)ModCriteria.FED_HAMSTER_STEAMED_BEANS.get())).trigger(serverPlayer, this);
            }
        } else if (ModItemTags.isStandardFood(stack)) {
            if (canHeal) {
                this.heal(((Float)config.standardFoodHealing.get()).floatValue());
                actionTaken = true;
                AdorableHamsterPets.LOGGER.debug("[FeedAttempt {}] Healed with standard food.", (Object)this.getId());
            } else if (readyToBreed) {
                this.setSitting(false, true);
                this.setCustomInLove(player);
                this.setInLove(true);
                actionTaken = true;
                AdorableHamsterPets.LOGGER.debug("[FeedAttempt {}] Entered love mode with standard food.", (Object)this.getId());
            }
        }
        if (!actionTaken) {
            AdorableHamsterPets.LOGGER.debug("[FeedAttempt {} Tick {}] Item {} was not a valid food for any action.", new Object[]{this.getId(), world.getGameTime(), stack.getItem()});
        }
        return actionTaken;
    }

    @Unique
    private boolean checkConditionsForInitiatingDrowsiness() {
        if (!this.isOrderedToSit()) {
            return false;
        }
        Level world = this.level();
        if (Configs.AHP.requireDaytimeForTamedSleep && !world.isDay()) {
            return false;
        }
        if (this.isInLove()) {
            return false;
        }
        if (!this.onGround()) {
            return false;
        }
        double threatRadius = ((Integer)Configs.AHP.tamedSleepThreatDetectionRadiusBlocks.get()).intValue();
        List nearbyHostiles = world.getEntitiesOfClass(LivingEntity.class, this.getBoundingBox().inflate(threatRadius), entity -> entity instanceof Monster && entity.isAlive() && !entity.isSpectator());
        return nearbyHostiles.isEmpty();
    }

    @Unique
    private boolean checkConditionsForSustainingSlumber() {
        return this.isOrderedToSit() && this.checkConditionsForInitiatingDrowsiness();
    }

    @Unique
    private void resetSleepSequence(String reason) {
        AdorableHamsterPets.LOGGER.debug("Hamster {} resetting sleep sequence: {}. Current phase was: {}", new Object[]{this.getId(), reason, this.getDozingPhase()});
        this.setDozingPhase(DozingPhase.NONE);
        this.quiescentSitDurationTimer = 0;
        this.driftingOffTimer = 0;
        this.settleSleepAnimationCooldown = 0;
    }

    public void onClientRemoval() {
        super.onClientRemoval();
        if (!this.level().isClientSide()) {
            HamsterRenderTracker.onEntityUnload(this.getId());
        }
    }

    public static enum DozingPhase {
        NONE,
        QUIESCENT_SITTING,
        DRIFTING_OFF,
        SETTLING_INTO_SLUMBER,
        DEEP_SLEEP;

    }
}

