/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.event;

import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.EntityEvent;
import dev.architectury.event.events.common.PlayerEvent;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.UUID;
import net.dawson.adorablehamsterpets.AdorableHamsterPets;
import net.dawson.adorablehamsterpets.entity.custom.HamsterEntity;
import net.dawson.adorablehamsterpets.mixin.accessor.SlotAccessor;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class AHPCommonEvents {
    public static void init() {
        PlayerEvent.OPEN_MENU.register(AHPCommonEvents::onOpenMenu);
        EntityEvent.LIVING_HURT.register(AHPCommonEvents::onLivingHurt);
    }

    private static void onOpenMenu(Player player, AbstractContainerMenu menu) {
        if (player.level().isClientSide()) {
            return;
        }
        HashSet<Container> inventories = new HashSet<Container>();
        for (Slot slot : menu.slots) {
            Container inv = ((SlotAccessor)slot).adorablehamsterpets$getInventory();
            if (inv == null) continue;
            inventories.add(inv);
        }
        for (Container inv : inventories) {
            AdorableHamsterPets.replaceOldBooksInInventory(inv);
        }
    }

    private static EventResult onLivingHurt(LivingEntity victim, DamageSource source, float amount) {
        HamsterEntity victimHamster;
        HamsterEntity h;
        HamsterEntity h2;
        if (victim.level().isClientSide()) {
            return EventResult.pass();
        }
        Entity direct = source.getDirectEntity();
        Entity attacker = source.getEntity();
        AdorableHamsterPets.LOGGER.trace("onLivingHurt: victim={} srcType={} attacker={}({}) direct={}({}) amount={}", new Object[]{victim.getType().toString(), source.getMsgId(), attacker, attacker == null ? "null" : attacker.getClass().getSimpleName(), direct, direct == null ? "null" : direct.getClass().getSimpleName(), Float.valueOf(amount)});
        HamsterEntity hamster = null;
        if (direct instanceof HamsterEntity && (h2 = (HamsterEntity)direct).isTame()) {
            hamster = h2;
        } else if (attacker instanceof HamsterEntity && (h = (HamsterEntity)attacker).isTame()) {
            hamster = h;
        }
        if (hamster != null) {
            boolean victimIsTameable = victim instanceof TamableAnimal;
            AdorableHamsterPets.LOGGER.trace("hamster\u2192pet branch entered: hamsterTamed={} victim instanceof TameableEntity={}", (Object)hamster.isTame(), (Object)victimIsTameable);
            LivingEntity hamsterOwner = hamster.getOwner();
            LivingEntity victimOwner = AHPCommonEvents.getPetOwner(victim);
            AdorableHamsterPets.LOGGER.trace("hamster\u2192pet owners: hamsterOwnerUuid={} victimOwnerUuid={}", hamsterOwner == null ? "null" : hamsterOwner.getUUID(), victimOwner == null ? "null" : victimOwner.getUUID());
            if (hamsterOwner != null && victimOwner != null && AHPCommonEvents.sameOwner(hamsterOwner, victimOwner)) {
                AdorableHamsterPets.LOGGER.trace("hamster\u2192pet: SAME OWNER detected, cancelling damage.");
                return EventResult.interruptFalse();
            }
        }
        if (victim instanceof HamsterEntity && (victimHamster = (HamsterEntity)victim).isTame()) {
            LivingEntity livingEntity;
            LivingEntity victimOwner = victimHamster.getOwner();
            if (attacker instanceof LivingEntity) {
                LivingEntity leAttacker = (LivingEntity)attacker;
                livingEntity = AHPCommonEvents.getPetOwner(leAttacker);
            } else {
                livingEntity = null;
            }
            LivingEntity attackerOwner = livingEntity;
            AdorableHamsterPets.LOGGER.trace("onLivingHurt: symm hamsterOwnerUuid={} attackerOwnerUuid={}", victimOwner == null ? "null" : victimOwner.getUUID(), attackerOwner == null ? "null" : attackerOwner.getUUID());
            if (victimOwner != null && attackerOwner != null && AHPCommonEvents.sameOwner(victimOwner, attackerOwner)) {
                return EventResult.interruptFalse();
            }
        }
        return EventResult.pass();
    }

    @Nullable
    private static LivingEntity getPetOwner(LivingEntity entity) {
        AbstractHorse horse;
        UUID ownerId;
        if (entity instanceof TamableAnimal) {
            TamableAnimal tame = (TamableAnimal)entity;
            return tame.getOwner();
        }
        if (entity instanceof AbstractHorse && (ownerId = (horse = (AbstractHorse)entity).getOwnerUUID()) != null) {
            return AHPCommonEvents.lookupLivingByUuid(entity.level(), ownerId);
        }
        if (entity instanceof TraceableEntity) {
            LivingEntity le;
            TraceableEntity ownable = (TraceableEntity)entity;
            Entity e = ownable.getOwner();
            return e instanceof LivingEntity ? (le = (LivingEntity)e) : null;
        }
        try {
            Method m = entity.getClass().getMethod("getOwner", new Class[0]);
            Object ret = m.invoke((Object)entity, new Object[0]);
            if (ret instanceof LivingEntity) {
                LivingEntity le = (LivingEntity)ret;
                return le;
            }
            if (ret instanceof Entity) {
                LivingEntity le;
                Entity e = (Entity)ret;
                return e instanceof LivingEntity ? (le = (LivingEntity)e) : null;
            }
        }
        catch (Throwable m) {
            // empty catch block
        }
        UUID id = AHPCommonEvents.tryGetUuid(entity, "getOwnerUuid");
        if (id == null) {
            id = AHPCommonEvents.tryGetUuid(entity, "getOwnerUUID");
        }
        if (id != null) {
            return AHPCommonEvents.lookupLivingByUuid(entity.level(), id);
        }
        return null;
    }

    @Nullable
    private static UUID tryGetUuid(Object target, String methodName) {
        try {
            UUID u;
            Method m = target.getClass().getMethod(methodName, new Class[0]);
            Object ret = m.invoke(target, new Object[0]);
            return ret instanceof UUID ? (u = (UUID)ret) : null;
        }
        catch (Throwable ignored) {
            return null;
        }
    }

    @Nullable
    private static LivingEntity lookupLivingByUuid(Level world, UUID id) {
        LivingEntity le;
        if (!(world instanceof ServerLevel)) {
            return null;
        }
        ServerLevel server = (ServerLevel)world;
        Player player = server.getPlayerByUUID(id);
        if (player instanceof LivingEntity) {
            LivingEntity le2 = (LivingEntity)player;
            return le2;
        }
        Entity any = server.getEntity(id);
        return any instanceof LivingEntity ? (le = (LivingEntity)any) : null;
    }

    private static boolean sameOwner(LivingEntity a, LivingEntity b) {
        return a == b || a.getUUID().equals(b.getUUID());
    }
}

