/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.fabric.datagen;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import me.fzzyhmstrs.fzzy_config.api.ConfigApiJava;
import net.dawson.adorablehamsterpets.AdorableHamsterPets;
import net.dawson.adorablehamsterpets.config.AhpConfig;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricLanguageProvider;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceLocation;

public class EnUsGenerator
extends FabricLanguageProvider {
    private static final String BASE_RESOURCE_PATH = "assets/adorablehamsterpets/lang/en_us_base.json";
    private static final Gson GSON = new Gson();

    public EnUsGenerator(FabricDataOutput output, CompletableFuture<HolderLookup.Provider> lookup) {
        super(output, "en_us", lookup);
    }

    public void generateTranslations(HolderLookup.Provider registries, FabricLanguageProvider.TranslationBuilder builder) {
        HashSet<String> seen = new HashSet<String>();
        try (InputStream stream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(BASE_RESOURCE_PATH);){
            if (stream != null) {
                JsonObject obj = (JsonObject)GSON.fromJson((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8), JsonObject.class);
                for (Map.Entry e : obj.entrySet()) {
                    builder.add((String)e.getKey(), ((JsonElement)e.getValue()).getAsString());
                    seen.add((String)e.getKey());
                }
            } else {
                AdorableHamsterPets.LOGGER.warn("Could not locate {}", (Object)BASE_RESOURCE_PATH);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to read assets/adorablehamsterpets/lang/en_us_base.json", ex);
        }
        BiConsumer<String, String> safeSingleWriter = (key, value) -> {
            if (seen.add((String)key)) {
                builder.add(key, value);
            }
        };
        ConfigApiJava.buildTranslations(AhpConfig.class, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"adorablehamsterpets", (String)"main"), (String)"en_us", (boolean)true, safeSingleWriter);
    }
}

