/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.integration.jade;

import net.dawson.adorablehamsterpets.config.Configs;
import net.dawson.adorablehamsterpets.entity.custom.HamsterEntity;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IEntityComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationProcessor;

public enum HamsterDebugComponentProvider implements IEntityComponentProvider
{
    INSTANCE;

    private static final ResourceLocation UID;

    public void appendTooltip(ITooltip tooltip, EntityAccessor accessor, IPluginConfig config) {
        if (!Configs.AHP.enableJadeHamsterDebugInfo) {
            return;
        }
        Entity entity = accessor.getEntity();
        if (!(entity instanceof HamsterEntity)) {
            return;
        }
        HamsterEntity hamster = (HamsterEntity)entity;
        tooltip.add((Component)Component.literal((String)"--- Current Animation ---").withStyle(ChatFormatting.GRAY));
        AnimationController controller = (AnimationController)hamster.getAnimatableInstanceCache().getManagerForId((long)hamster.getId()).getAnimationControllers().get("mainController");
        if (controller != null) {
            AnimationProcessor.QueuedAnimation currentAnim = controller.getCurrentAnimation();
            if (currentAnim != null) {
                tooltip.add(this.fText("Current Anim: %s", Component.literal((String)currentAnim.animation().name()).withStyle(ChatFormatting.AQUA)));
            } else {
                tooltip.add(this.fText("Current Anim: %s", Component.literal((String)"None").withStyle(ChatFormatting.GRAY)));
            }
        }
        tooltip.add((Component)Component.literal((String)"--- AI & Action States ---").withStyle(ChatFormatting.GRAY));
        tooltip.add(this.fText("Sitting (Command): %s", hamster.isOrderedToSit() ? Component.literal((String)"true").withStyle(ChatFormatting.GREEN) : Component.literal((String)"false").withStyle(ChatFormatting.RED)));
        tooltip.add(this.fText("Sitting (Vanilla Pose): %s", hamster.isInSittingPose() ? Component.literal((String)"true").withStyle(ChatFormatting.GREEN) : Component.literal((String)"false").withStyle(ChatFormatting.RED)));
        tooltip.add(this.fText("Sleeping (Wild/General): %s", hamster.isSleeping() ? Component.literal((String)"true").withStyle(ChatFormatting.GREEN) : Component.literal((String)"false").withStyle(ChatFormatting.RED)));
        tooltip.add(this.fText("Cleaning: %s", hamster.isCleaning() ? Component.literal((String)"true").withStyle(ChatFormatting.GREEN) : Component.literal((String)"false").withStyle(ChatFormatting.RED)));
        if (hamster.isKnockedOut()) {
            tooltip.add(this.fText("State: %s", Component.literal((String)"Knocked Out").withStyle(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD})));
        } else if (hamster.isThrown()) {
            tooltip.add(this.fText("State: %s", Component.literal((String)"Thrown").withStyle(ChatFormatting.AQUA)));
        } else if (hamster.isSulking()) {
            tooltip.add(this.fText("State: %s", Component.literal((String)"Sulking").withStyle(new ChatFormatting[]{ChatFormatting.DARK_PURPLE, ChatFormatting.BOLD})));
        } else if (hamster.isCelebratingDiamond()) {
            tooltip.add(this.fText("State: %s", Component.literal((String)"Celebrating Diamond").withStyle(new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.BOLD})));
        }
        tooltip.add(this.fText("Is Navigating: %s", !hamster.getNavigation().isDone() ? Component.literal((String)"true").withStyle(ChatFormatting.GREEN) : Component.literal((String)"false").withStyle(ChatFormatting.RED)));
        LivingEntity target = hamster.getTarget();
        tooltip.add(this.fText("Has Target: %s", target != null ? Component.literal((String)"true").withStyle(ChatFormatting.GREEN) : Component.literal((String)"false").withStyle(ChatFormatting.RED)));
        if (target != null) {
            tooltip.add(this.fText("  Target: %s", Component.literal((String)target.getName().getString()).withStyle(ChatFormatting.WHITE)));
        }
        String activeGoalName = hamster.getActiveCustomGoalDebugName();
        tooltip.add(this.fText("Current Custom Goal: %s", Component.literal((String)activeGoalName).withStyle(activeGoalName.equals("None") ? ChatFormatting.GRAY : ChatFormatting.AQUA)));
        if (hamster.isTame()) {
            tooltip.add((Component)Component.literal((String)"--- Tamed Sleep Sequence ---").withStyle(ChatFormatting.GRAY));
            HamsterEntity.DozingPhase phase = hamster.getDozingPhase();
            tooltip.add(this.fText("Dozing Phase: %s", Component.literal((String)phase.name()).withStyle(phase != HamsterEntity.DozingPhase.NONE ? ChatFormatting.AQUA : ChatFormatting.WHITE)));
            if (phase == HamsterEntity.DozingPhase.DEEP_SLEEP || phase == HamsterEntity.DozingPhase.SETTLING_INTO_SLUMBER) {
                tooltip.add(this.fText("  Deep Sleep Anim: %s", Component.literal((String)hamster.getCurrentDeepSleepAnimationIdFromTracker()).withStyle(ChatFormatting.AQUA)));
            }
        }
        tooltip.add((Component)Component.literal((String)"--- Ore Seeking ---").withStyle(ChatFormatting.GRAY));
        tooltip.add(this.fText("Primed to Seek: %s", hamster.isPrimedToSeekDiamonds ? Component.literal((String)"true").withStyle(ChatFormatting.GREEN) : Component.literal((String)"false").withStyle(ChatFormatting.RED)));
        if (hamster.currentOreTarget != null) {
            tooltip.add(this.fText("  Current Ore Target: %s", Component.literal((String)hamster.currentOreTarget.toString()).withStyle(ChatFormatting.AQUA)));
        } else {
            tooltip.add(this.fText("  Current Ore Target: %s", Component.literal((String)"None").withStyle(ChatFormatting.GRAY)));
        }
        long foundOreCooldown = hamster.foundOreCooldownEndTick - hamster.level().getGameTime();
        if (Configs.AHP.enableIndependentDiamondSeekCooldown && foundOreCooldown > 0L) {
            tooltip.add(this.fText("  Found Ore Cooldown: %s sec", Component.literal((String)String.format("%.1f", (double)foundOreCooldown / 20.0)).withStyle(ChatFormatting.YELLOW)));
        } else if (Configs.AHP.enableIndependentDiamondSeekCooldown) {
            tooltip.add(this.fText("  Found Ore Cooldown: %s", Component.literal((String)"Ready").withStyle(ChatFormatting.GREEN)));
        } else {
            tooltip.add(this.fText("  Found Ore Cooldown: %s", Component.literal((String)"Disabled").withStyle(ChatFormatting.GRAY)));
        }
        tooltip.add((Component)Component.literal((String)"--- Diamond Stealing ---").withStyle(ChatFormatting.GRAY));
        tooltip.add(this.fText("Is Stealing: %s", hamster.isStealingDiamond() ? Component.literal((String)"true").withStyle(ChatFormatting.GREEN) : Component.literal((String)"false").withStyle(ChatFormatting.RED)));
        if (hamster.isStealingDiamond()) {
            int remainingTicks = hamster.getStealDurationTimer();
            tooltip.add(this.fText("  Time Remaining: %s sec", Component.literal((String)String.format("%.1f", (double)remainingTicks / 20.0)).withStyle(ChatFormatting.YELLOW)));
        }
        tooltip.add((Component)Component.literal((String)"--- Love & Interaction ---").withStyle(ChatFormatting.GRAY));
        tooltip.add(this.fText("Begging: %s", hamster.isBegging() ? Component.literal((String)"true").withStyle(ChatFormatting.GREEN) : Component.literal((String)"false").withStyle(ChatFormatting.RED)));
        tooltip.add(this.fText("Refusing Food: %s", hamster.isRefusingFood() ? Component.literal((String)"true").withStyle(ChatFormatting.GREEN) : Component.literal((String)"false").withStyle(ChatFormatting.RED)));
        boolean inLoveDataTracker = hamster.isInLove();
        boolean inLoveCustomTimer = hamster.customLoveTimer > 0;
        tooltip.add(this.fText("In Love (Tracker): %s", inLoveDataTracker ? Component.literal((String)"true").withStyle(ChatFormatting.GREEN) : Component.literal((String)"false").withStyle(ChatFormatting.RED)));
        tooltip.add(this.fText("In Love (Timer): %s (%d ticks)", inLoveCustomTimer ? Component.literal((String)"true").withStyle(ChatFormatting.GREEN) : Component.literal((String)"false").withStyle(ChatFormatting.RED), hamster.customLoveTimer));
        tooltip.add((Component)Component.literal((String)"--- General Info ---").withStyle(ChatFormatting.GRAY));
        tooltip.add(this.fText("Tamed: %s", hamster.isTame() ? Component.literal((String)"Yes").withStyle(ChatFormatting.GREEN) : Component.literal((String)"No").withStyle(ChatFormatting.RED)));
        if (hamster.isTame() && hamster.getOwner() != null) {
            tooltip.add(this.fText("  Owner: %s", Component.literal((String)hamster.getOwner().getName().getString()).withStyle(ChatFormatting.WHITE)));
        }
        tooltip.add(this.fText("Variant: %s (ID: %d)", Component.literal((String)hamster.getVariantEnum().name()).withStyle(ChatFormatting.AQUA), hamster.getVariant()));
        tooltip.add(this.fText("Age: %s", hamster.isBaby() ? Component.literal((String)"Baby").withStyle(ChatFormatting.AQUA) : Component.literal((String)"Adult").withStyle(ChatFormatting.WHITE)));
    }

    public ResourceLocation getUid() {
        return UID;
    }

    private Component fText(String format, Object ... args) {
        Component[] formattedArgs = new Component[args.length];
        for (int i = 0; i < args.length; ++i) {
            Component textComponent;
            Object object = args[i];
            formattedArgs[i] = object instanceof Component ? (textComponent = (Component)object) : Component.literal((String)String.valueOf(args[i])).withStyle(ChatFormatting.WHITE);
        }
        MutableComponent result = Component.empty();
        String[] parts = format.split("%s", -1);
        for (int i = 0; i < parts.length; ++i) {
            result.append((Component)Component.literal((String)parts[i]).withStyle(ChatFormatting.GOLD));
            if (i >= formattedArgs.length) continue;
            result.append(formattedArgs[i]);
        }
        return result;
    }

    static {
        UID = ResourceLocation.fromNamespaceAndPath((String)"adorablehamsterpets", (String)"hamster_debug_info");
    }
}

