/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.item.custom;

import dev.architectury.platform.Platform;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import vazkii.patchouli.api.PatchouliAPI;

public class PatchouliGuideBookItem
extends Item {
    public PatchouliGuideBookItem(Item.Properties settings) {
        super(settings);
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        ItemStack stack = user.getItemInHand(hand);
        if (user instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)user;
            PatchouliAPI.get().openBookGUI(serverPlayer, ResourceLocation.fromNamespaceAndPath((String)"adorablehamsterpets", (String)"hamster_tips_guide_book"));
        }
        return InteractionResultHolder.success((Object)stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        boolean needsToolTip;
        tooltip.add((Component)Component.translatable((String)"tooltip.adorablehamsterpets.hamster_guide_book.hint").withStyle(ChatFormatting.GRAY));
        boolean isJadeLoaded = Platform.isModLoaded((String)"jade");
        Screen currentScreen = Minecraft.getInstance().screen;
        boolean bl = needsToolTip = currentScreen == null || currentScreen.getClass() == CreativeModeInventoryScreen.class;
        if (!isJadeLoaded || needsToolTip) {
            tooltip.add((Component)Component.literal((String)"Adorable Hamster Pets").withStyle(new ChatFormatting[]{ChatFormatting.BLUE, ChatFormatting.ITALIC}));
        }
        super.appendHoverText(stack, context, tooltip, type);
    }
}

