/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.mixin.client;

import com.mojang.blaze3d.systems.RenderSystem;
import net.dawson.adorablehamsterpets.mixin.accessor.ScreenWidgetAdder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import vazkii.patchouli.client.book.BookCategory;
import vazkii.patchouli.client.book.gui.GuiBook;
import vazkii.patchouli.client.book.gui.GuiBookLanding;
import vazkii.patchouli.client.book.gui.button.GuiButtonCategory;
import vazkii.patchouli.common.book.Book;

@Mixin(value={GuiBookLanding.class}, remap=false)
public abstract class GuiBookLandingMixin
extends GuiBook {
    public GuiBookLandingMixin(Book book, Component title) {
        super(book, title);
    }

    private boolean isHamsterBook() {
        return this.book != null && this.book.id.equals((Object)ResourceLocation.fromNamespaceAndPath((String)"adorablehamsterpets", (String)"hamster_tips_guide_book"));
    }

    private int getTotalIcons() {
        if (this.book.getContents().pamphletCategory != null) {
            return 0;
        }
        int count = 0;
        for (BookCategory cat : this.book.getContents().categories.values()) {
            if (cat.getParentCategory() != null || cat.shouldHide()) continue;
            ++count;
        }
        return count + 1;
    }

    @Inject(method={"drawHeader"}, at={@At(value="HEAD")}, cancellable=true)
    private void adorablehamsterpets$onDrawHeader(GuiGraphics graphics, CallbackInfo ci) {
        if (!this.isHamsterBook()) {
            return;
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int ribbonX = -8;
        int ribbonY = 12;
        int ribbonU = 0;
        int ribbonV = 180;
        int ribbonWidth = 140;
        int ribbonHeight = 43;
        GuiBookLandingMixin.drawFromTexture((GuiGraphics)graphics, (Book)this.book, (int)ribbonX, (int)ribbonY, (int)ribbonU, (int)ribbonV, (int)ribbonWidth, (int)ribbonHeight);
        int titleColor = this.book.nameplateColor;
        Component titleText = this.book.getBookItem().getHoverName();
        int titleX = 20;
        int titleY = 16;
        graphics.drawString(Minecraft.getInstance().font, titleText, titleX, titleY, titleColor, false);
        MutableComponent subtitleText = this.book.getSubtitle().withStyle(this.book.getFontStyle());
        int subtitleX = 19;
        int subtitleY = 26;
        int wrapWidth = 100;
        graphics.drawWordWrap(Minecraft.getInstance().font, (FormattedText)subtitleText, subtitleX, subtitleY, wrapWidth, titleColor);
        ci.cancel();
    }

    @Inject(method={"addCategoryButton"}, at={@At(value="HEAD")}, cancellable=true)
    private void adorablehamsterpets$onAddCategoryButton(int i, BookCategory category, CallbackInfo ci) {
        if (!this.isHamsterBook() || this.book.getContents().pamphletCategory != null) {
            return;
        }
        int total = this.getTotalIcons();
        if (total == 0) {
            return;
        }
        int columns = 4;
        int row = i / columns;
        int lastRow = (total - 1) / columns;
        int rowItems = row == lastRow ? total - lastRow * columns : columns;
        int shift = (columns - rowItems) * 12;
        int x = 151 + shift + i % columns * 24;
        int y = 43 + row * 24;
        GuiBookLanding self = (GuiBookLanding)this;
        GuiButtonCategory button = category == null ? new GuiButtonCategory((GuiBook)this, x, y, this.book.getIcon(), (Component)Component.translatable((String)"patchouli.gui.lexicon.index"), arg_0 -> ((GuiBookLanding)self).handleButtonIndex(arg_0)) : new GuiButtonCategory((GuiBook)this, x, y, category, arg_0 -> ((GuiBookLanding)self).handleButtonCategory(arg_0));
        ((ScreenWidgetAdder)((Object)this)).adorablehamsterpets$addWidget(button);
        ci.cancel();
    }
}

