/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.mixin.server;

import com.mojang.authlib.GameProfile;
import dev.architectury.networking.NetworkManager;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.dawson.adorablehamsterpets.AdorableHamsterPets;
import net.dawson.adorablehamsterpets.accessor.PlayerEntityAccessor;
import net.dawson.adorablehamsterpets.advancement.criterion.HamsterCreeperAlertCriterion;
import net.dawson.adorablehamsterpets.advancement.criterion.HamsterDiamondAlertCriterion;
import net.dawson.adorablehamsterpets.advancement.criterion.HamsterThrownCriterion;
import net.dawson.adorablehamsterpets.advancement.criterion.ModCriteria;
import net.dawson.adorablehamsterpets.client.state.ClientShoulderHamsterData;
import net.dawson.adorablehamsterpets.config.AhpConfig;
import net.dawson.adorablehamsterpets.config.DismountOrder;
import net.dawson.adorablehamsterpets.entity.AI.HamsterSeekDiamondGoal;
import net.dawson.adorablehamsterpets.entity.ShoulderLocation;
import net.dawson.adorablehamsterpets.entity.custom.HamsterEntity;
import net.dawson.adorablehamsterpets.networking.payload.StartHamsterFlightSoundPayload;
import net.dawson.adorablehamsterpets.networking.payload.StartHamsterThrowSoundPayload;
import net.dawson.adorablehamsterpets.sound.ModSounds;
import net.dawson.adorablehamsterpets.util.HamsterRenderTracker;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Player.class})
public abstract class PlayerEntityMixin
extends LivingEntity
implements PlayerEntityAccessor {
    @Unique
    private static final EntityDataAccessor<CompoundTag> SHOULDER_HAMSTERS = SynchedEntityData.defineId(Player.class, (EntityDataSerializer)EntityDataSerializers.COMPOUND_TAG);
    @Unique
    private transient ClientShoulderHamsterData adorablehamsterpets$clientShoulderData;
    @Unique
    private static final int CHECK_INTERVAL_TICKS = 20;
    @Unique
    private static final List<String> DISMOUNT_MESSAGE_KEYS = Arrays.asList("message.adorablehamsterpets.dismount.1", "message.adorablehamsterpets.dismount.2", "message.adorablehamsterpets.dismount.3", "message.adorablehamsterpets.dismount.4", "message.adorablehamsterpets.dismount.5", "message.adorablehamsterpets.dismount.6");
    @Unique
    private int adorablehamsterpets$diamondCheckTimer = 0;
    @Unique
    private int adorablehamsterpets$creeperCheckTimer = 0;
    @Unique
    private int adorablehamsterpets$diamondSoundCooldownTicks = 0;
    @Unique
    private int adorablehamsterpets$creeperSoundCooldownTicks = 0;
    @Unique
    private String adorablehamsterpets$lastDismountMessageKey = "";
    @Unique
    private boolean adorablehamsterpets$isDiamondAlertConditionMet = false;
    @Unique
    private int adorablehamsterpets$lastGoldMessageIndex = -1;
    @Unique
    private final transient ArrayDeque<ShoulderLocation> adorablehamsterpets$mountOrderQueue = new ArrayDeque();

    @Inject(method={"<init>(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;FLcom/mojang/authlib/GameProfile;)V"}, at={@At(value="TAIL")})
    private void adorablehamsterpets$onInit(Level world, BlockPos pos, float yaw, GameProfile gameProfile, CallbackInfo ci) {
        if (world.isClientSide) {
            this.adorablehamsterpets$clientShoulderData = new ClientShoulderHamsterData();
        }
    }

    protected PlayerEntityMixin(EntityType<? extends LivingEntity> entityType, Level world) {
        super(entityType, world);
    }

    @Inject(method={"defineSynchedData(Lnet/minecraft/network/syncher/SynchedEntityData$Builder;)V"}, at={@At(value="TAIL")})
    private void adorablehamsterpets$initDataTracker(SynchedEntityData.Builder builder, CallbackInfo ci) {
        AdorableHamsterPets.LOGGER.trace("[AHP Mixin] PlayerEntityMixin initDataTracker is RUNNING for entity {}.", (Object)this.getId());
        builder.define(SHOULDER_HAMSTERS, (Object)new CompoundTag());
    }

    @Inject(method={"addAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V"}, at={@At(value="TAIL")})
    private void adorablehamsterpets$writeNbt(CompoundTag nbt, CallbackInfo ci) {
        AdorableHamsterPets.LOGGER.trace("[AHP Mixin] PlayerEntityMixin writeNbt is RUNNING for entity {}.", (Object)this.getId());
        CompoundTag shoulderPetsNbt = (CompoundTag)this.getEntityData().get(SHOULDER_HAMSTERS);
        if (!shoulderPetsNbt.isEmpty()) {
            nbt.put("ShoulderHamsters", (Tag)shoulderPetsNbt);
        }
        if (!this.adorablehamsterpets$mountOrderQueue.isEmpty()) {
            ListTag mountOrderList = new ListTag();
            for (ShoulderLocation location : this.adorablehamsterpets$mountOrderQueue) {
                mountOrderList.add((Object)StringTag.valueOf((String)location.name()));
            }
            nbt.put("MountOrderQueue", (Tag)mountOrderList);
        }
        if (this.adorablehamsterpets$lastGoldMessageIndex != -1) {
            nbt.putInt("LastGoldMessageIndex", this.adorablehamsterpets$lastGoldMessageIndex);
        }
    }

    @Inject(method={"readAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V"}, at={@At(value="TAIL")})
    private void adorablehamsterpets$readNbt(CompoundTag nbt, CallbackInfo ci) {
        AdorableHamsterPets.LOGGER.trace("[AHP Mixin] PlayerEntityMixin readNbt is RUNNING for entity {}.", (Object)this.getId());
        if (nbt.contains("ShoulderHamster", 10)) {
            CompoundTag oldHamsterNbt = nbt.getCompound("ShoulderHamster");
            if (!oldHamsterNbt.isEmpty()) {
                CompoundTag newShoulderPetsNbt = new CompoundTag();
                newShoulderPetsNbt.put(ShoulderLocation.RIGHT_SHOULDER.name(), (Tag)oldHamsterNbt);
                this.getEntityData().set(SHOULDER_HAMSTERS, (Object)newShoulderPetsNbt);
                this.adorablehamsterpets$mountOrderQueue.clear();
                this.adorablehamsterpets$mountOrderQueue.add(ShoulderLocation.RIGHT_SHOULDER);
                nbt.remove("ShoulderHamster");
                AdorableHamsterPets.LOGGER.info("Migrated legacy shoulder hamster data for player {}.", (Object)this.getDisplayName().getString());
            }
        } else if (nbt.contains("ShoulderHamsters", 10)) {
            this.getEntityData().set(SHOULDER_HAMSTERS, (Object)nbt.getCompound("ShoulderHamsters"));
        }
        this.adorablehamsterpets$mountOrderQueue.clear();
        if (nbt.contains("MountOrderQueue", 9)) {
            ListTag mountOrderList = nbt.getList("MountOrderQueue", 8);
            for (Tag element : mountOrderList) {
                try {
                    this.adorablehamsterpets$mountOrderQueue.add(ShoulderLocation.valueOf(element.getAsString()));
                }
                catch (IllegalArgumentException e) {
                    AdorableHamsterPets.LOGGER.warn("Found invalid ShoulderLocation name in NBT: {}", (Object)element.getAsString());
                }
            }
        }
        if (this.adorablehamsterpets$mountOrderQueue.isEmpty() && this.hasAnyShoulderHamster()) {
            AdorableHamsterPets.LOGGER.info("Player {} has shoulder hamsters but an empty mount queue. Rebuilding queue...", (Object)this.getDisplayName().getString());
            for (ShoulderLocation location : ShoulderLocation.values()) {
                if (this.getShoulderHamster(location).isEmpty()) continue;
                this.adorablehamsterpets$mountOrderQueue.addLast(location);
            }
            AdorableHamsterPets.LOGGER.info("Successfully rebuilt mount queue for player {}. New queue: {}", (Object)this.getDisplayName().getString(), this.adorablehamsterpets$mountOrderQueue);
        }
        this.adorablehamsterpets$lastGoldMessageIndex = nbt.contains("LastGoldMessageIndex", 3) ? nbt.getInt("LastGoldMessageIndex") : -1;
    }

    @Inject(method={"remove(Lnet/minecraft/world/entity/Entity$RemovalReason;)V"}, at={@At(value="HEAD")})
    private void adorablehamsterpets$onRemove(Entity.RemovalReason reason, CallbackInfo ci) {
        if (!this.level().isClientSide()) {
            HamsterRenderTracker.onPlayerDisconnect(this.getUUID());
        }
    }

    @Override
    @Unique
    public CompoundTag getShoulderHamster(ShoulderLocation location) {
        CompoundTag allShoulderPets = (CompoundTag)this.getEntityData().get(SHOULDER_HAMSTERS);
        return allShoulderPets.getCompound(location.name());
    }

    @Override
    @Unique
    public void setShoulderHamster(ShoulderLocation location, CompoundTag nbt) {
        CompoundTag allShoulderPets = new CompoundTag();
        allShoulderPets.merge((CompoundTag)this.getEntityData().get(SHOULDER_HAMSTERS));
        if (nbt == null || nbt.isEmpty()) {
            allShoulderPets.remove(location.name());
        } else {
            allShoulderPets.put(location.name(), (Tag)nbt);
        }
        this.getEntityData().set(SHOULDER_HAMSTERS, (Object)allShoulderPets);
    }

    @Inject(method={"tick()V"}, at={@At(value="TAIL")})
    private void adorablehamsterpets$onTick(CallbackInfo ci) {
        Player self = (Player)this;
        Level world = self.level();
        if (world.isClientSide) {
            return;
        }
        RandomSource random = world.getRandom();
        AhpConfig config = AdorableHamsterPets.CONFIG;
        if (this.adorablehamsterpets$diamondSoundCooldownTicks > 0) {
            --this.adorablehamsterpets$diamondSoundCooldownTicks;
        }
        if (this.adorablehamsterpets$creeperSoundCooldownTicks > 0) {
            --this.adorablehamsterpets$creeperSoundCooldownTicks;
        }
        if (this.hasAnyShoulderHamster()) {
            if (config.enableShoulderDiamondDetection) {
                ++this.adorablehamsterpets$diamondCheckTimer;
                if (this.adorablehamsterpets$diamondCheckTimer >= 20) {
                    this.adorablehamsterpets$diamondCheckTimer = 0;
                    if (this.isDiamondNearby(self, (Double)config.shoulderDiamondDetectionRadius.get())) {
                        this.adorablehamsterpets$isDiamondAlertConditionMet = true;
                        if (this.adorablehamsterpets$diamondSoundCooldownTicks == 0) {
                            world.playSound(null, self.blockPosition(), ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_DIAMOND_SNIFF_SOUNDS, random), SoundSource.NEUTRAL, 2.5f, 1.0f);
                            self.displayClientMessage((Component)Component.translatable((String)"message.adorablehamsterpets.diamond_nearby").withStyle(ChatFormatting.AQUA), true);
                            this.adorablehamsterpets$diamondSoundCooldownTicks = random.nextIntBetweenInclusive(140, 200);
                            ((HamsterDiamondAlertCriterion)((Object)ModCriteria.HAMSTER_DIAMOND_ALERT_TRIGGERED.get())).trigger((ServerPlayer)self);
                        }
                    } else {
                        this.adorablehamsterpets$isDiamondAlertConditionMet = false;
                    }
                }
            }
            if (config.enableShoulderCreeperDetection) {
                ++this.adorablehamsterpets$creeperCheckTimer;
                if (this.adorablehamsterpets$creeperCheckTimer >= 20) {
                    this.adorablehamsterpets$creeperCheckTimer = 0;
                    if (this.creeperSeesPlayer(self, (Double)config.shoulderCreeperDetectionRadius.get()) && this.adorablehamsterpets$creeperSoundCooldownTicks == 0) {
                        world.playSound(null, self.blockPosition(), ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_CREEPER_DETECT_SOUNDS, random), SoundSource.NEUTRAL, 1.0f, 1.0f);
                        self.displayClientMessage((Component)Component.translatable((String)"message.adorablehamsterpets.creeper_detected").withStyle(ChatFormatting.RED), true);
                        this.adorablehamsterpets$creeperSoundCooldownTicks = random.nextIntBetweenInclusive(100, 160);
                        ((HamsterCreeperAlertCriterion)((Object)ModCriteria.HAMSTER_CREEPER_ALERT_TRIGGERED.get())).trigger((ServerPlayer)self);
                    }
                }
            }
        }
    }

    @Override
    @Unique
    public void adorablehamsterpets$dismountShoulderHamster(boolean isThrow) {
        ShoulderLocation locationToProcess;
        Player self = (Player)this;
        Level world = self.level();
        if (world.isClientSide || this.adorablehamsterpets$mountOrderQueue.isEmpty()) {
            return;
        }
        AhpConfig config = AdorableHamsterPets.CONFIG;
        RandomSource random = world.getRandom();
        ShoulderLocation shoulderLocation = locationToProcess = config.dismountOrder.get() == DismountOrder.LIFO ? this.adorablehamsterpets$mountOrderQueue.peekLast() : this.adorablehamsterpets$mountOrderQueue.peekFirst();
        if (locationToProcess == null) {
            return;
        }
        CompoundTag shoulderNbt = this.getShoulderHamster(locationToProcess);
        if (shoulderNbt.isEmpty()) {
            AdorableHamsterPets.LOGGER.warn("Dismount queue pointed to an empty slot ({}). This may indicate a desync.", (Object)locationToProcess);
            if (config.dismountOrder.get() == DismountOrder.LIFO) {
                this.adorablehamsterpets$mountOrderQueue.pollLast();
            } else {
                this.adorablehamsterpets$mountOrderQueue.pollFirst();
            }
            return;
        }
        HamsterEntity hamster = HamsterEntity.createFromNbt((ServerLevel)world, self, shoulderNbt);
        if (hamster == null) {
            AdorableHamsterPets.LOGGER.error("Failed to create hamster from NBT for slot {}. Clearing data.", (Object)locationToProcess);
            this.setShoulderHamster(locationToProcess, new CompoundTag());
            if (config.dismountOrder.get() == DismountOrder.LIFO) {
                this.adorablehamsterpets$mountOrderQueue.pollLast();
            } else {
                this.adorablehamsterpets$mountOrderQueue.pollFirst();
            }
            return;
        }
        if (isThrow) {
            if (hamster.isBaby()) {
                self.displayClientMessage((Component)Component.translatable((String)"message.adorablehamsterpets.baby_throw_refusal").withStyle(ChatFormatting.RED), true);
                return;
            }
            long currentTime = world.getGameTime();
            if (hamster.throwCooldownEndTick > currentTime) {
                long remainingTicks = hamster.throwCooldownEndTick - currentTime;
                long totalSecondsRemaining = remainingTicks / 20L;
                long minutes = totalSecondsRemaining / 60L;
                long seconds = totalSecondsRemaining % 60L;
                self.displayClientMessage((Component)Component.translatable((String)"message.adorablehamsterpets.throw_cooldown", (Object[])new Object[]{minutes, seconds}).withStyle(ChatFormatting.RED), true);
                return;
            }
            hamster.moveTo(self.getX(), self.getEyeY() - 0.1, self.getZ(), self.getYRot(), self.getXRot());
            hamster.setThrown(true);
            hamster.interactionCooldown = 10;
            hamster.throwCooldownEndTick = currentTime + (long)((Integer)config.hamsterThrowCooldown.get()).intValue();
            boolean isBuffed = hamster.hasGreenBeanBuff();
            float throwSpeed = isBuffed ? ((Double)config.hamsterThrowVelocityBuffed.get()).floatValue() : ((Double)config.hamsterThrowVelocity.get()).floatValue();
            Vec3 lookVec = self.getViewVector(1.0f);
            Vec3 throwVec = new Vec3(lookVec.x, lookVec.y + (double)0.1f, lookVec.z).normalize();
            hamster.setDeltaMovement(throwVec.scale((double)throwSpeed));
            hamster.hasImpulse = true;
        }
        if (config.dismountOrder.get() == DismountOrder.LIFO) {
            this.adorablehamsterpets$mountOrderQueue.pollLast();
        } else {
            this.adorablehamsterpets$mountOrderQueue.pollFirst();
        }
        this.setShoulderHamster(locationToProcess, new CompoundTag());
        HamsterEntity.spawnFromNbt((ServerLevel)world, self, shoulderNbt, this.adorablehamsterpets$isDiamondAlertConditionMet, hamster);
        this.adorablehamsterpets$isDiamondAlertConditionMet = false;
        if (isThrow) {
            StartHamsterFlightSoundPayload flightPayload = new StartHamsterFlightSoundPayload(hamster.getId());
            StartHamsterThrowSoundPayload throwPayload = new StartHamsterThrowSoundPayload(hamster.getId());
            NetworkManager.sendToPlayer((ServerPlayer)((ServerPlayer)self), (CustomPacketPayload)flightPayload);
            NetworkManager.sendToPlayer((ServerPlayer)((ServerPlayer)self), (CustomPacketPayload)throwPayload);
            double radius = 64.0;
            Vec3 hamsterPos = hamster.position();
            AABB searchBox = new AABB(hamsterPos.subtract(radius, radius, radius), hamsterPos.add(radius, radius, radius));
            List nearbyPlayers = ((ServerLevel)world).getPlayers(p -> p != self && searchBox.contains(p.position()));
            NetworkManager.sendToPlayers((Iterable)nearbyPlayers, (CustomPacketPayload)flightPayload);
            NetworkManager.sendToPlayers((Iterable)nearbyPlayers, (CustomPacketPayload)throwPayload);
            ((HamsterThrownCriterion)((Object)ModCriteria.HAMSTER_THROWN.get())).trigger((ServerPlayer)self);
        } else {
            world.playSound(null, self.blockPosition(), (SoundEvent)ModSounds.HAMSTER_DISMOUNT.get(), SoundSource.PLAYERS, 0.7f, 1.0f + random.nextFloat() * 0.2f);
            if (config.enableShoulderDismountMessages && !DISMOUNT_MESSAGE_KEYS.isEmpty()) {
                String chosenKey;
                if (DISMOUNT_MESSAGE_KEYS.size() == 1) {
                    chosenKey = DISMOUNT_MESSAGE_KEYS.get(0);
                } else {
                    ArrayList<String> availableKeys = new ArrayList<String>(DISMOUNT_MESSAGE_KEYS);
                    availableKeys.remove(this.adorablehamsterpets$lastDismountMessageKey);
                    chosenKey = availableKeys.isEmpty() ? this.adorablehamsterpets$lastDismountMessageKey : (String)availableKeys.get(random.nextInt(availableKeys.size()));
                }
                self.displayClientMessage((Component)Component.translatable((String)chosenKey), true);
                this.adorablehamsterpets$lastDismountMessageKey = chosenKey;
            }
        }
    }

    @Unique
    private boolean isDiamondNearby(Player player, double radius) {
        Level world = player.level();
        BlockPos center = player.blockPosition();
        int intRadius = (int)Math.ceil(radius);
        ArrayList<BlockPos> exposedOres = new ArrayList<BlockPos>();
        ArrayList<BlockPos> buriedOres = new ArrayList<BlockPos>();
        for (BlockPos checkPos : BlockPos.betweenClosed((BlockPos)center.offset(-intRadius, -intRadius, -intRadius), (BlockPos)center.offset(intRadius, intRadius, intRadius))) {
            BlockState state;
            if (!(checkPos.distSqr((Vec3i)center) <= radius * radius) || !(state = world.getBlockState(checkPos)).is(Blocks.DIAMOND_ORE) && !state.is(Blocks.DEEPSLATE_DIAMOND_ORE)) continue;
            if (HamsterSeekDiamondGoal.isOreExposed(checkPos, world)) {
                exposedOres.add(checkPos.immutable());
                continue;
            }
            buriedOres.add(checkPos.immutable());
        }
        return !exposedOres.isEmpty() || !buriedOres.isEmpty();
    }

    @Unique
    private boolean creeperSeesPlayer(Player player, double radius) {
        AABB searchBox;
        Level world = player.level();
        List nearbyCreepers = world.getEntitiesOfClass(Creeper.class, searchBox = new AABB(player.position().subtract(radius, radius, radius), player.position().add(radius, radius, radius)), creeper -> creeper.isAlive() && creeper.getTarget() == player && EntitySelector.ENTITY_STILL_ALIVE.test(creeper));
        return !nearbyCreepers.isEmpty();
    }

    @Override
    @Unique
    public boolean hasAnyShoulderHamster() {
        return !this.getShoulderHamster(ShoulderLocation.RIGHT_SHOULDER).isEmpty() || !this.getShoulderHamster(ShoulderLocation.LEFT_SHOULDER).isEmpty() || !this.getShoulderHamster(ShoulderLocation.HEAD).isEmpty();
    }

    @Override
    @Unique
    public int ahp_getLastGoldMessageIndex() {
        return this.adorablehamsterpets$lastGoldMessageIndex;
    }

    @Override
    @Unique
    public void ahp_setLastGoldMessageIndex(int index) {
        this.adorablehamsterpets$lastGoldMessageIndex = index;
    }

    @Override
    @Unique
    public ArrayDeque<ShoulderLocation> adorablehamsterpets$getMountOrderQueue() {
        return this.adorablehamsterpets$mountOrderQueue;
    }

    @Override
    @Unique
    public ClientShoulderHamsterData adorablehamsterpets$getClientShoulderData() {
        return this.adorablehamsterpets$clientShoulderData;
    }
}

