/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.networking;

import dev.architectury.networking.NetworkManager;
import net.dawson.adorablehamsterpets.AdorableHamsterPetsClient;
import net.dawson.adorablehamsterpets.accessor.PlayerEntityAccessor;
import net.dawson.adorablehamsterpets.entity.custom.HamsterEntity;
import net.dawson.adorablehamsterpets.networking.payload.DismountHamsterPayload;
import net.dawson.adorablehamsterpets.networking.payload.StartHamsterFlightSoundPayload;
import net.dawson.adorablehamsterpets.networking.payload.StartHamsterThrowSoundPayload;
import net.dawson.adorablehamsterpets.networking.payload.ThrowHamsterPayload;
import net.dawson.adorablehamsterpets.networking.payload.UpdateHamsterRenderStatePayload;
import net.dawson.adorablehamsterpets.util.HamsterRenderTracker;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class ModPackets {
    public static void registerPayloads() {
        NetworkManager.registerS2CPayloadType(StartHamsterFlightSoundPayload.ID, StartHamsterFlightSoundPayload.CODEC);
        NetworkManager.registerS2CPayloadType(StartHamsterThrowSoundPayload.ID, StartHamsterThrowSoundPayload.CODEC);
    }

    public static void registerC2SPackets() {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, ThrowHamsterPayload.ID, ThrowHamsterPayload.CODEC, (payload, context) -> context.queue(() -> HamsterEntity.tryThrowFromShoulder((ServerPlayer)context.getPlayer())));
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, UpdateHamsterRenderStatePayload.ID, UpdateHamsterRenderStatePayload.CODEC, (payload, context) -> context.queue(() -> ModPackets.handleUpdateRenderState(payload, context)));
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, DismountHamsterPayload.ID, DismountHamsterPayload.CODEC, (payload, context) -> context.queue(() -> {
            Player patt0$temp = context.getPlayer();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)patt0$temp;
                ((PlayerEntityAccessor)player).adorablehamsterpets$dismountShoulderHamster(false);
            }
        }));
    }

    public static void registerS2CPackets() {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, StartHamsterFlightSoundPayload.ID, StartHamsterFlightSoundPayload.CODEC, (payload, context) -> context.queue(() -> AdorableHamsterPetsClient.handleStartFlightSound(payload)));
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, StartHamsterThrowSoundPayload.ID, StartHamsterThrowSoundPayload.CODEC, (payload, context) -> context.queue(() -> AdorableHamsterPetsClient.handleStartThrowSound(payload)));
    }

    private static void handleUpdateRenderState(UpdateHamsterRenderStatePayload payload, NetworkManager.PacketContext context) {
        if (payload.isRendering()) {
            HamsterRenderTracker.addPlayer(payload.hamsterEntityId(), context.getPlayer().getUUID());
        } else {
            HamsterRenderTracker.removePlayer(payload.hamsterEntityId(), context.getPlayer().getUUID());
        }
    }
}

