/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.screen;

import net.dawson.adorablehamsterpets.AdorableHamsterPets;
import net.dawson.adorablehamsterpets.entity.custom.HamsterEntity;
import net.dawson.adorablehamsterpets.screen.ModScreenHandlers;
import net.dawson.adorablehamsterpets.screen.slot.HamsterSlot;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class HamsterInventoryScreenHandler
extends AbstractContainerMenu {
    private final Container inventory;
    @Nullable
    private final HamsterEntity hamsterEntityInstance;

    public HamsterInventoryScreenHandler(int syncId, Inventory playerInventory, @Nullable HamsterEntity hamsterEntity) {
        super((MenuType)ModScreenHandlers.HAMSTER_INVENTORY_SCREEN_HANDLER.get(), syncId);
        if (hamsterEntity != null) {
            this.inventory = hamsterEntity;
            this.hamsterEntityInstance = hamsterEntity;
            HamsterInventoryScreenHandler.checkContainerSize((Container)this.inventory, (int)6);
        } else {
            AdorableHamsterPets.LOGGER.warn("Could not find HamsterEntity on client, using empty inventory.");
            this.inventory = new SimpleContainer(6);
            this.hamsterEntityInstance = null;
        }
        this.inventory.startOpen(playerInventory.player);
        this.setupSlots(playerInventory);
    }

    @Nullable
    public HamsterEntity getHamsterEntity() {
        return this.hamsterEntityInstance;
    }

    private void setupSlots(Inventory playerInventory) {
        int i;
        this.addSlot(new HamsterSlot(this.inventory, 0, 26, 95));
        this.addSlot(new HamsterSlot(this.inventory, 1, 44, 95));
        this.addSlot(new HamsterSlot(this.inventory, 2, 62, 95));
        this.addSlot(new Slot(this, (Container)new SimpleContainer(1), 0, 80, 95){

            public boolean mayPlace(ItemStack stack) {
                return false;
            }

            public boolean mayPickup(Player playerEntity) {
                return false;
            }

            public boolean isActive() {
                return false;
            }
        });
        this.addSlot(new HamsterSlot(this.inventory, 3, 98, 95));
        this.addSlot(new HamsterSlot(this.inventory, 4, 116, 95));
        this.addSlot(new HamsterSlot(this.inventory, 5, 134, 95));
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 140 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInventory, i, 8 + i * 18, 198));
        }
    }

    public void clicked(int slotIndex, int button, ClickType actionType, Player player) {
        super.clicked(slotIndex, button, actionType, player);
    }

    public boolean stillValid(Player player) {
        return this.inventory.stillValid(player);
    }

    public ItemStack quickMoveStack(Player player, int slotIndex) {
        ItemStack itemStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(slotIndex);
        if (slot.hasItem()) {
            ItemStack sourceStack = slot.getItem();
            itemStack = sourceStack.copy();
            int hamsterInvSize = 6;
            int gapSlotIndex = 3;
            int totalHamsterAreaSlots = hamsterInvSize + 1;
            if (slotIndex < totalHamsterAreaSlots && slotIndex != gapSlotIndex) {
                if (!this.moveItemStackTo(sourceStack, totalHamsterAreaSlots, this.slots.size(), true)) {
                    return ItemStack.EMPTY;
                }
            } else if (slotIndex >= totalHamsterAreaSlots) {
                if (this.hamsterEntityInstance != null && this.hamsterEntityInstance.isItemDisallowed(sourceStack)) {
                    return ItemStack.EMPTY;
                }
                if (!this.moveItemStackTo(sourceStack, 0, gapSlotIndex, false) && !this.moveItemStackTo(sourceStack, gapSlotIndex + 1, totalHamsterAreaSlots, false)) {
                    return ItemStack.EMPTY;
                }
            } else {
                return ItemStack.EMPTY;
            }
            if (sourceStack.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (sourceStack.getCount() == itemStack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, sourceStack);
        }
        return itemStack;
    }

    public void removed(Player player) {
        super.removed(player);
        this.inventory.stopOpen(player);
    }
}

