/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.tag;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.dawson.adorablehamsterpets.AdorableHamsterPets;
import net.dawson.adorablehamsterpets.config.Configs;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ModItemTags {
    private static final Set<Item> tamingItems = new HashSet<Item>();
    private static final Set<TagKey<Item>> tamingTags = new HashSet<TagKey<Item>>();
    private static final Set<Item> standardFoodItems = new HashSet<Item>();
    private static final Set<TagKey<Item>> standardFoodTags = new HashSet<TagKey<Item>>();
    private static final Set<Item> stealableItems = new HashSet<Item>();
    private static final Set<TagKey<Item>> stealableTags = new HashSet<TagKey<Item>>();
    private static final Set<Item> buffFoodItems = new HashSet<Item>();
    private static final Set<TagKey<Item>> buffFoodTags = new HashSet<TagKey<Item>>();
    private static final Set<Item> shoulderMountItems = new HashSet<Item>();
    private static final Set<TagKey<Item>> shoulderMountTags = new HashSet<TagKey<Item>>();
    private static final Set<Item> pouchUnlockItems = new HashSet<Item>();
    private static final Set<TagKey<Item>> pouchUnlockTags = new HashSet<TagKey<Item>>();
    private static final Set<Item> repeatableFoodItems = new HashSet<Item>();
    private static final Set<TagKey<Item>> repeatableFoodTags = new HashSet<TagKey<Item>>();
    private static final Set<Item> pouchAllowedItems = new HashSet<Item>();
    private static final Set<Item> autoHealFoodItems = new HashSet<Item>();
    private static final Set<TagKey<Item>> autoHealFoodTags = new HashSet<TagKey<Item>>();
    private static final Set<TagKey<Item>> pouchAllowedTags = new HashSet<TagKey<Item>>();
    private static final Set<Item> pouchDisallowedItems = new HashSet<Item>();
    private static final Set<TagKey<Item>> pouchDisallowedTags = new HashSet<TagKey<Item>>();

    public static void parseConfig() {
        ModItemTags.clearAll();
        ModItemTags.parseList(Configs.AHP.tamingFoods, tamingItems, tamingTags, "tamingFoods");
        ModItemTags.parseList(Configs.AHP.standardFoods, standardFoodItems, standardFoodTags, "standardFoods");
        ModItemTags.parseList(Configs.AHP.stealableItems, stealableItems, stealableTags, "stealableItems");
        ModItemTags.parseList(Configs.AHP.buffFoods, buffFoodItems, buffFoodTags, "buffFoods");
        ModItemTags.parseList(Configs.AHP.shoulderMountFoods, shoulderMountItems, shoulderMountTags, "shoulderMountFoods");
        ModItemTags.parseList(Configs.AHP.pouchUnlockFoods, pouchUnlockItems, pouchUnlockTags, "pouchUnlockFoods");
        ModItemTags.parseList(Configs.AHP.repeatableFoods, repeatableFoodItems, repeatableFoodTags, "repeatableFoods");
        ModItemTags.parseList(Configs.AHP.pouchAllowedItems, pouchAllowedItems, pouchAllowedTags, "pouchAllowedItems");
        ModItemTags.parseList(Configs.AHP.pouchDisallowedItems, pouchDisallowedItems, pouchDisallowedTags, "pouchDisallowedItems");
        ModItemTags.parseList(Configs.AHP.pouchDisallowedTags, pouchDisallowedItems, pouchDisallowedTags, "pouchDisallowedTags");
        ModItemTags.parseList(Configs.AHP.autoHealFoods, autoHealFoodItems, autoHealFoodTags, "autoHealFoods");
        AdorableHamsterPets.LOGGER.info("Parsed all item tag overrides from config.");
    }

    public static boolean isTamingFood(ItemStack stack) {
        return ModItemTags.matches(stack, tamingItems, tamingTags);
    }

    public static boolean isStandardFood(ItemStack stack) {
        return ModItemTags.matches(stack, standardFoodItems, standardFoodTags);
    }

    public static boolean isStealableItem(ItemStack stack) {
        return ModItemTags.matches(stack, stealableItems, stealableTags);
    }

    public static boolean isBuffFood(ItemStack stack) {
        return ModItemTags.matches(stack, buffFoodItems, buffFoodTags);
    }

    public static boolean isShoulderMountFood(ItemStack stack) {
        return ModItemTags.matches(stack, shoulderMountItems, shoulderMountTags);
    }

    public static boolean isPouchUnlockFood(ItemStack stack) {
        return ModItemTags.matches(stack, pouchUnlockItems, pouchUnlockTags);
    }

    public static boolean isRepeatableFood(ItemStack stack) {
        return ModItemTags.matches(stack, repeatableFoodItems, repeatableFoodTags);
    }

    public static boolean isAutoHealFood(ItemStack stack) {
        return ModItemTags.matches(stack, autoHealFoodItems, autoHealFoodTags);
    }

    public static boolean isPouchAllowed(ItemStack stack) {
        return ModItemTags.matches(stack, pouchAllowedItems, pouchAllowedTags);
    }

    public static boolean isPouchDisallowed(ItemStack stack) {
        return ModItemTags.matches(stack, pouchDisallowedItems, pouchDisallowedTags);
    }

    private static void parseList(List<String> configList, Set<Item> itemSet, Set<TagKey<Item>> tagSet, String listName) {
        for (String entry : configList) {
            if (entry.startsWith("#")) {
                try {
                    ResourceLocation tagId = ResourceLocation.parse((String)entry.substring(1));
                    tagSet.add((TagKey<Item>)TagKey.create((ResourceKey)BuiltInRegistries.ITEM.key(), (ResourceLocation)tagId));
                }
                catch (Exception e) {
                    AdorableHamsterPets.LOGGER.warn("[ItemTagManager] Invalid item tag identifier in '{}' config list: '{}'", (Object)listName, (Object)entry);
                }
                continue;
            }
            try {
                ResourceLocation itemId = ResourceLocation.parse((String)entry);
                BuiltInRegistries.ITEM.getOptional(itemId).ifPresent(itemSet::add);
            }
            catch (Exception e) {
                AdorableHamsterPets.LOGGER.warn("[ItemTagManager] Invalid item identifier in '{}' config list: '{}'", (Object)listName, (Object)entry);
            }
        }
    }

    private static boolean matches(ItemStack stack, Set<Item> itemSet, Set<TagKey<Item>> tagSet) {
        if (stack.isEmpty()) {
            return false;
        }
        if (itemSet.contains(stack.getItem())) {
            return true;
        }
        for (TagKey<Item> tag : tagSet) {
            if (!stack.is(tag)) continue;
            return true;
        }
        return false;
    }

    private static void clearAll() {
        tamingItems.clear();
        tamingTags.clear();
        standardFoodItems.clear();
        standardFoodTags.clear();
        stealableItems.clear();
        stealableTags.clear();
        buffFoodItems.clear();
        buffFoodTags.clear();
        shoulderMountItems.clear();
        shoulderMountTags.clear();
        pouchUnlockItems.clear();
        pouchUnlockTags.clear();
        repeatableFoodItems.clear();
        repeatableFoodTags.clear();
        autoHealFoodItems.clear();
        autoHealFoodTags.clear();
        pouchAllowedItems.clear();
        pouchAllowedTags.clear();
        pouchDisallowedItems.clear();
        pouchDisallowedTags.clear();
    }
}

