/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.block.custom;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Stream;
import net.dawson.adorablehamsterpets.advancement.criterion.ModCriteria;
import net.dawson.adorablehamsterpets.block.ModBlockEntities;
import net.dawson.adorablehamsterpets.block.custom.WoodVariant;
import net.dawson.adorablehamsterpets.block.entity.HamsterBedBlockEntity;
import net.dawson.adorablehamsterpets.config.ConfigDataCache;
import net.dawson.adorablehamsterpets.config.Configs;
import net.dawson.adorablehamsterpets.config.WanderDistance;
import net.dawson.adorablehamsterpets.entity.custom.HamsterEntity;
import net.dawson.adorablehamsterpets.item.ModItems;
import net.dawson.adorablehamsterpets.particles.ModParticles;
import net.dawson.adorablehamsterpets.sound.ModSounds;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2464;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4208;
import net.minecraft.class_4970;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5558;
import net.minecraft.class_8567;
import org.jetbrains.annotations.Nullable;

public class HamsterBedBlock
extends class_2237
implements class_2343 {
    public static final class_2746 OCCUPIED = class_2746.method_11825((String)"occupied");
    public static final class_2746 UPSIDE_DOWN = class_2746.method_11825((String)"upside_down");
    public static final class_2753 ORIENTATION = class_2753.method_11844((String)"orientation", dir -> dir.method_10166().method_10179());
    public static final class_2754<WoodVariant> WOOD_VARIANT = class_2754.method_11850((String)"wood_variant", WoodVariant.class);
    private static final class_265 SHAPE_NORMAL = Stream.of(class_2248.method_9541((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)1.0, (double)15.0), class_2248.method_9541((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)3.0, (double)2.0), class_2248.method_9541((double)1.0, (double)0.0, (double)14.0, (double)15.0, (double)3.0, (double)15.0), class_2248.method_9541((double)1.0, (double)0.0, (double)2.0, (double)2.0, (double)3.0, (double)14.0), class_2248.method_9541((double)14.0, (double)0.0, (double)2.0, (double)15.0, (double)3.0, (double)14.0)).reduce(class_259::method_1084).get();
    private static final class_265 SHAPE_UPSIDE_DOWN = Stream.of(class_2248.method_9541((double)1.0, (double)15.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0), class_2248.method_9541((double)1.0, (double)13.0, (double)1.0, (double)15.0, (double)16.0, (double)2.0), class_2248.method_9541((double)1.0, (double)13.0, (double)14.0, (double)15.0, (double)16.0, (double)15.0), class_2248.method_9541((double)1.0, (double)13.0, (double)2.0, (double)2.0, (double)16.0, (double)14.0), class_2248.method_9541((double)14.0, (double)13.0, (double)2.0, (double)15.0, (double)16.0, (double)14.0)).reduce(class_259::method_1084).get();

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return (Boolean)state.method_11654((class_2769)UPSIDE_DOWN) != false ? SHAPE_UPSIDE_DOWN : SHAPE_NORMAL;
    }

    public class_265 method_9549(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return (Boolean)state.method_11654((class_2769)UPSIDE_DOWN) != false ? SHAPE_UPSIDE_DOWN : SHAPE_NORMAL;
    }

    public HamsterBedBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.method_9595().method_11664()).method_11657((class_2769)OCCUPIED, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)UPSIDE_DOWN, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)ORIENTATION, (Comparable)class_2350.field_11043)).method_11657(WOOD_VARIANT, (Comparable)((Object)WoodVariant.OAK)));
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new HamsterBedBlockEntity(pos, state);
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{OCCUPIED, UPSIDE_DOWN, ORIENTATION, WOOD_VARIANT});
    }

    public class_2680 method_9605(class_1750 ctx) {
        boolean isUpsideDown = ctx.method_8038() == class_2350.field_11033;
        WoodVariant variant = WoodVariant.OAK;
        class_1799 stack = ctx.method_8041();
        if (stack.method_7985() && stack.method_7969().method_10545("WoodVariant")) {
            try {
                variant = WoodVariant.valueOf(stack.method_7969().method_10558("WoodVariant"));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        class_2338 pos = ctx.method_8037();
        long s = pos.method_10063() ^ 0x9E3779B97F4A7C15L;
        s ^= s >>> 30;
        s *= -4658895280553007687L;
        s ^= s >>> 27;
        s *= -7723592293110705685L;
        s ^= s >>> 31;
        int idx = (int)(s & 3L);
        class_2350 direction = class_2350.method_10139((int)idx);
        return (class_2680)((class_2680)((class_2680)((class_2680)this.method_9564().method_11657((class_2769)OCCUPIED, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)UPSIDE_DOWN, (Comparable)Boolean.valueOf(isUpsideDown))).method_11657((class_2769)ORIENTATION, (Comparable)direction)).method_11657(WOOD_VARIANT, (Comparable)((Object)variant));
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11456;
    }

    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 itemStack) {
        super.method_9567(world, pos, state, placer, itemStack);
        if (!world.field_9236) {
            HamsterBedBlockEntity bedEntity;
            class_2586 be = world.method_8321(pos);
            if (be instanceof HamsterBedBlockEntity) {
                class_2487 nbt;
                bedEntity = (HamsterBedBlockEntity)be;
                if (((Boolean)state.method_11654((class_2769)UPSIDE_DOWN)).booleanValue()) {
                    bedEntity.setAllowSleep(false);
                    if (placer instanceof class_3222) {
                        class_3222 serverPlayer = (class_3222)placer;
                        ModCriteria.HAMSTER_BED_PLACED_UPSIDE_DOWN.trigger(serverPlayer);
                    }
                }
                if (itemStack.method_7985() && (nbt = itemStack.method_7969()).method_10545("LinkedHamsterUuid")) {
                    UUID hamsterUuid = nbt.method_25926("LinkedHamsterUuid");
                    class_5250 hamsterName = null;
                    if (nbt.method_10545("LinkedHamsterName")) {
                        hamsterName = class_2561.class_2562.method_10877((String)nbt.method_10558("LinkedHamsterName"));
                    }
                    WanderDistance wanderDistance = (WanderDistance)((Object)Configs.AHP.defaultWanderDistance.get());
                    if (nbt.method_10545("WanderDistance")) {
                        try {
                            wanderDistance = WanderDistance.valueOf(nbt.method_10558("WanderDistance"));
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            // empty catch block
                        }
                    }
                    bedEntity.setLinkedHamster(hamsterUuid, (class_2561)(hamsterName != null ? hamsterName : class_2561.method_43470((String)"Hamster")), wanderDistance);
                    class_1297 entity = ((class_3218)world).method_14190(hamsterUuid);
                    if (entity instanceof HamsterEntity) {
                        HamsterEntity hamster = (HamsterEntity)entity;
                        hamster.setLinkedBedPos(Optional.of(class_4208.method_19443((class_5321)world.method_27983(), (class_2338)pos)));
                        hamster.setWanderModeActive(true);
                    }
                }
            }
            if (be instanceof HamsterBedBlockEntity) {
                bedEntity = (HamsterBedBlockEntity)be;
                bedEntity.triggerAnim("hamster_bed_controller", "anim_bed_being_placed");
            }
        }
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        if (world.field_9236) {
            class_1799 heldStack = player.method_5998(hand);
            boolean isLureItem = ConfigDataCache.isLureItem(heldStack);
            boolean isAvoidanceItem = ConfigDataCache.isBedAvoidanceFood(heldStack);
            return isLureItem || isAvoidanceItem ? class_1269.field_5812 : class_1269.field_21466;
        }
        class_2586 be = world.method_8321(pos);
        if (be instanceof HamsterBedBlockEntity) {
            HamsterBedBlockEntity bedEntity = (HamsterBedBlockEntity)be;
            if (((Boolean)state.method_11654((class_2769)OCCUPIED)).booleanValue()) {
                bedEntity.triggerAnim("hamster_bed_controller", "anim_bed_interact_occupied");
            } else {
                bedEntity.triggerAnim("hamster_bed_controller", "anim_bed_interact_unoccupied");
            }
            ((class_3218)world).method_14199((class_2394)ModParticles.getForVariant((WoodVariant)((Object)state.method_11654(WOOD_VARIANT))), (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.2, (double)pos.method_10260() + 0.5, 30, 0.1, 0.1, 0.1, 0.0);
            class_3414 rustleSound = ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_BED_LEAVES_RUSTLE_SOUNDS, world.method_8409());
            if (rustleSound != null) {
                world.method_8396(null, pos, rustleSound, class_3419.field_15245, 0.2f, 1.8f);
            }
            class_1799 heldStack = player.method_5998(hand);
            if (player.method_5715() && ConfigDataCache.isBedAvoidanceFood(heldStack)) {
                bedEntity.unlinkHamster(player);
                return class_1269.field_5812;
            }
            if (ConfigDataCache.isBedAvoidanceFood(heldStack)) {
                if (((Boolean)state.method_11654((class_2769)OCCUPIED)).booleanValue()) {
                    bedEntity.getLinkedHamsterUuid().ifPresent(uuid -> {
                        HamsterEntity hamster;
                        class_1297 entity = ((class_3218)world).method_14190(uuid);
                        if (entity instanceof HamsterEntity && (hamster = (HamsterEntity)entity).method_6113()) {
                            hamster.wakeUpFromBed(true);
                        }
                    });
                }
                bedEntity.applyRepellentEffect();
                player.method_7353((class_2561)class_2561.method_43471((String)"message.adorablehamsterpets.bed_repellent_applied").method_27692(class_124.field_1061), true);
                world.method_8396(null, pos, class_3417.field_21074, class_3419.field_15245, 1.2f, 0.8f);
                ((class_3218)world).method_14199((class_2394)class_2398.field_11251, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.7, (double)pos.method_10260() + 0.5, 15, 0.4, 0.3, 0.4, 0.01);
                if (!player.method_31549().field_7477) {
                    heldStack.method_7934(1);
                }
                return class_1269.field_5812;
            }
            if (ConfigDataCache.isLureItem(heldStack)) {
                boolean wasRepellentActive;
                if (((Boolean)state.method_11654((class_2769)UPSIDE_DOWN)).booleanValue()) {
                    player.method_7353((class_2561)class_2561.method_43471((String)"message.adorablehamsterpets.bed_upside_down_lure_fail").method_27692(class_124.field_1061), true);
                    world.method_8396(null, pos, class_3417.field_14701, class_3419.field_15245, 0.5f, 1.5f);
                    return class_1269.field_5812;
                }
                boolean bl = wasRepellentActive = !bedEntity.isSleepingAllowed();
                if (wasRepellentActive) {
                    bedEntity.setAllowSleep(true);
                }
                boolean lureWasSuccessful = bedEntity.lureHamsterToBed(player, heldStack);
                if (wasRepellentActive) {
                    player.method_7353((class_2561)class_2561.method_43471((String)"message.adorablehamsterpets.bed_repellent_removed").method_27692(class_124.field_1060), true);
                } else if (lureWasSuccessful) {
                    bedEntity.getLinkedHamsterName().ifPresent(name -> player.method_7353((class_2561)class_2561.method_43469((String)"message.adorablehamsterpets.lure_to_bed_success", (Object[])new Object[]{name}), true));
                }
                if (!player.method_31549().field_7477 && Configs.AHP.consumeLureItem) {
                    heldStack.method_7934(1);
                }
                return class_1269.field_5812;
            }
            if (player.method_5715()) {
                bedEntity.cycleWanderDistance(player);
                return class_1269.field_5812;
            }
            bedEntity.toggleWanderMode(player);
            return class_1269.field_5812;
        }
        return class_1269.field_5814;
    }

    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        if (!state.method_27852(newState.method_26204()) && !world.method_8608()) {
            class_3414 rustleSound = ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_BED_LEAVES_RUSTLE_SOUNDS, world.method_8409());
            if (rustleSound != null) {
                world.method_8396(null, pos, rustleSound, class_3419.field_15245, 0.3f, 1.5f);
            }
            ((class_3218)world).method_14199((class_2394)ModParticles.getForVariant((WoodVariant)((Object)state.method_11654(WOOD_VARIANT))), (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.2, (double)pos.method_10260() + 0.5, 30, 0.1, 0.1, 0.1, 0.0);
            class_2586 blockEntity = world.method_8321(pos);
            if (blockEntity instanceof HamsterBedBlockEntity) {
                HamsterBedBlockEntity bedEntity = (HamsterBedBlockEntity)blockEntity;
                class_3218 serverWorld = (class_3218)world;
                bedEntity.getLinkedHamsterUuid().ifPresent(uuid -> {
                    class_1297 entity = serverWorld.method_14190(uuid);
                    if (entity instanceof HamsterEntity) {
                        class_1309 patt15960$temp;
                        HamsterEntity hamster = (HamsterEntity)entity;
                        hamster.setWanderModeActive(false);
                        hamster.setLinkedBedPos(Optional.empty());
                        if (hamster.method_6113()) {
                            hamster.wakeUpFromBed(true);
                        }
                        if ((patt15960$temp = hamster.method_35057()) instanceof class_1657) {
                            class_1657 owner = (class_1657)patt15960$temp;
                            if (Configs.AHP.enableBedBreakMessage) {
                                owner.method_7353((class_2561)class_2561.method_43471((String)"message.adorablehamsterpets.bed_broken").method_27692(class_124.field_1061), true);
                            }
                        }
                    }
                });
            }
        }
        super.method_9536(state, world, pos, newState, moved);
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        if (world.method_8608()) {
            return HamsterBedBlock.method_31618(type, (class_2591)((class_2591)ModBlockEntities.HAMSTER_BED_BLOCK_ENTITY.get()), (world1, pos, state1, be) -> {
                if (((Boolean)state1.method_11654((class_2769)UPSIDE_DOWN)).booleanValue() && world1.field_9229.method_43048(35) == 0) {
                    double x = (double)pos.method_10263() + world1.field_9229.method_43058();
                    double y = (double)pos.method_10264() + 0.6;
                    double z = (double)pos.method_10260() + world1.field_9229.method_43058();
                    world1.method_8406((class_2394)ModParticles.getForVariant((WoodVariant)((Object)((Object)state1.method_11654(WOOD_VARIANT)))), x, y, z, 0.0, -1.23E-4, 0.0);
                }
            });
        }
        return null;
    }

    public class_1799 method_9574(class_1922 world, class_2338 pos, class_2680 state) {
        WoodVariant variant = (WoodVariant)((Object)state.method_11654(WOOD_VARIANT));
        class_1792 item = (class_1792)ModItems.HAMSTER_BED_ITEMS.get((Object)variant).get();
        return new class_1799((class_1935)item);
    }

    public List<class_1799> method_9560(class_2680 state, class_8567.class_8568 builder) {
        WoodVariant variant = (WoodVariant)((Object)state.method_11654(WOOD_VARIANT));
        class_1792 itemToDrop = (class_1792)ModItems.HAMSTER_BED_ITEMS.get((Object)variant).get();
        class_1799 stack = new class_1799((class_1935)itemToDrop);
        class_2586 blockEntity = (class_2586)builder.method_51873(class_181.field_1228);
        if (blockEntity instanceof HamsterBedBlockEntity) {
            HamsterBedBlockEntity bedEntity = (HamsterBedBlockEntity)blockEntity;
            class_2487 nbt = stack.method_7948();
            bedEntity.getLinkedHamsterUuid().ifPresent(uuid -> nbt.method_25927("LinkedHamsterUuid", uuid));
            bedEntity.getLinkedHamsterName().ifPresent(name -> nbt.method_10582("LinkedHamsterName", class_2561.class_2562.method_10867((class_2561)name)));
            nbt.method_10582("WanderDistance", bedEntity.getWanderDistance().method_15434());
        }
        return List.of(stack);
    }
}

