/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.client.announcements;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.architectury.platform.Platform;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.dawson.adorablehamsterpets.AdorableHamsterPets;
import net.dawson.adorablehamsterpets.client.announcements.Announcement;
import net.dawson.adorablehamsterpets.client.announcements.AnnouncementManifest;
import net.dawson.adorablehamsterpets.client.announcements.ClientAnnouncementState;
import net.dawson.adorablehamsterpets.client.announcements.PatchouliIntegration;
import net.dawson.adorablehamsterpets.client.announcements.Semver;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.slf4j.Logger;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.client.book.ClientBookRegistry;
import vazkii.patchouli.common.book.Book;
import vazkii.patchouli.common.book.BookRegistry;

public class AnnouncementManager {
    public static final AnnouncementManager INSTANCE = new AnnouncementManager();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String GITHUB_RAW_URL = "https://raw.githubusercontent.com/DawsonBodenhamer/AdorableHamsterPets-Public/main/announcements/";
    private ClientAnnouncementState clientState;
    private AnnouncementManifest manifest;
    private boolean initialized = false;
    private boolean hasRefreshedThisSession = false;
    private boolean manifestJustLoaded = false;
    private boolean manifestLoaded = false;
    private HttpClient httpClient;
    private CompletableFuture<Void> activeRefreshFuture = CompletableFuture.completedFuture(null);
    private final Set<String> sessionSnoozedIds = new HashSet<String>();
    private final Set<class_2960> deferredReadMarks = new HashSet<class_2960>();
    private boolean patchouliStateSynced = false;
    private Path stateFilePath;
    private Path manifestCacheFilePath;

    public static class_2561 getTooltipTextForNotification(PendingNotification notification) {
        return switch (notification.reason()) {
            case "update_available_announcement" -> class_2561.method_43469((String)"tooltip.adorablehamsterpets.hud.update_available_announcement", (Object[])new Object[]{notification.announcement().semver()});
            case "regular_announcement" -> class_2561.method_43471((String)"tooltip.adorablehamsterpets.hud.regular_announcement");
            default -> class_2561.method_43469((String)"tooltip.adorablehamsterpets.hud.whats_new", (Object[])new Object[]{notification.announcement().semver()});
        };
    }

    private AnnouncementManager() {
        this.clientState = ClientAnnouncementState.createDefault();
        this.manifest = AnnouncementManifest.empty();
    }

    public CompletableFuture<Void> refreshManifestOnce() {
        this.ensureInitialized();
        if (!this.hasRefreshedThisSession) {
            this.hasRefreshedThisSession = true;
            return this.refreshManifest();
        }
        return this.activeRefreshFuture;
    }

    public CompletableFuture<String> fetchMarkdown(String relativePath) {
        this.ensureInitialized();
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(GITHUB_RAW_URL + relativePath)).GET().build();
        return ((CompletableFuture)this.httpClient.sendAsync(request, HttpResponse.BodyHandlers.ofString()).thenApply(response -> {
            if (response.statusCode() == 200) {
                return (String)response.body();
            }
            AdorableHamsterPets.LOGGER.warn("Failed to fetch markdown from '{}', status code: {}", (Object)relativePath, (Object)response.statusCode());
            return "# Oops! Looks like you're offline.\n\nThere was supposed to be a really fancy announcement message here, but that requires a teensy bit of internet connection.\n\nYou can always [join the Discord](https://discord.gg/w54mk5bqdf) to see the latest announcements there!\n";
        })).exceptionally(e -> {
            AdorableHamsterPets.LOGGER.error("Exception while fetching markdown from '" + relativePath + "'", e);
            return "# Oops! Looks like you're offline.\n\nThere was supposed to be a really fancy announcement message here, but that requires a teensy bit of internet connection.\n\nYou can always [join the Discord](https://discord.gg/w54mk5bqdf) to see the latest announcements there!\n";
        });
    }

    public List<PendingNotification> getPendingNotifications() {
        boolean newUpdateAvailable;
        this.ensureInitialized();
        if (!this.manifestLoaded) {
            return Collections.emptyList();
        }
        AdorableHamsterPets.LOGGER.trace("[Announcements] Running getPendingNotifications check...");
        ArrayList<PendingNotification> pending = new ArrayList<PendingNotification>();
        if (this.manifest == null || this.manifest.messages().isEmpty()) {
            AdorableHamsterPets.LOGGER.error("[Announcements] -> Check failed: Manifest is null or empty.");
            return pending;
        }
        Semver installedVersion = Semver.parse(Platform.getMod((String)"adorablehamsterpets").getVersion().toString());
        Semver latestVersion = Semver.parse(this.manifest.latest_version());
        Semver lastAckVersion = Semver.parse(this.clientState.last_acknowledged_update());
        Instant now = Instant.now();
        AdorableHamsterPets.LOGGER.trace("[Announcements] -> Versions: Installed={}, Latest={}, LastAck={}", new Object[]{installedVersion, latestVersion, lastAckVersion});
        AdorableHamsterPets.LOGGER.trace("[Announcements] -> Snooze IDs: {}.", this.clientState.snoozed_ids());
        boolean bl = newUpdateAvailable = installedVersion.compareTo(latestVersion) < 0;
        if (newUpdateAvailable) {
            this.manifest.messages().stream().filter(a -> "update".equals(a.kind()) && latestVersion.toString().equals(a.semver())).filter(a -> !this.clientState.seen_ids().contains(a.id()) && !this.clientState.snoozed_ids().getOrDefault(a.id(), Instant.EPOCH).isAfter(now) && !this.sessionSnoozedIds.contains(a.id())).findFirst().ifPresent(announcement -> {
                pending.add(new PendingNotification("update_available_announcement", (Announcement)announcement));
                AdorableHamsterPets.LOGGER.trace("[Announcements] -> ADDED (Update Available): id='{}', semver='{}'", (Object)announcement.id(), (Object)announcement.semver());
            });
        }
        AdorableHamsterPets.LOGGER.trace("[Announcements] -> Scanning all {} messages for other notifications...", (Object)this.manifest.messages().size());
        for (Announcement message : this.manifest.messages()) {
            boolean alreadyPendingAsUpdate;
            boolean isUnacknowledged;
            if (this.clientState.seen_ids().contains(message.id()) || this.clientState.snoozed_ids().getOrDefault(message.id(), Instant.EPOCH).isAfter(now) || this.sessionSnoozedIds.contains(message.id())) continue;
            Semver messageVersion = Semver.parse(message.semver());
            if ("announcement".equals(message.kind())) {
                pending.add(new PendingNotification("regular_announcement", message));
                AdorableHamsterPets.LOGGER.trace("[Announcements] -> ADDED (Optional Announcement): id='{}'", (Object)message.id());
                continue;
            }
            if (!"update".equals(message.kind())) continue;
            boolean versionIsRelevant = messageVersion.compareTo(installedVersion) <= 0;
            boolean bl2 = isUnacknowledged = messageVersion.compareTo(lastAckVersion) > 0;
            if (!versionIsRelevant || !isUnacknowledged) continue;
            boolean bl3 = alreadyPendingAsUpdate = newUpdateAvailable && message.semver().equals(latestVersion.toString());
            if (!alreadyPendingAsUpdate) {
                pending.add(new PendingNotification("whats_new_announcement", message));
                AdorableHamsterPets.LOGGER.trace("[Announcements] -> ADDED (What's New): id='{}', semver='{}'", (Object)message.id(), (Object)message.semver());
                continue;
            }
            AdorableHamsterPets.LOGGER.trace("[Announcements] -> SKIPPED (Duplicate Update): id='{}'", (Object)message.id());
        }
        pending.sort(Comparator.comparing(p -> p.announcement().published()).reversed());
        AdorableHamsterPets.LOGGER.trace("[Announcements] -> Final pending count: {}", (Object)pending.size());
        return pending;
    }

    public ClientAnnouncementState getClientState() {
        this.ensureInitialized();
        return this.clientState;
    }

    public Announcement getAnnouncementById(String id) {
        this.ensureInitialized();
        return this.manifest.messages().stream().filter(a -> a.id().equals(id)).findFirst().orElse(null);
    }

    public List<Announcement> getAllManifestMessages() {
        this.ensureInitialized();
        return this.manifest != null ? this.manifest.messages() : List.of();
    }

    public String getCanonicalReasonForAnnouncement(String announcementId) {
        Semver latestVersion;
        this.ensureInitialized();
        Announcement announcement = this.getAnnouncementById(announcementId);
        if (announcement == null) {
            return "unknown";
        }
        Semver installedVersion = Semver.parse(Platform.getMod((String)"adorablehamsterpets").getVersion().toString());
        if (installedVersion.compareTo(latestVersion = Semver.parse(this.manifest.latest_version())) < 0 && announcement.semver().equals(latestVersion.toString())) {
            return "update_available_announcement";
        }
        if ("announcement".equals(announcement.kind())) {
            return "regular_announcement";
        }
        return announcement.kind();
    }

    public boolean isPatchouliStateSynced() {
        return this.patchouliStateSynced;
    }

    public void markAsSeen(String id) {
        this.ensureInitialized();
        HashSet<String> newSeenIds = new HashSet<String>(this.clientState.seen_ids());
        if (newSeenIds.add(id)) {
            this.clientState = new ClientAnnouncementState(newSeenIds, this.clientState.snoozed_ids(), this.clientState.last_acknowledged_update(), this.clientState.manifest_etag(), this.clientState.manifest_last_modified());
            this.saveState();
        }
    }

    public void markAllAsRead() {
        this.ensureInitialized();
        Book book = (Book)BookRegistry.INSTANCE.books.get(class_2960.method_43902((String)"adorablehamsterpets", (String)"hamster_tips_guide_book"));
        if (book == null) {
            AdorableHamsterPets.LOGGER.error("[Announcements] Could not mark all as read: Hamster Tips book not found.");
            return;
        }
        HashSet<String> newSeenIds = new HashSet<String>(this.clientState.seen_ids());
        boolean changed = false;
        for (Announcement announcement : this.getAllManifestMessages()) {
            class_2960 entryId;
            BookEntry entry;
            if (newSeenIds.add(announcement.id())) {
                changed = true;
            }
            if ("update".equals(announcement.kind())) {
                this.setLastAcknowledgedUpdate(announcement.semver());
            }
            if ((entry = (BookEntry)book.getContents().entries.get(entryId = class_2960.method_43902((String)"adorablehamsterpets", (String)("announcement_" + announcement.id())))) == null) continue;
            PatchouliIntegration.setEntryAsRead(entry);
        }
        if (changed) {
            this.clientState = new ClientAnnouncementState(newSeenIds, this.clientState.snoozed_ids(), this.clientState.last_acknowledged_update(), this.clientState.manifest_etag(), this.clientState.manifest_last_modified());
            this.saveState();
            AdorableHamsterPets.LOGGER.info("Marked all announcements as read via config action.");
        }
    }

    public void setLastAcknowledgedUpdate(String version) {
        this.ensureInitialized();
        Semver currentAck = Semver.parse(this.clientState.last_acknowledged_update());
        Semver newAck = Semver.parse(version);
        if (newAck.compareTo(currentAck) > 0) {
            this.clientState = new ClientAnnouncementState(this.clientState.seen_ids(), this.clientState.snoozed_ids(), newAck.toString(), this.clientState.manifest_etag(), this.clientState.manifest_last_modified());
            this.saveState();
        }
    }

    public void setSnooze(String id, int days) {
        this.ensureInitialized();
        Instant snoozeUntil = Instant.now().plus((long)days, ChronoUnit.DAYS);
        HashMap<String, Instant> newSnoozedIds = new HashMap<String, Instant>(this.clientState.snoozed_ids());
        newSnoozedIds.put(id, snoozeUntil);
        this.clientState = new ClientAnnouncementState(this.clientState.seen_ids(), newSnoozedIds, this.clientState.last_acknowledged_update(), this.clientState.manifest_etag(), this.clientState.manifest_last_modified());
        this.saveState();
    }

    public void snoozeForSession(String id) {
        this.ensureInitialized();
        this.sessionSnoozedIds.add(id);
    }

    public void resetClientState() {
        this.ensureInitialized();
        this.clientState = ClientAnnouncementState.createDefault();
        this.saveState();
        PatchouliIntegration.clearAllVirtualEntriesFromHistory();
        AdorableHamsterPets.LOGGER.info("Client announcement state has been reset.");
    }

    public void queueDeferredReadMark(class_2960 entryId) {
        this.ensureInitialized();
        this.deferredReadMarks.add(entryId);
        AdorableHamsterPets.LOGGER.trace("[Announcements] Queued deferred read mark for entry: {}", (Object)entryId);
    }

    public void processDeferredReadMarks() {
        this.ensureInitialized();
        if (this.deferredReadMarks.isEmpty()) {
            return;
        }
        AdorableHamsterPets.LOGGER.trace("[Announcements] Processing {} deferred read marks...", (Object)this.deferredReadMarks.size());
        Book book = (Book)BookRegistry.INSTANCE.books.get(class_2960.method_43902((String)"adorablehamsterpets", (String)"hamster_tips_guide_book"));
        if (book == null) {
            AdorableHamsterPets.LOGGER.error("[Announcements] Could not process deferred read marks: Hamster Tips book not found.");
            return;
        }
        int successCount = 0;
        for (class_2960 entryId : this.deferredReadMarks) {
            BookEntry entry = (BookEntry)book.getContents().entries.get(entryId);
            if (entry != null) {
                PatchouliIntegration.setEntryAsRead(entry);
                ++successCount;
                continue;
            }
            AdorableHamsterPets.LOGGER.warn("[Announcements] Could not find virtual entry for deferred read mark: {}", (Object)entryId);
        }
        if (successCount > 0) {
            AdorableHamsterPets.LOGGER.trace("[Announcements] Successfully processed {} deferred read marks.", (Object)successCount);
        }
        this.deferredReadMarks.clear();
    }

    private void initialize() {
        AdorableHamsterPets.LOGGER.trace("[Announcements] Initializing AnnouncementManager...");
        this.httpClient = HttpClient.newHttpClient();
        Path configDir = Platform.getConfigFolder().resolve("adorablehamsterpets");
        this.stateFilePath = configDir.resolve("announcements.json");
        this.manifestCacheFilePath = configDir.resolve("manifest.cache.json");
        AdorableHamsterPets.LOGGER.trace("[Announcements] State file path resolved to: {}", (Object)this.stateFilePath.toAbsolutePath());
        try {
            Files.createDirectories(configDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            AdorableHamsterPets.LOGGER.error("[Announcements] CRITICAL: Failed to create config directory for announcements at {}", (Object)configDir.toAbsolutePath(), (Object)e);
        }
        this.loadState();
        this.loadCachedManifest();
        this.processExpiredSnoozes();
        AdorableHamsterPets.LOGGER.trace("[Announcements] Initialization complete.");
    }

    private void ensureInitialized() {
        if (!this.initialized) {
            this.initialize();
            this.initialized = true;
        }
    }

    public void acknowledgeManifestLoad() {
        this.ensureInitialized();
        this.manifestJustLoaded = false;
    }

    public CompletableFuture<Void> refreshManifest() {
        this.ensureInitialized();
        if (!this.activeRefreshFuture.isDone()) {
            return this.activeRefreshFuture;
        }
        HttpRequest.Builder requestBuilder = HttpRequest.newBuilder().uri(URI.create("https://raw.githubusercontent.com/DawsonBodenhamer/AdorableHamsterPets-Public/main/announcements/manifest.json")).GET();
        this.clientState.manifest_etag().ifPresent(etag -> requestBuilder.header("If-None-Match", (String)etag));
        this.clientState.manifest_last_modified().ifPresent(lastModified -> requestBuilder.header("If-Modified-Since", (String)lastModified));
        this.activeRefreshFuture = ((CompletableFuture)this.httpClient.sendAsync(requestBuilder.build(), HttpResponse.BodyHandlers.ofString()).thenAccept(response -> {
            AdorableHamsterPets.LOGGER.trace("[Announcements] Manifest fetch completed with status code {}. Current screen: {}", (Object)response.statusCode(), (Object)class_310.method_1551().field_1755);
            if (response.statusCode() == 200) {
                AdorableHamsterPets.LOGGER.trace("[Announcements] Fetched new manifest.");
                AnnouncementManifest.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)((JsonElement)GSON.fromJson((String)response.body(), JsonElement.class))).resultOrPartial(arg_0 -> ((Logger)AdorableHamsterPets.LOGGER).error(arg_0)).ifPresent(newManifest -> {
                    this.manifest = newManifest;
                    this.manifestLoaded = true;
                    this.saveManifestToCache();
                    Optional<String> etag = response.headers().firstValue("ETag");
                    Optional<String> lastModified = response.headers().firstValue("Last-Modified");
                    this.clientState = new ClientAnnouncementState(this.clientState.seen_ids(), this.clientState.snoozed_ids(), this.clientState.last_acknowledged_update(), etag, lastModified);
                    this.saveState();
                    this.manifestJustLoaded = true;
                    if (class_310.method_1551().field_1687 != null) {
                        class_310.method_1551().execute(() -> {
                            ClientBookRegistry.INSTANCE.reload();
                            this.acknowledgeManifestLoad();
                        });
                    }
                });
            } else if (response.statusCode() == 304) {
                AdorableHamsterPets.LOGGER.trace("[Announcements] Manifest is up to date (304 Not Modified).");
            } else {
                AdorableHamsterPets.LOGGER.warn("[Announcements] Failed to fetch manifest, status code: {}", (Object)response.statusCode());
            }
        })).exceptionally(e -> {
            AdorableHamsterPets.LOGGER.error("[Announcements] Exception while fetching manifest. Using cached version or offline fallback.", e);
            if (this.manifest == null || this.manifest.messages().isEmpty()) {
                this.manifest = this.createOfflineFallbackManifest();
                this.manifestLoaded = true;
                this.manifestJustLoaded = true;
                if (class_310.method_1551().field_1687 != null) {
                    class_310.method_1551().execute(() -> {
                        ClientBookRegistry.INSTANCE.reload();
                        this.acknowledgeManifestLoad();
                    });
                }
            }
            return null;
        });
        return this.activeRefreshFuture;
    }

    private void loadState() {
        AdorableHamsterPets.LOGGER.trace("[Announcements] Attempting to load state from {}...", (Object)this.stateFilePath.toAbsolutePath());
        if (Files.exists(this.stateFilePath, new LinkOption[0])) {
            AdorableHamsterPets.LOGGER.trace("[Announcements] announcements.json found. Reading file.");
            try (FileReader reader = new FileReader(this.stateFilePath.toFile());){
                ClientAnnouncementState.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)((JsonElement)GSON.fromJson((Reader)reader, JsonElement.class))).resultOrPartial(arg_0 -> ((Logger)AdorableHamsterPets.LOGGER).error(arg_0)).ifPresent(state -> {
                    this.clientState = state;
                });
            }
            catch (IOException e) {
                AdorableHamsterPets.LOGGER.error("[Announcements] CRITICAL: Failed to load announcement state from existing file.", (Throwable)e);
            }
        } else {
            AdorableHamsterPets.LOGGER.trace("[Announcements] announcements.json not found. Creating default state file.");
            this.saveState();
        }
    }

    private void saveState() {
        AdorableHamsterPets.LOGGER.trace("[Announcements] Attempting to save state...");
        ClientAnnouncementState.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this.clientState).resultOrPartial(error -> AdorableHamsterPets.LOGGER.error("[Announcements] CRITICAL: Failed to encode client state to JSON: {}", error)).ifPresent(jsonElement -> {
            AdorableHamsterPets.LOGGER.trace("[Announcements] State encoded successfully. Writing to file: {}", (Object)this.stateFilePath.toAbsolutePath());
            try (FileWriter writer = new FileWriter(this.stateFilePath.toFile());){
                GSON.toJson(jsonElement, (Appendable)writer);
                AdorableHamsterPets.LOGGER.trace("[Announcements] Successfully saved announcement state.");
            }
            catch (IOException e) {
                AdorableHamsterPets.LOGGER.error("[Announcements] CRITICAL: FAILED TO SAVE ANNOUNCEMENT STATE TO FILE.", (Throwable)e);
            }
        });
    }

    private void loadCachedManifest() {
        if (Files.exists(this.manifestCacheFilePath, new LinkOption[0])) {
            try (FileReader reader = new FileReader(this.manifestCacheFilePath.toFile());){
                AnnouncementManifest.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)((JsonElement)GSON.fromJson((Reader)reader, JsonElement.class))).resultOrPartial(arg_0 -> ((Logger)AdorableHamsterPets.LOGGER).error(arg_0)).ifPresent(cachedManifest -> {
                    this.manifest = cachedManifest;
                    this.manifestLoaded = true;
                    AdorableHamsterPets.LOGGER.trace("[Announcements] Loaded cached manifest with {} messages.", (Object)this.manifest.messages().size());
                });
            }
            catch (IOException e) {
                AdorableHamsterPets.LOGGER.error("[Announcements] Failed to load cached manifest.", (Throwable)e);
            }
        }
    }

    private void saveManifestToCache() {
        AnnouncementManifest.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this.manifest).resultOrPartial(error -> AdorableHamsterPets.LOGGER.error("[Announcements] Failed to encode manifest for caching: {}", error)).ifPresent(jsonElement -> {
            try (FileWriter writer = new FileWriter(this.manifestCacheFilePath.toFile());){
                GSON.toJson(jsonElement, (Appendable)writer);
                AdorableHamsterPets.LOGGER.trace("[Announcements] Successfully saved manifest to cache.");
            }
            catch (IOException e) {
                AdorableHamsterPets.LOGGER.error("[Announcements] FAILED TO SAVE MANIFEST TO CACHE.", (Throwable)e);
            }
        });
    }

    private void processExpiredSnoozes() {
        Instant now = Instant.now();
        HashMap<String, Instant> newSnoozedIds = new HashMap<String, Instant>(this.clientState.snoozed_ids());
        newSnoozedIds.entrySet().removeIf(entry -> {
            if (now.isAfter((Instant)entry.getValue())) {
                class_2960 entryId = class_2960.method_43902((String)"adorablehamsterpets", (String)("announcement_" + (String)entry.getKey()));
                PatchouliIntegration.setEntryAsUnread(entryId);
                return true;
            }
            return false;
        });
        if (newSnoozedIds.size() != this.clientState.snoozed_ids().size()) {
            this.clientState = new ClientAnnouncementState(this.clientState.seen_ids(), newSnoozedIds, this.clientState.last_acknowledged_update(), this.clientState.manifest_etag(), this.clientState.manifest_last_modified());
            this.saveState();
        }
    }

    public void syncPatchouliReadState() {
        this.ensureInitialized();
        class_2960 bookId = class_2960.method_43902((String)"adorablehamsterpets", (String)"hamster_tips_guide_book");
        Book book = (Book)BookRegistry.INSTANCE.books.get(bookId);
        if (book == null) {
            return;
        }
        this.patchouliStateSynced = true;
        AdorableHamsterPets.LOGGER.trace("[Announcements] Patchouli book found. Syncing read state...");
        List<PendingNotification> pendingNotifications = this.getPendingNotifications();
        if (pendingNotifications.isEmpty()) {
            AdorableHamsterPets.LOGGER.trace("[Announcements] -> No pending notifications to sync.");
            return;
        }
        AdorableHamsterPets.LOGGER.trace("[Announcements] -> Found {} pending notifications to sync.", (Object)pendingNotifications.size());
        for (PendingNotification notification : pendingNotifications) {
            class_2960 entryId = class_2960.method_43902((String)"adorablehamsterpets", (String)("announcement_" + notification.announcement().id()));
            AdorableHamsterPets.LOGGER.trace("[Announcements] -> Syncing entry: {}", (Object)entryId);
            boolean success = PatchouliIntegration.setEntryAsUnread(entryId);
            if (success) {
                AdorableHamsterPets.LOGGER.trace("[Announcements] -> Successfully marked {} as unread.", (Object)entryId);
                continue;
            }
            AdorableHamsterPets.LOGGER.error("[Announcements] -> Could not mark {} as unread (was it already unread?).", (Object)entryId);
        }
    }

    private Announcement createOfflineFallbackAnnouncement() {
        return new Announcement("offline-fallback", "No Internet Connection", "announcement", "0.0.0", "offline-fallback.md", ZonedDateTime.now());
    }

    private AnnouncementManifest createOfflineFallbackManifest() {
        return new AnnouncementManifest("0.0.0", List.of(this.createOfflineFallbackAnnouncement()));
    }

    public record PendingNotification(String reason, Announcement announcement) {
        public static final String UPDATE_AVAILABLE_ANNOUNCEMENT = "update_available_announcement";
        public static final String REGULAR_ANNOUNCEMENT = "regular_announcement";
        public static final String WHATS_NEW_ANNOUNCEMENT = "whats_new_announcement";
    }
}

