/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.client.gui;

import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_124;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import org.jetbrains.annotations.Nullable;

public class MarkdownRenderer {
    private static final Pattern BOLD_PATTERN = Pattern.compile("\\*\\*(.*?)\\*\\*");
    private static final Pattern ITALIC_PATTERN = Pattern.compile("\\*(.*?)\\*");
    private static final Pattern CODE_PATTERN = Pattern.compile("`(.*?)`");
    private static final Pattern LINK_PATTERN = Pattern.compile("\\[(.*?)]\\((.*?)\\)");
    public static final int LINE_SPACING = 2;
    public static final int HEADING_BOTTOM_MARGIN = 4;
    public static final int DIVIDER_HEIGHT = 13;
    public static final int LIST_INDENT = 10;
    public static final int SPACES_PER_INDENT_LEVEL = 4;
    private final class_327 textRenderer;
    public final List<String> lines;
    private final int x;
    private final int startY;
    public final int width;
    private int totalHeight = 0;

    public MarkdownRenderer(String markdownContent, int x, int startY, int width) {
        this.textRenderer = class_310.method_1551().field_1772;
        this.lines = markdownContent == null ? List.of() : List.of(markdownContent.split("\n"));
        this.x = x;
        this.startY = startY;
        this.width = width;
        this.calculateHeight(width);
    }

    public void render(class_332 context, int scrollY, @Nullable class_2583 hoveredStyle) {
        int currentY = this.startY - scrollY;
        for (String originalLine : this.lines) {
            String trimmedLine = originalLine.trim();
            if (trimmedLine.isEmpty()) {
                Objects.requireNonNull(this.textRenderer);
                currentY += 9 / 2;
                continue;
            }
            if (trimmedLine.startsWith("#")) {
                currentY = this.renderHeading(context, trimmedLine, currentY);
                continue;
            }
            if (trimmedLine.equals("---")) {
                currentY = this.renderDivider(context, currentY);
                continue;
            }
            if (trimmedLine.startsWith("- ") || trimmedLine.startsWith("* ") || trimmedLine.matches("^\\d+\\.\\s.*")) {
                currentY = this.renderListItem(context, originalLine, currentY, hoveredStyle);
                continue;
            }
            currentY = this.renderParagraph(context, trimmedLine, currentY, this.x, this.width, hoveredStyle);
        }
    }

    public int getTotalHeight() {
        return this.totalHeight;
    }

    public static int getIndentationLevel(String line) {
        int spaces = 0;
        for (char c : line.toCharArray()) {
            if (c != ' ') break;
            ++spaces;
        }
        return spaces / 4;
    }

    private int renderHeading(class_332 context, String line, int y) {
        int level;
        for (level = 0; level < line.length() && line.charAt(level) == '#'; ++level) {
        }
        String text = line.substring(level).trim();
        float scale = Math.max(1.0f, 2.0f - (float)(level - 1) * 0.25f);
        int color = 0x323232;
        class_5250 styledText = class_2561.method_43470((String)text).method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true)));
        int scaledWidth = (int)((float)this.width / scale);
        List wrappedLines = this.textRenderer.method_1728((class_5348)styledText, scaledWidth);
        class_4587 matrices = context.method_51448();
        for (class_5481 wrappedLine : wrappedLines) {
            matrices.method_22903();
            matrices.method_46416((float)this.x, (float)y, 0.0f);
            matrices.method_22905(scale, scale, 1.0f);
            context.method_51430(this.textRenderer, wrappedLine, 0, 0, color, false);
            matrices.method_22909();
            Objects.requireNonNull(this.textRenderer);
            y += (int)(9.0f * scale) + 2;
        }
        return y - 2 + 4;
    }

    private int renderDivider(class_332 context, int y) {
        context.method_25294(this.x + 15, y + 3, this.x + this.width - 15, y + 4, -5000269);
        return y + 13;
    }

    private int renderListItem(class_332 context, String line, int y, @Nullable class_2583 hoveredStyle) {
        String content;
        String bullet;
        int indentationLevel = MarkdownRenderer.getIndentationLevel(line);
        String trimmedLine = line.trim();
        if (trimmedLine.matches("^\\d+\\.\\s.*")) {
            int dotIndex = trimmedLine.indexOf(46);
            bullet = trimmedLine.substring(0, dotIndex + 1);
            content = trimmedLine.substring(dotIndex + 1).trim();
        } else {
            bullet = "\u2022";
            content = trimmedLine.substring(1).trim();
        }
        int bulletX = this.x + indentationLevel * 10;
        int contentX = bulletX + 10;
        int contentWidth = this.width - (indentationLevel + 1) * 10;
        context.method_51433(this.textRenderer, bullet, bulletX, y, 0x323232, false);
        return this.renderParagraph(context, content, y, contentX, contentWidth, hoveredStyle);
    }

    private int renderParagraph(class_332 context, String line, int y, int startX, int lineWidth, @Nullable class_2583 hoveredStyle) {
        int indentationLevel = MarkdownRenderer.getIndentationLevel(line);
        String content = line.substring(indentationLevel * 4);
        int finalStartX = startX + indentationLevel * 10;
        int finalLineWidth = lineWidth - indentationLevel * 10;
        class_5250 styledText = this.parseLineToText(content, hoveredStyle);
        List wrappedLines = this.textRenderer.method_1728((class_5348)styledText, finalLineWidth);
        for (class_5481 wrappedLine : wrappedLines) {
            context.method_51430(this.textRenderer, wrappedLine, finalStartX, y, 0x323232, false);
            Objects.requireNonNull(this.textRenderer);
            y += 9 + 2;
        }
        return y;
    }

    public class_5250 parseLineToText(String line, @Nullable class_2583 hoveredStyle) {
        class_5250 result = class_2561.method_43473();
        String remaining = line;
        while (!remaining.isEmpty()) {
            Matcher boldMatcher = BOLD_PATTERN.matcher(remaining);
            Matcher italicMatcher = ITALIC_PATTERN.matcher(remaining);
            Matcher codeMatcher = CODE_PATTERN.matcher(remaining);
            Matcher linkMatcher = LINK_PATTERN.matcher(remaining);
            int nextMatchPos = Integer.MAX_VALUE;
            Matcher nextMatcher = null;
            if (boldMatcher.find(0) && boldMatcher.start() < nextMatchPos) {
                nextMatchPos = boldMatcher.start();
                nextMatcher = boldMatcher;
            }
            if (italicMatcher.find(0) && italicMatcher.start() < nextMatchPos) {
                nextMatchPos = italicMatcher.start();
                nextMatcher = italicMatcher;
            }
            if (codeMatcher.find(0) && codeMatcher.start() < nextMatchPos) {
                nextMatchPos = codeMatcher.start();
                nextMatcher = codeMatcher;
            }
            if (linkMatcher.find(0) && linkMatcher.start() < nextMatchPos) {
                nextMatchPos = linkMatcher.start();
                nextMatcher = linkMatcher;
            }
            if (nextMatcher != null) {
                if (nextMatchPos > 0) {
                    result.method_10852((class_2561)class_2561.method_43470((String)remaining.substring(0, nextMatchPos)));
                }
                if (nextMatcher == boldMatcher) {
                    result.method_10852((class_2561)class_2561.method_43470((String)boldMatcher.group(1)).method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true))));
                } else if (nextMatcher == italicMatcher) {
                    result.method_10852((class_2561)class_2561.method_43470((String)italicMatcher.group(1)).method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(true))));
                } else if (nextMatcher == codeMatcher) {
                    result.method_10852((class_2561)class_2561.method_43470((String)codeMatcher.group(1)).method_10862(class_2583.field_24360.method_27704(class_2960.method_43902((String)"minecraft", (String)"uniform")).method_10977(class_124.field_1074)));
                } else if (nextMatcher == linkMatcher) {
                    class_2558 clickEvent;
                    String linkText = linkMatcher.group(1);
                    String url = linkMatcher.group(2);
                    if (url.startsWith("ahp://copy ")) {
                        String command = url.substring("ahp://copy ".length());
                        clickEvent = new class_2558(class_2558.class_2559.field_21462, command);
                    } else {
                        clickEvent = new class_2558(class_2558.class_2559.field_11749, url);
                    }
                    class_2583 linkStyle = class_2583.field_24360.method_10977(class_124.field_1075).method_30938(Boolean.valueOf(true)).method_10982(Boolean.valueOf(true)).method_10958(clickEvent);
                    if (hoveredStyle != null && hoveredStyle.method_10970() != null && hoveredStyle.method_10970().equals((Object)clickEvent)) {
                        linkStyle = linkStyle.method_10977(class_124.field_1065).method_30938(Boolean.valueOf(false)).method_10982(Boolean.valueOf(true));
                    }
                    result.method_10852((class_2561)class_2561.method_43470((String)linkText).method_10862(linkStyle));
                }
                remaining = remaining.substring(nextMatcher.end());
                continue;
            }
            result.method_10852((class_2561)class_2561.method_43470((String)remaining));
            break;
        }
        return result;
    }

    private void calculateHeight(int lineWidth) {
        int currentY = 0;
        for (String line : this.lines) {
            int contentWidth;
            String trimmedLine = line.trim();
            if (trimmedLine.isEmpty()) {
                Objects.requireNonNull(this.textRenderer);
                currentY += 9 / 2;
                continue;
            }
            if (trimmedLine.startsWith("#")) {
                int level;
                for (level = 0; level < trimmedLine.length() && trimmedLine.charAt(level) == '#'; ++level) {
                }
                String text = trimmedLine.substring(level).trim();
                float scale = Math.max(1.0f, 2.0f - (float)(level - 1) * 0.25f);
                int scaledWidth = (int)((float)lineWidth / scale);
                class_5250 styledText = class_2561.method_43470((String)text).method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true)));
                int wrappedLinesCount = this.textRenderer.method_1728((class_5348)styledText, scaledWidth).size();
                Objects.requireNonNull(this.textRenderer);
                int heightOfLines = wrappedLinesCount * (int)(9.0f * scale);
                int totalSpacing = Math.max(0, wrappedLinesCount - 1) * 2;
                currentY += heightOfLines + totalSpacing + 4;
                continue;
            }
            if (trimmedLine.equals("---")) {
                currentY += 13;
                continue;
            }
            int indentationLevel = MarkdownRenderer.getIndentationLevel(line);
            String content = trimmedLine;
            if (content.startsWith("- ") || content.startsWith("* ") || content.matches("^\\d+\\.\\s.*")) {
                contentWidth = lineWidth - (indentationLevel + 1) * 10;
                content = content.matches("^\\d+\\.\\s.*") ? content.substring(content.indexOf(46) + 1).trim() : content.substring(1).trim();
            } else {
                contentWidth = lineWidth - indentationLevel * 10;
            }
            class_5250 styledText = this.parseLineToText(content, null);
            int wrappedLinesCount = this.textRenderer.method_1728((class_5348)styledText, contentWidth).size();
            Objects.requireNonNull(this.textRenderer);
            currentY += wrappedLinesCount * (9 + 2);
        }
        this.totalHeight = currentY;
    }
}

