/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.client.gui.widgets;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.architectury.platform.Platform;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.dawson.adorablehamsterpets.AdorableHamsterPets;
import net.dawson.adorablehamsterpets.client.announcements.Announcement;
import net.dawson.adorablehamsterpets.client.announcements.AnnouncementManager;
import net.dawson.adorablehamsterpets.client.announcements.Semver;
import net.dawson.adorablehamsterpets.client.gui.AnnouncementScreen;
import net.dawson.adorablehamsterpets.client.gui.widgets.AnnouncementIconAnimator;
import net.dawson.adorablehamsterpets.config.AhpConfig;
import net.dawson.adorablehamsterpets.config.Configs;
import net.dawson.adorablehamsterpets.mixin.client.accessor.HandledScreenAccessor;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_442;
import net.minecraft.class_465;
import net.minecraft.class_481;
import net.minecraft.class_5250;
import net.minecraft.class_6880;
import net.minecraft.class_7833;
import vazkii.patchouli.api.PatchouliAPI;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.common.book.Book;
import vazkii.patchouli.common.book.BookRegistry;

public class AnnouncementIconWidget
extends class_4185 {
    private static final class_2960 ICON_TEXTURE = class_2960.method_43902((String)"adorablehamsterpets", (String)"textures/item/announcement_bell_icon.png");
    private static final int ICON_WIDTH = 16;
    private static final int ICON_HEIGHT = 16;
    private final class_437 parentScreen;
    private int lastTargetX = -1;
    private int lastTargetY = -1;

    public AnnouncementIconWidget(int x, int y, int width, int height, class_4185.class_4241 onPress, class_437 parentScreen) {
        super(x, y, width, height, (class_2561)class_2561.method_43473(), onPress, field_40754);
        this.parentScreen = parentScreen;
    }

    protected void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
        List<AnnouncementManager.PendingNotification> notifications;
        AnnouncementIconAnimator animator = AnnouncementIconAnimator.INSTANCE;
        class_437 class_4372 = this.parentScreen;
        if (class_4372 instanceof class_465) {
            int targetY;
            int targetX;
            int neoForgeCreativeModeOffset;
            class_465 containerScreen = (class_465)class_4372;
            HandledScreenAccessor accessor = (HandledScreenAccessor)containerScreen;
            int guiLeft = accessor.getX();
            int guiTop = accessor.getY();
            int guiWidth = accessor.getBackgroundWidth();
            int n2 = neoForgeCreativeModeOffset = Platform.isForge() ? -26 : 0;
            if (containerScreen instanceof class_481) {
                targetX = guiLeft + guiWidth - 22 + neoForgeCreativeModeOffset + (Integer)((AhpConfig.WidgetIconOffsets)Configs.AHP.creativeWidgetIconSettings.get()).offsetX.get();
                targetY = guiTop - 47 + (Integer)((AhpConfig.WidgetIconOffsets)Configs.AHP.creativeWidgetIconSettings.get()).offsetY.get();
            } else {
                targetX = guiLeft + guiWidth - this.field_22758 + 4 + (Integer)((AhpConfig.WidgetIconOffsets)Configs.AHP.survivalWidgetIconSettings.get()).offsetX.get();
                targetY = guiTop - 4 + (Integer)((AhpConfig.WidgetIconOffsets)Configs.AHP.survivalWidgetIconSettings.get()).offsetY.get();
            }
            if (targetX != this.lastTargetX || targetY != this.lastTargetY) {
                AnnouncementIconAnimator.INSTANCE.startTransition(targetX, targetY);
                this.lastTargetX = targetX;
                this.lastTargetY = targetY;
            }
        } else if (this.parentScreen instanceof class_442) {
            animator.updateTargetPosition(this.parentScreen.field_22789, this.parentScreen.field_22790);
        }
        animator.setHovered(this.method_49606());
        float animScale = animator.getRenderScale(delta);
        float configScale = ((Float)Configs.AHP.hudIconScale.get()).floatValue();
        float finalScale = animScale * configScale;
        float angle = animator.getRenderAngle(delta);
        double renderX = animator.getRenderX(delta);
        double renderY = animator.getRenderY(delta);
        this.field_22758 = (int)(16.0f * configScale);
        this.field_22759 = (int)(16.0f * configScale);
        this.method_46421((int)Math.round(renderX));
        this.method_46419((int)Math.round(renderY));
        context.method_51448().method_22903();
        context.method_51448().method_22904(renderX + (double)this.field_22758 / 2.0, renderY + (double)this.field_22759 / 2.0, 0.0);
        context.method_51448().method_22905(finalScale, finalScale, 1.0f);
        context.method_51448().method_22907(class_7833.field_40718.rotationDegrees(angle));
        context.method_51448().method_22904(-8.0, -8.0, 0.0);
        context.method_25290(ICON_TEXTURE, 0, 0, 0.0f, 0.0f, 16, 16, 16, 16);
        context.method_51448().method_22909();
        if (this.method_49606() && !(notifications = AnnouncementManager.INSTANCE.getPendingNotifications()).isEmpty()) {
            ArrayList<Object> tooltipLines = new ArrayList<Object>();
            class_5250 modNameText = class_2561.method_43471((String)"key.categories.adorablehamsterpets.main").method_27695(new class_124[]{class_124.field_1078, class_124.field_1056});
            class_2561 mainTooltipLine = null;
            if (this.parentScreen instanceof class_442) {
                mainTooltipLine = notifications.stream().filter(n -> n.reason().equals("update_available_announcement")).findFirst().map(AnnouncementManager::getTooltipTextForNotification).orElse(null);
            } else {
                AnnouncementManager.PendingNotification primary = notifications.get(0);
                mainTooltipLine = AnnouncementManager.getTooltipTextForNotification(primary);
            }
            if (mainTooltipLine != null) {
                tooltipLines.add(mainTooltipLine);
                tooltipLines.add(modNameText);
                context.method_51434(class_310.method_1551().field_1772, tooltipLines, mouseX, mouseY);
            }
        }
    }

    public void method_25306() {
        AnnouncementIconAnimator.INSTANCE.triggerClickAnimation();
        class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
        List<AnnouncementManager.PendingNotification> notifications = AnnouncementManager.INSTANCE.getPendingNotifications();
        if (notifications.isEmpty()) {
            return;
        }
        class_310 client = class_310.method_1551();
        class_2960 bookId = class_2960.method_43902((String)"adorablehamsterpets", (String)"hamster_tips_guide_book");
        if (this.parentScreen instanceof class_442) {
            notifications.stream().filter(n -> n.reason().equals("update_available_announcement")).max(Comparator.comparing(n -> Semver.parse(n.announcement().semver()))).ifPresent(notification -> {
                Announcement announcement = notification.announcement();
                Book book = (Book)BookRegistry.INSTANCE.books.get(bookId);
                if (book != null) {
                    class_2960 entryId = class_2960.method_43902((String)"adorablehamsterpets", (String)("announcement_" + announcement.id()));
                    JsonObject json = new JsonObject();
                    json.addProperty("name", announcement.title());
                    json.addProperty("icon", "minecraft:writable_book");
                    json.addProperty("category", "adorablehamsterpets:update_notes");
                    json.add("pages", (JsonElement)new JsonArray());
                    BookEntry virtualEntry = new BookEntry(json, entryId, book, "adorablehamsterpets");
                    client.method_1507((class_437)new AnnouncementScreen(announcement, notification.reason(), this.parentScreen, virtualEntry));
                }
            });
        } else if (notifications.size() == 1) {
            AnnouncementManager.PendingNotification notification2 = notifications.get(0);
            Announcement announcement = notifications.get(0).announcement();
            Book book = (Book)BookRegistry.INSTANCE.books.get(bookId);
            if (book != null) {
                class_2960 entryId = class_2960.method_43902((String)"adorablehamsterpets", (String)("announcement_" + announcement.id()));
                BookEntry realVirtualEntry = (BookEntry)book.getContents().entries.get(entryId);
                if (realVirtualEntry != null) {
                    client.method_1507((class_437)new AnnouncementScreen(announcement, notification2.reason(), null, realVirtualEntry));
                } else {
                    AdorableHamsterPets.LOGGER.error("[AHP] Could not find virtual entry '{}' in book contents to open announcement screen.", (Object)entryId);
                }
            }
        } else {
            Book book = (Book)BookRegistry.INSTANCE.books.get(bookId);
            if (book != null) {
                book.getContents().currentGui = null;
                book.getContents().guiStack.clear();
            }
            PatchouliAPI.get().openBookGUI(bookId);
        }
    }
}

