/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.entity.AI.navigation;

import net.dawson.adorablehamsterpets.AdorableHamsterPets;
import net.dawson.adorablehamsterpets.entity.custom.HamsterEntity;
import net.minecraft.class_11;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1409;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import org.jetbrains.annotations.Nullable;

public class HamsterNavigation
extends class_1409 {
    private final HamsterEntity hamster;
    @Nullable
    private class_2338 avoidanceWaypoint = null;
    @Nullable
    private class_2338 waypointTargetSnapshot = null;
    @Nullable
    private class_1297 waypointEntitySnapshot = null;
    @Nullable
    private class_2338 lastUnsafeTarget = null;
    private int unsafeCycles = 0;
    private static final int MAX_ALT_ATTEMPTS = 10;
    private static final int ALT_RADIUS = 4;
    private static final double WAYPOINT_REACH_DIST_SQ = 2.25;
    private static final double TARGET_MOVE_REPATH_DIST_SQ = 25.0;
    private static final int ALLOW_UNSAFE_AFTER_CYCLES = 6;

    public HamsterNavigation(HamsterEntity hamster, class_1937 world) {
        super((class_1308)hamster, world);
        this.hamster = hamster;
        AdorableHamsterPets.LOGGER.trace("[AHP Nav Debug] HamsterNavigation constructed for hamster {}", (Object)hamster.method_5667());
    }

    public boolean method_6337(double x, double y, double z, double speed) {
        class_11 planned;
        class_2338 target = class_2338.method_49637((double)x, (double)y, (double)z);
        AdorableHamsterPets.LOGGER.trace("[AHP Nav Debug] startMovingTo(xyz={}, speed={})  waypoint={}", new Object[]{target, speed, this.avoidanceWaypoint});
        if (this.isWaypointValidForTarget(target, null)) {
            class_11 wp = super.method_6348(this.avoidanceWaypoint, 0);
            if (wp != null) {
                AdorableHamsterPets.LOGGER.trace("[AHP Nav Debug] Using existing waypoint {} toward {}", (Object)this.avoidanceWaypoint, (Object)target);
                return this.method_6334(wp, speed);
            }
            AdorableHamsterPets.LOGGER.trace("[AHP Nav Debug] Waypoint {} no longer pathable; clearing", (Object)this.avoidanceWaypoint);
            this.clearWaypoint();
        }
        return (planned = this.planPathWithWaypoint(target, null)) != null && this.method_6334(planned, speed);
    }

    public boolean method_6335(class_1297 entity, double speed) {
        class_11 planned;
        class_2338 target = entity.method_24515();
        AdorableHamsterPets.LOGGER.trace("[AHP Nav Debug] startMovingTo(entity={}, speed={}) waypoint={}", new Object[]{entity.method_5477().getString(), speed, this.avoidanceWaypoint});
        if (this.isWaypointValidForTarget(target, entity)) {
            class_11 wp = super.method_6348(this.avoidanceWaypoint, 0);
            if (wp != null) {
                AdorableHamsterPets.LOGGER.trace("[AHP Nav Debug] Using existing waypoint {} toward entity {}", (Object)this.avoidanceWaypoint, (Object)entity.method_5477().getString());
                return this.method_6334(wp, speed);
            }
            AdorableHamsterPets.LOGGER.trace("[AHP Nav Debug] Waypoint {} no longer pathable; clearing", (Object)this.avoidanceWaypoint);
            this.clearWaypoint();
        }
        return (planned = this.planPathWithWaypoint(target, entity)) != null && this.method_6334(planned, speed);
    }

    @Nullable
    public class_11 method_6348(class_2338 pos, int range) {
        return super.method_6348(pos, range);
    }

    public void method_6360() {
        double d2;
        super.method_6360();
        if (this.avoidanceWaypoint != null && (d2 = this.hamster.method_5649((double)this.avoidanceWaypoint.method_10263() + 0.5, (double)this.avoidanceWaypoint.method_10264() + 0.1, (double)this.avoidanceWaypoint.method_10260() + 0.5)) <= 2.25) {
            AdorableHamsterPets.LOGGER.trace("[AHP Nav Debug] Reached waypoint {}; clearing", (Object)this.avoidanceWaypoint);
            this.clearWaypoint();
        }
    }

    @Nullable
    private class_11 planPathWithWaypoint(class_2338 targetPos, @Nullable class_1297 targetEntity) {
        boolean directUnsafe;
        AdorableHamsterPets.LOGGER.trace("[AHP Nav Debug] planPathWithWaypoint target={}", (Object)targetPos);
        class_11 direct = super.method_6348(targetPos, 0);
        boolean bl = directUnsafe = direct != null && this.hamster.isPathThroughUnlinkedBed(direct);
        if (!directUnsafe) {
            this.hamster.pathingFailures = 0;
            this.hamster.lastFailedTarget = null;
            if (this.avoidanceWaypoint != null) {
                AdorableHamsterPets.LOGGER.trace("[AHP Nav Debug] Direct path safe; clearing previous waypoint {}", (Object)this.avoidanceWaypoint);
                this.clearWaypoint();
            }
            return direct;
        }
        if (this.hamster.lastFailedTarget == null || !this.hamster.lastFailedTarget.equals((Object)targetPos)) {
            this.hamster.pathingFailures = 1;
            this.hamster.lastFailedTarget = targetPos.method_10062();
        } else {
            ++this.hamster.pathingFailures;
        }
        if (this.hamster.pathingFailures >= 6) {
            AdorableHamsterPets.LOGGER.trace("[AHP Nav Debug] No safe alternates after {} cycles; allowing direct unsafe path to {}", (Object)this.hamster.pathingFailures, (Object)targetPos);
            this.hamster.pathingFailures = 0;
            this.hamster.lastFailedTarget = null;
            this.clearWaypoint();
            return direct;
        }
        for (int i = 0; i < 10; ++i) {
            int dz;
            int dx = this.hamster.method_6051().method_39332(-4, 4);
            class_2338 alt = targetPos.method_10069(dx, 0, dz = this.hamster.method_6051().method_39332(-4, 4));
            class_11 altPath = super.method_6348(alt, 0);
            boolean altUnsafe = altPath == null || this.hamster.isPathThroughUnlinkedBed(altPath);
            AdorableHamsterPets.LOGGER.trace("[AHP Nav Debug] Alt attempt {}: {} \u2192 {} unsafe={}", new Object[]{i + 1, alt, altPath == null ? "null" : "len=" + altPath.method_38(), altUnsafe});
            if (altUnsafe) continue;
            this.setWaypoint(alt, targetPos, targetEntity);
            AdorableHamsterPets.LOGGER.trace("[AHP Nav Debug] Using safe waypoint {} toward {}", (Object)this.avoidanceWaypoint, (Object)targetPos);
            return altPath;
        }
        AdorableHamsterPets.LOGGER.trace("[AHP Nav Debug] No safe alternates this cycle; will retry next tick; refusing unsafe path to {}", (Object)targetPos);
        return null;
    }

    private boolean isWaypointValidForTarget(class_2338 currentTargetPos, @Nullable class_1297 currentEntityTarget) {
        double movedSq;
        if (this.avoidanceWaypoint == null) {
            return false;
        }
        if (this.waypointEntitySnapshot != null && currentEntityTarget != null && (movedSq = currentEntityTarget.method_5649(this.waypointEntitySnapshot.method_23317(), this.waypointEntitySnapshot.method_23318(), this.waypointEntitySnapshot.method_23321())) > 25.0) {
            AdorableHamsterPets.LOGGER.trace("[AHP Nav Debug] Target entity moved too far; invalidating waypoint {}", (Object)this.avoidanceWaypoint);
            this.clearWaypoint();
            return false;
        }
        if (this.waypointTargetSnapshot != null && this.waypointTargetSnapshot.method_10262((class_2382)currentTargetPos) > 25.0) {
            AdorableHamsterPets.LOGGER.trace("[AHP Nav Debug] Target position moved {}; invalidating waypoint {}", (Object)this.waypointTargetSnapshot, (Object)this.avoidanceWaypoint);
            this.clearWaypoint();
            return false;
        }
        class_11 directNow = super.method_6348(currentTargetPos, 0);
        if (directNow != null && !this.hamster.isPathThroughUnlinkedBed(directNow)) {
            AdorableHamsterPets.LOGGER.trace("[AHP Nav Debug] Direct path became safe; clearing waypoint {}", (Object)this.avoidanceWaypoint);
            this.clearWaypoint();
            return false;
        }
        return true;
    }

    private void setWaypoint(class_2338 waypoint, class_2338 targetSnapshot, @Nullable class_1297 entitySnapshot) {
        this.avoidanceWaypoint = waypoint;
        this.waypointTargetSnapshot = targetSnapshot.method_10062();
        this.waypointEntitySnapshot = entitySnapshot;
    }

    private void clearWaypoint() {
        this.avoidanceWaypoint = null;
        this.waypointTargetSnapshot = null;
        this.waypointEntitySnapshot = null;
    }
}

