/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.integration.jade;

import java.util.Optional;
import net.dawson.adorablehamsterpets.block.entity.HamsterBedBlockEntity;
import net.dawson.adorablehamsterpets.config.Configs;
import net.dawson.adorablehamsterpets.config.WanderDistance;
import net.dawson.adorablehamsterpets.entity.custom.HamsterEntity;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_5455;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;

public enum HamsterBedComponentProvider implements IBlockComponentProvider,
IServerDataProvider<BlockAccessor>
{
    INSTANCE;

    private static final class_2960 UID;

    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        class_2487 serverData = accessor.getServerData();
        class_5455 registryLookup = accessor.getLevel().method_30349();
        class_1657 player = accessor.getPlayer();
        if (serverData.method_10545("LinkedHamsterName")) {
            boolean isWanderActive;
            class_5250 hamsterName = class_2561.class_2562.method_10877((String)serverData.method_10558("LinkedHamsterName"));
            if (hamsterName != null) {
                tooltip.add((class_2561)class_2561.method_43469((String)"tooltip.adorablehamsterpets.hamster_bed.linked_to", (Object[])new Object[]{hamsterName}).method_27692(class_124.field_1060));
            }
            class_5250 wanderStatus = (isWanderActive = serverData.method_10577("WanderModeActive")) ? class_2561.method_43470((String)"ACTIVE").method_27692(class_124.field_1060) : class_2561.method_43470((String)"INACTIVE").method_27692(class_124.field_1061);
            WanderDistance distance = WanderDistance.valueOf(serverData.method_10558("WanderDistance").toUpperCase());
            int radius = switch (distance) {
                case WanderDistance.NEAR -> (Integer)Configs.AHP.wanderDistanceNear.get();
                case WanderDistance.FAR -> (Integer)Configs.AHP.wanderDistanceFar.get();
                default -> (Integer)Configs.AHP.wanderDistanceMedium.get();
            };
            tooltip.add((class_2561)class_2561.method_43469((String)"tooltip.adorablehamsterpets.jade.wander_status", (Object[])new Object[]{wanderStatus, distance.method_15434(), radius}));
            if (player.method_5715()) {
                boolean allowSleep = serverData.method_10577("AllowSleepInBed");
                class_5250 sleepStatus = allowSleep ? class_2561.method_43470((String)"TRUE").method_27692(class_124.field_1060) : class_2561.method_43470((String)"FALSE").method_27692(class_124.field_1061);
                tooltip.add((class_2561)class_2561.method_43469((String)"tooltip.adorablehamsterpets.jade.sleep_status", (Object[])new Object[]{sleepStatus}));
                tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.adorablehamsterpets.jade.wander_controls").method_27692(class_124.field_1080));
                tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.adorablehamsterpets.jade.lure_hint").method_27692(class_124.field_1080));
                tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.adorablehamsterpets.jade.repellent_hint").method_27692(class_124.field_1080));
                tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.adorablehamsterpets.jade.unlink_hint").method_27692(class_124.field_1080));
            } else {
                tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.adorablehamsterpets.sneak_for_info").method_27692(class_124.field_1080));
            }
        } else {
            tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.adorablehamsterpets.jade.unlinked").method_27692(class_124.field_1065));
        }
    }

    public void appendServerData(class_2487 data, BlockAccessor accessor) {
        class_2586 blockEntity = accessor.getBlockEntity();
        if (blockEntity instanceof HamsterBedBlockEntity) {
            HamsterBedBlockEntity bedEntity = (HamsterBedBlockEntity)blockEntity;
            class_1657 class_16572 = accessor.getPlayer();
            if (class_16572 instanceof class_3222) {
                class_3222 player = (class_3222)class_16572;
                class_3218 serverWorld = player.method_51469();
                Optional<class_2561> liveName = bedEntity.getLinkedHamsterUuid().map(arg_0 -> ((class_3218)serverWorld).method_14190(arg_0)).filter(e -> e instanceof HamsterEntity).map(entity -> {
                    HamsterEntity hamster = (HamsterEntity)entity;
                    if (hamster.method_16914()) {
                        return hamster.method_5477();
                    }
                    return hamster.method_5476().method_27661().method_27693(" " + hamster.method_5628());
                });
                class_2561 nameToShow = liveName.or(bedEntity::getLinkedHamsterName).orElse(null);
                if (nameToShow != null) {
                    data.method_10582("LinkedHamsterName", class_2561.class_2562.method_10867((class_2561)nameToShow));
                }
            }
            data.method_10556("WanderModeActive", bedEntity.isWanderModeActive());
            data.method_10582("WanderDistance", bedEntity.getWanderDistance().method_15434());
            data.method_10556("AllowSleepInBed", bedEntity.isSleepingAllowed());
        }
    }

    public class_2960 getUid() {
        return UID;
    }

    static {
        UID = class_2960.method_43902((String)"adorablehamsterpets", (String)"hamster_bed_info");
    }
}

