/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.integration.jade;

import net.dawson.adorablehamsterpets.block.entity.HamsterBedBlockEntity;
import net.dawson.adorablehamsterpets.config.Configs;
import net.dawson.adorablehamsterpets.entity.custom.HamsterEntity;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5250;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IEntityComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationProcessor;

public enum HamsterDebugComponentProvider implements IEntityComponentProvider,
IServerDataProvider<EntityAccessor>
{
    INSTANCE;

    private static final class_2960 UID;

    public void appendTooltip(ITooltip tooltip, EntityAccessor accessor, IPluginConfig config) {
        if (!Configs.AHP.enableJadeHamsterDebugInfo) {
            return;
        }
        class_1297 entity = accessor.getEntity();
        if (!(entity instanceof HamsterEntity)) {
            return;
        }
        HamsterEntity hamster = (HamsterEntity)entity;
        tooltip.add((class_2561)class_2561.method_43470((String)"--- Current Animation ---").method_27692(class_124.field_1080));
        AnimationController controller = (AnimationController)hamster.getAnimatableInstanceCache().getManagerForId((long)hamster.method_5628()).getAnimationControllers().get("mainController");
        if (controller != null) {
            AnimationProcessor.QueuedAnimation currentAnim = controller.getCurrentAnimation();
            if (currentAnim != null) {
                tooltip.add(this.fText("Current Anim: %s", class_2561.method_43470((String)currentAnim.animation().name()).method_27692(class_124.field_1075)));
            } else {
                tooltip.add(this.fText("Current Anim: %s", class_2561.method_43470((String)"None").method_27692(class_124.field_1080)));
            }
        }
        tooltip.add((class_2561)class_2561.method_43470((String)"--- AI & Action States ---").method_27692(class_124.field_1080));
        tooltip.add(this.fText("Sitting (Command): %s", hamster.method_24345() ? class_2561.method_43470((String)"true").method_27692(class_124.field_1060) : class_2561.method_43470((String)"false").method_27692(class_124.field_1061)));
        tooltip.add(this.fText("Sitting (Vanilla Pose): %s", hamster.method_6172() ? class_2561.method_43470((String)"true").method_27692(class_124.field_1060) : class_2561.method_43470((String)"false").method_27692(class_124.field_1061)));
        tooltip.add(this.fText("Sleeping (Wild/General): %s", hamster.method_6113() ? class_2561.method_43470((String)"true").method_27692(class_124.field_1060) : class_2561.method_43470((String)"false").method_27692(class_124.field_1061)));
        tooltip.add(this.fText("Cleaning: %s", hamster.isCleaning() ? class_2561.method_43470((String)"true").method_27692(class_124.field_1060) : class_2561.method_43470((String)"false").method_27692(class_124.field_1061)));
        if (hamster.isKnockedOut()) {
            tooltip.add(this.fText("State: %s", class_2561.method_43470((String)"Knocked Out").method_27695(new class_124[]{class_124.field_1061, class_124.field_1067})));
        } else if (hamster.isThrown()) {
            tooltip.add(this.fText("State: %s", class_2561.method_43470((String)"Thrown").method_27692(class_124.field_1075)));
        } else if (hamster.isSulking()) {
            tooltip.add(this.fText("State: %s", class_2561.method_43470((String)"Sulking").method_27695(new class_124[]{class_124.field_1064, class_124.field_1067})));
        } else if (hamster.isCelebratingDiamond()) {
            tooltip.add(this.fText("State: %s", class_2561.method_43470((String)"Celebrating Diamond").method_27695(new class_124[]{class_124.field_1075, class_124.field_1067})));
        }
        tooltip.add(this.fText("Is Navigating: %s", !hamster.method_5942().method_6357() ? class_2561.method_43470((String)"true").method_27692(class_124.field_1060) : class_2561.method_43470((String)"false").method_27692(class_124.field_1061)));
        class_1309 target = hamster.method_5968();
        tooltip.add(this.fText("Has Target: %s", target != null ? class_2561.method_43470((String)"true").method_27692(class_124.field_1060) : class_2561.method_43470((String)"false").method_27692(class_124.field_1061)));
        if (target != null) {
            tooltip.add(this.fText("  Target: %s", class_2561.method_43470((String)target.method_5477().getString()).method_27692(class_124.field_1068)));
        }
        String activeGoalName = hamster.getActiveCustomGoalDebugName();
        tooltip.add(this.fText("Current Custom Goal: %s", class_2561.method_43470((String)activeGoalName).method_27692(activeGoalName.equals("None") ? class_124.field_1080 : class_124.field_1075)));
        tooltip.add((class_2561)class_2561.method_43470((String)"--- Bed Link ---").method_27692(class_124.field_1080));
        class_2487 serverData = accessor.getServerData();
        boolean isWanderActive = serverData.method_10577("IsWanderModeActive");
        boolean isOnTheWayToBed = serverData.method_10577("IsOnTheWayToBed");
        int goToBedDelay = serverData.method_10550("GoToBedDelay");
        tooltip.add(this.fText("Wander Mode: %s", isWanderActive ? class_2561.method_43470((String)"ACTIVE").method_27692(class_124.field_1060) : class_2561.method_43470((String)"INACTIVE").method_27692(class_124.field_1061)));
        if (isWanderActive) {
            if (isOnTheWayToBed) {
                if (goToBedDelay > 0) {
                    tooltip.add(this.fText("  Status: %s", class_2561.method_43470((String)String.format("Waiting... (starts in %.1f s)", (double)goToBedDelay / 20.0)).method_27692(class_124.field_1054)));
                } else {
                    tooltip.add(this.fText("  Status: %s", class_2561.method_43470((String)"Pathfinding to bed...").method_27692(class_124.field_1054)));
                }
            } else if (serverData.method_10545("WanderDistance")) {
                String distanceStr = serverData.method_10558("WanderDistance");
                tooltip.add(this.fText("  Wander Distance: %s", class_2561.method_43470((String)distanceStr).method_27692(class_124.field_1075)));
            }
        }
        if (hamster.method_6181()) {
            tooltip.add((class_2561)class_2561.method_43470((String)"--- Tamed Sleep Sequence ---").method_27692(class_124.field_1080));
            HamsterEntity.DozingPhase phase = hamster.getDozingPhase();
            tooltip.add(this.fText("Dozing Phase: %s", class_2561.method_43470((String)phase.name()).method_27692(phase != HamsterEntity.DozingPhase.NONE ? class_124.field_1075 : class_124.field_1068)));
            if (phase == HamsterEntity.DozingPhase.DEEP_SLEEP || phase == HamsterEntity.DozingPhase.SETTLING_INTO_SLUMBER) {
                tooltip.add(this.fText("  Deep Sleep Anim: %s", class_2561.method_43470((String)hamster.getCurrentDeepSleepAnimationIdFromTracker()).method_27692(class_124.field_1075)));
            }
        }
        tooltip.add((class_2561)class_2561.method_43470((String)"--- Ore Seeking ---").method_27692(class_124.field_1080));
        tooltip.add(this.fText("Primed to Seek: %s", hamster.isPrimedToSeekDiamonds ? class_2561.method_43470((String)"true").method_27692(class_124.field_1060) : class_2561.method_43470((String)"false").method_27692(class_124.field_1061)));
        if (hamster.currentOreTarget != null) {
            tooltip.add(this.fText("  Current Ore Target: %s", class_2561.method_43470((String)hamster.currentOreTarget.toString()).method_27692(class_124.field_1075)));
        } else {
            tooltip.add(this.fText("  Current Ore Target: %s", class_2561.method_43470((String)"None").method_27692(class_124.field_1080)));
        }
        long foundOreCooldown = hamster.foundOreCooldownEndTick - hamster.method_37908().method_8510();
        if (Configs.AHP.enableIndependentDiamondSeekCooldown && foundOreCooldown > 0L) {
            tooltip.add(this.fText("  Found Ore Cooldown: %s sec", class_2561.method_43470((String)String.format("%.1f", (double)foundOreCooldown / 20.0)).method_27692(class_124.field_1054)));
        } else if (Configs.AHP.enableIndependentDiamondSeekCooldown) {
            tooltip.add(this.fText("  Found Ore Cooldown: %s", class_2561.method_43470((String)"Ready").method_27692(class_124.field_1060)));
        } else {
            tooltip.add(this.fText("  Found Ore Cooldown: %s", class_2561.method_43470((String)"Disabled").method_27692(class_124.field_1080)));
        }
        tooltip.add((class_2561)class_2561.method_43470((String)"--- Diamond Stealing ---").method_27692(class_124.field_1080));
        tooltip.add(this.fText("Is Stealing: %s", hamster.isStealingDiamond() ? class_2561.method_43470((String)"true").method_27692(class_124.field_1060) : class_2561.method_43470((String)"false").method_27692(class_124.field_1061)));
        if (hamster.isStealingDiamond()) {
            int remainingTicks = hamster.getStealDurationTimer();
            tooltip.add(this.fText("  Time Remaining: %s sec", class_2561.method_43470((String)String.format("%.1f", (double)remainingTicks / 20.0)).method_27692(class_124.field_1054)));
        }
        tooltip.add((class_2561)class_2561.method_43470((String)"--- Love & Interaction ---").method_27692(class_124.field_1080));
        tooltip.add(this.fText("Begging: %s", hamster.isBegging() ? class_2561.method_43470((String)"true").method_27692(class_124.field_1060) : class_2561.method_43470((String)"false").method_27692(class_124.field_1061)));
        tooltip.add(this.fText("Refusing Food: %s", hamster.isRefusingFood() ? class_2561.method_43470((String)"true").method_27692(class_124.field_1060) : class_2561.method_43470((String)"false").method_27692(class_124.field_1061)));
        boolean inLoveDataTracker = hamster.method_6479();
        boolean inLoveCustomTimer = hamster.customLoveTimer > 0;
        tooltip.add(this.fText("In Love (Tracker): %s", inLoveDataTracker ? class_2561.method_43470((String)"true").method_27692(class_124.field_1060) : class_2561.method_43470((String)"false").method_27692(class_124.field_1061)));
        tooltip.add(this.fText("In Love (Timer): %s (%d ticks)", inLoveCustomTimer ? class_2561.method_43470((String)"true").method_27692(class_124.field_1060) : class_2561.method_43470((String)"false").method_27692(class_124.field_1061), hamster.customLoveTimer));
        tooltip.add((class_2561)class_2561.method_43470((String)"--- General Info ---").method_27692(class_124.field_1080));
        tooltip.add(this.fText("Tamed: %s", hamster.method_6181() ? class_2561.method_43470((String)"Yes").method_27692(class_124.field_1060) : class_2561.method_43470((String)"No").method_27692(class_124.field_1061)));
        if (hamster.method_6181() && hamster.method_35057() != null) {
            tooltip.add(this.fText("  Owner: %s", class_2561.method_43470((String)hamster.method_35057().method_5477().getString()).method_27692(class_124.field_1068)));
        }
        tooltip.add(this.fText("Variant: %s (ID: %d)", class_2561.method_43470((String)hamster.getVariantEnum().name()).method_27692(class_124.field_1075), hamster.getVariant()));
        tooltip.add(this.fText("Age: %s", hamster.method_6109() ? class_2561.method_43470((String)"Baby").method_27692(class_124.field_1075) : class_2561.method_43470((String)"Adult").method_27692(class_124.field_1068)));
    }

    public class_2960 getUid() {
        return UID;
    }

    public void appendServerData(class_2487 data, EntityAccessor accessor) {
        class_1297 entity = accessor.getEntity();
        if (entity instanceof HamsterEntity) {
            HamsterEntity hamster = (HamsterEntity)entity;
            data.method_10556("IsWanderModeActive", hamster.isWanderModeActive());
            data.method_10556("IsOnTheWayToBed", hamster.isOnTheWayToBed());
            data.method_10569("GoToBedDelay", hamster.getGoToBedDelayTicks());
            if (hamster.isWanderModeActive()) {
                hamster.getLinkedBedPos().ifPresent(globalPos -> {
                    class_2586 patt11469$temp;
                    class_3218 serverWorld;
                    class_1937 world = hamster.method_37908();
                    if (world instanceof class_3218 && (serverWorld = (class_3218)world).method_27983() == globalPos.method_19442() && (patt11469$temp = serverWorld.method_8321(globalPos.method_19446())) instanceof HamsterBedBlockEntity) {
                        HamsterBedBlockEntity bedEntity = (HamsterBedBlockEntity)patt11469$temp;
                        data.method_10582("WanderDistance", bedEntity.getWanderDistance().method_15434());
                    }
                });
            }
        }
    }

    private class_2561 fText(String format, Object ... args) {
        class_2561[] formattedArgs = new class_2561[args.length];
        for (int i = 0; i < args.length; ++i) {
            class_2561 textComponent;
            Object object = args[i];
            formattedArgs[i] = object instanceof class_2561 ? (textComponent = (class_2561)object) : class_2561.method_43470((String)String.valueOf(args[i])).method_27692(class_124.field_1068);
        }
        class_5250 result = class_2561.method_43473();
        String[] parts = format.split("%s", -1);
        for (int i = 0; i < parts.length; ++i) {
            result.method_10852((class_2561)class_2561.method_43470((String)parts[i]).method_27692(class_124.field_1065));
            if (i >= formattedArgs.length) continue;
            result.method_10852(formattedArgs[i]);
        }
        return result;
    }

    static {
        UID = class_2960.method_43902((String)"adorablehamsterpets", (String)"hamster_debug_info");
    }
}

