/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.mixin.server;

import com.mojang.authlib.GameProfile;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.dawson.adorablehamsterpets.AdorableHamsterPets;
import net.dawson.adorablehamsterpets.accessor.PlayerEntityAccessor;
import net.dawson.adorablehamsterpets.advancement.criterion.ModCriteria;
import net.dawson.adorablehamsterpets.client.state.ClientShoulderHamsterData;
import net.dawson.adorablehamsterpets.config.AhpConfig;
import net.dawson.adorablehamsterpets.config.DismountOrder;
import net.dawson.adorablehamsterpets.entity.AI.HamsterSeekDiamondGoal;
import net.dawson.adorablehamsterpets.entity.ShoulderLocation;
import net.dawson.adorablehamsterpets.entity.custom.HamsterEntity;
import net.dawson.adorablehamsterpets.sound.ModSounds;
import net.dawson.adorablehamsterpets.util.HamsterRenderTracker;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1309;
import net.minecraft.class_1548;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_5819;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1657.class})
public abstract class PlayerEntityMixin
extends class_1309
implements PlayerEntityAccessor {
    @Unique
    private static final class_2940<class_2487> SHOULDER_HAMSTERS = class_2945.method_12791(class_1657.class, (class_2941)class_2943.field_13318);
    @Unique
    private transient ClientShoulderHamsterData adorablehamsterpets$clientShoulderData;
    @Unique
    private static final int CHECK_INTERVAL_TICKS = 20;
    @Unique
    private static final List<String> DISMOUNT_MESSAGE_KEYS = Arrays.asList("message.adorablehamsterpets.dismount.1", "message.adorablehamsterpets.dismount.2", "message.adorablehamsterpets.dismount.3", "message.adorablehamsterpets.dismount.4", "message.adorablehamsterpets.dismount.5", "message.adorablehamsterpets.dismount.6");
    @Unique
    private int adorablehamsterpets$diamondCheckTimer = 0;
    @Unique
    private int adorablehamsterpets$creeperCheckTimer = 0;
    @Unique
    private int adorablehamsterpets$diamondSoundCooldownTicks = 0;
    @Unique
    private int adorablehamsterpets$creeperSoundCooldownTicks = 0;
    @Unique
    private String adorablehamsterpets$lastDismountMessageKey = "";
    @Unique
    private boolean adorablehamsterpets$isDiamondAlertConditionMet = false;
    @Unique
    private int adorablehamsterpets$lastGoldMessageIndex = -1;
    @Unique
    private final transient ArrayDeque<ShoulderLocation> adorablehamsterpets$mountOrderQueue = new ArrayDeque();
    @Unique
    private final List<ScheduledTask> adorablehamsterpets$scheduledTasks = new ArrayList<ScheduledTask>();

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void adorablehamsterpets$onInit(class_1937 world, class_2338 pos, float yaw, GameProfile gameProfile, CallbackInfo ci) {
        if (world.field_9236) {
            this.adorablehamsterpets$clientShoulderData = new ClientShoulderHamsterData();
        }
    }

    protected PlayerEntityMixin(class_1299<? extends class_1309> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Inject(method={"initDataTracker"}, at={@At(value="TAIL")})
    private void adorablehamsterpets$initDataTracker(CallbackInfo ci) {
        this.field_6011.method_12784(SHOULDER_HAMSTERS, (Object)new class_2487());
    }

    @Inject(method={"writeCustomDataToNbt"}, at={@At(value="TAIL")})
    private void adorablehamsterpets$writeNbt(class_2487 nbt, CallbackInfo ci) {
        AdorableHamsterPets.LOGGER.trace("[AHP Mixin] PlayerEntityMixin writeNbt is RUNNING for entity {}.", (Object)this.method_5628());
        class_2487 shoulderPetsNbt = (class_2487)this.method_5841().method_12789(SHOULDER_HAMSTERS);
        if (!shoulderPetsNbt.method_33133()) {
            nbt.method_10566("ShoulderHamsters", (class_2520)shoulderPetsNbt);
        }
        if (!this.adorablehamsterpets$mountOrderQueue.isEmpty()) {
            class_2499 mountOrderList = new class_2499();
            for (ShoulderLocation location : this.adorablehamsterpets$mountOrderQueue) {
                mountOrderList.add((Object)class_2519.method_23256((String)location.name()));
            }
            nbt.method_10566("MountOrderQueue", (class_2520)mountOrderList);
        }
        if (this.adorablehamsterpets$lastGoldMessageIndex != -1) {
            nbt.method_10569("LastGoldMessageIndex", this.adorablehamsterpets$lastGoldMessageIndex);
        }
    }

    @Inject(method={"readCustomDataFromNbt"}, at={@At(value="TAIL")})
    private void adorablehamsterpets$readNbt(class_2487 nbt, CallbackInfo ci) {
        AdorableHamsterPets.LOGGER.trace("[AHP Mixin] PlayerEntityMixin readNbt is RUNNING for entity {}.", (Object)this.method_5628());
        if (nbt.method_10573("ShoulderHamster", 10)) {
            class_2487 oldHamsterNbt = nbt.method_10562("ShoulderHamster");
            if (!oldHamsterNbt.method_33133()) {
                class_2487 newShoulderPetsNbt = new class_2487();
                newShoulderPetsNbt.method_10566(ShoulderLocation.RIGHT_SHOULDER.name(), (class_2520)oldHamsterNbt);
                this.method_5841().method_12778(SHOULDER_HAMSTERS, (Object)newShoulderPetsNbt);
                this.adorablehamsterpets$mountOrderQueue.clear();
                this.adorablehamsterpets$mountOrderQueue.add(ShoulderLocation.RIGHT_SHOULDER);
                nbt.method_10551("ShoulderHamster");
                AdorableHamsterPets.LOGGER.info("Migrated legacy shoulder hamster data for player {}.", (Object)this.method_5476().getString());
            }
        } else if (nbt.method_10573("ShoulderHamsters", 10)) {
            this.method_5841().method_12778(SHOULDER_HAMSTERS, (Object)nbt.method_10562("ShoulderHamsters"));
        }
        this.adorablehamsterpets$mountOrderQueue.clear();
        if (nbt.method_10573("MountOrderQueue", 9)) {
            class_2499 mountOrderList = nbt.method_10554("MountOrderQueue", 8);
            for (class_2520 element : mountOrderList) {
                try {
                    this.adorablehamsterpets$mountOrderQueue.add(ShoulderLocation.valueOf(element.method_10714()));
                }
                catch (IllegalArgumentException e) {
                    AdorableHamsterPets.LOGGER.warn("Found invalid ShoulderLocation name in NBT: {}", (Object)element.method_10714());
                }
            }
        }
        if (this.adorablehamsterpets$mountOrderQueue.isEmpty() && this.hasAnyShoulderHamster()) {
            AdorableHamsterPets.LOGGER.info("Player {} has shoulder hamsters but an empty mount queue. Rebuilding queue...", (Object)this.method_5476().getString());
            for (ShoulderLocation location : ShoulderLocation.values()) {
                if (this.getShoulderHamster(location).method_33133()) continue;
                this.adorablehamsterpets$mountOrderQueue.addLast(location);
            }
            AdorableHamsterPets.LOGGER.info("Successfully rebuilt mount queue for player {}. New queue: {}", (Object)this.method_5476().getString(), this.adorablehamsterpets$mountOrderQueue);
        }
        this.adorablehamsterpets$lastGoldMessageIndex = nbt.method_10573("LastGoldMessageIndex", 3) ? nbt.method_10550("LastGoldMessageIndex") : -1;
    }

    @Inject(method={"remove(Lnet/minecraft/entity/Entity$RemovalReason;)V"}, at={@At(value="HEAD")})
    private void adorablehamsterpets$onRemove(class_1297.class_5529 reason, CallbackInfo ci) {
        if (!this.method_37908().method_8608()) {
            HamsterRenderTracker.onPlayerDisconnect(this.method_5667());
        }
    }

    @Override
    @Unique
    public class_2487 getShoulderHamster(ShoulderLocation location) {
        class_2487 allShoulderPets = (class_2487)this.method_5841().method_12789(SHOULDER_HAMSTERS);
        return allShoulderPets.method_10562(location.name());
    }

    @Override
    @Unique
    public void setShoulderHamster(ShoulderLocation location, class_2487 nbt) {
        class_2487 allShoulderPets = new class_2487();
        allShoulderPets.method_10543((class_2487)this.method_5841().method_12789(SHOULDER_HAMSTERS));
        if (nbt == null || nbt.method_33133()) {
            allShoulderPets.method_10551(location.name());
        } else {
            allShoulderPets.method_10566(location.name(), (class_2520)nbt);
        }
        this.method_5841().method_12778(SHOULDER_HAMSTERS, (Object)allShoulderPets);
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void adorablehamsterpets$onTick(CallbackInfo ci) {
        class_1657 self = (class_1657)this;
        class_1937 world = self.method_37908();
        if (world.field_9236) {
            return;
        }
        class_5819 random = world.method_8409();
        AhpConfig config = AdorableHamsterPets.CONFIG;
        long currentTime = world.method_8510();
        this.adorablehamsterpets$scheduledTasks.removeIf(task -> {
            if (currentTime >= task.executionTick()) {
                task.action().run();
                return true;
            }
            return false;
        });
        if (this.adorablehamsterpets$diamondSoundCooldownTicks > 0) {
            --this.adorablehamsterpets$diamondSoundCooldownTicks;
        }
        if (this.adorablehamsterpets$creeperSoundCooldownTicks > 0) {
            --this.adorablehamsterpets$creeperSoundCooldownTicks;
        }
        if (this.hasAnyShoulderHamster()) {
            if (config.enableShoulderDiamondDetection) {
                ++this.adorablehamsterpets$diamondCheckTimer;
                if (this.adorablehamsterpets$diamondCheckTimer >= 20) {
                    this.adorablehamsterpets$diamondCheckTimer = 0;
                    if (this.isDiamondNearby(self, (Double)config.shoulderDiamondDetectionRadius.get())) {
                        this.adorablehamsterpets$isDiamondAlertConditionMet = true;
                        if (this.adorablehamsterpets$diamondSoundCooldownTicks == 0) {
                            world.method_8396(null, self.method_24515(), ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_DIAMOND_SNIFF_SOUNDS, random), class_3419.field_15254, 2.5f, 1.0f);
                            self.method_7353((class_2561)class_2561.method_43471((String)"message.adorablehamsterpets.diamond_nearby").method_27692(class_124.field_1075), true);
                            this.adorablehamsterpets$diamondSoundCooldownTicks = random.method_39332(140, 200);
                            ModCriteria.HAMSTER_DIAMOND_ALERT_TRIGGERED.trigger((class_3222)self);
                        }
                    } else {
                        this.adorablehamsterpets$isDiamondAlertConditionMet = false;
                    }
                }
            }
            if (config.enableShoulderCreeperDetection) {
                ++this.adorablehamsterpets$creeperCheckTimer;
                if (this.adorablehamsterpets$creeperCheckTimer >= 20) {
                    this.adorablehamsterpets$creeperCheckTimer = 0;
                    if (this.creeperSeesPlayer(self, (Double)config.shoulderCreeperDetectionRadius.get()) && this.adorablehamsterpets$creeperSoundCooldownTicks == 0) {
                        world.method_8396(null, self.method_24515(), ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_CREEPER_DETECT_SOUNDS, random), class_3419.field_15254, 1.0f, 1.0f);
                        self.method_7353((class_2561)class_2561.method_43471((String)"message.adorablehamsterpets.creeper_detected").method_27692(class_124.field_1061), true);
                        this.adorablehamsterpets$creeperSoundCooldownTicks = random.method_39332(100, 160);
                        ModCriteria.HAMSTER_CREEPER_ALERT_TRIGGERED.trigger((class_3222)self);
                    }
                }
            }
        }
    }

    @Override
    @Unique
    public void adorablehamsterpets$dismountShoulderHamster(boolean isThrow) {
        ShoulderLocation locationToProcess;
        class_1657 self = (class_1657)this;
        class_1937 world = self.method_37908();
        if (world.field_9236) {
            return;
        }
        if (this.adorablehamsterpets$mountOrderQueue.isEmpty() && this.hasAnyShoulderHamster()) {
            AdorableHamsterPets.LOGGER.warn("[HamsterDismount] Player {} has shoulder hamsters but empty queue. Rebuilding...", (Object)self.method_5477().getString());
            for (ShoulderLocation location : ShoulderLocation.values()) {
                if (this.getShoulderHamster(location).method_33133()) continue;
                this.adorablehamsterpets$mountOrderQueue.addLast(location);
            }
        }
        if (this.adorablehamsterpets$mountOrderQueue.isEmpty()) {
            return;
        }
        AhpConfig config = AdorableHamsterPets.CONFIG;
        class_5819 random = world.method_8409();
        ShoulderLocation shoulderLocation = locationToProcess = config.dismountOrder.get() == DismountOrder.LIFO ? this.adorablehamsterpets$mountOrderQueue.peekLast() : this.adorablehamsterpets$mountOrderQueue.peekFirst();
        if (locationToProcess == null) {
            return;
        }
        class_2487 shoulderNbt = this.getShoulderHamster(locationToProcess);
        if (shoulderNbt.method_33133()) {
            AdorableHamsterPets.LOGGER.warn("Dismount queue pointed to an empty slot ({}). This may indicate a desync.", (Object)locationToProcess);
            if (config.dismountOrder.get() == DismountOrder.LIFO) {
                this.adorablehamsterpets$mountOrderQueue.pollLast();
            } else {
                this.adorablehamsterpets$mountOrderQueue.pollFirst();
            }
            return;
        }
        HamsterEntity hamster = HamsterEntity.createFromNbt((class_3218)world, self, shoulderNbt);
        if (hamster == null) {
            AdorableHamsterPets.LOGGER.error("Failed to create hamster from NBT for slot {}. Clearing data.", (Object)locationToProcess);
            this.setShoulderHamster(locationToProcess, new class_2487());
            if (config.dismountOrder.get() == DismountOrder.LIFO) {
                this.adorablehamsterpets$mountOrderQueue.pollLast();
            } else {
                this.adorablehamsterpets$mountOrderQueue.pollFirst();
            }
            return;
        }
        if (isThrow) {
            if (hamster.method_6109()) {
                self.method_7353((class_2561)class_2561.method_43471((String)"message.adorablehamsterpets.baby_throw_refusal").method_27692(class_124.field_1061), true);
                return;
            }
            long currentTime = world.method_8510();
            if (hamster.throwCooldownEndTick > currentTime) {
                long remainingTicks = hamster.throwCooldownEndTick - currentTime;
                long totalSecondsRemaining = remainingTicks / 20L;
                long minutes = totalSecondsRemaining / 60L;
                long seconds = totalSecondsRemaining % 60L;
                self.method_7353((class_2561)class_2561.method_43469((String)"message.adorablehamsterpets.throw_cooldown", (Object[])new Object[]{minutes, seconds}).method_27692(class_124.field_1061), true);
                return;
            }
            hamster.method_5808(self.method_23317(), self.method_23320() - 0.1, self.method_23321(), self.method_36454(), self.method_36455());
            hamster.setThrown(true);
            hamster.interactionCooldown = 10;
            hamster.throwCooldownEndTick = currentTime + (long)((Integer)config.hamsterThrowCooldown.get()).intValue();
            boolean isBuffed = hamster.hasGreenBeanBuff();
            float throwSpeed = isBuffed ? ((Double)config.hamsterThrowVelocityBuffed.get()).floatValue() : ((Double)config.hamsterThrowVelocity.get()).floatValue();
            class_243 lookVec = self.method_5828(1.0f);
            class_243 throwVec = new class_243(lookVec.field_1352, lookVec.field_1351 + (double)0.1f, lookVec.field_1350).method_1029();
            hamster.method_18799(throwVec.method_1021((double)throwSpeed));
            hamster.field_6007 = true;
        }
        if (config.dismountOrder.get() == DismountOrder.LIFO) {
            this.adorablehamsterpets$mountOrderQueue.pollLast();
        } else {
            this.adorablehamsterpets$mountOrderQueue.pollFirst();
        }
        this.setShoulderHamster(locationToProcess, new class_2487());
        HamsterEntity.spawnFromNbt((class_3218)world, self, shoulderNbt, this.adorablehamsterpets$isDiamondAlertConditionMet, hamster);
        this.adorablehamsterpets$isDiamondAlertConditionMet = false;
        if (isThrow) {
            world.method_43128(null, self.method_23317(), self.method_23318(), self.method_23321(), (class_3414)ModSounds.HAMSTER_THROW.get(), class_3419.field_15248, 1.0f, 1.0f);
            this.adorablehamsterpets$scheduledTasks.add(new ScheduledTask(world.method_8510() + 3L, () -> {
                class_3414 celebrationSound = ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_FLYING_SOUNDS, random);
                if (celebrationSound != null) {
                    world.method_43128(null, self.method_23317(), self.method_23318(), self.method_23321(), celebrationSound, class_3419.field_15248, 1.0f, 1.0f);
                }
            }));
            ModCriteria.HAMSTER_THROWN.trigger((class_3222)self);
        } else {
            world.method_8396(null, self.method_24515(), (class_3414)ModSounds.HAMSTER_DISMOUNT.get(), class_3419.field_15248, 0.7f, 1.0f + random.method_43057() * 0.2f);
            if (config.enableShoulderDismountMessages && !DISMOUNT_MESSAGE_KEYS.isEmpty()) {
                String chosenKey;
                if (DISMOUNT_MESSAGE_KEYS.size() == 1) {
                    chosenKey = DISMOUNT_MESSAGE_KEYS.get(0);
                } else {
                    ArrayList<String> availableKeys = new ArrayList<String>(DISMOUNT_MESSAGE_KEYS);
                    availableKeys.remove(this.adorablehamsterpets$lastDismountMessageKey);
                    chosenKey = availableKeys.isEmpty() ? this.adorablehamsterpets$lastDismountMessageKey : (String)availableKeys.get(random.method_43048(availableKeys.size()));
                }
                self.method_7353((class_2561)class_2561.method_43471((String)chosenKey), true);
                this.adorablehamsterpets$lastDismountMessageKey = chosenKey;
            }
        }
    }

    @Unique
    private boolean isDiamondNearby(class_1657 player, double radius) {
        class_1937 world = player.method_37908();
        class_2338 center = player.method_24515();
        int intRadius = (int)Math.ceil(radius);
        ArrayList<class_2338> exposedOres = new ArrayList<class_2338>();
        ArrayList<class_2338> buriedOres = new ArrayList<class_2338>();
        for (class_2338 checkPos : class_2338.method_10097((class_2338)center.method_10069(-intRadius, -intRadius, -intRadius), (class_2338)center.method_10069(intRadius, intRadius, intRadius))) {
            class_2680 state;
            if (!(checkPos.method_10262((class_2382)center) <= radius * radius) || !(state = world.method_8320(checkPos)).method_27852(class_2246.field_10442) && !state.method_27852(class_2246.field_29029)) continue;
            if (HamsterSeekDiamondGoal.isOreExposed(checkPos, world)) {
                exposedOres.add(checkPos.method_10062());
                continue;
            }
            buriedOres.add(checkPos.method_10062());
        }
        return !exposedOres.isEmpty() || !buriedOres.isEmpty();
    }

    @Unique
    private boolean creeperSeesPlayer(class_1657 player, double radius) {
        class_238 searchBox;
        class_1937 world = player.method_37908();
        List nearbyCreepers = world.method_8390(class_1548.class, searchBox = new class_238(player.method_19538().method_1023(radius, radius, radius), player.method_19538().method_1031(radius, radius, radius)), creeper -> creeper.method_5805() && creeper.method_5968() == player && class_1301.field_6154.test(creeper));
        return !nearbyCreepers.isEmpty();
    }

    @Override
    @Unique
    public boolean hasAnyShoulderHamster() {
        return !this.getShoulderHamster(ShoulderLocation.RIGHT_SHOULDER).method_33133() || !this.getShoulderHamster(ShoulderLocation.LEFT_SHOULDER).method_33133() || !this.getShoulderHamster(ShoulderLocation.HEAD).method_33133();
    }

    @Override
    @Unique
    public int ahp_getLastGoldMessageIndex() {
        return this.adorablehamsterpets$lastGoldMessageIndex;
    }

    @Override
    @Unique
    public void ahp_setLastGoldMessageIndex(int index) {
        this.adorablehamsterpets$lastGoldMessageIndex = index;
    }

    @Override
    @Unique
    public ArrayDeque<ShoulderLocation> adorablehamsterpets$getMountOrderQueue() {
        return this.adorablehamsterpets$mountOrderQueue;
    }

    @Override
    @Unique
    public ClientShoulderHamsterData adorablehamsterpets$getClientShoulderData() {
        return this.adorablehamsterpets$clientShoulderData;
    }

    @Unique
    private record ScheduledTask(long executionTick, Runnable action) {
    }
}

