/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.world.gen;

import dev.architectury.registry.level.biome.BiomeModifications;
import java.util.HashSet;
import java.util.Set;
import net.dawson.adorablehamsterpets.AdorableHamsterPets;
import net.dawson.adorablehamsterpets.config.Configs;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7924;

public class ModEntitySpawns {
    public static final Set<class_2248> VALID_SPAWN_BLOCKS = new HashSet<class_2248>();
    private static final Set<class_6862<class_1959>> PARSED_TAGS = new HashSet<class_6862<class_1959>>();
    private static final Set<class_2960> PARSED_INCLUDES = new HashSet<class_2960>();
    private static final Set<class_2960> PARSED_EXCLUDES = new HashSet<class_2960>();

    public static void parseConfig() {
        PARSED_TAGS.clear();
        PARSED_INCLUDES.clear();
        PARSED_EXCLUDES.clear();
        for (String tagStr : Configs.AHP_WORLDGEN.spawnBiomeTags) {
            try {
                PARSED_TAGS.add((class_6862<class_1959>)class_6862.method_40092((class_5321)class_7924.field_41236, (class_2960)new class_2960(tagStr)));
            }
            catch (Exception e) {
                AdorableHamsterPets.LOGGER.info("[BiomeConfig] Invalid biome tag identifier in config: '{}'", (Object)tagStr);
            }
        }
        for (String biomeIdStr : Configs.AHP_WORLDGEN.includeBiomes) {
            try {
                PARSED_INCLUDES.add(new class_2960(biomeIdStr));
            }
            catch (Exception e) {
                AdorableHamsterPets.LOGGER.warn("[BiomeConfig] Invalid biome identifier in include list: '{}'", (Object)biomeIdStr);
            }
        }
        for (String biomeIdStr : Configs.AHP_WORLDGEN.excludeBiomes) {
            try {
                PARSED_EXCLUDES.add(new class_2960(biomeIdStr));
            }
            catch (Exception e) {
                AdorableHamsterPets.LOGGER.warn("[BiomeConfig] Invalid biome identifier in exclude list: '{}'", (Object)biomeIdStr);
            }
        }
        AdorableHamsterPets.LOGGER.info("[BiomeConfig] Parsed {} tags, {} included biomes, and {} excluded biomes.", new Object[]{PARSED_TAGS.size(), PARSED_INCLUDES.size(), PARSED_EXCLUDES.size()});
    }

    public static boolean shouldSpawnInBiome(BiomeModifications.BiomeContext ctx) {
        class_2960 biomeId = ctx.getKey().orElse(null);
        if (biomeId == null) {
            return false;
        }
        if (PARSED_EXCLUDES.contains(biomeId)) {
            return false;
        }
        if (PARSED_INCLUDES.contains(biomeId)) {
            return true;
        }
        for (class_6862<class_1959> tag : PARSED_TAGS) {
            if (!ctx.hasTag(tag)) continue;
            return true;
        }
        return false;
    }

    public static boolean shouldSpawnInBiomeNeoForge(class_6880<class_1959> biomeEntry) {
        class_2960 biomeId = biomeEntry.method_40230().map(class_5321::method_29177).orElse(null);
        if (biomeId == null) {
            return false;
        }
        if (PARSED_EXCLUDES.contains(biomeId)) {
            return false;
        }
        if (PARSED_INCLUDES.contains(biomeId)) {
            return true;
        }
        for (class_6862<class_1959> tag : PARSED_TAGS) {
            if (!biomeEntry.method_40220(tag)) continue;
            return true;
        }
        return false;
    }

    static {
        VALID_SPAWN_BLOCKS.add(class_2246.field_10102);
        VALID_SPAWN_BLOCKS.add(class_2246.field_10534);
        VALID_SPAWN_BLOCKS.add(class_2246.field_10415);
        VALID_SPAWN_BLOCKS.add(class_2246.field_10611);
        VALID_SPAWN_BLOCKS.add(class_2246.field_10184);
        VALID_SPAWN_BLOCKS.add(class_2246.field_10015);
        VALID_SPAWN_BLOCKS.add(class_2246.field_10325);
        VALID_SPAWN_BLOCKS.add(class_2246.field_10143);
        VALID_SPAWN_BLOCKS.add(class_2246.field_10014);
        VALID_SPAWN_BLOCKS.add(class_2246.field_10444);
        VALID_SPAWN_BLOCKS.add(class_2246.field_10349);
        VALID_SPAWN_BLOCKS.add(class_2246.field_10590);
        VALID_SPAWN_BLOCKS.add(class_2246.field_10235);
        VALID_SPAWN_BLOCKS.add(class_2246.field_10570);
        VALID_SPAWN_BLOCKS.add(class_2246.field_10409);
        VALID_SPAWN_BLOCKS.add(class_2246.field_10123);
        VALID_SPAWN_BLOCKS.add(class_2246.field_10526);
        VALID_SPAWN_BLOCKS.add(class_2246.field_10328);
        VALID_SPAWN_BLOCKS.add(class_2246.field_10626);
        VALID_SPAWN_BLOCKS.add(class_2246.field_10340);
        VALID_SPAWN_BLOCKS.add(class_2246.field_28888);
        VALID_SPAWN_BLOCKS.add(class_2246.field_10115);
        VALID_SPAWN_BLOCKS.add(class_2246.field_10508);
        VALID_SPAWN_BLOCKS.add(class_2246.field_10474);
        VALID_SPAWN_BLOCKS.add(class_2246.field_10255);
        VALID_SPAWN_BLOCKS.add(class_2246.field_10566);
        VALID_SPAWN_BLOCKS.add(class_2246.field_37576);
        VALID_SPAWN_BLOCKS.add(class_2246.field_37556);
        VALID_SPAWN_BLOCKS.add(class_2246.field_10219);
        VALID_SPAWN_BLOCKS.add(class_2246.field_28681);
        VALID_SPAWN_BLOCKS.add(class_2246.field_10253);
        VALID_SPAWN_BLOCKS.add(class_2246.field_10520);
        VALID_SPAWN_BLOCKS.add(class_2246.field_10491);
        VALID_SPAWN_BLOCKS.add(class_2246.field_10402);
        VALID_SPAWN_BLOCKS.add(class_2246.field_37568);
    }
}

