/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets;

import dev.architectury.event.EventResult;
import dev.architectury.event.events.client.ClientGuiEvent;
import dev.architectury.event.events.client.ClientTickEvent;
import dev.architectury.event.events.common.InteractionEvent;
import dev.architectury.registry.client.level.entity.EntityRendererRegistry;
import dev.architectury.registry.client.rendering.BlockEntityRendererRegistry;
import dev.architectury.registry.client.rendering.ColorHandlerRegistry;
import dev.architectury.registry.client.rendering.RenderTypeRegistry;
import dev.architectury.registry.menu.MenuRegistry;
import io.netty.buffer.Unpooled;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import me.fzzyhmstrs.fzzy_config.api.ConfigApiJava;
import net.dawson.adorablehamsterpets.AdorableHamsterPets;
import net.dawson.adorablehamsterpets.accessor.PlayerEntityAccessor;
import net.dawson.adorablehamsterpets.block.ModBlockEntities;
import net.dawson.adorablehamsterpets.block.ModBlocks;
import net.dawson.adorablehamsterpets.block.client.HamsterBedRenderer;
import net.dawson.adorablehamsterpets.client.announcements.AnnouncementHudRenderer;
import net.dawson.adorablehamsterpets.client.announcements.AnnouncementManager;
import net.dawson.adorablehamsterpets.client.event.AHPClientScreenEvents;
import net.dawson.adorablehamsterpets.client.gui.widgets.AnnouncementIconAnimator;
import net.dawson.adorablehamsterpets.client.option.ModKeyBindings;
import net.dawson.adorablehamsterpets.config.AhpConfig;
import net.dawson.adorablehamsterpets.config.ConfigDataCache;
import net.dawson.adorablehamsterpets.config.Configs;
import net.dawson.adorablehamsterpets.config.DismountPressType;
import net.dawson.adorablehamsterpets.config.DismountTriggerType;
import net.dawson.adorablehamsterpets.entity.ModEntities;
import net.dawson.adorablehamsterpets.entity.client.HamsterRenderer;
import net.dawson.adorablehamsterpets.entity.custom.HamsterEntity;
import net.dawson.adorablehamsterpets.item.ModItems;
import net.dawson.adorablehamsterpets.networking.ModPackets;
import net.dawson.adorablehamsterpets.particles.ModParticles;
import net.dawson.adorablehamsterpets.screen.HamsterInventoryScreen;
import net.dawson.adorablehamsterpets.screen.ModScreenHandlers;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class AdorableHamsterPetsClient {
    private static final Set<Integer> renderedHamsterIdsThisTick = new HashSet<Integer>();
    private static final Set<Integer> renderedHamsterIdsLastTick = new HashSet<Integer>();
    private static long lastSneakPressTime = 0L;
    private static boolean isWaitingForSecondSneakPress = false;
    private static boolean hadShoulderHamsterLastTick = false;
    private static int dismountDebounceTicks = 0;
    private static final int DISMOUNT_DEBOUNCE_DEFAULT = 5;
    private static final AnnouncementHudRenderer announcementHudRenderer = new AnnouncementHudRenderer();
    private static List<AnnouncementManager.PendingNotification> pendingNotifications = Collections.emptyList();
    private static int nextRefreshTicks = 6000;

    public static List<AnnouncementManager.PendingNotification> getPendingNotifications() {
        return pendingNotifications;
    }

    public static void init() {
        RenderTypeRegistry.register((RenderType)RenderType.m_110463_(), (Block[])new Block[]{(Block)ModBlocks.GREEN_BEANS_CROP.get(), (Block)ModBlocks.CUCUMBER_CROP.get(), (Block)ModBlocks.SUNFLOWER_BLOCK.get(), (Block)ModBlocks.WILD_CUCUMBER_BUSH.get(), (Block)ModBlocks.WILD_GREEN_BEAN_BUSH.get(), (Block)ModBlocks.HAMSTER_BED.get()});
        RenderTypeRegistry.register((RenderType)RenderType.m_110463_(), (Block[])new Block[]{(Block)ModBlocks.GREEN_BEANS_CROP.get(), (Block)ModBlocks.CUCUMBER_CROP.get(), (Block)ModBlocks.SUNFLOWER_BLOCK.get(), (Block)ModBlocks.WILD_CUCUMBER_BUSH.get(), (Block)ModBlocks.WILD_GREEN_BEAN_BUSH.get(), (Block)ModBlocks.HAMSTER_BED.get()});
        ConfigApiJava.event().onUpdateClient((id, config) -> {
            if (id.equals((Object)ResourceLocation.m_214293_((String)"adorablehamsterpets", (String)"main"))) {
                ConfigDataCache.parseConfig();
                AdorableHamsterPets.LOGGER.info("Reloaded Adorable Hamster Pets item tag config on client following GUI update. *wink wink*");
            }
        });
        ColorHandlerRegistry.registerItemColors((stack, tintIndex) -> -1, (ItemLike[])new ItemLike[]{(ItemLike)ModItems.HAMSTER_SPAWN_EGG.get()});
        ModPackets.registerS2CPackets();
        AHPClientScreenEvents.register();
        ClientTickEvent.CLIENT_POST.register(AdorableHamsterPetsClient::onEndClientTick);
        ClientGuiEvent.RENDER_HUD.register((context, tickDelta) -> announcementHudRenderer.render(context, tickDelta));
        InteractionEvent.INTERACT_ENTITY.register((player, entity, hand) -> {
            if (player.m_9236_().f_46443_ && hand == InteractionHand.MAIN_HAND && entity instanceof HamsterEntity) {
                HamsterEntity hamster = (HamsterEntity)entity;
                if (Configs.AHP.enableShoulderMountKeybind && ModKeyBindings.FORCE_MOUNT_HAMSTER_KEY.m_90857_() && hamster.m_21824_() && hamster.m_21830_((LivingEntity)player)) {
                    ModPackets.CHANNEL.sendToServer((Object)new ModPackets.RequestHamsterMountC2SPacket(hamster.m_19879_()));
                    return EventResult.interruptTrue();
                }
            }
            return EventResult.pass();
        });
    }

    public static void initBlockEntityRenderers() {
        BlockEntityRendererRegistry.register((BlockEntityType)((BlockEntityType)ModBlockEntities.HAMSTER_BED_BLOCK_ENTITY.get()), HamsterBedRenderer::new);
    }

    public static void initScreenHandlers() {
        MenuRegistry.registerScreenFactory((MenuType)((MenuType)ModScreenHandlers.HAMSTER_INVENTORY_SCREEN_HANDLER.get()), HamsterInventoryScreen::new);
    }

    public static void initEntityRenderers() {
        EntityRendererRegistry.register(ModEntities.HAMSTER, HamsterRenderer::new);
    }

    public static void onHamsterRendered(int entityId) {
        renderedHamsterIdsThisTick.add(entityId);
    }

    private static void onEndClientTick(Minecraft client) {
        boolean isGuiOpen = client.f_91080_ != null;
        AnnouncementIconAnimator.INSTANCE.tick(isGuiOpen);
        if (client.f_91073_ != null && !AnnouncementManager.INSTANCE.isPatchouliStateSynced()) {
            AnnouncementManager.INSTANCE.syncPatchouliReadState();
            if (AnnouncementManager.INSTANCE.isPatchouliStateSynced()) {
                AnnouncementManager.INSTANCE.processDeferredReadMarks();
            }
        }
        if (client.f_91073_ != null) {
            pendingNotifications = AnnouncementManager.INSTANCE.getPendingNotifications();
        }
        if (--nextRefreshTicks <= 0) {
            nextRefreshTicks = 6000;
            AnnouncementManager.INSTANCE.refreshManifest();
            AdorableHamsterPets.LOGGER.debug("[AHP Client Tick] Triggered periodic manifest refresh.");
        }
        if (client.f_91074_ == null || client.f_91073_ == null) {
            renderedHamsterIdsThisTick.clear();
            renderedHamsterIdsLastTick.clear();
            return;
        }
        if (ModKeyBindings.THROW_HAMSTER_KEY.m_90859_()) {
            AhpConfig currentConfig = AdorableHamsterPets.CONFIG;
            if (!currentConfig.enableHamsterThrowing) {
                client.f_91074_.m_5661_((Component)Component.m_237115_((String)"message.adorablehamsterpets.throwing_disabled"), true);
            } else {
                boolean lookingAtReachableBlock = client.f_91077_ != null && client.f_91077_.m_6662_() == HitResult.Type.BLOCK;
                boolean hasShoulderHamsterClient = ((PlayerEntityAccessor)client.f_91074_).hasAnyShoulderHamster();
                if (!lookingAtReachableBlock && hasShoulderHamsterClient) {
                    ModPackets.CHANNEL.sendToServer((Object)new ModPackets.ThrowHamsterC2SPacket());
                }
            }
        }
        HashSet<Integer> stoppedRendering = new HashSet<Integer>(renderedHamsterIdsLastTick);
        stoppedRendering.removeAll(renderedHamsterIdsThisTick);
        for (Integer entityId : stoppedRendering) {
            FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
            buf.writeInt(entityId.intValue());
            buf.writeBoolean(false);
            ModPackets.CHANNEL.sendToServer((Object)new ModPackets.UpdateRenderStateC2SPacket(entityId, false));
        }
        renderedHamsterIdsLastTick.clear();
        renderedHamsterIdsLastTick.addAll(renderedHamsterIdsThisTick);
        renderedHamsterIdsThisTick.clear();
        AdorableHamsterPetsClient.handleDismountKeyPress(client);
    }

    private static void handleDismountKeyPress(Minecraft client) {
        long delayMillis;
        long currentTime;
        if (client.f_91074_ == null || client.f_91073_ == null) {
            return;
        }
        boolean hasShoulderHamster = ((PlayerEntityAccessor)client.f_91074_).hasAnyShoulderHamster();
        if (hasShoulderHamster && !hadShoulderHamsterLastTick) {
            KeyMapping vanillaSneak = client.f_91066_.f_92090_;
            KeyMapping customDismount = ModKeyBindings.DISMOUNT_HAMSTER_KEY;
            if (vanillaSneak != null) {
                vanillaSneak.m_7249_(false);
                while (vanillaSneak.m_90859_()) {
                }
            }
            if (customDismount != null) {
                customDismount.m_7249_(false);
                while (customDismount.m_90859_()) {
                }
            }
            dismountDebounceTicks = 5;
            isWaitingForSecondSneakPress = false;
            AdorableHamsterPets.LOGGER.trace("[AHP DEBUG CLIENT] Mount transition detected -> draining input queues and starting debounce ({} ticks).", (Object)5);
        }
        hadShoulderHamsterLastTick = hasShoulderHamster;
        if (!hasShoulderHamster) {
            if (isWaitingForSecondSneakPress) {
                isWaitingForSecondSneakPress = false;
            }
            return;
        }
        if (dismountDebounceTicks > 0) {
            --dismountDebounceTicks;
            return;
        }
        AhpConfig config = AdorableHamsterPets.CONFIG;
        KeyMapping keyToListenFor = Configs.AHP.dismountTriggerType == DismountTriggerType.CUSTOM_KEYBIND ? ModKeyBindings.DISMOUNT_HAMSTER_KEY : client.f_91066_.f_92090_;
        boolean wasKeyPressed = keyToListenFor != null && keyToListenFor.m_90859_();
        AdorableHamsterPets.LOGGER.trace("[AHP DEBUG CLIENT] Tick Handler: Listening for '{}'. wasPressed() = {}", (Object)(keyToListenFor != null ? keyToListenFor.m_90860_() : "null-binding"), (Object)wasKeyPressed);
        if (wasKeyPressed) {
            AdorableHamsterPets.LOGGER.debug("[AHP DEBUG CLIENT] Tick Handler: SINGLE_PRESS detected. Press type config: {}", config.dismountPressType.get());
            if (config.dismountPressType.get() == DismountPressType.SINGLE_PRESS) {
                ModPackets.CHANNEL.sendToServer((Object)new ModPackets.DismountHamsterC2SPacket());
            } else {
                currentTime = System.currentTimeMillis();
                delayMillis = (long)((Integer)config.doubleTapDelayTicks.get()).intValue() * 50L;
                if (isWaitingForSecondSneakPress && currentTime - lastSneakPressTime <= delayMillis) {
                    AdorableHamsterPets.LOGGER.trace("[AHP DEBUG CLIENT] Tick Handler: DOUBLE_TAP second press detected. Sending dismount payload.");
                    ModPackets.CHANNEL.sendToServer((Object)new ModPackets.DismountHamsterC2SPacket());
                    isWaitingForSecondSneakPress = false;
                } else {
                    AdorableHamsterPets.LOGGER.trace("[AHP DEBUG CLIENT] Tick Handler: DOUBLE_TAP first press detected. Starting timer.");
                    isWaitingForSecondSneakPress = true;
                    lastSneakPressTime = currentTime;
                }
            }
        }
        if (isWaitingForSecondSneakPress && (currentTime = System.currentTimeMillis()) - lastSneakPressTime > (delayMillis = (long)((Integer)config.doubleTapDelayTicks.get()).intValue() * 50L)) {
            AdorableHamsterPets.LOGGER.trace("[AHP DEBUG CLIENT] Tick Handler: DOUBLE_TAP timed out.");
            isWaitingForSecondSneakPress = false;
        }
    }

    public static void handleSpawnBeddingParticles(ModPackets.SpawnBeddingParticlesS2CPacket packet) {
        Minecraft client = Minecraft.m_91087_();
        if (client.f_91073_ == null) {
            return;
        }
        BlockPos spawnPos = packet.pos().m_121945_(packet.direction());
        Vec3 particleCenter = Vec3.m_82512_((Vec3i)spawnPos);
        SimpleParticleType particleType = ModParticles.getForVariant(packet.variant());
        for (int i = 0; i < 30; ++i) {
            double offsetX = client.f_91073_.f_46441_.m_188583_() * 1.2;
            double offsetY = client.f_91073_.f_46441_.m_188583_() * 1.2;
            double offsetZ = client.f_91073_.f_46441_.m_188583_() * 1.2;
            client.f_91073_.m_7106_((ParticleOptions)particleType, particleCenter.f_82479_ + offsetX, particleCenter.f_82480_ + offsetY, particleCenter.f_82481_ + offsetZ, 0.0, -1.23E-4, 0.0);
        }
    }

    public static void handlePlayGuidebookEffects() {
        int i;
        Minecraft client = Minecraft.m_91087_();
        if (client == null) {
            return;
        }
        client.m_91152_(null);
        LocalPlayer player = client.f_91074_;
        ClientLevel world = client.f_91073_;
        if (player == null || world == null) {
            return;
        }
        player.m_5661_((Component)Component.m_237115_((String)"message.adorablehamsterpets.guidebook_rediscovered").m_130940_(ChatFormatting.GOLD), true);
        world.m_7785_(player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11887_, SoundSource.PLAYERS, 0.5f, 1.2f, false);
        world.m_7785_(player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11713_, SoundSource.PLAYERS, 0.7f, 1.5f, false);
        for (i = 0; i < 50; ++i) {
            world.m_7106_((ParticleOptions)ParticleTypes.f_123809_, player.m_20208_(0.6), player.m_20187_(), player.m_20262_(0.6), (world.f_46441_.m_188500_() - 0.5) * 0.5, (world.f_46441_.m_188500_() - 0.5) * 0.5, (world.f_46441_.m_188500_() - 0.5) * 0.5);
        }
        for (i = 0; i < 20; ++i) {
            world.m_7106_((ParticleOptions)ParticleTypes.f_123748_, player.m_20208_(1.0), player.m_20187_(), player.m_20262_(1.0), (world.f_46441_.m_188500_() - 0.5) * 0.5, (world.f_46441_.m_188500_() - 0.5) * 0.5, (world.f_46441_.m_188500_() - 0.5) * 0.5);
        }
    }
}

