/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.block.entity;

import java.util.Optional;
import java.util.UUID;
import net.dawson.adorablehamsterpets.block.ModBlockEntities;
import net.dawson.adorablehamsterpets.block.custom.HamsterBedBlock;
import net.dawson.adorablehamsterpets.config.Configs;
import net.dawson.adorablehamsterpets.config.WanderDistance;
import net.dawson.adorablehamsterpets.entity.custom.HamsterEntity;
import net.dawson.adorablehamsterpets.sound.ModSounds;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class HamsterBedBlockEntity
extends BlockEntity
implements GeoBlockEntity {
    private Optional<UUID> linkedHamsterUuid = Optional.empty();
    private Optional<Component> linkedHamsterName = Optional.empty();
    private WanderDistance wanderDistance = WanderDistance.MEDIUM;
    private boolean isNewlyPlaced = true;
    private boolean allowSleep = true;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public void registerControllers(AnimatableManager.ControllerRegistrar registrar) {
        AnimationController controller = new AnimationController((GeoAnimatable)this, "hamster_bed_controller", 2, state -> {
            BlockState blockState = ((HamsterBedBlockEntity)state.getAnimatable()).m_58900_();
            if (((Boolean)blockState.m_61143_((Property)HamsterBedBlock.OCCUPIED)).booleanValue()) {
                return state.setAndContinue(RawAnimation.begin().thenLoop("anim_bed_idle_waving_occupied"));
            }
            return state.setAndContinue(RawAnimation.begin().thenLoop("anim_bed_idle_waving_unoccupied"));
        });
        controller.triggerableAnim("anim_bed_being_placed", RawAnimation.begin().thenPlay("anim_bed_being_placed"));
        controller.triggerableAnim("anim_bed_becoming_occupied", RawAnimation.begin().thenPlay("anim_bed_becoming_occupied"));
        controller.triggerableAnim("anim_bed_becoming_unoccupied", RawAnimation.begin().thenPlay("anim_bed_becoming_unoccupied"));
        controller.triggerableAnim("anim_bed_interact_occupied", RawAnimation.begin().thenPlay("anim_bed_interact_occupied"));
        controller.triggerableAnim("anim_bed_interact_unoccupied", RawAnimation.begin().thenPlay("anim_bed_interact_unoccupied"));
        registrar.add(new AnimationController[]{controller});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public Optional<UUID> getLinkedHamsterUuid() {
        return this.linkedHamsterUuid;
    }

    public Optional<Component> getLinkedHamsterName() {
        return this.linkedHamsterName;
    }

    public boolean isWanderModeActive() {
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            Entity entity;
            ServerLevel serverWorld = (ServerLevel)level;
            if (this.linkedHamsterUuid.isPresent() && (entity = serverWorld.m_8791_(this.linkedHamsterUuid.get())) instanceof HamsterEntity) {
                HamsterEntity hamster = (HamsterEntity)entity;
                return hamster.isWanderModeActive();
            }
        }
        return false;
    }

    public boolean isNewlyPlaced() {
        return this.isNewlyPlaced;
    }

    public void markAsUsed() {
        this.isNewlyPlaced = false;
    }

    public boolean isSleepingAllowed() {
        return this.allowSleep;
    }

    public void setAllowSleep(boolean allow) {
        this.allowSleep = allow;
        this.m_6596_();
    }

    public void applyRepellentEffect() {
        this.setAllowSleep(false);
    }

    public HamsterBedBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.HAMSTER_BED_BLOCK_ENTITY.get(), pos, state);
    }

    public void setLinkedHamster(UUID uuid, Component name, WanderDistance distance) {
        this.linkedHamsterUuid = Optional.of(uuid);
        this.linkedHamsterName = Optional.of(name);
        this.wanderDistance = distance;
        this.m_6596_();
    }

    public WanderDistance getWanderDistance() {
        return this.wanderDistance;
    }

    public void toggleWanderMode(Player player) {
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            Entity entity;
            ServerLevel serverWorld = (ServerLevel)level;
            if (this.linkedHamsterUuid.isPresent() && (entity = serverWorld.m_8791_(this.linkedHamsterUuid.get())) instanceof HamsterEntity) {
                HamsterEntity hamster = (HamsterEntity)entity;
                boolean newMode = !hamster.isWanderModeActive();
                hamster.setWanderModeActive(newMode);
                if (!newMode && ((Boolean)this.m_58900_().m_61143_((Property)HamsterBedBlock.OCCUPIED)).booleanValue() && hamster.m_5803_()) {
                    hamster.wakeUpFromBed(true);
                }
                MutableComponent status = newMode ? Component.m_237113_((String)"ENABLED") : Component.m_237113_((String)"DISABLED");
                player.m_5661_((Component)Component.m_237110_((String)"message.adorablehamsterpets.wander_mode_set", (Object[])new Object[]{hamster.m_7755_(), status}), true);
                this.f_58857_.m_5594_(null, this.m_58899_(), (SoundEvent)SoundEvents.f_12490_.m_203334_(), SoundSource.BLOCKS, 0.5f, newMode ? 1.2f : 0.8f);
            }
        }
    }

    public void cycleWanderDistance(Player player) {
        WanderDistance[] values = WanderDistance.values();
        this.wanderDistance = values[(this.wanderDistance.ordinal() + 1) % values.length];
        this.m_6596_();
        if (this.linkedHamsterName.isPresent()) {
            player.m_5661_((Component)Component.m_237110_((String)"message.adorablehamsterpets.wander_distance_set", (Object[])new Object[]{this.linkedHamsterName.get(), this.wanderDistance.m_7912_()}), true);
            this.f_58857_.m_5594_(null, this.m_58899_(), (SoundEvent)SoundEvents.f_12490_.m_203334_(), SoundSource.BLOCKS, 0.5f, 1.0f);
        }
    }

    public boolean lureHamsterToBed(Player player, ItemStack lureItem) {
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            Entity entity;
            ServerLevel serverWorld = (ServerLevel)level;
            if (this.linkedHamsterUuid.isPresent() && (entity = serverWorld.m_8791_(this.linkedHamsterUuid.get())) instanceof HamsterEntity) {
                HamsterEntity hamster = (HamsterEntity)entity;
                if (!hamster.isWanderModeActive()) {
                    hamster.setWanderModeActive(true);
                }
                if (hamster.m_21827_() || hamster.m_5803_()) {
                    player.m_5661_((Component)Component.m_237115_((String)"message.adorablehamsterpets.lure_to_bed_fail").m_130940_(ChatFormatting.RED), true);
                    return false;
                }
                hamster.lureToBed();
                SoundEvent lureSound = ModSounds.getDynamicItemSound(lureItem);
                this.f_58857_.m_5594_(null, this.m_58899_(), lureSound, SoundSource.BLOCKS, 1.0f, 1.0f);
                ((ServerLevel)this.f_58857_).m_8767_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, lureItem), (double)this.m_58899_().m_123341_() + 0.5, (double)this.m_58899_().m_123342_() + 0.7, (double)this.m_58899_().m_123343_() + 0.5, 8, 0.25, 0.25, 0.25, 0.05);
                return true;
            }
        }
        return false;
    }

    public void unlinkHamster(Player player) {
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)level;
            if (this.linkedHamsterUuid.isPresent()) {
                HamsterEntity hamster;
                Entity entity;
                UUID uuidToUnlink = this.linkedHamsterUuid.get();
                Component hamsterNameToUnlink = this.linkedHamsterName.orElse((Component)Component.m_237113_((String)"A hamster"));
                if (((Boolean)this.m_58900_().m_61143_((Property)HamsterBedBlock.OCCUPIED)).booleanValue() && (entity = serverWorld.m_8791_(uuidToUnlink)) instanceof HamsterEntity && (hamster = (HamsterEntity)entity).m_5803_()) {
                    hamster.wakeUpFromBed(true);
                }
                this.linkedHamsterUuid = Optional.empty();
                this.linkedHamsterName = Optional.empty();
                this.wanderDistance = (WanderDistance)((Object)Configs.AHP.defaultWanderDistance.get());
                this.m_6596_();
                entity = serverWorld.m_8791_(uuidToUnlink);
                if (entity instanceof HamsterEntity) {
                    hamster = (HamsterEntity)entity;
                    hamster.setWanderModeActive(false);
                    hamster.setLinkedBedPos(Optional.empty());
                }
                player.m_5661_((Component)Component.m_237110_((String)"message.adorablehamsterpets.bed_unlinked", (Object[])new Object[]{hamsterNameToUnlink}).m_130940_(ChatFormatting.YELLOW), true);
                this.f_58857_.m_5594_(null, this.m_58899_(), SoundEvents.f_12344_, SoundSource.BLOCKS, 1.0f, 1.2f);
            }
        }
    }

    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        this.linkedHamsterUuid.ifPresent(uuid -> nbt.m_128362_("LinkedHamsterUuid", uuid));
        this.linkedHamsterName.ifPresent(name -> nbt.m_128359_("LinkedHamsterName", Component.Serializer.m_130703_((Component)name)));
        nbt.m_128359_("WanderDistance", this.wanderDistance.m_7912_());
        nbt.m_128379_("IsNewlyPlaced", this.isNewlyPlaced);
        if (!((Boolean)this.m_58900_().m_61143_((Property)HamsterBedBlock.UPSIDE_DOWN)).booleanValue()) {
            nbt.m_128379_("AllowSleep", this.allowSleep);
        }
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.linkedHamsterUuid = nbt.m_128403_("LinkedHamsterUuid") ? Optional.of(nbt.m_128342_("LinkedHamsterUuid")) : Optional.empty();
        this.linkedHamsterName = nbt.m_128441_("LinkedHamsterName") ? Optional.ofNullable(Component.Serializer.m_130701_((String)nbt.m_128461_("LinkedHamsterName"))) : Optional.empty();
        try {
            this.wanderDistance = WanderDistance.valueOf(nbt.m_128461_("WanderDistance").toUpperCase());
        }
        catch (IllegalArgumentException e) {
            this.wanderDistance = WanderDistance.MEDIUM;
        }
        this.isNewlyPlaced = nbt.m_128441_("IsNewlyPlaced") ? nbt.m_128471_("IsNewlyPlaced") : false;
        this.allowSleep = !nbt.m_128441_("AllowSleep") || nbt.m_128471_("AllowSleep");
    }
}

