/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.client.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.Nullable;

public class MarkdownRenderer {
    private static final Pattern BOLD_PATTERN = Pattern.compile("\\*\\*(.*?)\\*\\*");
    private static final Pattern ITALIC_PATTERN = Pattern.compile("\\*(.*?)\\*");
    private static final Pattern CODE_PATTERN = Pattern.compile("`(.*?)`");
    private static final Pattern LINK_PATTERN = Pattern.compile("\\[(.*?)]\\((.*?)\\)");
    public static final int LINE_SPACING = 2;
    public static final int HEADING_BOTTOM_MARGIN = 4;
    public static final int DIVIDER_HEIGHT = 13;
    public static final int LIST_INDENT = 10;
    public static final int SPACES_PER_INDENT_LEVEL = 4;
    private final Font textRenderer;
    public final List<String> lines;
    private final int x;
    private final int startY;
    public final int width;
    private int totalHeight = 0;

    public MarkdownRenderer(String markdownContent, int x, int startY, int width) {
        this.textRenderer = Minecraft.m_91087_().f_91062_;
        this.lines = markdownContent == null ? List.of() : List.of(markdownContent.split("\n"));
        this.x = x;
        this.startY = startY;
        this.width = width;
        this.calculateHeight(width);
    }

    public void render(GuiGraphics context, int scrollY, @Nullable Style hoveredStyle) {
        int currentY = this.startY - scrollY;
        for (String originalLine : this.lines) {
            String trimmedLine = originalLine.trim();
            if (trimmedLine.isEmpty()) {
                Objects.requireNonNull(this.textRenderer);
                currentY += 9 / 2;
                continue;
            }
            if (trimmedLine.startsWith("#")) {
                currentY = this.renderHeading(context, trimmedLine, currentY);
                continue;
            }
            if (trimmedLine.equals("---")) {
                currentY = this.renderDivider(context, currentY);
                continue;
            }
            if (trimmedLine.startsWith("- ") || trimmedLine.startsWith("* ") || trimmedLine.matches("^\\d+\\.\\s.*")) {
                currentY = this.renderListItem(context, originalLine, currentY, hoveredStyle);
                continue;
            }
            currentY = this.renderParagraph(context, trimmedLine, currentY, this.x, this.width, hoveredStyle);
        }
    }

    public int getTotalHeight() {
        return this.totalHeight;
    }

    public static int getIndentationLevel(String line) {
        int spaces = 0;
        for (char c : line.toCharArray()) {
            if (c != ' ') break;
            ++spaces;
        }
        return spaces / 4;
    }

    private int renderHeading(GuiGraphics context, String line, int y) {
        int level;
        for (level = 0; level < line.length() && line.charAt(level) == '#'; ++level) {
        }
        String text = line.substring(level).trim();
        float scale = Math.max(1.0f, 2.0f - (float)(level - 1) * 0.25f);
        int color = 0x323232;
        MutableComponent styledText = Component.m_237113_((String)text).m_6270_(Style.f_131099_.m_131136_(Boolean.valueOf(true)));
        int scaledWidth = (int)((float)this.width / scale);
        List wrappedLines = this.textRenderer.m_92923_((FormattedText)styledText, scaledWidth);
        PoseStack matrices = context.m_280168_();
        for (FormattedCharSequence wrappedLine : wrappedLines) {
            matrices.m_85836_();
            matrices.m_252880_((float)this.x, (float)y, 0.0f);
            matrices.m_85841_(scale, scale, 1.0f);
            context.m_280649_(this.textRenderer, wrappedLine, 0, 0, color, false);
            matrices.m_85849_();
            Objects.requireNonNull(this.textRenderer);
            y += (int)(9.0f * scale) + 2;
        }
        return y - 2 + 4;
    }

    private int renderDivider(GuiGraphics context, int y) {
        context.m_280509_(this.x + 15, y + 3, this.x + this.width - 15, y + 4, -5000269);
        return y + 13;
    }

    private int renderListItem(GuiGraphics context, String line, int y, @Nullable Style hoveredStyle) {
        String content;
        String bullet;
        int indentationLevel = MarkdownRenderer.getIndentationLevel(line);
        String trimmedLine = line.trim();
        if (trimmedLine.matches("^\\d+\\.\\s.*")) {
            int dotIndex = trimmedLine.indexOf(46);
            bullet = trimmedLine.substring(0, dotIndex + 1);
            content = trimmedLine.substring(dotIndex + 1).trim();
        } else {
            bullet = "\u2022";
            content = trimmedLine.substring(1).trim();
        }
        int bulletX = this.x + indentationLevel * 10;
        int contentX = bulletX + 10;
        int contentWidth = this.width - (indentationLevel + 1) * 10;
        context.m_280056_(this.textRenderer, bullet, bulletX, y, 0x323232, false);
        return this.renderParagraph(context, content, y, contentX, contentWidth, hoveredStyle);
    }

    private int renderParagraph(GuiGraphics context, String line, int y, int startX, int lineWidth, @Nullable Style hoveredStyle) {
        int indentationLevel = MarkdownRenderer.getIndentationLevel(line);
        String content = line.substring(indentationLevel * 4);
        int finalStartX = startX + indentationLevel * 10;
        int finalLineWidth = lineWidth - indentationLevel * 10;
        MutableComponent styledText = this.parseLineToText(content, hoveredStyle);
        List wrappedLines = this.textRenderer.m_92923_((FormattedText)styledText, finalLineWidth);
        for (FormattedCharSequence wrappedLine : wrappedLines) {
            context.m_280649_(this.textRenderer, wrappedLine, finalStartX, y, 0x323232, false);
            Objects.requireNonNull(this.textRenderer);
            y += 9 + 2;
        }
        return y;
    }

    public MutableComponent parseLineToText(String line, @Nullable Style hoveredStyle) {
        MutableComponent result = Component.m_237119_();
        String remaining = line;
        while (!remaining.isEmpty()) {
            Matcher boldMatcher = BOLD_PATTERN.matcher(remaining);
            Matcher italicMatcher = ITALIC_PATTERN.matcher(remaining);
            Matcher codeMatcher = CODE_PATTERN.matcher(remaining);
            Matcher linkMatcher = LINK_PATTERN.matcher(remaining);
            int nextMatchPos = Integer.MAX_VALUE;
            Matcher nextMatcher = null;
            if (boldMatcher.find(0) && boldMatcher.start() < nextMatchPos) {
                nextMatchPos = boldMatcher.start();
                nextMatcher = boldMatcher;
            }
            if (italicMatcher.find(0) && italicMatcher.start() < nextMatchPos) {
                nextMatchPos = italicMatcher.start();
                nextMatcher = italicMatcher;
            }
            if (codeMatcher.find(0) && codeMatcher.start() < nextMatchPos) {
                nextMatchPos = codeMatcher.start();
                nextMatcher = codeMatcher;
            }
            if (linkMatcher.find(0) && linkMatcher.start() < nextMatchPos) {
                nextMatchPos = linkMatcher.start();
                nextMatcher = linkMatcher;
            }
            if (nextMatcher != null) {
                if (nextMatchPos > 0) {
                    result.m_7220_((Component)Component.m_237113_((String)remaining.substring(0, nextMatchPos)));
                }
                if (nextMatcher == boldMatcher) {
                    result.m_7220_((Component)Component.m_237113_((String)boldMatcher.group(1)).m_6270_(Style.f_131099_.m_131136_(Boolean.valueOf(true))));
                } else if (nextMatcher == italicMatcher) {
                    result.m_7220_((Component)Component.m_237113_((String)italicMatcher.group(1)).m_6270_(Style.f_131099_.m_131155_(Boolean.valueOf(true))));
                } else if (nextMatcher == codeMatcher) {
                    result.m_7220_((Component)Component.m_237113_((String)codeMatcher.group(1)).m_6270_(Style.f_131099_.m_131150_(ResourceLocation.m_214293_((String)"minecraft", (String)"uniform")).m_131140_(ChatFormatting.BLACK)));
                } else if (nextMatcher == linkMatcher) {
                    ClickEvent clickEvent;
                    String linkText = linkMatcher.group(1);
                    String url = linkMatcher.group(2);
                    if (url.startsWith("ahp://copy ")) {
                        String command = url.substring("ahp://copy ".length());
                        clickEvent = new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, command);
                    } else {
                        clickEvent = new ClickEvent(ClickEvent.Action.OPEN_URL, url);
                    }
                    Style linkStyle = Style.f_131099_.m_131140_(ChatFormatting.AQUA).m_131162_(Boolean.valueOf(true)).m_131136_(Boolean.valueOf(true)).m_131142_(clickEvent);
                    if (hoveredStyle != null && hoveredStyle.m_131182_() != null && hoveredStyle.m_131182_().equals((Object)clickEvent)) {
                        linkStyle = linkStyle.m_131140_(ChatFormatting.GOLD).m_131162_(Boolean.valueOf(false)).m_131136_(Boolean.valueOf(true));
                    }
                    result.m_7220_((Component)Component.m_237113_((String)linkText).m_6270_(linkStyle));
                }
                remaining = remaining.substring(nextMatcher.end());
                continue;
            }
            result.m_7220_((Component)Component.m_237113_((String)remaining));
            break;
        }
        return result;
    }

    private void calculateHeight(int lineWidth) {
        int currentY = 0;
        for (String line : this.lines) {
            int contentWidth;
            String trimmedLine = line.trim();
            if (trimmedLine.isEmpty()) {
                Objects.requireNonNull(this.textRenderer);
                currentY += 9 / 2;
                continue;
            }
            if (trimmedLine.startsWith("#")) {
                int level;
                for (level = 0; level < trimmedLine.length() && trimmedLine.charAt(level) == '#'; ++level) {
                }
                String text = trimmedLine.substring(level).trim();
                float scale = Math.max(1.0f, 2.0f - (float)(level - 1) * 0.25f);
                int scaledWidth = (int)((float)lineWidth / scale);
                MutableComponent styledText = Component.m_237113_((String)text).m_6270_(Style.f_131099_.m_131136_(Boolean.valueOf(true)));
                int wrappedLinesCount = this.textRenderer.m_92923_((FormattedText)styledText, scaledWidth).size();
                Objects.requireNonNull(this.textRenderer);
                int heightOfLines = wrappedLinesCount * (int)(9.0f * scale);
                int totalSpacing = Math.max(0, wrappedLinesCount - 1) * 2;
                currentY += heightOfLines + totalSpacing + 4;
                continue;
            }
            if (trimmedLine.equals("---")) {
                currentY += 13;
                continue;
            }
            int indentationLevel = MarkdownRenderer.getIndentationLevel(line);
            String content = trimmedLine;
            if (content.startsWith("- ") || content.startsWith("* ") || content.matches("^\\d+\\.\\s.*")) {
                contentWidth = lineWidth - (indentationLevel + 1) * 10;
                content = content.matches("^\\d+\\.\\s.*") ? content.substring(content.indexOf(46) + 1).trim() : content.substring(1).trim();
            } else {
                contentWidth = lineWidth - indentationLevel * 10;
            }
            MutableComponent styledText = this.parseLineToText(content, null);
            int wrappedLinesCount = this.textRenderer.m_92923_((FormattedText)styledText, contentWidth).size();
            Objects.requireNonNull(this.textRenderer);
            currentY += wrappedLinesCount * (9 + 2);
        }
        this.totalHeight = currentY;
    }
}

