/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.entity.AI;

import java.util.EnumSet;
import java.util.List;
import net.dawson.adorablehamsterpets.AdorableHamsterPets;
import net.dawson.adorablehamsterpets.config.AhpConfig;
import net.dawson.adorablehamsterpets.entity.custom.HamsterEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;

public class HamsterMateGoal
extends Goal {
    private final HamsterEntity hamster;
    private HamsterEntity targetMate;
    private final double speed;
    private int timer;

    public HamsterMateGoal(HamsterEntity hamster, double speed) {
        this.hamster = hamster;
        this.speed = speed;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (this.hamster.m_21827_()) {
            return false;
        }
        boolean inLove = this.hamster.isInCustomLove();
        if (inLove) {
            this.targetMate = this.getNearbyMate();
            return this.targetMate != null;
        }
        return false;
    }

    public boolean m_8045_() {
        return this.targetMate != null && this.targetMate.m_6084_() && this.hamster.isInCustomLove() && this.timer < 60;
    }

    public void m_8056_() {
        this.timer = 0;
        this.hamster.setActiveCustomGoalDebugName(((Object)((Object)this)).getClass().getSimpleName());
    }

    public void m_8041_() {
        if (this.hamster.getActiveCustomGoalDebugName().equals(((Object)((Object)this)).getClass().getSimpleName())) {
            this.hamster.setActiveCustomGoalDebugName("None");
        }
        this.targetMate = null;
    }

    public void m_8037_() {
        this.hamster.m_21573_().m_5624_((Entity)this.targetMate, this.speed);
        this.hamster.m_21563_().m_24960_((Entity)this.targetMate, 25.0f, 25.0f);
        ++this.timer;
        if (this.timer >= 60) {
            this.breed();
        }
    }

    private HamsterEntity getNearbyMate() {
        AdorableHamsterPets.LOGGER.trace("[MateGoal {} Tick {}] getNearbyMate() searching...", (Object)this.hamster.m_19879_(), (Object)this.hamster.m_9236_().m_46467_());
        List candidates = this.hamster.m_9236_().m_6443_(HamsterEntity.class, this.hamster.m_20191_().m_82400_(8.0), h -> {
            boolean potential = h != this.hamster && h.isInCustomLove() && h.m_146764_() == 0;
            AdorableHamsterPets.LOGGER.trace("  - Checking candidate {}: isInCustomLove={}, getBreedingAge={}, isSelf={}, Result={}", new Object[]{h.m_19879_(), h.isInCustomLove(), h.m_146764_(), h == this.hamster, potential});
            return potential;
        });
        HamsterEntity found = candidates.stream().findAny().orElse(null);
        AdorableHamsterPets.LOGGER.trace("[MateGoal {} Tick {}] getNearbyMate() found: {}", new Object[]{this.hamster.m_19879_(), this.hamster.m_9236_().m_46467_(), found != null ? Integer.valueOf(found.m_19879_()) : "null"});
        return found;
    }

    private void breed() {
        AhpConfig config = AdorableHamsterPets.CONFIG;
        int cooldown = (Integer)config.breedingCooldownTicks.get();
        this.hamster.m_146762_(cooldown);
        this.targetMate.m_146762_(cooldown);
        this.hamster.customLoveTimer = 0;
        this.targetMate.customLoveTimer = 0;
        HamsterEntity baby = (HamsterEntity)this.hamster.m_142606_((ServerLevel)this.hamster.m_9236_(), (AgeableMob)this.targetMate);
        if (baby != null) {
            baby.m_7678_(this.hamster.m_20185_(), this.hamster.m_20186_(), this.hamster.m_20189_(), 0.0f, 0.0f);
            this.hamster.m_9236_().m_7967_((Entity)baby);
        }
    }
}

