/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.item.custom;

import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.architectury.platform.Platform;
import dev.architectury.utils.Env;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.dawson.adorablehamsterpets.block.custom.HamsterBedBlock;
import net.dawson.adorablehamsterpets.block.custom.WoodVariant;
import net.dawson.adorablehamsterpets.block.entity.HamsterBedBlockEntity;
import net.dawson.adorablehamsterpets.config.Configs;
import net.dawson.adorablehamsterpets.config.WanderDistance;
import net.dawson.adorablehamsterpets.entity.custom.HamsterEntity;
import net.dawson.adorablehamsterpets.item.client.HamsterBedRenderProvider;
import net.dawson.adorablehamsterpets.item.custom.forge.HamsterBedItemImpl;
import net.dawson.adorablehamsterpets.particles.ModParticles;
import net.dawson.adorablehamsterpets.sound.ModSounds;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class HamsterBedItem
extends BlockItem
implements GeoItem {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final WoodVariant variant;
    private final Supplier<Object> renderProvider = new Supplier<Object>(){
        private Object provider;

        @Override
        public Object get() {
            if (this.provider == null && Platform.getEnvironment() == Env.CLIENT) {
                this.provider = HamsterBedRenderProvider.create();
            }
            return this.provider;
        }
    };

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static HamsterBedItem create(Block block, WoodVariant variant, Item.Properties settings) {
        void var2_2;
        void var1_1;
        return HamsterBedItemImpl.create(block, (WoodVariant)var1_1, (Item.Properties)var2_2);
    }

    public Supplier<Object> getRenderProvider() {
        return this.renderProvider;
    }

    public HamsterBedItem(Block block, WoodVariant variant, Item.Properties settings) {
        super(block, settings);
        this.variant = variant;
        GeoItem.registerSyncedAnimatable((GeoAnimatable)this);
    }

    protected boolean m_7274_(BlockPos pos, Level world, @Nullable Player player, ItemStack stack, BlockState state) {
        if (!world.f_46443_) {
            BlockEntity be;
            SoundEvent rustleSound = ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_BED_LEAVES_RUSTLE_SOUNDS, world.m_213780_());
            if (rustleSound != null) {
                world.m_5594_(null, pos, rustleSound, SoundSource.BLOCKS, 0.5f, 1.5f);
            }
            if ((be = world.m_7702_(pos)) instanceof HamsterBedBlockEntity) {
                HamsterBedBlockEntity bedEntity = (HamsterBedBlockEntity)be;
                bedEntity.triggerAnim("hamster_bed_controller", "anim_bed_being_placed");
                WoodVariant variant = this.variant;
                if (stack.m_41782_() && stack.m_41783_().m_128441_("WoodVariant")) {
                    try {
                        variant = WoodVariant.valueOf(stack.m_41783_().m_128461_("WoodVariant"));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
                ((ServerLevel)world).m_8767_((ParticleOptions)ModParticles.getForVariant(variant), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.3, (double)pos.m_123343_() + 0.5, 30, 0.1, 0.2, 0.1, 0.0);
            }
        }
        return world.m_7731_(pos, (BlockState)state.m_61124_(HamsterBedBlock.WOOD_VARIANT, (Comparable)((Object)this.variant)), 11);
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag context) {
        WoodVariant stackVariant = this.variant;
        if (stack.m_41782_() && stack.m_41783_().m_128441_("WoodVariant")) {
            try {
                stackVariant = WoodVariant.valueOf(stack.m_41783_().m_128461_("WoodVariant"));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (Configs.AHP.enableItemTooltips) {
            if (Screen.m_96638_()) {
                CompoundTag nbt;
                tooltip.add((Component)Component.m_237115_((String)"tooltip.adorablehamsterpets.hamster_bed.description1").m_130940_(ChatFormatting.GOLD));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.adorablehamsterpets.hamster_bed.description2").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.adorablehamsterpets.jade.wander_controls").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.adorablehamsterpets.jade.lure_hint").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.adorablehamsterpets.jade.repellent_hint").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.adorablehamsterpets.jade.unlink_hint").m_130940_(ChatFormatting.GRAY));
                if (stack.m_41782_() && (nbt = stack.m_41783_()).m_128441_("LinkedHamsterUuid") && nbt.m_128441_("LinkedHamsterName")) {
                    MutableComponent hamsterName = Component.Serializer.m_130701_((String)nbt.m_128461_("LinkedHamsterName"));
                    tooltip.add((Component)Component.m_237113_((String)""));
                    if (hamsterName != null) {
                        tooltip.add((Component)Component.m_237110_((String)"tooltip.adorablehamsterpets.hamster_bed.linked_to", (Object[])new Object[]{hamsterName}).m_130940_(ChatFormatting.GREEN));
                    }
                    if (nbt.m_128441_("WanderDistance")) {
                        try {
                            WanderDistance wanderDistance = WanderDistance.valueOf(nbt.m_128461_("WanderDistance"));
                            int radius = switch (wanderDistance) {
                                case WanderDistance.NEAR -> (Integer)Configs.AHP.wanderDistanceNear.get();
                                case WanderDistance.FAR -> (Integer)Configs.AHP.wanderDistanceFar.get();
                                default -> (Integer)Configs.AHP.wanderDistanceMedium.get();
                            };
                            tooltip.add((Component)Component.m_237110_((String)"tooltip.adorablehamsterpets.hamster_bed.wander_distance", (Object[])new Object[]{wanderDistance.m_7912_(), radius}).m_130940_(ChatFormatting.AQUA));
                        }
                        catch (IllegalArgumentException illegalArgumentException) {}
                    }
                }
            } else {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.adorablehamsterpets.hamster_bed.description1").m_130940_(ChatFormatting.GOLD));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.adorablehamsterpets.shift_for_info").m_130940_(ChatFormatting.DARK_GRAY));
            }
        } else {
            tooltip.add((Component)Component.m_237113_((String)"Adorable Hamster Pets").m_130944_(new ChatFormatting[]{ChatFormatting.BLUE, ChatFormatting.ITALIC}));
        }
        super.m_7373_(stack, world, tooltip, context);
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        if (!world.f_46443_) {
            return;
        }
        if (!stack.m_41782_() || !stack.m_41783_().m_128441_("LinkedHamsterUuid")) {
            return;
        }
        UUID linkedUuid = stack.m_41783_().m_128342_("LinkedHamsterUuid");
        if (entity instanceof Player) {
            world.m_6443_(HamsterEntity.class, entity.m_20191_().m_82400_(16.0), e -> e.m_20148_().equals(linkedUuid)).stream().findFirst().ifPresent(hamster -> {
                String newJson;
                Object newName = hamster.m_8077_() ? hamster.m_7755_() : hamster.m_5446_().m_6881_().m_130946_(" " + hamster.m_19879_());
                String currentJson = stack.m_41783_().m_128461_("LinkedHamsterName");
                if (!currentJson.equals(newJson = Component.Serializer.m_130703_((Component)newName))) {
                    stack.m_41784_().m_128359_("LinkedHamsterName", newJson);
                }
            });
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public WoodVariant getVariant() {
        return this.variant;
    }

    public String m_5524_() {
        return this.m_41467_();
    }

    public void createRenderer(Consumer<Object> consumer) {
        if (Platform.getEnvironment() == Env.CLIENT) {
            consumer.accept(HamsterBedRenderProvider.create());
        }
    }
}

