/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.world.gen;

import dev.architectury.registry.level.biome.BiomeModifications;
import java.util.HashSet;
import java.util.Set;
import net.dawson.adorablehamsterpets.AdorableHamsterPets;
import net.dawson.adorablehamsterpets.config.Configs;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class ModEntitySpawns {
    public static final Set<Block> VALID_SPAWN_BLOCKS = new HashSet<Block>();
    private static final Set<TagKey<Biome>> PARSED_TAGS = new HashSet<TagKey<Biome>>();
    private static final Set<ResourceLocation> PARSED_INCLUDES = new HashSet<ResourceLocation>();
    private static final Set<ResourceLocation> PARSED_EXCLUDES = new HashSet<ResourceLocation>();

    public static void parseConfig() {
        PARSED_TAGS.clear();
        PARSED_INCLUDES.clear();
        PARSED_EXCLUDES.clear();
        for (String tagStr : Configs.AHP_WORLDGEN.spawnBiomeTags) {
            try {
                PARSED_TAGS.add((TagKey<Biome>)TagKey.m_203882_((ResourceKey)Registries.f_256952_, (ResourceLocation)new ResourceLocation(tagStr)));
            }
            catch (Exception e) {
                AdorableHamsterPets.LOGGER.info("[BiomeConfig] Invalid biome tag identifier in config: '{}'", (Object)tagStr);
            }
        }
        for (String biomeIdStr : Configs.AHP_WORLDGEN.includeBiomes) {
            try {
                PARSED_INCLUDES.add(new ResourceLocation(biomeIdStr));
            }
            catch (Exception e) {
                AdorableHamsterPets.LOGGER.warn("[BiomeConfig] Invalid biome identifier in include list: '{}'", (Object)biomeIdStr);
            }
        }
        for (String biomeIdStr : Configs.AHP_WORLDGEN.excludeBiomes) {
            try {
                PARSED_EXCLUDES.add(new ResourceLocation(biomeIdStr));
            }
            catch (Exception e) {
                AdorableHamsterPets.LOGGER.warn("[BiomeConfig] Invalid biome identifier in exclude list: '{}'", (Object)biomeIdStr);
            }
        }
        AdorableHamsterPets.LOGGER.info("[BiomeConfig] Parsed {} tags, {} included biomes, and {} excluded biomes.", new Object[]{PARSED_TAGS.size(), PARSED_INCLUDES.size(), PARSED_EXCLUDES.size()});
    }

    public static boolean shouldSpawnInBiome(BiomeModifications.BiomeContext ctx) {
        ResourceLocation biomeId = ctx.getKey().orElse(null);
        if (biomeId == null) {
            return false;
        }
        if (PARSED_EXCLUDES.contains(biomeId)) {
            return false;
        }
        if (PARSED_INCLUDES.contains(biomeId)) {
            return true;
        }
        for (TagKey<Biome> tag : PARSED_TAGS) {
            if (!ctx.hasTag(tag)) continue;
            return true;
        }
        return false;
    }

    public static boolean shouldSpawnInBiomeNeoForge(Holder<Biome> biomeEntry) {
        ResourceLocation biomeId = biomeEntry.m_203543_().map(ResourceKey::m_135782_).orElse(null);
        if (biomeId == null) {
            return false;
        }
        if (PARSED_EXCLUDES.contains(biomeId)) {
            return false;
        }
        if (PARSED_INCLUDES.contains(biomeId)) {
            return true;
        }
        for (TagKey<Biome> tag : PARSED_TAGS) {
            if (!biomeEntry.m_203656_(tag)) continue;
            return true;
        }
        return false;
    }

    static {
        VALID_SPAWN_BLOCKS.add(Blocks.f_49992_);
        VALID_SPAWN_BLOCKS.add(Blocks.f_49993_);
        VALID_SPAWN_BLOCKS.add(Blocks.f_50352_);
        VALID_SPAWN_BLOCKS.add(Blocks.f_50287_);
        VALID_SPAWN_BLOCKS.add(Blocks.f_50288_);
        VALID_SPAWN_BLOCKS.add(Blocks.f_50289_);
        VALID_SPAWN_BLOCKS.add(Blocks.f_50290_);
        VALID_SPAWN_BLOCKS.add(Blocks.f_50291_);
        VALID_SPAWN_BLOCKS.add(Blocks.f_50292_);
        VALID_SPAWN_BLOCKS.add(Blocks.f_50293_);
        VALID_SPAWN_BLOCKS.add(Blocks.f_50294_);
        VALID_SPAWN_BLOCKS.add(Blocks.f_50295_);
        VALID_SPAWN_BLOCKS.add(Blocks.f_50296_);
        VALID_SPAWN_BLOCKS.add(Blocks.f_50297_);
        VALID_SPAWN_BLOCKS.add(Blocks.f_50298_);
        VALID_SPAWN_BLOCKS.add(Blocks.f_50299_);
        VALID_SPAWN_BLOCKS.add(Blocks.f_50300_);
        VALID_SPAWN_BLOCKS.add(Blocks.f_50301_);
        VALID_SPAWN_BLOCKS.add(Blocks.f_50302_);
        VALID_SPAWN_BLOCKS.add(Blocks.f_50069_);
        VALID_SPAWN_BLOCKS.add(Blocks.f_152550_);
        VALID_SPAWN_BLOCKS.add(Blocks.f_50334_);
        VALID_SPAWN_BLOCKS.add(Blocks.f_50228_);
        VALID_SPAWN_BLOCKS.add(Blocks.f_50122_);
        VALID_SPAWN_BLOCKS.add(Blocks.f_49994_);
        VALID_SPAWN_BLOCKS.add(Blocks.f_50493_);
        VALID_SPAWN_BLOCKS.add(Blocks.f_220864_);
        VALID_SPAWN_BLOCKS.add(Blocks.f_220843_);
        VALID_SPAWN_BLOCKS.add(Blocks.f_50440_);
        VALID_SPAWN_BLOCKS.add(Blocks.f_152544_);
        VALID_SPAWN_BLOCKS.add(Blocks.f_50546_);
        VALID_SPAWN_BLOCKS.add(Blocks.f_50599_);
        VALID_SPAWN_BLOCKS.add(Blocks.f_50127_);
        VALID_SPAWN_BLOCKS.add(Blocks.f_50195_);
        VALID_SPAWN_BLOCKS.add(Blocks.f_220855_);
    }
}

