/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets;

import dev.architectury.event.events.common.CommandRegistrationEvent;
import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.event.events.common.PlayerEvent;
import dev.architectury.registry.level.entity.EntityAttributeRegistry;
import net.dawson.adorablehamsterpets.ModRegistries;
import net.dawson.adorablehamsterpets.accessor.PlayerEntityAccessor;
import net.dawson.adorablehamsterpets.advancement.criterion.ModCriteria;
import net.dawson.adorablehamsterpets.block.ModBlocks;
import net.dawson.adorablehamsterpets.command.ModCommands;
import net.dawson.adorablehamsterpets.config.AhpConfig;
import net.dawson.adorablehamsterpets.config.Configs;
import net.dawson.adorablehamsterpets.entity.ModEntities;
import net.dawson.adorablehamsterpets.entity.ShoulderLocation;
import net.dawson.adorablehamsterpets.entity.custom.HamsterEntity;
import net.dawson.adorablehamsterpets.event.AHPCommonEvents;
import net.dawson.adorablehamsterpets.item.ModItemGroups;
import net.dawson.adorablehamsterpets.item.ModItems;
import net.dawson.adorablehamsterpets.networking.ModPackets;
import net.dawson.adorablehamsterpets.screen.ModScreenHandlers;
import net.dawson.adorablehamsterpets.sound.ModSounds;
import net.dawson.adorablehamsterpets.tag.ModItemTags;
import net.dawson.adorablehamsterpets.world.ModSpawnPlacements;
import net.dawson.adorablehamsterpets.world.ModWorldGeneration;
import net.dawson.adorablehamsterpets.world.gen.ModEntitySpawns;
import net.minecraft.class_1263;
import net.minecraft.class_1299;
import net.minecraft.class_1317;
import net.minecraft.class_161;
import net.minecraft.class_1657;
import net.minecraft.class_167;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_2985;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3481;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdorableHamsterPets {
    public static final String MOD_ID = "adorablehamsterpets";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"adorablehamsterpets");
    public static AhpConfig CONFIG;

    public static void initRegistries() {
        CONFIG = Configs.AHP;
        ModEntities.register();
        ModSounds.register();
        ModBlocks.register();
        ModItems.register();
        ModItemGroups.register();
        ModScreenHandlers.register();
        ModCriteria.register();
    }

    public static void initCommonSetup() {
        if (System.getProperty("fabric-api.datagen") == null) {
            ModRegistries.registerCompostables();
            ModEntitySpawns.parseConfig();
            ModWorldGeneration.parseConfig();
            ModItemTags.parseConfig();
            ModPackets.register();
            ModWorldGeneration.registerBiomeModifications();
            AHPCommonEvents.init();
            PlayerEvent.PLAYER_JOIN.register(AdorableHamsterPets::onPlayerJoin);
            PlayerEvent.PLAYER_CLONE.register(AdorableHamsterPets::onPlayerClone);
            CommandRegistrationEvent.EVENT.register(ModCommands::register);
            LifecycleEvent.SETUP.register(AdorableHamsterPets::onSetup);
        }
    }

    public static void initAttributes() {
        EntityAttributeRegistry.register(ModEntities.HAMSTER, HamsterEntity::createHamsterAttributes);
    }

    private static void onSetup() {
        ModSpawnPlacements.register((class_1299)ModEntities.HAMSTER.get(), class_1317.class_1319.field_6317, class_2902.class_2903.field_13203, (type, world, reason, pos, random) -> world.method_8320(pos.method_10074()).method_26164(class_3481.field_35567) || ModEntitySpawns.VALID_SPAWN_BLOCKS.contains(world.method_8320(pos.method_10074()).method_26204()));
    }

    private static void onPlayerJoin(class_3222 player) {
        if (Configs.AHP.enableAutoGuidebookDelivery) {
            class_2985 advancementTracker = player.method_14236();
            class_2960 flagAdvId = class_2960.method_43902((String)MOD_ID, (String)"technical/has_received_initial_guidebook");
            class_161 flagAdvancement = player.field_13995.method_3851().method_12896(flagAdvId);
            if (flagAdvancement != null) {
                class_167 flagProgress = advancementTracker.method_12882(flagAdvancement);
                if (!flagProgress.method_740()) {
                    ModCriteria.FIRST_JOIN_GUIDEBOOK_CHECK.trigger(player);
                    for (String criterion : flagAdvancement.method_682().keySet()) {
                        advancementTracker.method_12878(flagAdvancement, criterion);
                    }
                }
            } else {
                LOGGER.warn("Could not find flag advancement: {}", (Object)flagAdvId);
            }
        }
        AdorableHamsterPets.replaceOldBooksInInventory((class_1263)player.method_31548());
    }

    private static void onPlayerClone(class_3222 oldPlayer, class_3222 newPlayer, boolean wasDeath) {
        PlayerEntityAccessor oldPlayerAccessor = (PlayerEntityAccessor)oldPlayer;
        PlayerEntityAccessor newPlayerAccessor = (PlayerEntityAccessor)newPlayer;
        for (ShoulderLocation location : ShoulderLocation.values()) {
            class_2487 shoulderNbt = oldPlayerAccessor.getShoulderHamster(location);
            if (shoulderNbt.method_33133()) continue;
            if (wasDeath) {
                class_3218 world = oldPlayer.method_51469();
                HamsterEntity.spawnFromNbt(world, (class_1657)oldPlayer, shoulderNbt, false, null);
                LOGGER.debug("Player {} died. Spawning {} hamster at death location.", (Object)oldPlayer.method_5477().getString(), (Object)location);
                continue;
            }
            newPlayerAccessor.setShoulderHamster(location, shoulderNbt);
            LOGGER.debug("Player {} was cloned. Transferring {} hamster to new entity.", (Object)newPlayer.method_5477().getString(), (Object)location);
        }
    }

    public static void replaceOldBooksInInventory(class_1263 inventory) {
        if (inventory == null) {
            return;
        }
        String PATCHOULI_BOOK_TAG = "patchouli:book";
        String TARGET_BOOK_ID = new class_2960(MOD_ID, "hamster_tips_guide_book").toString();
        for (int i = 0; i < inventory.method_5439(); ++i) {
            boolean hasPatchouliBookTag;
            class_1799 stack = inventory.method_5438(i);
            if (stack.method_7960() || !stack.method_31574((class_1792)ModItems.HAMSTER_GUIDE_BOOK.get())) continue;
            class_2487 nbt = stack.method_7969();
            boolean bl = hasPatchouliBookTag = nbt != null && nbt.method_10573("patchouli:book", 8);
            if (hasPatchouliBookTag) continue;
            class_1799 newBookStack = new class_1799((class_1935)ModItems.HAMSTER_GUIDE_BOOK.get(), stack.method_7947());
            newBookStack.method_7948().method_10582("patchouli:book", TARGET_BOOK_ID);
            inventory.method_5447(i, newBookStack);
            LOGGER.info("Upgraded an old Hamster Tips Guide Book to the new Patchouli version.");
        }
    }
}

