/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets;

import dev.architectury.event.events.client.ClientGuiEvent;
import dev.architectury.event.events.client.ClientPlayerEvent;
import dev.architectury.event.events.client.ClientTickEvent;
import dev.architectury.registry.client.level.entity.EntityRendererRegistry;
import dev.architectury.registry.client.rendering.ColorHandlerRegistry;
import dev.architectury.registry.client.rendering.RenderTypeRegistry;
import dev.architectury.registry.menu.MenuRegistry;
import io.netty.buffer.Unpooled;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import me.fzzyhmstrs.fzzy_config.api.ConfigApiJava;
import net.dawson.adorablehamsterpets.AdorableHamsterPets;
import net.dawson.adorablehamsterpets.accessor.PlayerEntityAccessor;
import net.dawson.adorablehamsterpets.block.ModBlocks;
import net.dawson.adorablehamsterpets.client.announcements.AnnouncementHudRenderer;
import net.dawson.adorablehamsterpets.client.announcements.AnnouncementManager;
import net.dawson.adorablehamsterpets.client.event.AHPClientScreenEvents;
import net.dawson.adorablehamsterpets.client.gui.widgets.AnnouncementIconAnimator;
import net.dawson.adorablehamsterpets.client.option.ModKeyBindings;
import net.dawson.adorablehamsterpets.client.sound.HamsterFlightSoundInstance;
import net.dawson.adorablehamsterpets.client.sound.HamsterThrowSoundInstance;
import net.dawson.adorablehamsterpets.config.AhpConfig;
import net.dawson.adorablehamsterpets.config.Configs;
import net.dawson.adorablehamsterpets.config.DismountPressType;
import net.dawson.adorablehamsterpets.config.DismountTriggerType;
import net.dawson.adorablehamsterpets.entity.ModEntities;
import net.dawson.adorablehamsterpets.entity.client.HamsterRenderer;
import net.dawson.adorablehamsterpets.entity.custom.HamsterEntity;
import net.dawson.adorablehamsterpets.item.ModItems;
import net.dawson.adorablehamsterpets.networking.ModPackets;
import net.dawson.adorablehamsterpets.screen.HamsterInventoryScreen;
import net.dawson.adorablehamsterpets.screen.ModScreenHandlers;
import net.dawson.adorablehamsterpets.sound.ModSounds;
import net.dawson.adorablehamsterpets.tag.ModItemTags;
import net.minecraft.class_1113;
import net.minecraft.class_1297;
import net.minecraft.class_1921;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_239;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3917;

public class AdorableHamsterPetsClient {
    private static final Set<Integer> renderedHamsterIdsThisTick = new HashSet<Integer>();
    private static final Set<Integer> renderedHamsterIdsLastTick = new HashSet<Integer>();
    private static long lastSneakPressTime = 0L;
    private static boolean isWaitingForSecondSneakPress = false;
    private static boolean hadShoulderHamsterLastTick = false;
    private static int dismountDebounceTicks = 0;
    private static final int DISMOUNT_DEBOUNCE_DEFAULT = 5;
    private static final AnnouncementHudRenderer announcementHudRenderer = new AnnouncementHudRenderer();
    private static List<AnnouncementManager.PendingNotification> pendingNotifications = Collections.emptyList();
    private static int nextRefreshTicks = 6000;

    public static List<AnnouncementManager.PendingNotification> getPendingNotifications() {
        return pendingNotifications;
    }

    public static void init() {
        RenderTypeRegistry.register((class_1921)class_1921.method_23581(), (class_2248[])new class_2248[]{(class_2248)ModBlocks.GREEN_BEANS_CROP.get(), (class_2248)ModBlocks.CUCUMBER_CROP.get(), (class_2248)ModBlocks.SUNFLOWER_BLOCK.get(), (class_2248)ModBlocks.WILD_CUCUMBER_BUSH.get(), (class_2248)ModBlocks.WILD_GREEN_BEAN_BUSH.get()});
        ConfigApiJava.event().onUpdateClient((id, config) -> {
            if (id.equals((Object)class_2960.method_43902((String)"adorablehamsterpets", (String)"main"))) {
                ModItemTags.parseConfig();
                AdorableHamsterPets.LOGGER.info("Reloaded Adorable Hamster Pets item tag config on client following GUI update. *wink wink*");
            }
        });
        ColorHandlerRegistry.registerItemColors((stack, tintIndex) -> -1, (class_1935[])new class_1935[]{(class_1935)ModItems.HAMSTER_SPAWN_EGG.get()});
        AHPClientScreenEvents.register();
        ClientTickEvent.CLIENT_POST.register(AdorableHamsterPetsClient::onEndClientTick);
        ClientPlayerEvent.CLIENT_PLAYER_JOIN.register(player -> AnnouncementManager.INSTANCE.processDeferredReadMarks());
        ClientGuiEvent.RENDER_HUD.register((context, tickDelta) -> announcementHudRenderer.render(context, tickDelta));
    }

    public static void initScreenHandlers() {
        MenuRegistry.registerScreenFactory((class_3917)((class_3917)ModScreenHandlers.HAMSTER_INVENTORY_SCREEN_HANDLER.get()), HamsterInventoryScreen::new);
    }

    public static void initEntityRenderers() {
        EntityRendererRegistry.register(ModEntities.HAMSTER, HamsterRenderer::new);
    }

    public static void onHamsterRendered(int entityId) {
        renderedHamsterIdsThisTick.add(entityId);
    }

    private static void onEndClientTick(class_310 client) {
        boolean isGuiOpen = client.field_1755 != null;
        AnnouncementIconAnimator.INSTANCE.tick(isGuiOpen);
        if (client.field_1687 != null) {
            pendingNotifications = AnnouncementManager.INSTANCE.getPendingNotifications();
        }
        if (--nextRefreshTicks <= 0) {
            nextRefreshTicks = 6000;
            AnnouncementManager.INSTANCE.refreshManifest();
            AdorableHamsterPets.LOGGER.debug("[AHP Client Tick] Triggered periodic manifest refresh.");
        }
        if (client.field_1724 == null || client.field_1687 == null) {
            renderedHamsterIdsThisTick.clear();
            renderedHamsterIdsLastTick.clear();
            return;
        }
        if (ModKeyBindings.THROW_HAMSTER_KEY.method_1436()) {
            AhpConfig currentConfig = AdorableHamsterPets.CONFIG;
            if (!currentConfig.enableHamsterThrowing) {
                client.field_1724.method_7353((class_2561)class_2561.method_43471((String)"message.adorablehamsterpets.throwing_disabled"), true);
            } else {
                boolean lookingAtReachableBlock = client.field_1765 != null && client.field_1765.method_17783() == class_239.class_240.field_1332;
                boolean hasShoulderHamsterClient = ((PlayerEntityAccessor)client.field_1724).hasAnyShoulderHamster();
                if (!lookingAtReachableBlock && hasShoulderHamsterClient) {
                    ModPackets.CHANNEL.sendToServer((Object)new ModPackets.ThrowHamsterC2SPacket());
                }
            }
        }
        HashSet<Integer> stoppedRendering = new HashSet<Integer>(renderedHamsterIdsLastTick);
        stoppedRendering.removeAll(renderedHamsterIdsThisTick);
        for (Integer entityId : stoppedRendering) {
            class_2540 buf = new class_2540(Unpooled.buffer());
            buf.writeInt(entityId.intValue());
            buf.writeBoolean(false);
            ModPackets.CHANNEL.sendToServer((Object)new ModPackets.UpdateRenderStateC2SPacket(entityId, false));
        }
        renderedHamsterIdsLastTick.clear();
        renderedHamsterIdsLastTick.addAll(renderedHamsterIdsThisTick);
        renderedHamsterIdsThisTick.clear();
        AdorableHamsterPetsClient.handleDismountKeyPress(client);
    }

    public static void handleStartFlightSound(int hamsterEntityId) {
        HamsterEntity hamster;
        class_3414 flightSound;
        class_310 client = class_310.method_1551();
        if (client.field_1687 == null) {
            return;
        }
        class_1297 entity = client.field_1687.method_8469(hamsterEntityId);
        if (entity instanceof HamsterEntity && (flightSound = ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_FLYING_SOUNDS, (hamster = (HamsterEntity)entity).method_6051())) != null) {
            client.method_1483().method_4873((class_1113)new HamsterFlightSoundInstance(flightSound, class_3419.field_15254, hamster));
        }
    }

    public static void handleStartThrowSound(int hamsterEntityId) {
        class_310 client = class_310.method_1551();
        if (client.field_1687 == null) {
            return;
        }
        class_1297 entity = client.field_1687.method_8469(hamsterEntityId);
        if (entity instanceof HamsterEntity) {
            HamsterEntity hamster = (HamsterEntity)entity;
            client.method_1483().method_4873((class_1113)new HamsterThrowSoundInstance((class_3414)ModSounds.HAMSTER_THROW.get(), class_3419.field_15248, hamster));
        }
    }

    private static void handleDismountKeyPress(class_310 client) {
        long delayMillis;
        long currentTime;
        if (client.field_1724 == null || client.field_1687 == null) {
            return;
        }
        boolean hasShoulderHamster = ((PlayerEntityAccessor)client.field_1724).hasAnyShoulderHamster();
        if (hasShoulderHamster && !hadShoulderHamsterLastTick) {
            class_304 vanillaSneak = client.field_1690.field_1832;
            class_304 customDismount = ModKeyBindings.DISMOUNT_HAMSTER_KEY;
            if (vanillaSneak != null) {
                vanillaSneak.method_23481(false);
                while (vanillaSneak.method_1436()) {
                }
            }
            if (customDismount != null) {
                customDismount.method_23481(false);
                while (customDismount.method_1436()) {
                }
            }
            dismountDebounceTicks = 5;
            isWaitingForSecondSneakPress = false;
            AdorableHamsterPets.LOGGER.trace("[AHP DEBUG CLIENT] Mount transition detected -> draining input queues and starting debounce ({} ticks).", (Object)5);
        }
        hadShoulderHamsterLastTick = hasShoulderHamster;
        if (!hasShoulderHamster) {
            if (isWaitingForSecondSneakPress) {
                isWaitingForSecondSneakPress = false;
            }
            return;
        }
        if (dismountDebounceTicks > 0) {
            --dismountDebounceTicks;
            return;
        }
        AhpConfig config = AdorableHamsterPets.CONFIG;
        class_304 keyToListenFor = Configs.AHP.dismountTriggerType == DismountTriggerType.CUSTOM_KEYBIND ? ModKeyBindings.DISMOUNT_HAMSTER_KEY : client.field_1690.field_1832;
        boolean wasKeyPressed = keyToListenFor != null && keyToListenFor.method_1436();
        AdorableHamsterPets.LOGGER.trace("[AHP DEBUG CLIENT] Tick Handler: Listening for '{}'. wasPressed() = {}", (Object)(keyToListenFor != null ? keyToListenFor.method_1431() : "null-binding"), (Object)wasKeyPressed);
        if (wasKeyPressed) {
            AdorableHamsterPets.LOGGER.debug("[AHP DEBUG CLIENT] Tick Handler: SINGLE_PRESS detected. Press type config: {}", config.dismountPressType.get());
            if (config.dismountPressType.get() == DismountPressType.SINGLE_PRESS) {
                ModPackets.CHANNEL.sendToServer((Object)new ModPackets.DismountHamsterC2SPacket());
            } else {
                currentTime = System.currentTimeMillis();
                delayMillis = (long)((Integer)config.doubleTapDelayTicks.get()).intValue() * 50L;
                if (isWaitingForSecondSneakPress && currentTime - lastSneakPressTime <= delayMillis) {
                    AdorableHamsterPets.LOGGER.trace("[AHP DEBUG CLIENT] Tick Handler: DOUBLE_TAP second press detected. Sending dismount payload.");
                    ModPackets.CHANNEL.sendToServer((Object)new ModPackets.DismountHamsterC2SPacket());
                    isWaitingForSecondSneakPress = false;
                } else {
                    AdorableHamsterPets.LOGGER.trace("[AHP DEBUG CLIENT] Tick Handler: DOUBLE_TAP first press detected. Starting timer.");
                    isWaitingForSecondSneakPress = true;
                    lastSneakPressTime = currentTime;
                }
            }
        }
        if (isWaitingForSecondSneakPress && (currentTime = System.currentTimeMillis()) - lastSneakPressTime > (delayMillis = (long)((Integer)config.doubleTapDelayTicks.get()).intValue() * 50L)) {
            AdorableHamsterPets.LOGGER.trace("[AHP DEBUG CLIENT] Tick Handler: DOUBLE_TAP timed out.");
            isWaitingForSecondSneakPress = false;
        }
    }
}

