/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.client.gui;

import java.lang.invoke.CallSite;
import java.net.URI;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.dawson.adorablehamsterpets.client.announcements.Announcement;
import net.dawson.adorablehamsterpets.client.announcements.AnnouncementManager;
import net.dawson.adorablehamsterpets.client.announcements.ClientAnnouncementState;
import net.dawson.adorablehamsterpets.client.announcements.PatchouliIntegration;
import net.dawson.adorablehamsterpets.client.gui.MarkdownRenderer;
import net.dawson.adorablehamsterpets.config.Configs;
import net.dawson.adorablehamsterpets.mixin.accessor.ScreenWidgetAdder;
import net.dawson.adorablehamsterpets.mixin.accessor.ValidatedFieldAccessor;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_442;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_7919;
import org.jetbrains.annotations.Nullable;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.common.book.Book;
import vazkii.patchouli.common.book.BookRegistry;

public class AnnouncementScreen
extends class_437 {
    private static final class_2960 BACKGROUND_TEXTURE = class_2960.method_43902((String)"adorablehamsterpets", (String)"textures/gui/announcement_ui.png");
    private static final class_2960 SCROLLBAR_TEXTURE = class_2960.method_43902((String)"adorablehamsterpets", (String)"textures/gui/announcement_ui_scroll_bar.png");
    private static final int BACKGROUND_WIDTH = 256;
    private static final int BACKGROUND_HEIGHT = 256;
    private static final int TOTAL_GUI_HEIGHT = 283;
    private static final int CONTENT_X_OFFSET = 17;
    private static final int CONTENT_Y_OFFSET = 35;
    private static final int CONTENT_WIDTH = 221;
    private static final int CONTENT_HEIGHT = 204;
    private static final int SCROLLBAR_X_OFFSET = 242;
    private static final int SCROLLBAR_START_Y = 28;
    private static final int SCROLLBAR_END_Y = 221;
    private static final int EDGE_MARGIN = 7;
    private static final int BUTTON_WIDTH = 100;
    private final Announcement announcement;
    private MarkdownRenderer markdownRenderer;
    private String markdownContent = "Loading...";
    private double scrollY = 0.0;
    private int guiLeft;
    private int guiTop;
    @Nullable
    private class_2583 hoveredStyle = null;
    private final class_437 parentScreen;
    private final BookEntry virtualEntry;
    private final String reason;
    private float uiScale = 1.0f;
    private boolean isDraggingScrollbar = false;
    private int scaledBackgroundWidth;
    private int scaledBackgroundHeight;
    private int scaledTotalHeight;
    private int scaledContentXOffset;
    private int scaledContentYOffset;
    private int scaledContentWidth;
    private int scaledContentHeight;
    private int scaledScrollBarXOffset;
    private int scaledScrollBarStartY;
    private int scaledScrollBarEndY;
    private int scaledButtonHeight;
    private int scaledButtonPadding;

    public AnnouncementScreen(Announcement announcement, String reason, @Nullable class_437 parentScreen, BookEntry virtualEntry) {
        super((class_2561)class_2561.method_43470((String)announcement.title()));
        this.announcement = announcement;
        this.reason = reason;
        this.parentScreen = parentScreen;
        this.virtualEntry = virtualEntry;
    }

    protected void method_25426() {
        int currentX;
        class_4185.class_7840 builder;
        super.method_25426();
        int availableWidth = Math.max(0, this.field_22789 - 14);
        int availableHeight = Math.max(0, this.field_22790 - 14);
        int buttonRows = 2;
        int unscaledTotalHeight = 283 + (buttonRows - 1) * 27;
        float scaleX = (float)availableWidth / 256.0f;
        float scaleY = (float)availableHeight / (float)unscaledTotalHeight;
        this.uiScale = Math.min(1.0f, Math.min(scaleX, scaleY));
        this.scaledBackgroundWidth = Math.round(256.0f * this.uiScale);
        this.scaledBackgroundHeight = Math.round(256.0f * this.uiScale);
        this.scaledContentXOffset = Math.round(17.0f * this.uiScale);
        this.scaledContentYOffset = Math.round(35.0f * this.uiScale);
        this.scaledContentWidth = Math.max(1, Math.round(221.0f * this.uiScale));
        this.scaledContentHeight = Math.max(1, Math.round(204.0f * this.uiScale));
        this.scaledScrollBarXOffset = Math.round(242.0f * this.uiScale);
        this.scaledScrollBarStartY = Math.round(28.0f * this.uiScale);
        this.scaledScrollBarEndY = Math.round(221.0f * this.uiScale);
        this.scaledButtonHeight = Math.max(12, Math.round(20.0f * this.uiScale));
        this.scaledButtonPadding = Math.max(2, Math.round(7.0f * this.uiScale));
        this.scaledTotalHeight = this.scaledBackgroundHeight + buttonRows * (this.scaledButtonHeight + this.scaledButtonPadding);
        this.guiLeft = 7 + (availableWidth - this.scaledBackgroundWidth) / 2;
        this.guiTop = 7 + (availableHeight - this.scaledTotalHeight) / 2;
        this.markdownRenderer = new MarkdownRenderer(this.markdownContent, this.guiLeft + this.scaledContentXOffset, this.guiTop + this.scaledContentYOffset, this.scaledContentWidth);
        AnnouncementManager.INSTANCE.fetchMarkdown(this.announcement.markdown()).thenAccept(content -> this.field_22787.execute(() -> {
            this.markdownContent = content;
            this.markdownRenderer = new MarkdownRenderer((String)content, this.guiLeft + this.scaledContentXOffset, this.guiTop + this.scaledContentYOffset, this.scaledContentWidth);
        }));
        int closeButtonX = this.guiLeft - 10;
        int closeButtonY = this.guiTop + 5;
        ((ScreenWidgetAdder)((Object)this)).adorablehamsterpets$addWidget(class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2190").method_27692(class_124.field_1067), button -> this.returnToBook()).method_46434(closeButtonX, closeButtonY, 20, 16).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"gui.adorablehamsterpets.announcement.button.close.tooltip"))).method_46431());
        int buttonWidth = 100;
        int buttonPadding = this.scaledButtonPadding;
        ArrayList<class_4185.class_7840> primaryBuilders = new ArrayList<class_4185.class_7840>();
        ArrayList<class_4185.class_7840> secondaryBuilders = new ArrayList<class_4185.class_7840>();
        class_5250 markAsReadTooltip = class_2561.method_43471((String)"gui.adorablehamsterpets.announcement.button.mark_as_read.tooltip").method_27693("\n\n").method_10852((class_2561)class_2561.method_43471((String)"gui.adorablehamsterpets.announcement.button.mark_as_read.shift_tooltip").method_27692(class_124.field_1065));
        primaryBuilders.add(class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.adorablehamsterpets.announcement.button.mark_as_read"), button -> {
            if (class_437.method_25442()) {
                Book book = (Book)BookRegistry.INSTANCE.books.get(class_2960.method_43902((String)"adorablehamsterpets", (String)"hamster_tips_guide_book"));
                if (book != null) {
                    AnnouncementManager.INSTANCE.getAllManifestMessages().forEach(msg -> {
                        class_2960 entryId;
                        BookEntry entry;
                        AnnouncementManager.INSTANCE.markAsSeen(msg.id());
                        if ("update".equals(msg.kind())) {
                            AnnouncementManager.INSTANCE.setLastAcknowledgedUpdate(msg.semver());
                        }
                        if ((entry = (BookEntry)book.getContents().entries.get(entryId = class_2960.method_43902((String)"adorablehamsterpets", (String)("announcement_" + msg.id())))) != null) {
                            PatchouliIntegration.setEntryAsRead(entry);
                        }
                    });
                }
            } else {
                PatchouliIntegration.setEntryAsRead(this.virtualEntry);
                AnnouncementManager.INSTANCE.markAsSeen(this.announcement.id());
                if ("update".equals(this.announcement.kind())) {
                    AnnouncementManager.INSTANCE.setLastAcknowledgedUpdate(this.announcement.semver());
                }
            }
            this.returnToBook();
        }).method_46436(class_7919.method_47407((class_2561)markAsReadTooltip)));
        primaryBuilders.add(class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.adorablehamsterpets.announcement.button.disable_icons"), button -> {
            ((ValidatedFieldAccessor)Configs.AHP.enableNotificationIcons).adorablehamsterpets$set(false);
            Configs.AHP.save();
            this.method_25419();
        }).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"gui.adorablehamsterpets.announcement.button.disable_icons.tooltip"))));
        class_5250 remindLaterTooltip = class_2561.method_43469((String)"gui.adorablehamsterpets.announcement.button.snooze_days.tooltip", (Object[])new Object[]{Configs.AHP.snoozeUpdateReminderDays.get()});
        ClientAnnouncementState state = AnnouncementManager.INSTANCE.getClientState();
        Instant snoozeUntil = state.snoozed_ids().get(this.announcement.id());
        if (snoozeUntil != null && snoozeUntil.isAfter(Instant.now())) {
            Duration remaining = Duration.between(Instant.now(), snoozeUntil);
            remindLaterTooltip.method_27693("\n\n").method_10852(this.formatDuration(remaining));
        }
        primaryBuilders.add(class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.adorablehamsterpets.announcement.button.snooze_days"), button -> {
            AnnouncementManager.INSTANCE.setSnooze(this.announcement.id(), (Integer)Configs.AHP.snoozeUpdateReminderDays.get());
            if (this.parentScreen instanceof class_442) {
                AnnouncementManager.INSTANCE.queueDeferredReadMark(this.virtualEntry.getId());
            } else {
                PatchouliIntegration.setEntryAsRead(this.virtualEntry);
            }
            this.returnToBook();
        }).method_46436(class_7919.method_47407((class_2561)remindLaterTooltip)));
        primaryBuilders.add(class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.adorablehamsterpets.announcement.button.snooze_session"), button -> {
            AnnouncementManager.INSTANCE.setDisabledUntilLaunch(true);
            this.method_25419();
        }).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"gui.adorablehamsterpets.announcement.button.snooze_session.tooltip"))));
        if ("update".equals(this.announcement.kind())) {
            String changelogUrl = String.format("https://modrinth.com/mod/adorable-hamster-pets/version/%s-1.21.1+fabric", this.announcement.semver());
            secondaryBuilders.add(class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.adorablehamsterpets.announcement.button.changelog"), button -> class_156.method_668().method_673(URI.create(changelogUrl))).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"gui.adorablehamsterpets.announcement.button.changelog.tooltip"))));
        }
        secondaryBuilders.add(class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.adorablehamsterpets.announcement.button.discord"), button -> class_156.method_668().method_673(URI.create("https://discord.gg/w54mk5bqdf"))).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"config.adorablehamsterpets.main.helpAndResources.joinDiscord.desc"))));
        int availableWidthButtons = Math.max(0, this.field_22789 - 14);
        int primaryCount = primaryBuilders.size();
        int secondaryCount = secondaryBuilders.size();
        int totalPrimaryWidth = primaryCount * buttonWidth + Math.max(0, primaryCount - 1) * buttonPadding;
        int totalSecondaryWidth = secondaryCount * buttonWidth + Math.max(0, secondaryCount - 1) * buttonPadding;
        int startXRow1 = 7 + (availableWidthButtons - totalPrimaryWidth) / 2;
        int startXRow2 = 7 + (availableWidthButtons - totalSecondaryWidth) / 2;
        int firstRowY = this.guiTop + this.scaledBackgroundHeight + this.scaledButtonPadding;
        int secondRowY = firstRowY + this.scaledButtonHeight + this.scaledButtonPadding;
        for (int i = 0; i < primaryCount; ++i) {
            builder = (class_4185.class_7840)primaryBuilders.get(i);
            currentX = startXRow1 + i * (buttonWidth + buttonPadding);
            ((ScreenWidgetAdder)((Object)this)).adorablehamsterpets$addWidget(builder.method_46434(currentX, firstRowY, buttonWidth, this.scaledButtonHeight).method_46431());
        }
        for (int j = 0; j < secondaryCount; ++j) {
            builder = (class_4185.class_7840)secondaryBuilders.get(j);
            currentX = startXRow2 + j * (buttonWidth + buttonPadding);
            ((ScreenWidgetAdder)((Object)this)).adorablehamsterpets$addWidget(builder.method_46434(currentX, secondRowY, buttonWidth, this.scaledButtonHeight).method_46431());
        }
    }

    private class_2561 formatDuration(Duration duration) {
        String formattedString;
        long days = duration.toDays();
        long hours = duration.toHoursPart();
        long minutes = duration.toMinutesPart();
        ArrayList<CallSite> parts = new ArrayList<CallSite>();
        if (days > 0L) {
            parts.add((CallSite)((Object)(days + (days == 1L ? " day" : " days"))));
        }
        if (hours > 0L) {
            parts.add((CallSite)((Object)(hours + (hours == 1L ? " hour" : " hours"))));
        }
        if (days == 0L && minutes > 0L) {
            parts.add((CallSite)((Object)(minutes + (minutes == 1L ? " minute" : " minutes"))));
        }
        if ((formattedString = String.join((CharSequence)", ", parts)).isEmpty()) {
            formattedString = "less than a minute";
        }
        return class_2561.method_43469((String)"tooltip.adorablehamsterpets.hud.snooze_remaining", (Object[])new Object[]{formattedString}).method_27692(class_124.field_1080);
    }

    private void returnToBook() {
        if (this.field_22787 != null) {
            this.field_22787.method_1507(this.parentScreen);
        }
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        class_2561 textAtMouse = this.getTextAt(mouseX, mouseY);
        this.hoveredStyle = textAtMouse != null && textAtMouse.method_10866().method_10970() != null ? textAtMouse.method_10866() : null;
        this.method_25420(context);
        super.method_25394(context, mouseX, mouseY, delta);
        context.method_44379(this.guiLeft + this.scaledContentXOffset, this.guiTop + this.scaledContentYOffset, this.guiLeft + this.scaledContentXOffset + this.scaledContentWidth, this.guiTop + this.scaledContentYOffset + this.scaledContentHeight);
        this.markdownRenderer.render(context, (int)this.scrollY, this.hoveredStyle);
        context.method_44380();
        int maxScroll = Math.max(0, this.markdownRenderer.getTotalHeight() - this.scaledContentHeight);
        if (maxScroll > 0) {
            int scrollbarX = this.guiLeft + this.scaledScrollBarXOffset;
            int scrollbarTravel = this.scaledScrollBarEndY - this.scaledScrollBarStartY;
            double scrollPercent = this.scrollY / (double)maxScroll;
            int scrollbarY = this.guiTop + this.scaledScrollBarStartY + (int)(scrollPercent * (double)scrollbarTravel);
            context.method_25290(SCROLLBAR_TEXTURE, scrollbarX, scrollbarY, 0.0f, 0.0f, 4, 25, 4, 25);
        }
        class_4587 matrices = context.method_51448();
        matrices.method_22903();
        float defaultScale = 1.3f * this.uiScale;
        int maxWidth = Math.round(222.0f * this.uiScale);
        class_5250 boldTitle = this.field_22785.method_27661().method_27692(class_124.field_1067);
        int titleWidth = class_310.method_1551().field_1772.method_27525((class_5348)boldTitle);
        float finalScale = defaultScale;
        if ((float)titleWidth * defaultScale > (float)maxWidth) {
            finalScale = (float)maxWidth / (float)titleWidth;
        }
        matrices.method_22904((double)this.field_22789 / 2.0, (double)(this.guiTop + Math.round(9.0f * this.uiScale)), 0.0);
        matrices.method_22905(finalScale, finalScale, 1.0f);
        context.method_51439(class_310.method_1551().field_1772, (class_2561)boldTitle, -titleWidth / 2, 0, 0x323232, false);
        matrices.method_22909();
    }

    public void method_25420(class_332 context) {
        super.method_25420(context);
        context.method_51448().method_22903();
        context.method_51448().method_46416((float)this.guiLeft, (float)this.guiTop, 0.0f);
        context.method_51448().method_22905(this.uiScale, this.uiScale, 1.0f);
        context.method_25290(BACKGROUND_TEXTURE, 0, 0, 0.0f, 0.0f, 256, 256, 256, 256);
        context.method_51448().method_22909();
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.field_22787 != null && this.field_22787.field_1690.field_1822.method_1417(keyCode, scanCode)) {
            this.method_25419();
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_25401(double mouseX, double mouseY, double amount) {
        int maxScroll = Math.max(0, this.markdownRenderer.getTotalHeight() - this.scaledContentHeight);
        double scrollStep = 10.0f * this.uiScale;
        this.scrollY = class_3532.method_15350((double)(this.scrollY - amount * scrollStep), (double)0.0, (double)maxScroll);
        return true;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button == 0) {
            class_2583 style;
            class_2561 clickedText;
            int maxScroll = Math.max(0, this.markdownRenderer.getTotalHeight() - this.scaledContentHeight);
            if (maxScroll > 0) {
                int scrollbarX = this.guiLeft + this.scaledScrollBarXOffset;
                int scrollbarTravel = this.scaledScrollBarEndY - this.scaledScrollBarStartY;
                double scrollPercent = this.scrollY / (double)maxScroll;
                int scrollbarY = this.guiTop + this.scaledScrollBarStartY + (int)(scrollPercent * (double)scrollbarTravel);
                if (mouseX >= (double)scrollbarX && mouseX < (double)(scrollbarX + 4) && mouseY >= (double)scrollbarY && mouseY < (double)(scrollbarY + 25)) {
                    this.isDraggingScrollbar = true;
                    return true;
                }
            }
            if ((clickedText = this.getTextAt(mouseX, mouseY)) != null && this.method_25430(style = clickedText.method_10866())) {
                return true;
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.isDraggingScrollbar) {
            int maxScroll = Math.max(0, this.markdownRenderer.getTotalHeight() - this.scaledContentHeight);
            int scrollbarTravel = this.scaledScrollBarEndY - this.scaledScrollBarStartY;
            double relativeMouseY = mouseY - (double)(this.guiTop + this.scaledScrollBarStartY);
            double scrollPercent = relativeMouseY / (double)scrollbarTravel;
            this.scrollY = class_3532.method_15350((double)(scrollPercent * (double)maxScroll), (double)0.0, (double)maxScroll);
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.isDraggingScrollbar = false;
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25421() {
        return true;
    }

    public void method_25419() {
        this.returnToBook();
    }

    @Nullable
    public class_2561 getTextAt(double x, double y) {
        int scrollOffset = (int)((double)(this.guiTop + this.scaledContentYOffset) - this.scrollY);
        int relativeY = (int)y - scrollOffset;
        if (relativeY < 0) {
            return null;
        }
        int currentY = 0;
        for (String originalLine : this.markdownRenderer.lines) {
            class_5250 styledText;
            int indentationLevel;
            int lineHeight;
            boolean isListItem;
            String trimmedLine = originalLine.trim();
            int startX = this.guiLeft + this.scaledContentXOffset;
            int contentWidth = this.markdownRenderer.width;
            String content = trimmedLine;
            boolean bl = isListItem = trimmedLine.startsWith("- ") || trimmedLine.startsWith("* ") || trimmedLine.matches("^\\d+\\.\\s.*");
            if (trimmedLine.isEmpty()) {
                Objects.requireNonNull(this.field_22793);
                lineHeight = 9 / 2;
            } else if (trimmedLine.startsWith("#")) {
                int level;
                for (level = 0; level < trimmedLine.length() && trimmedLine.charAt(level) == '#'; ++level) {
                }
                String text = trimmedLine.substring(level).trim();
                float scale = Math.max(1.0f, 2.0f - (float)(level - 1) * 0.25f);
                int scaledWidth = (int)((float)this.markdownRenderer.width / scale);
                class_5250 styledText2 = class_2561.method_43470((String)text).method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true)));
                List wrappedLines = class_310.method_1551().field_1772.method_1728((class_5348)styledText2, scaledWidth);
                int n = wrappedLines.size();
                Objects.requireNonNull(this.field_22793);
                int heightOfLines = n * (int)(9.0f * scale);
                int totalSpacing = Math.max(0, wrappedLines.size() - 1) * 2;
                lineHeight = heightOfLines + totalSpacing + 4;
            } else if (trimmedLine.equals("---")) {
                lineHeight = 13;
            } else {
                indentationLevel = MarkdownRenderer.getIndentationLevel(originalLine);
                if (isListItem) {
                    contentWidth = this.markdownRenderer.width - (indentationLevel + 1) * 10;
                    startX += indentationLevel * 10 + 10;
                    content = trimmedLine.matches("^\\d+\\.\\s.*") ? trimmedLine.substring(trimmedLine.indexOf(46) + 1).trim() : trimmedLine.substring(1).trim();
                } else {
                    contentWidth = this.markdownRenderer.width - indentationLevel * 10;
                    startX += indentationLevel * 10;
                    content = originalLine.substring(indentationLevel * 4);
                }
                styledText = this.markdownRenderer.parseLineToText(content, null);
                List wrappedLines = this.field_22793.method_1728((class_5348)styledText, contentWidth);
                int n = wrappedLines.size();
                Objects.requireNonNull(this.field_22793);
                lineHeight = n * (9 + 2);
            }
            if (relativeY >= currentY && relativeY < currentY + lineHeight) {
                if (!(trimmedLine.isEmpty() || trimmedLine.startsWith("#") || trimmedLine.equals("---"))) {
                    indentationLevel = MarkdownRenderer.getIndentationLevel(originalLine);
                    contentWidth = isListItem ? this.markdownRenderer.width - (indentationLevel + 1) * 10 : this.markdownRenderer.width - indentationLevel * 10;
                    styledText = this.markdownRenderer.parseLineToText(content, null);
                    List wrappedLines = this.field_22793.method_1728((class_5348)styledText, contentWidth);
                    int yInBlock = relativeY - currentY;
                    Objects.requireNonNull(this.field_22793);
                    int lineIndex = yInBlock / (9 + 2);
                    if (lineIndex >= 0 && lineIndex < wrappedLines.size()) {
                        class_5481 orderedText = (class_5481)wrappedLines.get(lineIndex);
                        int relativeX = (int)x - startX;
                        class_2583 style = this.field_22787.field_1772.method_27527().method_30876(orderedText, relativeX);
                        if (style != null && style.method_10970() != null) {
                            return class_2561.method_43470((String)"").method_10862(style);
                        }
                    }
                }
                return null;
            }
            currentY += lineHeight;
        }
        return null;
    }
}

