/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.entity.client;

import java.util.HashMap;
import java.util.Map;
import net.dawson.adorablehamsterpets.AdorableHamsterPetsClient;
import net.dawson.adorablehamsterpets.client.sound.HamsterCleaningSoundInstance;
import net.dawson.adorablehamsterpets.entity.client.HamsterModel;
import net.dawson.adorablehamsterpets.entity.client.layer.HamsterOverlayLayer;
import net.dawson.adorablehamsterpets.entity.client.layer.HamsterPinkPetalOverlayLayer;
import net.dawson.adorablehamsterpets.entity.custom.HamsterEntity;
import net.dawson.adorablehamsterpets.entity.custom.HamsterVariant;
import net.dawson.adorablehamsterpets.sound.ModSounds;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2498;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5617;
import net.minecraft.class_5819;
import net.minecraft.class_811;
import net.minecraft.class_918;
import org.jetbrains.annotations.Nullable;
import org.joml.AxisAngle4f;
import org.joml.Quaternionf;
import org.joml.Vector3d;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import software.bernie.geckolib.renderer.GeoRenderer;

public class HamsterRenderer
extends GeoEntityRenderer<HamsterEntity> {
    private final float adultShadowRadius;
    private static final Map<Integer, HamsterCleaningSoundInstance> activeCleaningSounds = new HashMap<Integer, HamsterCleaningSoundInstance>();

    public HamsterRenderer(class_5617.class_5618 ctx) {
        super(ctx, (GeoModel)new HamsterModel());
        this.field_4673 = this.adultShadowRadius = 0.2f;
        this.addRenderLayer(new HamsterOverlayLayer((GeoRenderer<HamsterEntity>)this));
        this.addRenderLayer(new HamsterPinkPetalOverlayLayer((GeoRenderer<HamsterEntity>)this));
    }

    public class_2960 getTextureLocation(HamsterEntity entity) {
        HamsterVariant variant = HamsterVariant.byId(entity.getVariant());
        String baseTextureName = variant.getBaseTextureName();
        return class_2960.method_43902((String)"adorablehamsterpets", (String)("textures/entity/hamster/" + baseTextureName + ".png"));
    }

    public void render(HamsterEntity entity, float entityYaw, float partialTick, class_4587 poseStack, class_4597 bufferSource, int packedLight) {
        AnimatableManager manager;
        AnimatableInstanceCache cache;
        boolean isCleaning = entity.isCleaning();
        HamsterCleaningSoundInstance sound = activeCleaningSounds.get(entity.method_5628());
        if (isCleaning && (sound == null || sound.method_4793())) {
            sound = new HamsterCleaningSoundInstance(entity);
            activeCleaningSounds.put(entity.method_5628(), sound);
            class_310.method_1551().method_1483().method_4873((class_1113)sound);
        } else if (!isCleaning && sound != null) {
            sound.stop();
            activeCleaningSounds.remove(entity.method_5628());
        }
        this.field_4673 = entity.method_6109() ? this.adultShadowRadius * 0.5f : this.adultShadowRadius;
        AdorableHamsterPetsClient.onHamsterRendered(entity.method_5628());
        poseStack.method_22903();
        float targetYOffset = 0.0f;
        class_2338 pos = entity.method_24515();
        class_2680 blockState = entity.method_37908().method_8320(pos);
        if (blockState.method_27852(class_2246.field_10477)) {
            targetYOffset = 0.125f;
        }
        entity.renderedSnowYOffset += (targetYOffset - entity.renderedSnowYOffset) * 0.15f;
        poseStack.method_22904(0.0, (double)entity.renderedSnowYOffset, 0.0);
        if (!entity.isShoulderPet() && (cache = entity.getAnimatableInstanceCache()) != null && (manager = cache.getManagerForId((long)entity.method_5628())) != null) {
            manager.updatedAt(0.0);
        }
        super.method_3936((class_1297)entity, entityYaw, partialTick, poseStack, bufferSource, packedLight);
        poseStack.method_22909();
    }

    public void preRender(class_4587 poseStack, HamsterEntity animatable, BakedGeoModel model, @Nullable class_4597 bufferSource, @Nullable class_4588 buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        super.preRender(poseStack, (class_1297)animatable, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
        model.getBone("left_foot").ifPresent(bone -> bone.setTrackingMatrices(true));
        model.getBone("nose").ifPresent(bone -> bone.setTrackingMatrices(true));
    }

    public void renderFinal(class_4587 poseStack, HamsterEntity animatable, BakedGeoModel model, class_4597 bufferSource, @Nullable class_4588 buffer, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        super.renderFinal(poseStack, (class_1297)animatable, model, bufferSource, buffer, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
        if (animatable.particleEffectId != null) {
            class_5819 random = animatable.method_6051();
            switch (animatable.particleEffectId) {
                case "attack_poof": {
                    model.getBone("left_foot").ifPresent(bone -> {
                        Vector3d pos = bone.getWorldPosition();
                        for (int i = 0; i < 3; ++i) {
                            double d = random.method_43059() * 0.1;
                            double e = random.method_43059() * 0.2;
                            double f = random.method_43059() * 0.1;
                            animatable.method_37908().method_8406((class_2394)class_2398.field_11203, pos.x + d, pos.y + e, pos.z + f, random.method_43059() * 0.05, random.method_43059() * 0.05 + 0.1, random.method_43059() * 0.05);
                        }
                    });
                    break;
                }
                case "seeking_dust": {
                    model.getBone("nose").ifPresent(bone -> {
                        Vector3d pos = bone.getWorldPosition();
                        class_2338 blockBelow = class_2338.method_49637((double)pos.x, (double)(pos.y - 0.1), (double)pos.z).method_10074();
                        class_2680 state = animatable.method_37908().method_8320(blockBelow);
                        if (state.method_26215()) {
                            state = class_2246.field_10566.method_9564();
                        }
                        for (int i = 0; i < 12; ++i) {
                            double d = random.method_43059() * 0.2;
                            double e = random.method_43059() * 0.03;
                            double f = random.method_43059() * 0.2;
                            animatable.method_37908().method_8406((class_2394)new class_2388(class_2398.field_11206, state), pos.x + d, pos.y + e, pos.z + f, 0.0, 0.0, 0.0);
                        }
                    });
                }
            }
            animatable.particleEffectId = null;
        }
        if (animatable.soundEffectId != null) {
            class_310 client = class_310.method_1551();
            switch (animatable.soundEffectId) {
                case "hamster_step_sound": {
                    class_2338 pos = animatable.method_24515();
                    class_2680 blockState = animatable.method_37908().method_8320(pos.method_10074());
                    if (blockState.method_26215()) {
                        blockState = animatable.method_37908().method_8320(pos.method_10087(2));
                    }
                    if (blockState.method_26215()) break;
                    class_2498 group = blockState.method_26231();
                    float volume = blockState.method_27852(class_2246.field_10255) ? 0.060000002f : 0.1f;
                    client.method_1483().method_4873((class_1113)new class_1109(group.method_10594(), class_3419.field_15254, volume, group.method_10599() * 1.5f, animatable.method_6051(), animatable.method_23317(), animatable.method_23318(), animatable.method_23321()));
                    break;
                }
                case "hamster_beg_bounce": {
                    class_3414 bounceSound = ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_BOUNCE_SOUNDS, animatable.method_6051());
                    if (bounceSound == null) break;
                    float basePitch = animatable.method_6017();
                    float randomPitchAddition = animatable.method_6051().method_43057() * 0.2f;
                    float finalPitch = basePitch * 1.2f + randomPitchAddition;
                    client.method_1483().method_4873((class_1113)new class_1109(bounceSound, class_3419.field_15254, 0.6f, finalPitch, animatable.method_6051(), animatable.method_23317(), animatable.method_23318(), animatable.method_23321()));
                }
            }
            animatable.soundEffectId = null;
        }
    }

    public void renderRecursively(class_4587 poseStack, HamsterEntity animatable, GeoBone bone, class_1921 renderType, class_4597 bufferSource, class_4588 buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        super.renderRecursively(poseStack, (class_1297)animatable, bone, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
        class_1799 stolenStack = animatable.getStolenItemStack();
        if (bone.getName().equals("nose") && animatable.isStealingDiamond()) {
            class_918 itemRenderer = class_310.method_1551().method_1480();
            poseStack.method_22903();
            poseStack.method_46416(bone.getPosX(), bone.getPosY(), bone.getPosZ());
            poseStack.method_22907(new Quaternionf().rotateZ(bone.getRotZ()));
            poseStack.method_22907(new Quaternionf().rotateY(bone.getRotY()));
            poseStack.method_22907(new Quaternionf().rotateX(bone.getRotX()));
            poseStack.method_22905(bone.getScaleX(), bone.getScaleY(), bone.getScaleZ());
            poseStack.method_46416(0.0f, 0.22f, -0.4f);
            poseStack.method_22905(0.7f, 0.7f, 0.7f);
            poseStack.method_22907(new Quaternionf(new AxisAngle4f((float)Math.toRadians(90.0), 1.0f, 0.0f, 0.0f)));
            itemRenderer.method_23178(stolenStack, class_811.field_4320, packedLight, packedOverlay, poseStack, bufferSource, animatable.method_37908(), animatable.method_5628());
            poseStack.method_22909();
        }
    }
}

